/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.configuration;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.felix.webconsole.internal.configuration.ConfigJsonSupport;
import org.apache.felix.webconsole.internal.configuration.ConfigurationUtil;
import org.apache.felix.webconsole.internal.configuration.MetaTypeServiceSupport;
import org.apache.felix.webconsole.internal.configuration.MetaTypeSupport;
import org.apache.felix.webconsole.internal.configuration.PropertyDescriptor;
import org.apache.felix.webconsole.internal.misc.ServletSupport;
import org.apache.felix.webconsole.spi.ConfigurationHandler;
import org.apache.felix.webconsole.spi.ValidationException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

class ConfigAdminSupport {
    public static final String PROPERTY_FACTORYCONFIG_NAMEHINT = "webconsole.configurationFactory.nameHint";
    public static final Set<String> CONFIG_PROPERTIES_HIDE = new HashSet<String>();
    public static final Pattern NAMEHINT_PLACEHOLER_REGEXP;
    private final ConfigurationAdmin service;
    private final ServletSupport servletSupport;
    private final List<ConfigurationHandler> configurationHandlers;

    ConfigAdminSupport(ServletSupport support, Object service, List<ConfigurationHandler> handlers) {
        this.servletSupport = support;
        this.service = (ConfigurationAdmin)service;
        this.configurationHandlers = handlers;
    }

    public ConfigJsonSupport getJsonSupport() {
        return new ConfigJsonSupport(this.servletSupport, this.getMetaTypeSupport(), this.service, this.configurationHandlers);
    }

    MetaTypeServiceSupport getMetaTypeSupport() {
        Object metaTypeService = this.servletSupport.getService("org.osgi.service.metatype.MetaTypeService");
        if (metaTypeService != null) {
            return new MetaTypeServiceSupport(this.servletSupport.getBundleContext(), metaTypeService);
        }
        return null;
    }

    private Map<String, Object> getAllowedValues(Configuration config, Dictionary<String, Object> props) throws IOException {
        List<String> allowedProperties = this.getJsonSupport().getPropertyNamesForForm(config.getFactoryPid(), config.getPid(), props);
        HashMap<String, Object> allowedValues = new HashMap<String, Object>();
        Dictionary origProps = config.getProperties();
        if (origProps != null) {
            for (String name : Collections.list(origProps.keys())) {
                if (allowedProperties.contains(name)) continue;
                allowedValues.put(name, origProps.get(name));
            }
        }
        return allowedValues;
    }

    /*
     * WARNING - void declaration
     */
    void applyConfiguration(HttpServletRequest request, String pid, String[] propertyList, boolean isUpdate) throws ValidationException, IOException {
        String factoryPid = request.getParameter("factoryPid");
        Configuration config = ConfigurationUtil.getOrCreateConfiguration(this.service, this.configurationHandlers, pid, factoryPid);
        Hashtable<String, Object> props = config.getProperties();
        if (props == null) {
            props = new Hashtable<String, Object>();
        }
        Map<String, Object> allowedValues = this.getAllowedValues(config, props);
        MetaTypeServiceSupport mtss = this.getMetaTypeSupport();
        Map<Object, Object> adMap = mtss != null ? mtss.getAttributeDefinitionMap(config, null) : new HashMap();
        ArrayList<String> propsToKeep = new ArrayList<String>();
        for (String propName : propertyList) {
            void var24_32;
            String value;
            String paramName = "action".equals(propName) || "delete".equals(propName) || "apply".equals(propName) || "propertylist".equals(propName) ? '$' + propName : propName;
            propsToKeep.add(propName);
            PropertyDescriptor ad = (PropertyDescriptor)adMap.get(propName);
            if (ad == null) {
                Object currentValue = ((Dictionary)props).get(propName);
                ad = MetaTypeSupport.createAttributeDefinition(propName, currentValue);
            }
            int attributeType = MetaTypeSupport.getAttributeType(ad);
            if (ad.getCardinality() == 0 && (attributeType == 1 || attributeType == 12)) {
                value = request.getParameter(paramName);
                if (value == null || attributeType == 12 && "unmodified".equals(value)) continue;
                ((Dictionary)props).put(propName, value);
                continue;
            }
            if (ad.getCardinality() == 0) {
                value = request.getParameter(paramName);
                if (value == null) continue;
                try {
                    ((Dictionary)props).put(propName, MetaTypeSupport.toType(attributeType, value));
                }
                catch (NumberFormatException nfe) {
                    ((Dictionary)props).put(propName, value);
                }
                continue;
            }
            Vector<Object> vec = new Vector<Object>();
            boolean formatError = false;
            String[] values = request.getParameterValues(paramName);
            if (values != null) {
                if (attributeType == 12) {
                    MetaTypeSupport.setPasswordProps(vec, values, ((Dictionary)props).get(propName));
                } else {
                    for (int i = 0; i < values.length; ++i) {
                        try {
                            vec.add(MetaTypeSupport.toType(attributeType, values[i]));
                            continue;
                        }
                        catch (NumberFormatException nfe) {
                            vec.add(values[i]);
                            formatError = true;
                        }
                    }
                }
            }
            if (formatError) {
                Vector<String> newVec = new Vector<String>();
                for (Object e : vec) {
                    newVec.add(e.toString());
                }
                vec = newVec;
            }
            int maxSize = Math.abs(ad.getCardinality());
            if (vec.size() > maxSize && maxSize > 0) {
                vec.setSize(maxSize);
            }
            String[] valueArray = new String[vec.size()];
            boolean bl = false;
            while (var24_32 < vec.size()) {
                valueArray[var24_32] = vec.get((int)var24_32).toString();
                ++var24_32;
            }
            if (ad.getCardinality() < 0) {
                if (vec.isEmpty()) {
                    ((Dictionary)props).remove(propName);
                    continue;
                }
                ((Dictionary)props).put(propName, vec);
                continue;
            }
            ((Dictionary)props).put(propName, MetaTypeSupport.toArray(formatError ? 1 : attributeType, vec));
        }
        if (!isUpdate) {
            Iterator<Map.Entry<String, Object>> updateProps = new Hashtable(((Dictionary)props).size());
            Enumeration e = ((Dictionary)props).keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!propsToKeep.contains(key) || ((Dictionary)props).get(key) == null) continue;
                ((Dictionary)((Object)updateProps)).put(key, ((Dictionary)props).get(key));
            }
            props = updateProps;
        }
        for (ConfigurationHandler h : this.configurationHandlers) {
            h.updateConfiguration(factoryPid, pid, (Dictionary<String, Object>)props);
        }
        for (Map.Entry<String, Object> allowed : allowedValues.entrySet()) {
            ((Dictionary)props).put(allowed.getKey(), allowed.getValue());
        }
        String location = request.getParameter("$location");
        if (location == null || location.trim().length() == 0 || "??unbound:bundle/location".equals(location)) {
            if (config.getBundleLocation() != null) {
                config.setBundleLocation(null);
                if (config.getBundleLocation() != null) {
                    config.setBundleLocation("??invalid:bundle/location");
                    config.setBundleLocation(null);
                }
            }
        } else if (config.getBundleLocation() == null || !config.getBundleLocation().equals(location)) {
            config.setBundleLocation(location);
        }
        config.update((Dictionary)props);
    }

    public void deleteConfiguration(String pid) throws ValidationException, IOException {
        Configuration config;
        if (!ConfigurationUtil.getPlaceholderPid().equals(pid) && (config = ConfigurationUtil.findConfiguration(this.service, pid)) != null) {
            for (ConfigurationHandler h : this.configurationHandlers) {
                h.deleteConfiguration(config.getFactoryPid(), config.getPid());
            }
            config.delete();
        }
    }

    public Configuration findConfiguration(String pid) {
        return ConfigurationUtil.findConfiguration(this.service, pid);
    }

    public Configuration[] listConfigurations(String filter) throws IOException, InvalidSyntaxException {
        return this.service.listConfigurations(filter);
    }

    static {
        CONFIG_PROPERTIES_HIDE.add(PROPERTY_FACTORYCONFIG_NAMEHINT);
        CONFIG_PROPERTIES_HIDE.add("service.bundleLocation");
        CONFIG_PROPERTIES_HIDE.add("service.factoryPid");
        CONFIG_PROPERTIES_HIDE.add("service.pid");
        NAMEHINT_PLACEHOLER_REGEXP = Pattern.compile("\\{([^\\{\\}]*)}");
    }
}

