/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.inventory.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.felix.inventory.Format;
import org.apache.felix.inventory.InventoryPrinter;
import org.apache.felix.inventory.impl.DefaultWebConsolePlugin;
import org.apache.felix.inventory.impl.InventoryPrinterAdapter;
import org.apache.felix.inventory.impl.InventoryPrinterDescription;
import org.apache.felix.inventory.impl.InventoryPrinterHandler;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class InventoryPrinterManagerImpl
implements ServiceTrackerCustomizer {
    private final BundleContext bundleContext;
    private final ServiceTracker cfgPrinterTracker;
    private final Map allAdapters = new HashMap();
    private final Set usedAdapters = new TreeSet();
    private final ServiceRegistration pluginRegistration;

    public InventoryPrinterManagerImpl(BundleContext btx) throws InvalidSyntaxException {
        this.bundleContext = btx;
        this.cfgPrinterTracker = new ServiceTracker(this.bundleContext, "org.apache.felix.inventory.InventoryPrinter", this);
        this.cfgPrinterTracker.open();
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("felix.webconsole.label", "config");
        ((Dictionary)props).put("felix.webconsole.title", "Overview");
        ((Dictionary)props).put("felix.webconsole.category", "Status");
        this.pluginRegistration = btx.registerService("javax.servlet.Servlet", (Object)new ServiceFactory(){

            public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
            }

            public Object getService(Bundle bundle, ServiceRegistration registration) {
                return new DefaultWebConsolePlugin(InventoryPrinterManagerImpl.this);
            }
        }, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.pluginRegistration != null) {
            this.pluginRegistration.unregister();
        }
        this.cfgPrinterTracker.close();
        Object object = this.allAdapters;
        synchronized (object) {
            this.allAdapters.clear();
        }
        object = this.usedAdapters;
        synchronized (object) {
            this.usedAdapters.clear();
        }
    }

    public Object addingService(ServiceReference reference) {
        Object obj = this.bundleContext.getService(reference);
        if (obj != null) {
            this.addService(reference, (InventoryPrinter)obj);
        }
        return obj;
    }

    public void modifiedService(ServiceReference reference, Object service) {
        this.removeService(reference);
        this.addService(reference, (InventoryPrinter)service);
    }

    public void removedService(ServiceReference reference, Object service) {
        this.removeService(reference);
        this.bundleContext.ungetService(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addService(ServiceReference reference, InventoryPrinter obj) {
        InventoryPrinterDescription desc = new InventoryPrinterDescription(reference);
        InventoryPrinterAdapter adapter = new InventoryPrinterAdapter(desc, obj);
        InventoryPrinterAdapter removeAdapter = null;
        InventoryPrinterAdapter addAdapter = null;
        String key = adapter.getName();
        Object object = this.allAdapters;
        synchronized (object) {
            InventoryPrinterAdapter first;
            LinkedList<InventoryPrinterAdapter> list = (LinkedList<InventoryPrinterAdapter>)this.allAdapters.get(key);
            if (list == null) {
                list = new LinkedList<InventoryPrinterAdapter>();
                this.allAdapters.put(key, list);
                first = null;
            } else {
                first = (InventoryPrinterAdapter)list.get(0);
            }
            list.add(adapter);
            Collections.sort(list, InventoryPrinterAdapter.RANKING_COMPARATOR);
            if (first != null) {
                if (first != list.get(0)) {
                    removeAdapter = first;
                    addAdapter = adapter;
                }
            } else {
                addAdapter = adapter;
            }
        }
        if (removeAdapter != null) {
            removeAdapter.unregisterConsole();
            object = this.usedAdapters;
            synchronized (object) {
                this.usedAdapters.remove(removeAdapter);
            }
        }
        if (addAdapter != null) {
            object = this.usedAdapters;
            synchronized (object) {
                this.usedAdapters.add(addAdapter);
            }
            addAdapter.registerConsole(this.bundleContext, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeService(ServiceReference reference) {
        Map map = this.allAdapters;
        synchronized (map) {
            Iterator i = this.allAdapters.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                Iterator iter = ((List)entry.getValue()).iterator();
                boolean removed = false;
                while (iter.hasNext()) {
                    InventoryPrinterAdapter adapter = (InventoryPrinterAdapter)iter.next();
                    if (!adapter.getDescription().getServiceReference().equals(reference)) continue;
                    iter.remove();
                    removed = true;
                    break;
                }
                if (!removed) continue;
                if (((List)entry.getValue()).size() != 0) break;
                i.remove();
                break;
            }
        }
        InventoryPrinterAdapter adapterToUnregister = null;
        Set set = this.usedAdapters;
        synchronized (set) {
            Iterator iter = this.usedAdapters.iterator();
            while (iter.hasNext()) {
                InventoryPrinterAdapter adapter = (InventoryPrinterAdapter)iter.next();
                if (!adapter.getDescription().getServiceReference().equals(reference)) continue;
                iter.remove();
                adapterToUnregister = adapter;
                break;
            }
        }
        if (adapterToUnregister != null) {
            adapterToUnregister.unregisterConsole();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryPrinterHandler[] getHandlers(Format format) {
        ArrayList<InventoryPrinterAdapter> result = new ArrayList<InventoryPrinterAdapter>();
        Set set = this.usedAdapters;
        synchronized (set) {
            Iterator i = this.usedAdapters.iterator();
            while (i.hasNext()) {
                InventoryPrinterAdapter printer = (InventoryPrinterAdapter)i.next();
                if (format != null && !printer.supports(format)) continue;
                result.add(printer);
            }
        }
        return result.toArray(new InventoryPrinterHandler[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryPrinterHandler getHandler(String name) {
        Set set = this.usedAdapters;
        synchronized (set) {
            Iterator i = this.usedAdapters.iterator();
            while (i.hasNext()) {
                InventoryPrinterAdapter printer = (InventoryPrinterAdapter)i.next();
                if (!name.equals(printer.getName())) continue;
                return printer;
            }
        }
        return null;
    }
}

