/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.useradmin.impl.role;

import org.apache.felix.useradmin.impl.role.ObservableRole;
import org.apache.felix.useradmin.impl.role.ObservableUser;
import org.osgi.service.useradmin.Group;
import org.osgi.service.useradmin.Role;
import org.osgi.service.useradmin.User;

public class ObservableGroup
extends ObservableUser
implements Group {
    private static final long serialVersionUID = 4012536225870565500L;
    private static final String BASIC_MEMBER = "basicMember";
    private static final String REQUIRED_MEMBER = "requiredMember";

    public ObservableGroup(Group group) {
        super((User)group);
    }

    public boolean addMember(Role role) {
        boolean result = ((Group)this.m_delegate).addMember(role);
        if (result) {
            this.entryAdded(BASIC_MEMBER, role);
        }
        return result;
    }

    public boolean addRequiredMember(Role role) {
        boolean result = ((Group)this.m_delegate).addRequiredMember(role);
        if (result) {
            this.entryAdded(REQUIRED_MEMBER, role);
        }
        return result;
    }

    public boolean removeMember(Role role) {
        Role[] members = this.getRequiredMembers();
        boolean result = ((Group)this.m_delegate).removeMember(role);
        if (result) {
            String key = BASIC_MEMBER;
            for (int i = 0; members != null && i < members.length; ++i) {
                if (!members[i].equals(role)) continue;
                key = REQUIRED_MEMBER;
                break;
            }
            this.entryRemoved(key);
        }
        return result;
    }

    public Role[] getMembers() {
        Role[] members = ((Group)this.m_delegate).getMembers();
        if (members == null) {
            return null;
        }
        Role[] result = new Role[members.length];
        for (int i = 0; i < members.length; ++i) {
            result[i] = ObservableRole.wrap(members[i]);
        }
        return result;
    }

    public Role[] getRequiredMembers() {
        Role[] requiredMembers = ((Group)this.m_delegate).getRequiredMembers();
        if (requiredMembers == null) {
            return null;
        }
        Role[] result = new Role[requiredMembers.length];
        for (int i = 0; i < requiredMembers.length; ++i) {
            result[i] = ObservableRole.wrap(requiredMembers[i]);
        }
        return requiredMembers;
    }

    public String toString() {
        return this.m_delegate.toString();
    }
}

