/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.useradmin.impl.role;

import java.io.Serializable;
import java.security.Permission;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.osgi.service.useradmin.UserAdminPermission;

class ObservableDictionary
extends Dictionary
implements Serializable {
    private static final long serialVersionUID = 3161552287666253189L;
    private final Dictionary m_dictionary;
    private final String m_getAction;
    private final String m_changeAction;
    private volatile transient DictionaryChangeListener m_listener;

    public ObservableDictionary(String getAction, String changeAction) {
        this(getAction, changeAction, new Hashtable());
    }

    public ObservableDictionary(String getAction, String changeAction, Dictionary dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("Dictionary cannot be null!");
        }
        this.m_getAction = getAction;
        this.m_changeAction = changeAction;
        this.m_dictionary = dictionary;
    }

    public Enumeration elements() {
        return this.m_dictionary.elements();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ObservableDictionary other = (ObservableDictionary)object;
        return !(this.m_dictionary == null ? other.m_dictionary != null : !this.m_dictionary.equals(other.m_dictionary));
    }

    public Object get(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null!");
        }
        if (this.m_getAction != null) {
            this.checkPermissions(this.getAsPermissionKey(key), this.m_getAction);
        }
        return this.m_dictionary.get(key);
    }

    public int hashCode() {
        int prime = 37;
        int result = 1;
        result = 37 * result + (this.m_dictionary == null ? 0 : this.m_dictionary.hashCode());
        return result;
    }

    public boolean isEmpty() {
        return this.m_dictionary.isEmpty();
    }

    public Enumeration keys() {
        return this.m_dictionary.keys();
    }

    public Object put(Object key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null!");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null!");
        }
        if (this.m_changeAction != null) {
            this.checkPermissions(this.getAsPermissionKey(key), this.m_changeAction);
        }
        Object oldValue = this.m_dictionary.put(key, value);
        DictionaryChangeListener listener = this.m_listener;
        if (listener != null) {
            if (oldValue == null) {
                listener.entryAdded(key, value);
            } else {
                listener.entryChanged(key, oldValue, value);
            }
        }
        return oldValue;
    }

    public Object remove(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null!");
        }
        if (this.m_changeAction != null) {
            this.checkPermissions(this.getAsPermissionKey(key), this.m_changeAction);
        }
        Object oldValue = this.m_dictionary.remove(key);
        DictionaryChangeListener listener = this.m_listener;
        if (listener != null) {
            listener.entryRemoved(key);
        }
        return oldValue;
    }

    public void setDictionaryChangeListener(DictionaryChangeListener listener) {
        this.m_listener = listener;
    }

    public int size() {
        return this.m_dictionary.size();
    }

    protected String getAsPermissionKey(Object key) {
        String k = "admin";
        if (key instanceof String) {
            k = (String)key;
        }
        return k;
    }

    private void checkPermissions(String key, String action) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission((Permission)new UserAdminPermission(key, action));
        }
    }

    static interface DictionaryChangeListener {
        public void entryAdded(Object var1, Object var2);

        public void entryChanged(Object var1, Object var2, Object var3);

        public void entryRemoved(Object var1);
    }
}

