/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.useradmin.impl;

import java.util.Dictionary;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.felix.useradmin.impl.UserAdminListenerList;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.useradmin.Role;
import org.osgi.service.useradmin.UserAdminEvent;
import org.osgi.service.useradmin.UserAdminListener;

public final class EventDispatcher
implements Runnable {
    private static final String TOPIC_BASE = "org/osgi/service/useradmin/UserAdmin/";
    private final EventAdmin m_eventAdmin;
    private final UserAdminListenerList m_listenerList;
    private final BlockingQueue m_eventQueue;
    private final Thread m_backgroundThread;

    public EventDispatcher(EventAdmin eventAdmin, UserAdminListenerList listenerList) {
        if (eventAdmin == null) {
            throw new IllegalArgumentException("EventAdmin cannot be null!");
        }
        if (listenerList == null) {
            throw new IllegalArgumentException("ListenerList cannot be null!");
        }
        this.m_eventAdmin = eventAdmin;
        this.m_listenerList = listenerList;
        this.m_eventQueue = new LinkedBlockingQueue();
        this.m_backgroundThread = new Thread((Runnable)this, "UserAdmin event dispatcher");
    }

    public void dispatch(UserAdminEvent event) {
        if (!this.isRunning()) {
            return;
        }
        try {
            this.m_eventQueue.put(event);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void start() {
        if (!this.isRunning()) {
            this.m_backgroundThread.start();
        }
    }

    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        this.m_eventQueue.add(this);
        try {
            this.m_backgroundThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    final boolean isRunning() {
        return this.m_backgroundThread.isAlive();
    }

    public void run() {
        try {
            Object event;
            while ((event = this.m_eventQueue.take()) instanceof UserAdminEvent) {
                this.deliverEventSynchronously((UserAdminEvent)event);
            }
            return;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    private Event convertEvent(UserAdminEvent event) {
        String topic = this.getTopicName(event.getType());
        Role role = event.getRole();
        ServiceReference serviceRef = event.getServiceReference();
        Properties props = new Properties();
        props.put("event.topics", TOPIC_BASE.concat(topic));
        props.put("event", event);
        props.put("role", role);
        props.put("role.name", role.getName());
        props.put("role.type", new Integer(role.getType()));
        if (serviceRef != null) {
            props.put("service", serviceRef);
            Object property = serviceRef.getProperty("service.id");
            if (property != null) {
                props.put("service.id", property);
            }
            if ((property = serviceRef.getProperty("objectClass")) != null) {
                props.put("service.objectClass", property);
            }
            if ((property = serviceRef.getProperty("service.pid")) != null) {
                props.put("service.pid", property);
            }
        }
        return new Event(topic, (Dictionary)props);
    }

    private void deliverEventSynchronously(UserAdminEvent event) {
        this.m_eventAdmin.postEvent(this.convertEvent(event));
        UserAdminListener[] listeners = this.m_listenerList.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].roleChanged(event);
        }
    }

    private String getTopicName(int type) {
        switch (type) {
            case 1: {
                return "ROLE_CREATED";
            }
            case 2: {
                return "ROLE_CHANGED";
            }
            case 4: {
                return "ROLE_REMOVED";
            }
        }
        return null;
    }
}

