/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.useradmin.impl;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.felix.useradmin.impl.RoleChecker;
import org.apache.felix.useradmin.impl.RoleRepository;
import org.osgi.service.useradmin.Authorization;
import org.osgi.service.useradmin.Role;
import org.osgi.service.useradmin.User;

public class AuthorizationImpl
implements Authorization {
    private final String m_name;
    private final User m_user;
    private final RoleRepository m_roleManager;
    private final RoleChecker m_roleChecker;

    public AuthorizationImpl(RoleRepository roleManager) {
        this(null, roleManager);
    }

    public AuthorizationImpl(User user, RoleRepository roleManager) {
        this.m_user = user;
        this.m_roleManager = roleManager;
        this.m_name = user != null ? user.getName() : null;
        this.m_roleChecker = new RoleChecker();
    }

    public String getName() {
        return this.m_name;
    }

    public boolean hasRole(String name) {
        Role role = this.m_roleManager.getRoleByName(name);
        if (role == null) {
            return false;
        }
        return this.m_roleChecker.isImpliedBy(role, (Role)this.m_user);
    }

    public String[] getRoles() {
        ArrayList<String> result = new ArrayList<String>();
        Iterator rolesIter = this.m_roleManager.getRoles(null).iterator();
        while (rolesIter.hasNext()) {
            Role role = (Role)rolesIter.next();
            if ("user.anyone".equals(role.getName()) || !this.m_roleChecker.isImpliedBy(role, (Role)this.m_user)) continue;
            result.add(role.getName());
        }
        return result.isEmpty() ? null : result.toArray(new String[result.size()]);
    }
}

