/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.systemready.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.felix.rootcause.DSComp;
import org.apache.felix.rootcause.DSRootCause;
import org.apache.felix.rootcause.RootCausePrinter;
import org.apache.felix.systemready.CheckStatus;
import org.apache.felix.systemready.StateType;
import org.apache.felix.systemready.SystemReadyCheck;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SystemReadyCheck.class}, name="org.apache.felix.systemready.impl.ComponentsCheck", configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=Config.class)
public class ComponentsCheck
implements SystemReadyCheck {
    public static final String PID = "org.apache.felix.systemready.impl.ComponentsCheck";
    private static final CheckStatus INVALID = new CheckStatus("invalid", StateType.READY, CheckStatus.State.RED, "invalid");
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private List<String> componentsList;
    private DSRootCause analyzer;
    private StateType type;
    private ServiceComponentRuntime scr;
    private final AtomicReference<CheckStatus> cache = new AtomicReference();

    @Activate
    public void activate(BundleContext ctx, Config config) throws InterruptedException {
        this.analyzer = new DSRootCause(this.scr);
        this.type = config.type();
        this.componentsList = Arrays.asList(config.components_list());
        this.cache.set(INVALID);
    }

    @Override
    public String getName() {
        return "Components Check " + this.componentsList;
    }

    private List<DSComp> getComponents(Collection<ComponentDescriptionDTO> descriptions) {
        try {
            return descriptions.stream().filter(desc -> this.componentsList.contains(desc.name)).map(arg_0 -> ((DSRootCause)this.analyzer).getRootCause(arg_0)).collect(Collectors.toList());
        }
        catch (Throwable e) {
            this.log.warn("Exception while getting ds component dtos {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    @Override
    public CheckStatus getStatus() {
        CheckStatus result = null;
        while (result == null) {
            this.cache.compareAndSet(INVALID, null);
            result = this.cache.get();
            if (result == INVALID) {
                result = null;
                continue;
            }
            if (result != null) continue;
            List<DSComp> watchedComps = this.getComponents(this.scr.getComponentDescriptionDTOs(new Bundle[0]));
            if (watchedComps == null) {
                result = new CheckStatus(this.getName(), this.type, CheckStatus.State.RED, "Exception while checking ds component dtos.");
            } else if (watchedComps.size() < this.componentsList.size()) {
                ArrayList<String> missed = new ArrayList<String>(this.componentsList);
                for (DSComp c : watchedComps) {
                    missed.remove(c.desc.name);
                }
                result = new CheckStatus(this.getName(), this.type, CheckStatus.State.RED, "Not all named components could be found, missing : " + missed);
            } else {
                try {
                    StringBuilder details = new StringBuilder();
                    watchedComps.stream().forEach(dsComp -> this.addDetails((DSComp)dsComp, details));
                    CheckStatus.State state = CheckStatus.State.worstOf(watchedComps.stream().map(this::status));
                    result = new CheckStatus(this.getName(), this.type, state, details.toString());
                }
                catch (Throwable e) {
                    this.log.warn("Exception while checking ds component dtos {}", (Object)e.getMessage(), (Object)e);
                    result = new CheckStatus(this.getName(), this.type, CheckStatus.State.RED, "Exception while checking ds component dtos : " + e.getMessage());
                }
            }
            this.cache.compareAndSet(null, result);
        }
        return result;
    }

    private CheckStatus.State status(DSComp component) {
        boolean missingConfig = component.config == null && "require".equals(component.desc.configurationPolicy);
        boolean unsatisfied = !component.unsatisfied.isEmpty();
        return missingConfig || unsatisfied ? CheckStatus.State.YELLOW : CheckStatus.State.GREEN;
    }

    private void addDetails(DSComp component, StringBuilder details) {
        RootCausePrinter printer = new RootCausePrinter(st -> details.append(st + "\n"));
        printer.print(component);
    }

    @Reference(policyOption=ReferencePolicyOption.GREEDY, updated="updatedServiceComponentRuntime")
    private void setServiceComponentRuntime(ServiceComponentRuntime c) {
        this.scr = c;
    }

    private void unsetServiceComponentRuntime(ServiceComponentRuntime c) {
        this.scr = null;
    }

    private void updatedServiceComponentRuntime(ServiceComponentRuntime c) {
        this.cache.set(INVALID);
    }

    @ObjectClassDefinition(name="DS Components System Ready Check", description="System ready check that checks a list of DS componentsand provides root cause analysis in case of errors")
    public static @interface Config {
        @AttributeDefinition(name="Components list", description="The components that need to come up before this check reports GREEN")
        public String[] components_list();

        @AttributeDefinition(name="Check type")
        public StateType type() default StateType.ALIVE;
    }
}

