/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.systemready.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.felix.rootcause.DSComp;
import org.apache.felix.rootcause.DSRootCause;
import org.apache.felix.rootcause.RootCausePrinter;
import org.apache.felix.systemready.CheckStatus;
import org.apache.felix.systemready.StateType;
import org.apache.felix.systemready.SystemReadyCheck;
import org.apache.felix.systemready.impl.Tracker;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(name="org.apache.felix.systemready.impl.ServicesCheck", configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=Config.class)
public class ServicesCheck
implements SystemReadyCheck {
    public static final String PID = "org.apache.felix.systemready.impl.ServicesCheck";
    private List<String> servicesList;
    private Map<String, Tracker> trackers;
    private DSRootCause analyzer;
    private StateType type;
    @Reference
    private ServiceComponentRuntime scr;

    @Activate
    public void activate(BundleContext ctx, Config config) throws InterruptedException {
        this.analyzer = new DSRootCause(this.scr);
        this.servicesList = Arrays.asList(config.services_list());
        this.trackers = this.servicesList.stream().collect(Collectors.toMap(Function.identity(), serviceName -> new Tracker(ctx, (String)serviceName)));
        this.type = config.type();
    }

    @Deactivate
    protected void deactivate() {
        this.trackers.values().stream().forEach(Tracker::close);
        this.trackers.clear();
    }

    @Override
    public String getName() {
        return "Services Check";
    }

    @Override
    public CheckStatus getStatus() {
        boolean allPresent = this.trackers.values().stream().allMatch(Tracker::present);
        CheckStatus.State state = CheckStatus.State.fromBoolean(allPresent);
        return new CheckStatus(this.getName(), this.type, state, this.getDetails());
    }

    private String getDetails() {
        List<String> missing = this.getMissing();
        StringBuilder missingSt = new StringBuilder();
        RootCausePrinter printer = new RootCausePrinter(st -> missingSt.append(st + "\n"));
        for (String iface : missing) {
            Optional rootCause = this.analyzer.getRootCause(iface);
            if (rootCause.isPresent()) {
                printer.print((DSComp)rootCause.get());
                continue;
            }
            missingSt.append("Missing service without matching DS component: " + iface);
        }
        return missingSt.toString();
    }

    private List<String> getMissing() {
        List<String> missing = this.trackers.entrySet().stream().filter(entry -> !((Tracker)entry.getValue()).present()).map(entry -> (String)entry.getKey()).collect(Collectors.toList());
        return missing;
    }

    @ObjectClassDefinition(name="Services Registered System Ready Check", description="System ready check that waits for a list of services to be registered")
    public static @interface Config {
        @AttributeDefinition(name="Services list", description="The services that need to be registered for the check to pass")
        public String[] services_list();

        @AttributeDefinition(name="Check type")
        public StateType type() default StateType.ALIVE;
    }
}

