/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.systemready;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.felix.systemready.StateType;

public final class CheckStatus {
    private final String checkName;
    private final StateType type;
    private final State state;
    private final String details;

    public CheckStatus(String checkName, StateType type, State state, String details) {
        this.checkName = checkName;
        this.type = type;
        this.state = state;
        this.details = details;
    }

    public String getCheckName() {
        return this.checkName;
    }

    public StateType getType() {
        return this.type;
    }

    public State getState() {
        return this.state;
    }

    public String getDetails() {
        return this.details;
    }

    public String toString() {
        return "CheckStatus{state=" + (Object)((Object)this.state) + ", details='" + this.details + '\'' + '}';
    }

    public static enum State {
        RED,
        YELLOW,
        GREEN;


        public static State fromBoolean(boolean ready) {
            return ready ? GREEN : YELLOW;
        }

        public static State worstOf(Stream<State> states) {
            return states.collect(Collectors.minBy(Enum::compareTo)).orElse(GREEN);
        }
    }
}

