/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.systemready.impl.servlet;

import java.io.PrintWriter;
import java.util.stream.Collectors;
import org.apache.felix.systemready.CheckStatus;
import org.apache.felix.systemready.SystemStatus;

public class StatusWriterJson {
    private PrintWriter writer;

    public StatusWriterJson(PrintWriter writer) {
        this.writer = writer;
    }

    public void write(SystemStatus systemState) {
        this.writer.println("{");
        this.writer.println(String.format("  \"systemStatus\": \"%s\", ", systemState.getState().name()));
        this.writer.println("  \"checks\": [");
        String states = systemState.getCheckStates().stream().map(this::getStatus).collect(Collectors.joining(",\n"));
        this.writer.println(states);
        this.writer.println("  ]");
        this.writer.println("}");
    }

    private String getStatus(CheckStatus status) {
        return String.format("    { \"check\": \"%s\", \"status\": \"%s\", \"details\": \"%s\" }", status.getCheckName(), status.getState().name(), status.getDetails());
    }
}

