/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.systemready.impl.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.systemready.Status;
import org.apache.felix.systemready.SystemReadyMonitor;
import org.apache.felix.systemready.SystemStatus;
import org.apache.felix.systemready.impl.servlet.StatusWriterJson;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="org.apache.felix.systemready.impl.servlet.SystemReadyServlet", service={Servlet.class}, property={"osgi.http.whiteboard.servlet.pattern=/systemready"})
@Designate(ocd=Config.class)
public class SystemReadyServlet
extends HttpServlet {
    public static final String PID = "org.apache.felix.systemready.impl.servlet.SystemReadyServlet";
    private static final long serialVersionUID = 1L;
    @Reference
    private SystemReadyMonitor monitor;
    private static final String DEFAULT_PATH = "/system/console/ready";
    private static final Logger LOG = LoggerFactory.getLogger(SystemReadyServlet.class);

    @Activate
    protected void activate(BundleContext ctx, Map<String, Object> properties, Config config) {
        String path = config.osgi_http_whiteboard_servlet_pattern();
        LOG.info("Registered servlet to listen on {}", (Object)path);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        SystemStatus systemState = this.monitor.getStatus();
        if (systemState.getState() != Status.State.GREEN) {
            response.setStatus(503);
        }
        PrintWriter writer = response.getWriter();
        new StatusWriterJson(writer).write(systemState);
    }

    @ObjectClassDefinition(name="System Ready Servlet", description="Servlet exposing a configurable http endpoint for showing the status reported by the system ready monitor")
    public static @interface Config {
        @AttributeDefinition(name="Servlet Path")
        public String osgi_http_whiteboard_servlet_pattern() default "/system/console/ready";

        @AttributeDefinition(name="Servlet Context select")
        public String osgi_http_whiteboard_context_select();
    }
}

