/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.systemready.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.felix.systemready.CheckStatus;
import org.apache.felix.systemready.Status;
import org.apache.felix.systemready.SystemReady;
import org.apache.felix.systemready.SystemReadyCheck;
import org.apache.felix.systemready.SystemReadyMonitor;
import org.apache.felix.systemready.SystemStatus;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="org.apache.felix.systemready.SystemReadyMonitor")
@Designate(ocd=Config.class)
public class SystemReadyMonitorImpl
implements SystemReadyMonitor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(policyOption=ReferencePolicyOption.GREEDY, policy=ReferencePolicy.DYNAMIC)
    private volatile List<SystemReadyCheck> checks;
    private BundleContext context;
    private ServiceRegistration<SystemReady> sreg;
    private ScheduledExecutorService executor;
    private AtomicReference<SystemStatus> systemState;

    public SystemReadyMonitorImpl() {
        SystemStatus initialStatus = new SystemStatus(Status.State.YELLOW, Collections.emptyList());
        this.systemState = new AtomicReference<SystemStatus>(initialStatus);
    }

    @Activate
    public void activate(BundleContext context, Config config) {
        this.context = context;
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.executor.scheduleAtFixedRate(this::check, 0L, config.poll_interval(), TimeUnit.MILLISECONDS);
        this.log.info("Activated. Running checks every {} ms.", (Object)config.poll_interval());
    }

    @Deactivate
    public void deactivate() {
        this.executor.shutdown();
    }

    @Override
    public boolean isReady() {
        return this.systemState.get().getState() == Status.State.GREEN;
    }

    @Override
    public SystemStatus getStatus() {
        return this.systemState.get();
    }

    private void check() {
        Status.State prevState = this.systemState.get().getState();
        ArrayList<SystemReadyCheck> currentChecks = new ArrayList<SystemReadyCheck>(this.checks);
        List checkNames = currentChecks.stream().map(check -> check.getName()).collect(Collectors.toList());
        this.log.debug("Running system checks {}", checkNames);
        List<CheckStatus> statuses = this.evaluateAllChecks(currentChecks);
        Status.State currState = Status.State.worstOf(statuses.stream().map(status -> status.getStatus().getState()));
        this.systemState.set(new SystemStatus(currState, statuses));
        if (currState != prevState) {
            this.manageMarkerService(currState);
        }
        this.log.debug("Checks finished");
    }

    private List<CheckStatus> evaluateAllChecks(List<SystemReadyCheck> currentChecks) {
        return currentChecks.stream().map(SystemReadyMonitorImpl::getStatus).sorted(Comparator.comparing(CheckStatus::getCheckName)).collect(Collectors.toList());
    }

    private void manageMarkerService(Status.State currState) {
        if (currState == Status.State.GREEN) {
            SystemReady readyService = new SystemReady(){};
            this.sreg = this.context.registerService(SystemReady.class, (Object)readyService, null);
        } else {
            this.sreg.unregister();
        }
    }

    private static final CheckStatus getStatus(SystemReadyCheck c) {
        try {
            return new CheckStatus(c.getName(), c.getStatus());
        }
        catch (Throwable e) {
            return new CheckStatus(c.getClass().getName(), new Status(Status.State.RED, e.getMessage()));
        }
    }

    @ObjectClassDefinition(name="System Ready Monitor", description="System ready monitor for System Ready Checks")
    public static @interface Config {
        @AttributeDefinition(name="Poll interval", description="Number of milliseconds between subsequents updates of all the checks")
        public long poll_interval() default 5000L;
    }
}

