/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.systemready.impl;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.felix.systemready.Status;
import org.apache.felix.systemready.SystemReadyCheck;
import org.apache.felix.systemready.rootcause.DSComp;
import org.apache.felix.systemready.rootcause.DSRootCause;
import org.apache.felix.systemready.rootcause.RootCausePrinter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(name="org.apache.felix.systemready.impl.ComponentsCheck", configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=Config.class)
public class ComponentsCheck
implements SystemReadyCheck {
    public static final String PID = "org.apache.felix.systemready.impl.ComponentsCheck";
    private List<String> componentsList;
    DSRootCause analyzer;
    @Reference
    ServiceComponentRuntime scr;

    @Activate
    public void activate(BundleContext ctx, Config config) throws InterruptedException {
        this.analyzer = new DSRootCause(this.scr);
        this.componentsList = Arrays.asList(config.components_list());
    }

    @Deactivate
    protected void deactivate() {
    }

    @Override
    public String getName() {
        return "Components Check";
    }

    @Override
    public Status getStatus() {
        StringBuilder details = new StringBuilder();
        List watchedComps = this.scr.getComponentDescriptionDTOs(new Bundle[0]).stream().filter(desc -> this.componentsList.contains(desc.name)).map(this.analyzer::getRootCause).collect(Collectors.toList());
        if (watchedComps.size() < this.componentsList.size()) {
            throw new IllegalStateException("Not all named components could be found");
        }
        watchedComps.stream().forEach(dsComp -> this.addDetails((DSComp)((Object)dsComp), details));
        Status.State state = Status.State.worstOf(watchedComps.stream().map(this::status));
        return new Status(state, details.toString());
    }

    private Status.State status(DSComp component) {
        boolean missingConfig = component.config == null && "require".equals(component.desc.configurationPolicy);
        return missingConfig || !component.unsatisfied.isEmpty() ? Status.State.YELLOW : Status.State.GREEN;
    }

    private void addDetails(DSComp component, StringBuilder details) {
        RootCausePrinter printer = new RootCausePrinter(st -> details.append(st + "\n"));
        printer.print(component);
    }

    @ObjectClassDefinition(name="DS Components System Ready Check", description="System ready check that checks a list of DS componentsand provides root cause analysis in case of errors")
    public static @interface Config {
        @AttributeDefinition(name="Components list", description="The components that need to come up before this check reports GREEN")
        public String[] components_list();
    }
}

