/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.scrplugin.Log;
import org.apache.felix.scrplugin.Project;
import org.apache.felix.scrplugin.SCRDescriptorException;
import org.apache.felix.scrplugin.SCRDescriptorFailureException;
import org.apache.felix.scrplugin.Source;
import org.apache.felix.scrplugin.annotations.AnnotationProcessor;
import org.apache.felix.scrplugin.annotations.ClassAnnotation;
import org.apache.felix.scrplugin.annotations.FieldAnnotation;
import org.apache.felix.scrplugin.annotations.MethodAnnotation;
import org.apache.felix.scrplugin.annotations.ScannedAnnotation;
import org.apache.felix.scrplugin.annotations.ScannedClass;
import org.apache.felix.scrplugin.description.ClassDescription;
import org.apache.felix.scrplugin.description.ComponentDescription;
import org.apache.felix.scrplugin.description.PropertyDescription;
import org.apache.felix.scrplugin.description.ReferenceDescription;
import org.apache.felix.scrplugin.description.ServiceDescription;
import org.apache.felix.scrplugin.helper.IssueLog;
import org.apache.felix.scrplugin.xml.ComponentDescriptorIO;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class ClassScanner {
    private static final String SERVICE_COMPONENT = "Service-Component";
    private static final String ABSTRACT_DESCRIPTOR_ARCHIV_PATH = "OSGI-INF/scr-plugin/scrinfo.xml";
    private static final String GENERATED = "<generated>";
    private static final Pattern ARRAY_PARAM_TYPE_NAME = Pattern.compile("^\\[L(.*);$");
    private Map<String, ClassDescription> loadedDependencies;
    private final Map<String, ClassDescription> allDescriptions = new HashMap<String, ClassDescription>();
    private final Log log;
    private final IssueLog iLog;
    private final Project project;
    private final AnnotationProcessor aProcessor;

    public ClassScanner(Log log, IssueLog iLog, Project project, AnnotationProcessor aProcessor) {
        this.allDescriptions.put(Object.class.getName(), new ClassDescription(Object.class, GENERATED));
        this.log = log;
        this.iLog = iLog;
        this.project = project;
        this.aProcessor = aProcessor;
    }

    public List<ClassDescription> scanSources() throws SCRDescriptorFailureException, SCRDescriptorException {
        ArrayList<ClassDescription> result = new ArrayList<ClassDescription>();
        for (Source src : this.project.getSources()) {
            if (src.getFile().getName().equals("package-info.java")) {
                this.log.debug("Skipping file " + src.getClassName());
                continue;
            }
            this.log.debug("Scanning class " + src.getClassName());
            try {
                Class<?> annotatedClass = this.project.getClassLoader().loadClass(src.getClassName());
                this.process(annotatedClass, src, result);
            }
            catch (SCRDescriptorFailureException e) {
                throw e;
            }
            catch (SCRDescriptorException e) {
                throw e;
            }
            catch (ClassNotFoundException e) {
                this.log.warn("ClassNotFoundException: " + e.getMessage());
            }
            catch (NoClassDefFoundError e) {
                this.log.warn("NoClassDefFoundError: " + e.getMessage());
            }
            catch (Throwable t) {
                throw new SCRDescriptorException("Unable to load compiled class: " + src.getClassName(), src.getFile().toString(), t);
            }
        }
        return result;
    }

    private void process(Class<?> annotatedClass, Source src, List<ClassDescription> result) throws SCRDescriptorFailureException, SCRDescriptorException {
        ClassDescription desc = this.processClass(annotatedClass, src.getFile().toString());
        if (desc != null) {
            this.allDescriptions.put(annotatedClass.getName(), desc);
            if (desc.getDescriptions(ComponentDescription.class).size() > 0) {
                result.add(desc);
                this.log.debug("Found component description " + desc + " in " + annotatedClass.getName());
            } else if (desc.getDescription(PropertyDescription.class) != null || desc.getDescription(ReferenceDescription.class) != null || desc.getDescription(ServiceDescription.class) != null) {
                this.iLog.addWarning("Class '" + src.getClassName() + "' contains SCR annotations, but not a @Component (or equivalent) annotation. Therefore no component descriptor is created for this class. Please add a @Component annotation and consider making it abstract.", src.getFile().toString());
            }
        } else {
            this.allDescriptions.put(annotatedClass.getName(), new ClassDescription(annotatedClass, GENERATED));
        }
        for (Class<?> innerClass : annotatedClass.getDeclaredClasses()) {
            if (innerClass.isAnnotation() || innerClass.isInterface()) continue;
            this.process(innerClass, src, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassDescription processClass(Class<?> annotatedClass, String location) throws SCRDescriptorFailureException, SCRDescriptorException {
        this.log.debug("Processing " + annotatedClass.getName());
        try {
            ClassReader classReader;
            String pathToClassFile = annotatedClass.getName().replace('.', '/') + ".class";
            InputStream input = this.project.getClassLoader().getResourceAsStream(pathToClassFile);
            try {
                classReader = new ClassReader(input);
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 7);
            List<ScannedAnnotation> annotations = this.extractAnnotation(classNode, annotatedClass);
            if (annotations.size() > 0) {
                ClassDescription desc = new ClassDescription(annotatedClass, location);
                this.aProcessor.process(new ScannedClass(annotations, annotatedClass), desc);
                this.log.debug("Found descriptions " + desc + " in " + annotatedClass.getName());
                return desc;
            }
        }
        catch (IllegalArgumentException ioe) {
            throw new SCRDescriptorException("Unable to scan class files: " + annotatedClass.getName() + " (Class file format probably not supported by ASM ?)", location, ioe);
        }
        catch (IOException ioe) {
            throw new SCRDescriptorException("Unable to scan class files: " + annotatedClass.getName(), location, ioe);
        }
        return null;
    }

    private final List<ScannedAnnotation> extractAnnotation(ClassNode classNode, Class<?> annotatedClass) throws SCRDescriptorException {
        ArrayList<ScannedAnnotation> descriptions = new ArrayList<ScannedAnnotation>();
        List<AnnotationNode> annotations = this.getAllAnnotations(classNode.invisibleAnnotations, classNode.visibleAnnotations);
        if (annotations != null) {
            List list;
            AccessibleObject found;
            List<AnnotationNode> annos;
            for (AnnotationNode annotationNode : annotations) {
                this.parseAnnotation(descriptions, annotationNode, annotatedClass);
            }
            List methods = classNode.methods;
            if (methods != null) {
                for (MethodNode method : methods) {
                    String name = method.name;
                    if ("<init>".equals(name) || (annos = this.getAllAnnotations(method.invisibleAnnotations, method.visibleAnnotations)) == null) continue;
                    Type[] signature = Type.getArgumentTypes((String)method.desc);
                    Method[] allMethods = annotatedClass.getDeclaredMethods();
                    found = null;
                    for (AccessibleObject accessibleObject : allMethods) {
                        if (!((Method)accessibleObject).getName().equals(name)) continue;
                        if (((Method)accessibleObject).getParameterTypes().length == 0 && (signature == null || signature.length == 0)) {
                            found = accessibleObject;
                        }
                        if (((Method)accessibleObject).getParameterTypes().length > 0 && signature != null && ((Method)accessibleObject).getParameterTypes().length == signature.length) {
                            found = accessibleObject;
                            for (int index = 0; index < ((Method)accessibleObject).getParameterTypes().length; ++index) {
                                String parameterTypeName = ((Method)accessibleObject).getParameterTypes()[index].getName();
                                Matcher matcher = ARRAY_PARAM_TYPE_NAME.matcher(parameterTypeName);
                                if (matcher.matches()) {
                                    parameterTypeName = matcher.group(1) + "[]";
                                }
                                if (parameterTypeName.equals(signature[index].getClassName()) || ((Method)accessibleObject).getParameterTypes()[index].getSimpleName().equals(signature[index].getClassName())) continue;
                                found = null;
                            }
                        }
                        if (found != null) break;
                    }
                    if (found == null) {
                        throw new SCRDescriptorException("Annotated method " + name + " not found.", annotatedClass.getName());
                    }
                    for (AnnotationNode annotation : annos) {
                        this.parseAnnotation(descriptions, annotation, found);
                    }
                }
            }
            if ((list = classNode.fields) != null) {
                for (FieldNode field : list) {
                    annos = this.getAllAnnotations(field.invisibleAnnotations, field.visibleAnnotations);
                    if (annos == null) continue;
                    String name = field.name;
                    Field[] allFields = annotatedClass.getDeclaredFields();
                    found = null;
                    for (AccessibleObject accessibleObject : allFields) {
                        if (!((Field)accessibleObject).getName().equals(name)) continue;
                        found = accessibleObject;
                        break;
                    }
                    if (found == null) {
                        throw new SCRDescriptorException("Annotated field " + name + " not found.", annotatedClass.getName());
                    }
                    for (AnnotationNode annotation : annos) {
                        this.parseAnnotation(descriptions, annotation, found);
                    }
                }
            }
        }
        return descriptions;
    }

    private List<AnnotationNode> getAllAnnotations(List<AnnotationNode> ... annotationLists) {
        ArrayList<AnnotationNode> resultList = null;
        for (List<AnnotationNode> annotationList : annotationLists) {
            if (annotationList == null || annotationList.size() <= 0) continue;
            if (resultList == null) {
                resultList = new ArrayList<AnnotationNode>();
            }
            resultList.addAll(annotationList);
        }
        return resultList;
    }

    private <T> T[] convertToArray(List<?> values, Class<T> type) {
        Object[] result = (Object[])Array.newInstance(type, values.size());
        return values.toArray(result);
    }

    private void parseAnnotation(List<ScannedAnnotation> descriptions, AnnotationNode annotation, Object annotatedObject) {
        ScannedAnnotation a;
        String name = annotation.desc.substring(1, annotation.desc.length() - 1).replace('/', '.');
        HashMap<String, Object> values = null;
        if (annotation.values != null) {
            values = new HashMap<String, Object>();
            Iterator i = annotation.values.iterator();
            while (i.hasNext()) {
                Object vName = i.next();
                Object value = i.next();
                if (value instanceof Type) {
                    value = ((Type)value).getClassName();
                } else if (value instanceof List) {
                    List objects = (List)value;
                    if (objects.size() > 0) {
                        if (objects.get(0) instanceof Type) {
                            String[] classNames = new String[objects.size()];
                            int index = 0;
                            for (Object v : objects) {
                                classNames[index] = ((Type)v).getClassName();
                                ++index;
                            }
                            value = classNames;
                        } else if (objects.get(0) instanceof AnnotationNode) {
                            ArrayList<ScannedAnnotation> innerDesc = new ArrayList<ScannedAnnotation>();
                            for (Object v : objects) {
                                this.parseAnnotation(innerDesc, (AnnotationNode)v, annotatedObject);
                            }
                            value = annotatedObject instanceof Method ? innerDesc.toArray(new MethodAnnotation[innerDesc.size()]) : (annotatedObject instanceof Field ? innerDesc.toArray(new FieldAnnotation[innerDesc.size()]) : innerDesc.toArray(new ClassAnnotation[innerDesc.size()]));
                        } else {
                            value = this.convertToArray(objects, objects.get(0).getClass());
                        }
                    } else {
                        value = null;
                    }
                }
                values.put(vName.toString(), value);
            }
        }
        if (annotatedObject instanceof Method) {
            a = new MethodAnnotation(name, values, (Method)annotatedObject);
            ((Method)annotatedObject).setAccessible(true);
        } else if (annotatedObject instanceof Field) {
            a = new FieldAnnotation(name, values, (Field)annotatedObject);
            ((Field)annotatedObject).setAccessible(true);
        } else {
            a = new ClassAnnotation(name, values);
        }
        descriptions.add(a);
    }

    public ClassDescription getDescription(Class<?> clazz) throws SCRDescriptorException, SCRDescriptorFailureException {
        String name = clazz.getName();
        if (name.startsWith("java.") || name.startsWith("javax.")) {
            return null;
        }
        ClassDescription result = this.allDescriptions.get(name);
        if (result == null) {
            result = this.processClass(clazz, GENERATED);
            if (result == null) {
                result = this.getComponentDescriptors().get(name);
            }
            if (result == null) {
                result = new ClassDescription(clazz, GENERATED);
            }
            this.allDescriptions.put(name, result);
        }
        return result.clone();
    }

    private Map<String, ClassDescription> getComponentDescriptors() throws SCRDescriptorException {
        if (this.loadedDependencies == null) {
            this.loadedDependencies = new HashMap<String, ClassDescription>();
            Collection<File> dependencies = this.project.getDependencies();
            for (File artifact : dependencies) {
                try {
                    this.log.debug("Trying to get scrinfo from artifact " + artifact);
                    InputStream scrInfoFile = null;
                    try {
                        scrInfoFile = this.getFile(artifact, ABSTRACT_DESCRIPTOR_ARCHIV_PATH);
                        if (scrInfoFile != null) {
                            this.readServiceComponentDescriptor(scrInfoFile, artifact.toString() + ':' + ABSTRACT_DESCRIPTOR_ARCHIV_PATH);
                            continue;
                        }
                        this.log.debug("Artifact has no scrinfo file (it's optional): " + artifact);
                    }
                    catch (IOException ioe) {
                        throw new SCRDescriptorException("Unable to get scrinfo from artifact", artifact.toString(), ioe);
                    }
                    finally {
                        if (scrInfoFile == null) continue;
                        try {
                            scrInfoFile.close();
                            continue;
                        }
                        catch (IOException iOException) {}
                    }
                    this.log.debug("Trying to get manifest from artifact " + artifact);
                    Manifest manifest = this.getManifest(artifact);
                    if (manifest != null) {
                        if (manifest.getMainAttributes().getValue(SERVICE_COMPONENT) != null) {
                            String serviceComponent = manifest.getMainAttributes().getValue(SERVICE_COMPONENT);
                            this.log.debug("Found Service-Component: " + serviceComponent + " in artifact " + artifact);
                            StringTokenizer st = new StringTokenizer(serviceComponent, ",");
                            while (st.hasMoreTokens()) {
                                String entry = st.nextToken().trim();
                                if (entry.length() <= 0) continue;
                                this.readServiceComponentDescriptor(artifact, entry);
                            }
                            continue;
                        }
                        this.log.debug("Artifact has no service component entry in manifest " + artifact);
                        continue;
                    }
                    this.log.debug("Unable to get manifest from artifact " + artifact);
                }
                catch (IOException ioe) {
                    throw new SCRDescriptorException("Unable to get manifest from artifact", artifact.toString(), ioe);
                }
            }
        }
        return this.loadedDependencies;
    }

    private void readServiceComponentDescriptor(InputStream file, String location) throws SCRDescriptorException {
        List<ClassDescription> list = ComponentDescriptorIO.read(file, this.project.getClassLoader(), this.iLog, location);
        if (list != null) {
            for (ClassDescription cd : list) {
                String name = cd.getDescribedClass() == null ? cd.getDescription(ComponentDescription.class).getName() : cd.getDescribedClass().getName();
                this.loadedDependencies.put(name, cd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readServiceComponentDescriptor(File artifactFile, String entry) {
        this.log.debug("Reading " + entry + " from " + artifactFile);
        InputStream xml = null;
        try {
            xml = this.getFile(artifactFile, entry);
            if (xml == null) {
                throw new SCRDescriptorException("Entry " + entry + " not contained in JAR File ", artifactFile.toString());
            }
            this.readServiceComponentDescriptor(xml, artifactFile.toString() + ':' + entry);
        }
        catch (IOException mee) {
            this.log.warn("Unable to read SCR descriptor file from JAR File " + artifactFile + " at " + entry);
            this.log.debug("Exception occurred during reading: " + mee.getMessage(), mee);
        }
        catch (SCRDescriptorException mee) {
            this.log.warn("Unable to read SCR descriptor file from JAR File " + artifactFile + " at " + entry);
            this.log.debug("Exception occurred during reading: " + mee.getMessage(), mee);
        }
        finally {
            if (xml != null) {
                try {
                    xml.close();
                }
                catch (IOException mee) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Manifest getManifest(File artifact) throws IOException {
        if (artifact.isDirectory()) {
            File dir = new File(artifact, "META-INF");
            if (!dir.exists() || !dir.isDirectory()) {
                return null;
            }
            File mf = new File(dir, "MANIFEST.MF");
            if (!mf.exists() || !mf.isFile()) {
                return null;
            }
            FileInputStream is = new FileInputStream(mf);
            try {
                Manifest manifest = new Manifest(is);
                return manifest;
            }
            finally {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
        JarFile file = null;
        try {
            file = new JarFile(artifact);
            Manifest manifest = file.getManifest();
            return manifest;
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getFile(File artifactFile, String path) throws IOException {
        if (artifactFile.isDirectory()) {
            String filePath = path.replace('/', File.separatorChar).replace('\\', File.separatorChar);
            File file = new File(artifactFile, filePath);
            if (file.exists() && file.isFile()) {
                return new FileInputStream(file);
            }
            return null;
        }
        JarFile file = null;
        try {
            file = new JarFile(artifactFile);
            JarEntry entry = file.getJarEntry(path);
            if (entry != null) {
                ArtifactFileInputStream stream = new ArtifactFileInputStream(file, entry);
                file = null;
                ArtifactFileInputStream artifactFileInputStream = stream;
                return artifactFileInputStream;
            }
            InputStream inputStream = null;
            return inputStream;
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static class ArtifactFileInputStream
    extends FilterInputStream {
        final JarFile jarFile;

        ArtifactFileInputStream(JarFile jarFile, JarEntry jarEntry) throws IOException {
            super(jarFile.getInputStream(jarEntry));
            this.jarFile = jarFile;
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.jarFile.close();
        }

        protected void finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }
    }
}

