/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.felix.scrplugin.Log;
import org.apache.felix.scrplugin.Options;
import org.apache.felix.scrplugin.Project;
import org.apache.felix.scrplugin.Result;
import org.apache.felix.scrplugin.SCRDescriptorException;
import org.apache.felix.scrplugin.SCRDescriptorFailureException;
import org.apache.felix.scrplugin.SpecVersion;
import org.apache.felix.scrplugin.description.ClassDescription;
import org.apache.felix.scrplugin.description.ComponentConfigurationPolicy;
import org.apache.felix.scrplugin.description.ComponentDescription;
import org.apache.felix.scrplugin.description.PropertyDescription;
import org.apache.felix.scrplugin.description.PropertyType;
import org.apache.felix.scrplugin.description.PropertyUnbounded;
import org.apache.felix.scrplugin.description.ReferenceCardinality;
import org.apache.felix.scrplugin.description.ReferenceDescription;
import org.apache.felix.scrplugin.description.ReferencePolicyOption;
import org.apache.felix.scrplugin.description.ReferenceStrategy;
import org.apache.felix.scrplugin.description.ServiceDescription;
import org.apache.felix.scrplugin.helper.AnnotationProcessorManager;
import org.apache.felix.scrplugin.helper.ClassModifier;
import org.apache.felix.scrplugin.helper.ClassScanner;
import org.apache.felix.scrplugin.helper.ComponentContainer;
import org.apache.felix.scrplugin.helper.DescriptionContainer;
import org.apache.felix.scrplugin.helper.IssueLog;
import org.apache.felix.scrplugin.helper.MetatypeAttributeDefinition;
import org.apache.felix.scrplugin.helper.MetatypeContainer;
import org.apache.felix.scrplugin.helper.StringUtils;
import org.apache.felix.scrplugin.helper.Validator;
import org.apache.felix.scrplugin.xml.ComponentDescriptorIO;
import org.apache.felix.scrplugin.xml.MetaTypeIO;

public class SCRDescriptorGenerator {
    private final Log logger;
    private Project project;
    private Options options = new Options();
    private ClassScanner scanner;
    private IssueLog iLog;

    public SCRDescriptorGenerator(Log logger) {
        this.logger = logger;
    }

    public void setProject(Project p) {
        this.project = p;
    }

    public void setOptions(Options p) {
        this.options = p;
    }

    public Result execute() throws SCRDescriptorException, SCRDescriptorFailureException {
        this.logger.debug("Starting SCR Descriptor Generator....");
        if (this.project == null) {
            throw new SCRDescriptorFailureException("Project has not been set!");
        }
        if (this.options == null) {
            this.options = new Options();
        }
        if (this.options.getOutputDirectory() == null) {
            throw new SCRDescriptorFailureException("Output directory has not been set!");
        }
        this.logger.debug("..using output directory: " + this.options.getOutputDirectory());
        this.logger.debug("..strict mode: " + this.options.isStrictMode());
        this.logger.debug("..generating accessors: " + this.options.isGenerateAccessors());
        SpecVersion specVersion = this.options.getSpecVersion();
        if (specVersion == null) {
            this.logger.debug("..auto detecting spec version");
        } else {
            this.logger.debug("..using spec version " + specVersion.getName());
        }
        this.iLog = new IssueLog(this.options.isStrictMode());
        AnnotationProcessorManager aProcessor = new AnnotationProcessorManager(this.logger, this.project.getClassLoader());
        this.scanner = new ClassScanner(this.logger, this.iLog, this.project, aProcessor);
        List<ClassDescription> scannedDescriptions = this.scanner.scanSources();
        Result result = new Result();
        ArrayList<ComponentContainer> processedContainers = new ArrayList<ComponentContainer>();
        for (ClassDescription desc : scannedDescriptions) {
            this.logger.debug("Processing component class " + desc.getSource());
            result.addProcessedSourceFile(desc.getSource());
            if (desc.getDescriptions(ComponentDescription.class).size() > 1) {
                this.iLog.addError("Class has more than one component definition. Check the annotations and merge the definitions to a single definition.", desc.getSource());
                continue;
            }
            ComponentContainer container = this.createComponent(desc, this.iLog);
            if (container.getComponentDescription().getSpecVersion() != null) {
                if (specVersion == null) {
                    specVersion = container.getComponentDescription().getSpecVersion();
                    this.logger.debug("Setting used spec version to " + (Object)((Object)specVersion));
                } else if (container.getComponentDescription().getSpecVersion().ordinal() > specVersion.ordinal()) {
                    if (this.options.getSpecVersion() != null) {
                        this.iLog.addError("Component " + container + " requires spec version " + container.getComponentDescription().getSpecVersion().name() + " but plugin is configured to use version " + (Object)((Object)this.options.getSpecVersion()), desc.getSource());
                    } else {
                        specVersion = container.getComponentDescription().getSpecVersion();
                        this.logger.debug("Setting used spec version to " + (Object)((Object)specVersion));
                    }
                }
            } else if (this.options.getSpecVersion() != null) {
                container.getComponentDescription().setSpecVersion(this.options.getSpecVersion());
            } else {
                container.getComponentDescription().setSpecVersion(SpecVersion.VERSION_1_0);
            }
            processedContainers.add(container);
        }
        if (specVersion == null) {
            specVersion = SpecVersion.VERSION_1_0;
            this.logger.debug("Using default spec version " + (Object)((Object)specVersion));
        }
        this.logger.debug("Generating descriptor for spec version: " + (Object)((Object)specVersion));
        this.options.setSpecVersion(specVersion);
        if (this.options.isGenerateAccessors()) {
            for (ComponentContainer container : processedContainers) {
                this.generateMethods(container);
            }
        }
        DescriptionContainer module = new DescriptionContainer(this.options);
        for (ComponentContainer container : processedContainers) {
            int errorCount = this.iLog.getNumberOfErrors();
            Validator validator = new Validator(container, this.project, this.options, this.iLog);
            validator.validate();
            if (this.iLog.getNumberOfErrors() != errorCount) continue;
            module.add(container);
        }
        this.iLog.logMessages(this.logger);
        if (this.iLog.hasErrors()) {
            throw new SCRDescriptorFailureException("SCR Descriptor parsing had failures (see log)");
        }
        result.setMetatypeFiles(MetaTypeIO.generateDescriptors(module, this.project, this.options, this.logger));
        result.setScrFiles(ComponentDescriptorIO.generateDescriptorFiles(module, this.options, this.logger));
        return result;
    }

    private void generateMethods(ComponentContainer container) throws SCRDescriptorException {
        for (ReferenceDescription ref : container.getReferences().values()) {
            if (StringUtils.isEmpty(ref.getInterfaceName()) || ref.getStrategy() == ReferenceStrategy.LOOKUP || ref.getField() == null || !ref.getField().getDeclaringClass().getName().equals(container.getClassDescription().getDescribedClass().getName()) || ref.getCardinality() != ReferenceCardinality.OPTIONAL_UNARY && ref.getCardinality() != ReferenceCardinality.MANDATORY_UNARY) continue;
            String bindValue = ref.getBind();
            String unbindValue = ref.getUnbind();
            String name = ref.getName();
            String type = ref.getInterfaceName();
            boolean createBind = false;
            boolean createUnbind = false;
            if (bindValue == null && Validator.findMethod(this.project, this.options, container.getClassDescription(), ref, "bind") == null) {
                createBind = true;
            }
            if (unbindValue == null && Validator.findMethod(this.project, this.options, container.getClassDescription(), ref, "unbind") == null) {
                createUnbind = true;
            }
            if (!createBind && !createUnbind) continue;
            if (createBind && createUnbind) {
                this.logger.debug("Generating bind and unbind method for " + name + " in " + container.getClassDescription().getDescribedClass().getName());
            } else if (createBind) {
                this.logger.debug("Generating bind method for " + name + " in " + container.getClassDescription().getDescribedClass().getName());
            } else {
                this.logger.debug("Generating unbind method for " + name + " in " + container.getClassDescription().getDescribedClass().getName());
            }
            ClassModifier.addMethods(container.getClassDescription().getDescribedClass().getName(), name, type, ref.getField().getName(), ref.getField().getType().getName(), createBind, createUnbind, this.project.getClassLoader(), this.project.getClassesDirectory(), this.logger);
            ref.setBindMethodCreated(createBind);
            ref.setUnbindMethodCreated(createUnbind);
        }
    }

    private ComponentContainer createComponent(ClassDescription desc, IssueLog iLog) throws SCRDescriptorException {
        Validator.MethodResult result;
        MetatypeContainer ocd;
        ComponentDescription componentDesc = desc.getDescription(ComponentDescription.class);
        SpecVersion intitialComponentSpecVersion = componentDesc.getSpecVersion();
        if (componentDesc.getConfigurationPid() != null && !componentDesc.getConfigurationPid().equals(componentDesc.getName())) {
            componentDesc.setSpecVersion(SpecVersion.VERSION_1_2);
        }
        ComponentContainer container = new ComponentContainer(desc, componentDesc);
        if (!componentDesc.isAbstract() && componentDesc.isCreateMetatype()) {
            ocd = new MetatypeContainer();
            container.setMetatypeContainer(ocd);
            ocd.setId(componentDesc.getName());
            if (componentDesc.getLabel() != null) {
                ocd.setName(componentDesc.getLabel());
            }
            if (componentDesc.getDescription() != null) {
                ocd.setDescription(componentDesc.getDescription());
            }
            if (componentDesc.isSetMetatypeFactoryPid()) {
                if (componentDesc.getFactory() == null) {
                    ocd.setFactoryPid(componentDesc.getName());
                } else {
                    iLog.addWarning("Component factory " + componentDesc.getName() + " should not set metatype factory pid.", desc.getSource());
                }
            }
        } else {
            ocd = null;
        }
        if (!componentDesc.isAbstract() && !componentDesc.isCreateMetatype()) {
            if (componentDesc.getLabel() != null && componentDesc.getLabel().trim().length() > 0) {
                iLog.addWarning(" Component " + componentDesc.getName() + " has set a label. However metatype is set to false. This label is ignored.", desc.getSource());
            }
            if (componentDesc.getDescription() != null && componentDesc.getDescription().trim().length() > 0) {
                iLog.addWarning(" Component " + componentDesc.getName() + " has set a description. However metatype is set to false. This description is ignored.", desc.getSource());
            }
        }
        ClassDescription current = desc;
        do {
            ComponentDescription cd;
            boolean inherit;
            boolean bl = inherit = (cd = current.getDescription(ComponentDescription.class)) == null ? true : cd.isInherit();
            if (cd != null) {
                if (current != desc) {
                    iLog.addWarning(" Component " + componentDesc.getName() + " is using the " + "deprecated inheritance feature and inherits from " + current.getDescribedClass().getName() + ". This feature will be removed in future versions.", desc.getSource());
                }
                if (componentDesc.getEnabled() == null) {
                    componentDesc.setEnabled(cd.getEnabled());
                }
                if (componentDesc.getImmediate() == null) {
                    componentDesc.setImmediate(cd.getImmediate());
                }
                if (componentDesc.getActivate() == null && cd.getActivate() != null) {
                    componentDesc.setActivate(cd.getActivate());
                }
                if (componentDesc.getDeactivate() == null && cd.getDeactivate() != null) {
                    componentDesc.setDeactivate(cd.getDeactivate());
                }
                if (componentDesc.getModified() == null && cd.getModified() != null) {
                    componentDesc.setModified(cd.getModified());
                }
                if (componentDesc.getActivate() != null || componentDesc.getDeactivate() != null || componentDesc.getModified() != null) {
                    componentDesc.setSpecVersion(SpecVersion.VERSION_1_1);
                }
                if (componentDesc.getConfigurationPolicy() != ComponentConfigurationPolicy.OPTIONAL) {
                    componentDesc.setSpecVersion(SpecVersion.VERSION_1_1);
                }
            }
            this.processServices(current, container);
            this.processProperties(current, container, ocd);
            this.processReferences(current, container);
            if (!inherit || current.getDescribedClass().getSuperclass() == null) {
                current = null;
                continue;
            }
            try {
                current = this.scanner.getDescription(current.getDescribedClass().getSuperclass());
            }
            catch (SCRDescriptorFailureException sde) {
                this.logger.debug(sde.getMessage(), sde);
                iLog.addError(sde.getMessage(), current.getSource());
            }
            catch (SCRDescriptorException sde) {
                this.logger.debug(sde.getSourceLocation() + " : " + sde.getMessage(), sde);
                iLog.addError(sde.getMessage(), sde.getSourceLocation());
            }
        } while (current != null);
        if (container.getServiceDescription() != null) {
            for (String interfaceName : container.getServiceDescription().getInterfaces()) {
                try {
                    Class<?> interfaceClass = this.project.getClassLoader().loadClass(interfaceName);
                    ClassDescription interfaceDesc = this.scanner.getDescription(interfaceClass);
                    if (interfaceDesc == null) continue;
                    this.processProperties(interfaceDesc, container, ocd);
                }
                catch (SCRDescriptorFailureException sde) {
                    this.logger.debug(sde.getMessage(), sde);
                    iLog.addError(sde.getMessage(), interfaceName);
                }
                catch (SCRDescriptorException sde) {
                    this.logger.debug(sde.getSourceLocation() + " : " + sde.getMessage(), sde);
                    iLog.addError(sde.getMessage(), sde.getSourceLocation());
                }
                catch (ClassNotFoundException e) {
                    this.logger.debug(e.getMessage(), e);
                    iLog.addError(e.getMessage(), interfaceName);
                }
            }
        }
        this.processGlobalProperties(desc, container.getProperties());
        if (componentDesc.getActivate() == null) {
            result = Validator.findLifecycleMethod(this.project, container, "activate", true);
            if (result.method != null) {
                componentDesc.setSpecVersion(result.requiredSpecVersion);
            }
        }
        if (componentDesc.getDeactivate() == null) {
            result = Validator.findLifecycleMethod(this.project, container, "deactivate", false);
            if (result.method != null) {
                componentDesc.setSpecVersion(result.requiredSpecVersion);
            }
        }
        if (intitialComponentSpecVersion != null && componentDesc.getSpecVersion().ordinal() > intitialComponentSpecVersion.ordinal()) {
            iLog.addError("Component " + container + " requires spec version " + container.getComponentDescription().getSpecVersion().name() + " but component is configured to use version " + intitialComponentSpecVersion.name(), desc.getSource());
        }
        return container;
    }

    private void processServices(ClassDescription current, ComponentContainer component) {
        ServiceDescription serviceDesc = current.getDescription(ServiceDescription.class);
        if (serviceDesc != null) {
            ServiceDescription service = component.getServiceDescription();
            if (service == null) {
                service = new ServiceDescription(serviceDesc.getAnnotation());
                service.setServiceFactory(false);
                component.setServiceDescription(service);
            }
            if (serviceDesc.isServiceFactory()) {
                service.setServiceFactory(true);
            }
            for (String className : serviceDesc.getInterfaces()) {
                service.addInterface(className);
            }
        }
    }

    private boolean isPrivateProperty(String name) {
        boolean isPrivate = "service.ranking".equals(name) || "service.pid".equals(name) || "service.description".equals(name) || "service.vendor".equals(name) || "service.bundleLocation".equals(name) || "service.factoryPid".equals(name);
        return isPrivate;
    }

    private void processProperties(ClassDescription current, ComponentContainer component, MetatypeContainer ocd) {
        for (PropertyDescription pd : current.getDescriptions(PropertyDescription.class)) {
            if (!this.testProperty(current, component.getProperties(), pd, current == component.getClassDescription())) continue;
            String name = pd.getName();
            if ("service.id".equals(name)) {
                this.iLog.addError("Class " + current.getDescribedClass().getName() + " is declaring " + "the protected property 'service.id'.", current.getSource());
                continue;
            }
            if (ocd != null) {
                boolean isPrivate = pd.isPrivate() != null ? pd.isPrivate() : this.isPrivateProperty(name);
                if (isPrivate) continue;
                MetatypeAttributeDefinition ad = new MetatypeAttributeDefinition();
                ocd.getProperties().add(ad);
                ad.setId(pd.getName());
                ad.setType(pd.getType().name());
                if (pd.getLabel() != null) {
                    ad.setName(pd.getLabel());
                }
                if (pd.getDescription() != null) {
                    ad.setDescription(pd.getDescription());
                }
                if (pd.getUnbounded() == PropertyUnbounded.DEFAULT) {
                    if (pd.getCardinality() != 0) {
                        ad.setCardinality(pd.getCardinality());
                    }
                } else if (pd.getUnbounded() == PropertyUnbounded.ARRAY) {
                    ad.setCardinality(new Integer(Integer.MAX_VALUE));
                } else {
                    ad.setCardinality(new Integer(Integer.MIN_VALUE));
                }
                ad.setDefaultValue(pd.getValue());
                ad.setDefaultMultiValue(pd.getMultiValue());
                String[] parameters = pd.getOptions();
                if (parameters == null || parameters.length <= 0) continue;
                LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
                for (int j = 0; j < parameters.length; j += 2) {
                    String optionValue;
                    String optionLabel = parameters[j];
                    String string = optionValue = j < parameters.length - 1 ? parameters[j + 1] : null;
                    if (optionValue == null) continue;
                    options.put(optionLabel, optionValue);
                }
                ad.setOptions(options);
                continue;
            }
            if (pd.isPrivate() == null || !pd.isPrivate().booleanValue()) continue;
            this.iLog.addWarning("Property " + pd.getName() + " in class " + current.getDescribedClass().getName() + " is set as private. " + "This is redundant as no metatype will be generated.", current.getSource());
        }
    }

    private void processGlobalProperties(ClassDescription desc, Map<String, PropertyDescription> allProperties) {
        if (this.options.getProperties() != null) {
            for (Map.Entry<String, String> entry : this.options.getProperties().entrySet()) {
                String propName = entry.getKey();
                String value = entry.getValue();
                if (value == null || allProperties.containsKey(propName)) continue;
                PropertyDescription p = new PropertyDescription(null);
                p.setName(propName);
                p.setValue(value);
                p.setType(PropertyType.String);
                allProperties.put(propName, p);
            }
        }
    }

    private boolean testProperty(ClassDescription current, Map<String, PropertyDescription> allProperties, PropertyDescription newProperty, boolean isInspectedClass) {
        String propName = newProperty.getName();
        if (!StringUtils.isEmpty(propName)) {
            if (allProperties.containsKey(propName)) {
                if (isInspectedClass) {
                    this.iLog.addError("Duplicate definition for property " + propName + " in class " + current.getDescribedClass().getName(), current.getSource());
                }
                return false;
            }
            allProperties.put(propName, newProperty);
        } else {
            allProperties.put(UUID.randomUUID().toString(), newProperty);
        }
        return true;
    }

    private void processReferences(ClassDescription current, ComponentContainer component) {
        for (ReferenceDescription rd : current.getDescriptions(ReferenceDescription.class)) {
            if (rd.getPolicyOption() != ReferencePolicyOption.RELUCTANT) {
                component.getComponentDescription().setSpecVersion(SpecVersion.VERSION_1_2);
            }
            if (rd.getUpdated() != null && (component.getComponentDescription().getSpecVersion() == null || component.getComponentDescription().getSpecVersion().ordinal() < SpecVersion.VERSION_1_1_FELIX.ordinal())) {
                component.getComponentDescription().setSpecVersion(SpecVersion.VERSION_1_2);
            }
            this.testReference(current, component.getReferences(), rd, component.getClassDescription() == current);
            if (StringUtils.isEmpty(rd.getInterfaceName())) continue;
            try {
                Validator.MethodResult unbindMethod;
                Validator.MethodResult bindMethod = Validator.findMethod(this.project, this.options, current, rd, rd.getBind() == null ? "bind" : rd.getBind());
                if (bindMethod != null) {
                    component.getComponentDescription().setSpecVersion(bindMethod.requiredSpecVersion);
                }
                if ((unbindMethod = Validator.findMethod(this.project, this.options, current, rd, rd.getUnbind() == null ? "unbind" : rd.getUnbind())) == null) continue;
                component.getComponentDescription().setSpecVersion(unbindMethod.requiredSpecVersion);
            }
            catch (SCRDescriptorException sCRDescriptorException) {}
        }
    }

    private void testReference(ClassDescription current, Map<String, ReferenceDescription> allReferences, ReferenceDescription newReference, boolean isInspectedClass) {
        String refName = newReference.getName();
        if (refName == null) {
            refName = newReference.getInterfaceName();
        }
        if (refName != null) {
            if (allReferences.containsKey(refName)) {
                if (isInspectedClass) {
                    this.iLog.addError("Duplicate definition for reference " + refName + " in class " + current.getDescribedClass().getName(), current.getSource());
                }
            } else {
                allReferences.put(refName, newReference);
            }
        } else {
            allReferences.put(UUID.randomUUID().toString(), newReference);
        }
    }
}

