/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.config;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.scr.impl.Activator;
import org.apache.felix.scr.impl.ComponentCommands;
import org.apache.felix.scr.impl.config.ScrManagedServiceServiceFactory;
import org.apache.felix.scr.impl.config.ScrMetaTypeProviderServiceFactory;
import org.apache.felix.scr.impl.manager.ScrConfiguration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class ScrConfigurationImpl
implements ScrConfiguration {
    private static final String VALUE_TRUE = Boolean.TRUE.toString();
    private static final String LOG_LEVEL_DEBUG = "debug";
    private static final String LOG_LEVEL_INFO = "info";
    private static final String LOG_LEVEL_WARN = "warn";
    private static final String LOG_LEVEL_ERROR = "error";
    private static final String PROP_SHOWTRACE = "ds.showtrace";
    private static final String PROP_SHOWERRORS = "ds.showerrors";
    private final Activator activator;
    private int logLevel;
    private boolean factoryEnabled;
    private boolean keepInstances;
    private boolean infoAsService;
    private long lockTimeout = 5000L;
    private long stopTimeout = 60000L;
    private Boolean globalExtender;
    private volatile BundleContext bundleContext;
    private volatile ServiceRegistration<?> managedServiceRef;
    private volatile ServiceRegistration<?> metatypeProviderRef;
    private ComponentCommands scrCommand;

    public ScrConfigurationImpl(Activator activator) {
        this.activator = activator;
    }

    public void start(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        Hashtable<String, String> msProps = new Hashtable<String, String>();
        ((Dictionary)msProps).put("service.pid", "org.apache.felix.scr.ScrService");
        ((Dictionary)msProps).put("service.description", "SCR Configurator");
        ((Dictionary)msProps).put("service.vendor", "The Apache Software Foundation");
        this.configure(null, false);
        this.managedServiceRef = bundleContext.registerService("org.osgi.service.cm.ManagedService", (Object)new ScrManagedServiceServiceFactory(this), msProps);
        Hashtable<String, String> mtProps = new Hashtable<String, String>();
        ((Dictionary)mtProps).put("metatype.pid", "org.apache.felix.scr.ScrService");
        ((Dictionary)mtProps).put("service.description", "SCR Configurator MetaTypeProvider");
        ((Dictionary)mtProps).put("service.vendor", "The Apache Software Foundation");
        this.metatypeProviderRef = bundleContext.registerService("org.osgi.service.metatype.MetaTypeProvider", (Object)new ScrMetaTypeProviderServiceFactory(this), mtProps);
    }

    public void stop() {
        if (this.managedServiceRef != null) {
            this.managedServiceRef.unregister();
            this.managedServiceRef = null;
        }
        if (this.metatypeProviderRef != null) {
            this.metatypeProviderRef.unregister();
            this.metatypeProviderRef = null;
        }
        this.bundleContext = null;
    }

    public void setScrCommand(ComponentCommands scrCommand) {
        this.scrCommand = scrCommand;
        scrCommand.updateProvideScrInfoService(this.infoAsService());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void configure(Dictionary<String, ?> config, boolean fromConfig) {
        Boolean oldGlobalExtender;
        Boolean newGlobalExtender;
        ScrConfigurationImpl scrConfigurationImpl = this;
        synchronized (scrConfigurationImpl) {
            if (config == null) {
                if (!fromConfig) {
                    if (this.bundleContext == null) {
                        this.logLevel = 1;
                        this.factoryEnabled = false;
                        this.keepInstances = false;
                        this.infoAsService = false;
                        this.lockTimeout = 5000L;
                        this.stopTimeout = 60000L;
                        newGlobalExtender = false;
                    } else {
                        this.logLevel = this.getDefaultLogLevel();
                        this.factoryEnabled = this.getDefaultFactoryEnabled();
                        this.keepInstances = this.getDefaultKeepInstances();
                        this.infoAsService = this.getDefaultInfoAsService();
                        this.lockTimeout = this.getDefaultLockTimeout();
                        this.stopTimeout = this.getDefaultStopTimeout();
                        newGlobalExtender = this.getDefaultGlobalExtender();
                    }
                } else {
                    newGlobalExtender = this.globalExtender;
                }
            } else {
                this.logLevel = this.getLogLevel(config.get("ds.loglevel"));
                this.factoryEnabled = VALUE_TRUE.equalsIgnoreCase(String.valueOf(config.get("ds.factory.enabled")));
                this.keepInstances = VALUE_TRUE.equalsIgnoreCase(String.valueOf(config.get("ds.delayed.keepInstances")));
                this.infoAsService = VALUE_TRUE.equalsIgnoreCase(String.valueOf(config.get("ds.info.service")));
                Long timeout = (Long)config.get("ds.lock.timeout.milliseconds");
                this.lockTimeout = timeout == null ? 5000L : timeout;
                timeout = (Long)config.get("ds.stop.timeout.milliseconds");
                this.stopTimeout = timeout == null ? 60000L : timeout;
                newGlobalExtender = VALUE_TRUE.equalsIgnoreCase(String.valueOf(config.get("ds.global.extender")));
            }
            if (this.scrCommand != null) {
                this.scrCommand.updateProvideScrInfoService(this.infoAsService());
            }
            oldGlobalExtender = this.globalExtender;
            this.globalExtender = newGlobalExtender;
        }
        if (newGlobalExtender != oldGlobalExtender) {
            this.activator.restart(newGlobalExtender);
        }
    }

    @Override
    public int getLogLevel() {
        return this.logLevel;
    }

    @Override
    public boolean isFactoryEnabled() {
        return this.factoryEnabled;
    }

    @Override
    public boolean keepInstances() {
        return this.keepInstances;
    }

    @Override
    public boolean infoAsService() {
        return this.infoAsService;
    }

    @Override
    public long lockTimeout() {
        return this.lockTimeout;
    }

    @Override
    public long stopTimeout() {
        return this.stopTimeout;
    }

    @Override
    public boolean globalExtender() {
        return this.globalExtender;
    }

    private boolean getDefaultFactoryEnabled() {
        return VALUE_TRUE.equals(this.bundleContext.getProperty("ds.factory.enabled"));
    }

    private boolean getDefaultKeepInstances() {
        return VALUE_TRUE.equals(this.bundleContext.getProperty("ds.delayed.keepInstances"));
    }

    private int getDefaultLogLevel() {
        return this.getLogLevel(this.bundleContext.getProperty("ds.loglevel"));
    }

    private boolean getDefaultInfoAsService() {
        return VALUE_TRUE.equalsIgnoreCase(this.bundleContext.getProperty("ds.info.service"));
    }

    private long getDefaultLockTimeout() {
        String val = this.bundleContext.getProperty("ds.lock.timeout.milliseconds");
        if (val == null) {
            return 5000L;
        }
        return Long.parseLong(val);
    }

    private long getDefaultStopTimeout() {
        String val = this.bundleContext.getProperty("ds.stop.timeout.milliseconds");
        if (val == null) {
            return 60000L;
        }
        return Long.parseLong(val);
    }

    private boolean getDefaultGlobalExtender() {
        return VALUE_TRUE.equalsIgnoreCase(this.bundleContext.getProperty("ds.global.extender"));
    }

    private int getLogLevel(Object levelObject) {
        block9: {
            if (levelObject != null) {
                if (levelObject instanceof Number) {
                    return ((Number)levelObject).intValue();
                }
                String levelString = levelObject.toString();
                try {
                    return Integer.parseInt(levelString);
                }
                catch (NumberFormatException numberFormatException) {
                    if (LOG_LEVEL_DEBUG.equalsIgnoreCase(levelString)) {
                        return 4;
                    }
                    if (LOG_LEVEL_INFO.equalsIgnoreCase(levelString)) {
                        return 3;
                    }
                    if (LOG_LEVEL_WARN.equalsIgnoreCase(levelString)) {
                        return 2;
                    }
                    if (!LOG_LEVEL_ERROR.equalsIgnoreCase(levelString)) break block9;
                    return 1;
                }
            }
        }
        if (VALUE_TRUE.equalsIgnoreCase(this.bundleContext.getProperty(PROP_SHOWTRACE))) {
            return 4;
        }
        if ("false".equalsIgnoreCase(this.bundleContext.getProperty(PROP_SHOWERRORS))) {
            return -1;
        }
        return 1;
    }
}

