/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.deployer.obr;

import aQute.bnd.service.ResourceHandle;
import aQute.bnd.service.url.URLConnector;
import aQute.lib.deployer.obr.DefaultURLConnector;
import aQute.lib.io.IO;
import aQute.libg.reporter.Reporter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;

public class CachingURLResourceHandle
implements ResourceHandle {
    static final String FILE_SCHEME = "file:";
    static final String HTTP_SCHEME = "http:";
    static final String UTF_8 = "UTF-8";
    final File cacheDir;
    final URLConnector connector;
    final URL url;
    final File localFile;
    final File cachedFile;
    final CachingMode mode;
    boolean downloaded = false;
    Reporter reporter;

    public CachingURLResourceHandle(String url, String baseUrl, File cacheDir, CachingMode mode) throws IOException {
        this(url, baseUrl, cacheDir, new DefaultURLConnector(), mode);
    }

    public CachingURLResourceHandle(String url, String baseUrl, File cacheDir, URLConnector connector, CachingMode mode) throws IOException {
        this.cacheDir = cacheDir;
        this.connector = connector;
        this.mode = mode;
        if (url.startsWith(FILE_SCHEME)) {
            File file = new File(url.substring(FILE_SCHEME.length()));
            if (file.isAbsolute()) {
                this.localFile = file;
            } else {
                if (baseUrl == null || !baseUrl.startsWith(FILE_SCHEME)) {
                    throw new IllegalArgumentException("Relative file URLs cannot be resolved if the base URL is a non-file URL.");
                }
                this.localFile = this.resolveFile(baseUrl.substring(FILE_SCHEME.length()), ((Object)file).toString());
            }
            this.url = this.localFile.toURI().toURL();
            if (!this.localFile.isFile() && !this.localFile.isDirectory()) {
                throw new FileNotFoundException("File URL " + this.url + " points at a non-existing file.");
            }
            this.cachedFile = null;
        } else if (url.startsWith(HTTP_SCHEME)) {
            this.url = new URL(url);
            this.localFile = null;
            this.cachedFile = this.mapRemoteURL(this.url);
        } else if (baseUrl == null) {
            this.url = new URL(url);
            this.localFile = null;
            this.cachedFile = this.mapRemoteURL(this.url);
        } else if (baseUrl.startsWith(FILE_SCHEME)) {
            this.localFile = this.resolveFile(baseUrl.substring(FILE_SCHEME.length()), url);
            this.url = this.localFile.toURI().toURL();
            this.cachedFile = null;
        } else {
            URL base = new URL(baseUrl);
            this.url = new URL(base, url);
            this.localFile = null;
            this.cachedFile = this.mapRemoteURL(this.url);
        }
    }

    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    File resolveFile(String baseFileName, String fileName) {
        File resolved;
        File baseFile = new File(baseFileName);
        if (baseFile.isDirectory()) {
            resolved = new File(baseFile, fileName);
        } else if (baseFile.isFile()) {
            resolved = new File(baseFile.getParentFile(), fileName);
        } else {
            throw new IllegalArgumentException("Cannot resolve relative to non-existant base file path: " + baseFileName);
        }
        return resolved;
    }

    private File mapRemoteURL(URL url) throws UnsupportedEncodingException {
        String localFileName;
        File localDir;
        String fullUrl = url.toExternalForm();
        int lastSlashIndex = fullUrl.lastIndexOf(47);
        if (lastSlashIndex > -1) {
            String localDirName = URLEncoder.encode(fullUrl.substring(0, lastSlashIndex), UTF_8);
            localDir = new File(this.cacheDir, localDirName);
            if (localDir.exists() && !localDir.isDirectory()) {
                localDir = this.cacheDir;
                localFileName = URLEncoder.encode(fullUrl, UTF_8);
            } else {
                localFileName = URLEncoder.encode(fullUrl.substring(lastSlashIndex + 1), UTF_8);
            }
        } else {
            localDir = this.cacheDir;
            localFileName = URLEncoder.encode(fullUrl, UTF_8);
        }
        localDir.mkdirs();
        return new File(localDir, localFileName);
    }

    public String getName() {
        return ((Object)this.url).toString();
    }

    public ResourceHandle.Location getLocation() {
        ResourceHandle.Location result = this.localFile != null ? ResourceHandle.Location.local : (this.cachedFile.exists() ? ResourceHandle.Location.remote_cached : ResourceHandle.Location.remote);
        return result;
    }

    public File request() throws IOException {
        if (this.localFile != null) {
            return this.localFile;
        }
        if (this.cachedFile == null) {
            throw new IllegalStateException("Invalid URLResourceHandle: both local file and cache file location are uninitialised.");
        }
        switch (this.mode) {
            case PreferCache: {
                if (!this.cachedFile.exists()) {
                    this.cacheDir.mkdirs();
                    this.downloadToFile(this.url, this.cachedFile);
                }
                return this.cachedFile;
            }
            case PreferRemote: {
                File tempFile = File.createTempFile("download", ".tmp");
                try {
                    this.downloadToFile(this.url, tempFile);
                    this.cacheDir.mkdirs();
                    IO.copy(tempFile, this.cachedFile);
                    return this.cachedFile;
                }
                catch (IOException e) {
                    if (this.cachedFile.exists()) {
                        if (this.reporter != null) {
                            this.reporter.warning("Download of remote resource %s failed, using local cache %s.", this.url, this.cachedFile);
                        }
                        return this.cachedFile;
                    }
                    throw new IOException(String.format("Download of remote resource %s failed and cached file %s not available!", this.url, this.cachedFile));
                }
            }
        }
        throw new IllegalArgumentException("Invalid caching mode");
    }

    void downloadToFile(URL url, File file) throws IOException {
        InputStream in = null;
        FileOutputStream out = null;
        try {
            int bytes;
            in = this.connector.connect(url);
            out = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            while ((bytes = in.read(buf, 0, 1024)) >= 0) {
                ((OutputStream)out).write(buf, 0, bytes);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (out != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public URL getResolvedUrl() {
        return this.url;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CachingMode {
        PreferCache,
        PreferRemote;

    }
}

