/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.inventory.impl.webconsole;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.felix.inventory.Format;
import org.osgi.framework.ServiceReference;

public class ConfigurationPrinterAdapter {
    private final Object printer;
    public String title;
    public String label;
    private final String[] modes;
    private final boolean escapeHtml;
    private final Method printMethod;
    private final Method attachmentMethod;
    private static final List<String> CUSTOM_MODES = new ArrayList<String>();

    private static boolean isConfigurationPrinter(Class<?> clazz) {
        Class<?>[] interf = clazz.getInterfaces();
        for (int i = 0; i < interf.length; ++i) {
            if (!interf[i].getName().equals("org.apache.felix.webconsole.ConfigurationPrinter")) continue;
            return true;
        }
        if (clazz.getSuperclass() != null) {
            return ConfigurationPrinterAdapter.isConfigurationPrinter(clazz.getSuperclass());
        }
        return false;
    }

    public static ConfigurationPrinterAdapter createAdapter(Object service, ServiceReference ref) {
        Method method1Params;
        String title;
        Object modes = null;
        if (ConfigurationPrinterAdapter.isConfigurationPrinter(service.getClass())) {
            Method titleMethod;
            modes = ref.getProperty("felix.webconsole.configprinter.modes");
            if (modes == null) {
                modes = ref.getProperty("modes");
            }
            if ((titleMethod = ConfigurationPrinterAdapter.getMethod(service.getClass(), "getTitle", null, false)) == null) {
                return null;
            }
            title = (String)ConfigurationPrinterAdapter.invoke(service, titleMethod, null);
        } else {
            modes = ref.getProperty("felix.webconsole.configprinter.modes");
            title = (String)ref.getProperty("felix.webconsole.title");
        }
        Object cfgPrinter = null;
        Method printMethod = null;
        Method method2Params = ConfigurationPrinterAdapter.getMethod(service.getClass(), "printConfiguration", new Class[]{PrintWriter.class, String.class}, true);
        if (method2Params != null) {
            cfgPrinter = service;
            printMethod = method2Params;
        }
        if (cfgPrinter == null && (method1Params = ConfigurationPrinterAdapter.getMethod(service.getClass(), "printConfiguration", new Class[]{PrintWriter.class}, true)) != null) {
            cfgPrinter = service;
            printMethod = method1Params;
        }
        if (cfgPrinter != null) {
            Object modesArray;
            Object label = ref.getProperty("felix.webconsole.label");
            Object ehObj = ref.getProperty("felix.webconsole.configprinter.web.unescaped");
            boolean webUnescaped = ehObj instanceof Boolean ? (Boolean)ehObj : (ehObj instanceof String ? Boolean.valueOf((String)ehObj) : false);
            if (modes == null || !(modes instanceof String) && !(modes instanceof String[])) {
                modesArray = null;
            } else if (modes instanceof String) {
                modesArray = CUSTOM_MODES.contains(modes) ? new String[]{modes.toString()} : null;
            } else {
                String[] values = (String[])modes;
                boolean valid = values.length > 0;
                for (int i = 0; i < values.length; ++i) {
                    if (CUSTOM_MODES.contains(values[i])) continue;
                    valid = false;
                    break;
                }
                modesArray = valid ? values : null;
            }
            return new ConfigurationPrinterAdapter(cfgPrinter, printMethod, ConfigurationPrinterAdapter.getMethod(cfgPrinter.getClass(), "getAttachments", new Class[]{String.class}, true), title, label instanceof String ? (String)label : null, (String[])modesArray, !webUnescaped);
        }
        return null;
    }

    private ConfigurationPrinterAdapter(Object printer, Method printMethod, Method attachmentMethod, String title, String label, String[] modesArray, boolean escapeHtml) {
        this.printer = printer;
        this.title = title;
        this.label = label;
        this.escapeHtml = escapeHtml;
        this.printMethod = printMethod;
        this.attachmentMethod = attachmentMethod;
        this.modes = modesArray;
    }

    public String[] getPrinterModes() {
        HashSet<String> list = new HashSet<String>();
        if (this.match("txt") || this.match("zip")) {
            list.add(Format.TEXT.toString());
        }
        if (this.match("web")) {
            if (!this.escapeHtml) {
                list.add(Format.HTML.toString());
            } else {
                list.add(Format.TEXT.toString());
            }
        }
        return list.toArray(new String[list.size()]);
    }

    private boolean match(String mode) {
        if (this.modes == null) {
            return true;
        }
        for (int i = 0; i < this.modes.length; ++i) {
            if (!this.modes[i].equals(mode)) continue;
            return true;
        }
        return false;
    }

    public final void printConfiguration(PrintWriter pw, String mode) {
        if (this.printMethod.getParameterTypes().length > 1) {
            ConfigurationPrinterAdapter.invoke(this.printer, this.printMethod, new Object[]{pw, mode});
        } else {
            ConfigurationPrinterAdapter.invoke(this.printer, this.printMethod, new Object[]{pw});
        }
    }

    public URL[] getAttachments() {
        URL[] attachments = null;
        if (this.attachmentMethod != null) {
            attachments = (URL[])ConfigurationPrinterAdapter.invoke(this.printer, this.attachmentMethod, new Object[]{"zip"});
        }
        return attachments;
    }

    public String toString() {
        return this.title + " (" + this.printer.getClass() + ")";
    }

    private static Method getMethod(Class<?> clazz, String mName, Class<?>[] params, boolean declaredByClass) {
        try {
            Method m;
            if (declaredByClass && Modifier.isPublic((m = clazz.getDeclaredMethod(mName, params)).getModifiers())) {
                return m;
            }
            return clazz.getMethod(mName, params);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Object invoke(Object obj, Method m, Object[] args) {
        try {
            return m.invoke(obj, args);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    static {
        CUSTOM_MODES.add("txt");
        CUSTOM_MODES.add("web");
        CUSTOM_MODES.add("zip");
    }
}

