/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.webconsoleplugin.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.Servlet;
import org.apache.felix.http.webconsoleplugin.impl.HttpServicePlugin;
import org.osgi.annotation.bundle.Header;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.servlet.runtime.HttpServiceRuntime;
import org.osgi.service.servlet.whiteboard.annotations.RequireHttpWhiteboard;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Header(name="Bundle-Activator", value="${@class}")
@RequireHttpWhiteboard
public class Activator
implements BundleActivator {
    private volatile ServiceTracker<HttpServiceRuntime, HttpServiceRuntime> tracker;
    private volatile ServiceRegistration<Servlet> serviceReg;

    private void register(BundleContext context, HttpServiceRuntime runtime) {
        HttpServicePlugin plugin = new HttpServicePlugin(context, runtime);
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("felix.webconsole.label", "httpservice");
        ((Dictionary)props).put("felix.webconsole.title", "HTTP Service");
        this.serviceReg = context.registerService(Servlet.class, (Object)plugin, props);
    }

    public void start(final BundleContext context) throws Exception {
        ServiceTracker tracker = new ServiceTracker(context, HttpServiceRuntime.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<HttpServiceRuntime, HttpServiceRuntime>(){

            public HttpServiceRuntime addingService(ServiceReference<HttpServiceRuntime> reference) {
                HttpServiceRuntime runtime = (HttpServiceRuntime)context.getService(reference);
                if (runtime != null) {
                    Activator.this.register(context, runtime);
                }
                return runtime;
            }

            public void modifiedService(ServiceReference<HttpServiceRuntime> reference, HttpServiceRuntime service) {
            }

            public void removedService(ServiceReference<HttpServiceRuntime> reference, HttpServiceRuntime service) {
                if (Activator.this.serviceReg != null) {
                    try {
                        Activator.this.serviceReg.unregister();
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                    Activator.this.serviceReg = null;
                }
            }
        });
        tracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.tracker != null) {
            this.tracker.close();
            this.tracker = null;
        }
    }
}

