/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.http.proxy.DispatcherTracker;
import org.osgi.framework.BundleContext;

public final class ProxyServlet
extends HttpServlet {
    private volatile DispatcherTracker tracker;
    private volatile boolean initialized = false;
    private volatile ServletContext servletContext;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    private void doInit() throws Exception {
        ServletConfig origConfig;
        ServletConfig config = origConfig = this.getServletConfig();
        if (this.servletContext != null) {
            config = new ServletConfig(){

                public String getServletName() {
                    return origConfig.getServletName();
                }

                public ServletContext getServletContext() {
                    return ProxyServlet.this.servletContext;
                }

                public Enumeration<String> getInitParameterNames() {
                    return origConfig.getInitParameterNames();
                }

                public String getInitParameter(String name) {
                    return origConfig.getInitParameter(name);
                }
            };
        }
        this.tracker = new DispatcherTracker(this.getBundleContext(), null, config);
        this.tracker.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        HttpServlet dispatcher;
        if (!this.initialized) {
            ProxyServlet proxyServlet = this;
            synchronized (proxyServlet) {
                if (!this.initialized) {
                    if (!"".equals(req.getServletPath())) {
                        this.servletContext = new ServletContextWrapper(req.getServletContext(), req.getContextPath() + req.getServletPath());
                    }
                    try {
                        this.doInit();
                    }
                    catch (ServletException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new ServletException((Throwable)e);
                    }
                    this.initialized = true;
                }
            }
        }
        if ((dispatcher = this.tracker.getDispatcher()) != null) {
            Object r = this.servletContext == null ? req : new BridgeHttpServletRequest(req, this.servletContext);
            dispatcher.service((ServletRequest)r, (ServletResponse)res);
        } else {
            res.sendError(503);
        }
    }

    public void destroy() {
        this.tracker.close();
        super.destroy();
    }

    private BundleContext getBundleContext() throws ServletException {
        Object context = this.getServletContext().getAttribute(BundleContext.class.getName());
        if (context instanceof BundleContext) {
            return (BundleContext)context;
        }
        throw new ServletException("Bundle context attribute [" + BundleContext.class.getName() + "] not set in servlet context");
    }

    private static final class ServletContextWrapper
    implements ServletContext {
        private final ServletContext delegatee;
        private final String path;

        public ServletContextWrapper(ServletContext sc, String path) {
            this.delegatee = sc;
            this.path = path;
        }

        public String getContextPath() {
            return this.path;
        }

        public ServletContext getContext(String uripath) {
            return this.delegatee.getContext(uripath);
        }

        public int getMajorVersion() {
            return this.delegatee.getMajorVersion();
        }

        public int getMinorVersion() {
            return this.delegatee.getMinorVersion();
        }

        public int getEffectiveMajorVersion() {
            return this.delegatee.getEffectiveMajorVersion();
        }

        public int getEffectiveMinorVersion() {
            return this.delegatee.getEffectiveMinorVersion();
        }

        public String getMimeType(String file) {
            return this.delegatee.getMimeType(file);
        }

        public Set<String> getResourcePaths(String path) {
            return this.delegatee.getResourcePaths(path);
        }

        public URL getResource(String path) throws MalformedURLException {
            return this.delegatee.getResource(path);
        }

        public InputStream getResourceAsStream(String path) {
            return this.delegatee.getResourceAsStream(path);
        }

        public RequestDispatcher getRequestDispatcher(String path) {
            return this.delegatee.getRequestDispatcher(path);
        }

        public RequestDispatcher getNamedDispatcher(String name) {
            return this.delegatee.getNamedDispatcher(name);
        }

        public Servlet getServlet(String name) throws ServletException {
            return this.delegatee.getServlet(name);
        }

        public Enumeration<Servlet> getServlets() {
            return this.delegatee.getServlets();
        }

        public Enumeration<String> getServletNames() {
            return this.delegatee.getServletNames();
        }

        public void log(String msg) {
            this.delegatee.log(msg);
        }

        public void log(Exception exception, String msg) {
            this.delegatee.log(exception, msg);
        }

        public void log(String message, Throwable throwable) {
            this.delegatee.log(message, throwable);
        }

        public String getRealPath(String path) {
            return this.delegatee.getRealPath(path);
        }

        public String getServerInfo() {
            return this.delegatee.getServerInfo();
        }

        public String getInitParameter(String name) {
            return this.delegatee.getInitParameter(name);
        }

        public Enumeration<String> getInitParameterNames() {
            return this.delegatee.getInitParameterNames();
        }

        public boolean setInitParameter(String name, String value) {
            return this.delegatee.setInitParameter(name, value);
        }

        public Object getAttribute(String name) {
            return this.delegatee.getAttribute(name);
        }

        public Enumeration<String> getAttributeNames() {
            return this.delegatee.getAttributeNames();
        }

        public void setAttribute(String name, Object object) {
            this.delegatee.setAttribute(name, object);
        }

        public void removeAttribute(String name) {
            this.delegatee.removeAttribute(name);
        }

        public String getServletContextName() {
            return this.delegatee.getServletContextName();
        }

        public ServletRegistration.Dynamic addServlet(String servletName, String className) {
            return this.delegatee.addServlet(servletName, className);
        }

        public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
            return this.delegatee.addServlet(servletName, servlet);
        }

        public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
            return this.delegatee.addServlet(servletName, servletClass);
        }

        public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
            return (T)this.delegatee.createServlet(clazz);
        }

        public ServletRegistration getServletRegistration(String servletName) {
            return this.delegatee.getServletRegistration(servletName);
        }

        public Map<String, ? extends ServletRegistration> getServletRegistrations() {
            return this.delegatee.getServletRegistrations();
        }

        public FilterRegistration.Dynamic addFilter(String filterName, String className) {
            return this.delegatee.addFilter(filterName, className);
        }

        public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
            return this.delegatee.addFilter(filterName, filter);
        }

        public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
            return this.delegatee.addFilter(filterName, filterClass);
        }

        public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
            return (T)this.delegatee.createFilter(clazz);
        }

        public FilterRegistration getFilterRegistration(String filterName) {
            return this.delegatee.getFilterRegistration(filterName);
        }

        public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
            return this.delegatee.getFilterRegistrations();
        }

        public SessionCookieConfig getSessionCookieConfig() {
            return this.delegatee.getSessionCookieConfig();
        }

        public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
            this.delegatee.setSessionTrackingModes(sessionTrackingModes);
        }

        public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
            return this.delegatee.getDefaultSessionTrackingModes();
        }

        public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
            return this.delegatee.getEffectiveSessionTrackingModes();
        }

        public void addListener(String className) {
            this.delegatee.addListener(className);
        }

        public <T extends EventListener> void addListener(T t) {
            this.delegatee.addListener(t);
        }

        public void addListener(Class<? extends EventListener> listenerClass) {
            this.delegatee.addListener(listenerClass);
        }

        public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
            return (T)this.delegatee.createListener(clazz);
        }

        public JspConfigDescriptor getJspConfigDescriptor() {
            return this.delegatee.getJspConfigDescriptor();
        }

        public ClassLoader getClassLoader() {
            return this.delegatee.getClassLoader();
        }

        public void declareRoles(String ... roleNames) {
            this.delegatee.declareRoles(roleNames);
        }

        public String getVirtualServerName() {
            return this.delegatee.getVirtualServerName();
        }
    }

    private static final class BridgeHttpServletRequest
    extends HttpServletRequestWrapper {
        private final ServletContext context;

        public BridgeHttpServletRequest(HttpServletRequest req, ServletContext context) {
            super(req);
            this.context = context;
        }

        public String getServletPath() {
            return "";
        }

        public String getContextPath() {
            return this.context.getContextPath();
        }

        public ServletContext getServletContext() {
            return this.context;
        }
    }
}

