/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLSession;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.ssl.X509;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureRequestCustomizer
implements HttpConfiguration.Customizer {
    public static final String X509_ATTRIBUTE = "org.eclipse.jetty.server.x509";
    private static final Logger LOG = LoggerFactory.getLogger(SecureRequestCustomizer.class);
    private boolean _sniRequired;
    private boolean _sniHostCheck;
    private long _stsMaxAge;
    private boolean _stsIncludeSubDomains;
    private HttpField _stsField;

    public SecureRequestCustomizer() {
        this(true);
    }

    public SecureRequestCustomizer(@Name(value="sniHostCheck") boolean sniHostCheck) {
        this(sniHostCheck, -1L, false);
    }

    public SecureRequestCustomizer(@Name(value="sniHostCheck") boolean sniHostCheck, @Name(value="stsMaxAgeSeconds") long stsMaxAgeSeconds, @Name(value="stsIncludeSubdomains") boolean stsIncludeSubdomains) {
        this(false, sniHostCheck, stsMaxAgeSeconds, stsIncludeSubdomains);
    }

    public SecureRequestCustomizer(@Name(value="sniRequired") boolean sniRequired, @Name(value="sniHostCheck") boolean sniHostCheck, @Name(value="stsMaxAgeSeconds") long stsMaxAgeSeconds, @Name(value="stsIncludeSubdomains") boolean stsIncludeSubdomains) {
        this._sniRequired = sniRequired;
        this._sniHostCheck = sniHostCheck;
        this._stsMaxAge = stsMaxAgeSeconds;
        this._stsIncludeSubDomains = stsIncludeSubdomains;
        this.formatSTS();
    }

    public boolean isSniHostCheck() {
        return this._sniHostCheck;
    }

    public void setSniHostCheck(boolean sniHostCheck) {
        this._sniHostCheck = sniHostCheck;
    }

    public boolean isSniRequired() {
        return this._sniRequired;
    }

    public void setSniRequired(boolean sniRequired) {
        this._sniRequired = sniRequired;
    }

    public long getStsMaxAge() {
        return this._stsMaxAge;
    }

    public void setStsMaxAge(long stsMaxAgeSeconds) {
        this.setStsMaxAge(stsMaxAgeSeconds, TimeUnit.SECONDS);
    }

    public void setStsMaxAge(long period, TimeUnit units) {
        this._stsMaxAge = units.toSeconds(period);
        this.formatSTS();
    }

    public boolean isStsIncludeSubDomains() {
        return this._stsIncludeSubDomains;
    }

    public void setStsIncludeSubDomains(boolean stsIncludeSubDomains) {
        this._stsIncludeSubDomains = stsIncludeSubDomains;
        this.formatSTS();
    }

    private void formatSTS() {
        long stsMaxAge = this.getStsMaxAge();
        this._stsField = stsMaxAge < 0L ? null : new PreEncodedHttpField(HttpHeader.STRICT_TRANSPORT_SECURITY, String.format("max-age=%d%s", stsMaxAge, this.isStsIncludeSubDomains() ? "; includeSubDomains" : ""));
    }

    @Override
    public Request customize(Request request, HttpFields.Mutable responseHeaders) {
        EndPoint.SslSessionData sslSessionData;
        EndPoint endPoint = request.getConnectionMetaData().getConnection().getEndPoint();
        EndPoint.SslSessionData sslSessionData2 = sslSessionData = endPoint != null ? endPoint.getSslSessionData() : null;
        if (sslSessionData != null) {
            request = this.newSecureRequest(request, sslSessionData);
        }
        if (this._stsField != null) {
            responseHeaders.add(this._stsField);
        }
        return request;
    }

    protected Request newSecureRequest(Request request, EndPoint.SslSessionData sslSessionData) {
        if (sslSessionData.sslSession() != null) {
            this.checkSni(request, sslSessionData.sslSession());
        }
        return new SecureRequestWithSslSessionData(request, sslSessionData);
    }

    protected void checkSni(Request request, SSLSession session) {
        if (this.isSniRequired() || this.isSniHostCheck()) {
            String sniHost = this.retrieveSni(request, session);
            X509 x509 = this.getX509(session);
            if (x509 == null) {
                throw new BadMessageException(400, "Invalid SNI");
            }
            String serverName = Request.getServerName(request);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Host={}, SNI={}, SNI Certificate={}", new Object[]{serverName, sniHost, x509});
            }
            if (this.isSniRequired() && (sniHost == null || !x509.matches(sniHost))) {
                throw new BadMessageException(400, "Invalid SNI");
            }
            if (this.isSniHostCheck() && !x509.matches(serverName)) {
                throw new BadMessageException(400, "Invalid SNI");
            }
        }
    }

    protected String retrieveSni(Request request, SSLSession session) {
        String sniHost = (String)session.getValue("org.eclipse.jetty.util.ssl.sniHost");
        if (sniHost != null) {
            return sniHost;
        }
        if (session instanceof ExtendedSSLSession) {
            ExtendedSSLSession extended = (ExtendedSSLSession)session;
            for (SNIServerName serverName : extended.getRequestedServerNames()) {
                if (!(serverName instanceof SNIHostName)) continue;
                SNIHostName hostName = (SNIHostName)serverName;
                return hostName.getAsciiName();
            }
        }
        return null;
    }

    private X509 getX509(SSLSession session) {
        X509 x509 = (X509)session.getValue(X509_ATTRIBUTE);
        if (x509 == null) {
            Certificate[] certificates = session.getLocalCertificates();
            if (certificates == null || certificates.length == 0 || !(certificates[0] instanceof X509Certificate)) {
                return null;
            }
            x509 = new X509(null, (X509Certificate)certificates[0]);
            session.putValue(X509_ATTRIBUTE, x509);
        }
        return x509;
    }

    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }

    protected class SecureRequestWithSslSessionData
    extends Request.AttributesWrapper {
        private static final Set<String> ATTRIBUTES = Set.of("org.eclipse.jetty.io.Endpoint.SslSessionData", "org.eclipse.jetty.server.x509");

        protected SecureRequestWithSslSessionData(Request request, final EndPoint.SslSessionData sslSessionData) {
            super(request, new Attributes.Synthetic(request){

                @Override
                protected Object getSyntheticAttribute(String name) {
                    return switch (name) {
                        case "org.eclipse.jetty.io.Endpoint.SslSessionData" -> sslSessionData;
                        case SecureRequestCustomizer.X509_ATTRIBUTE -> SecureRequestCustomizer.this.getX509(sslSessionData.sslSession());
                        default -> null;
                    };
                }

                @Override
                protected Set<String> getSyntheticNameSet() {
                    return ATTRIBUTES;
                }
            });
        }

        @Override
        public boolean isSecure() {
            return true;
        }
    }

    protected static class SecureRequest
    extends Request.Wrapper {
        public SecureRequest(Request wrapped) {
            super(wrapped);
        }

        @Override
        public boolean isSecure() {
            return true;
        }
    }
}

