/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.server.internal;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.Trailers;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.HTTP2Channel;
import org.eclipse.jetty.http2.HTTP2Stream;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.http2.server.internal.HTTP2ServerConnection;
import org.eclipse.jetty.http2.server.internal.ServerHTTP2StreamEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpStream;
import org.eclipse.jetty.server.TunnelSupport;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpStreamOverHTTP2
implements HttpStream,
HTTP2Channel.Server {
    private static final Logger LOG = LoggerFactory.getLogger(HttpStreamOverHTTP2.class);
    private final AutoLock lock = new AutoLock();
    private final HTTP2ServerConnection _connection;
    private final HttpChannel _httpChannel;
    private final HTTP2Stream _stream;
    private MetaData.Request _requestMetaData;
    private MetaData.Response _responseMetaData;
    private TunnelSupport tunnelSupport;
    private Content.Chunk _chunk;
    private Content.Chunk _trailer;
    private boolean committed;
    private boolean _demand;

    public HttpStreamOverHTTP2(HTTP2ServerConnection connection, HttpChannel httpChannel, HTTP2Stream stream) {
        this._connection = connection;
        this._httpChannel = httpChannel;
        this._stream = stream;
    }

    @Override
    public String getId() {
        return String.valueOf(this._stream.getId());
    }

    public Runnable onRequest(HeadersFrame frame) {
        try {
            this._requestMetaData = (MetaData.Request)frame.getMetaData();
            Runnable handler = this._httpChannel.onRequest(this._requestMetaData);
            if (frame.isEndStream()) {
                try (AutoLock ignored = this.lock.lock();){
                    this._chunk = Content.Chunk.EOF;
                }
            }
            HttpFields fields = this._requestMetaData.getHttpFields();
            if (this._requestMetaData instanceof MetaData.ConnectRequest) {
                this.tunnelSupport = new TunnelSupportOverHTTP2(this._requestMetaData.getProtocol());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP2 request #{}/{}, {} {} {}{}{}", new Object[]{this._stream.getId(), Integer.toHexString(this._stream.getSession().hashCode()), this._requestMetaData.getMethod(), this._requestMetaData.getHttpURI(), this._requestMetaData.getHttpVersion(), System.lineSeparator(), fields});
            }
            Invocable.InvocationType invocationType = Invocable.getInvocationType(handler);
            return new Invocable.ReadyTask(invocationType, handler){

                @Override
                public void run() {
                    if (HttpStreamOverHTTP2.this._stream.isClosed()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("HTTP2 request #{}/{} skipped handling, stream already closed {}", new Object[]{HttpStreamOverHTTP2.this._stream.getId(), Integer.toHexString(HttpStreamOverHTTP2.this._stream.getSession().hashCode()), HttpStreamOverHTTP2.this._stream});
                        }
                    } else {
                        super.run();
                    }
                }
            };
        }
        catch (Throwable x) {
            HttpException httpException;
            if (x instanceof HttpException) {
                HttpException http = (HttpException)((Object)x);
                httpException = http;
            } else {
                httpException = new HttpException.RuntimeException(500, x);
            }
            HttpException httpException2 = httpException;
            return () -> this.onBadMessage(httpException2);
        }
    }

    private void onBadMessage(HttpException x) {
    }

    @Override
    public Content.Chunk read() {
        Content.Chunk chunk;
        if (this.tunnelSupport != null) {
            return null;
        }
        try (AutoLock ignored = this.lock.lock();){
            chunk = this._chunk;
            this._chunk = Content.Chunk.next(chunk);
        }
        if (chunk != null) {
            return chunk;
        }
        Stream.Data data = this._stream.readData();
        if (data == null) {
            return null;
        }
        if (data.frame().isEndStream()) {
            try (AutoLock ignored = this.lock.lock();){
                Content.Chunk trailer = this._trailer;
                if (trailer != null) {
                    this._chunk = Content.Chunk.next(trailer);
                    Content.Chunk chunk2 = trailer;
                    return chunk2;
                }
            }
        }
        chunk = this.createChunk(data);
        try (AutoLock ignored = this.lock.lock();){
            this._chunk = Content.Chunk.next(chunk);
        }
        return chunk;
    }

    @Override
    public void demand() {
        boolean notify = false;
        boolean demand = false;
        try (AutoLock ignored = this.lock.lock();){
            if (this._chunk != null || this._trailer != null) {
                notify = true;
            } else if (!this._demand) {
                this._demand = true;
                demand = true;
            }
        }
        if (notify) {
            Runnable task = this._httpChannel.onContentAvailable();
            if (task != null) {
                this._connection.offerTask(task, false);
            }
        } else if (demand) {
            this._stream.demand();
        }
    }

    @Override
    public Runnable onDataAvailable() {
        try (AutoLock ignored = this.lock.lock();){
            this._demand = false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Request #{}/{}: data available", (Object)this._stream.getId(), (Object)Integer.toHexString(this._stream.getSession().hashCode()));
        }
        return this._httpChannel.onContentAvailable();
    }

    @Override
    public Runnable onTrailer(HeadersFrame frame) {
        HttpFields trailers = frame.getMetaData().getHttpFields().asImmutable();
        try (AutoLock ignored = this.lock.lock();){
            this._trailer = new Trailers(trailers);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Request #{}/{}, trailer:{}{}", new Object[]{this._stream.getId(), Integer.toHexString(this._stream.getSession().hashCode()), System.lineSeparator(), trailers});
        }
        return this._httpChannel.onContentAvailable();
    }

    private Content.Chunk createChunk(Stream.Data data) {
        DataFrame frame = data.frame();
        if (frame.isEndStream() && frame.remaining() == 0) {
            data.release();
            return Content.Chunk.EOF;
        }
        return Content.Chunk.asChunk(frame.getByteBuffer(), frame.isEndStream(), data);
    }

    @Override
    public void prepareResponse(HttpFields.Mutable headers) {
    }

    @Override
    public void send(MetaData.Request request, MetaData.Response response, boolean last, ByteBuffer byteBuffer, Callback callback) {
        ByteBuffer content;
        ByteBuffer byteBuffer2 = content = byteBuffer != null ? byteBuffer : BufferUtil.EMPTY_BUFFER;
        if (response != null) {
            this.sendHeaders(request, response, content, last, callback);
        } else {
            this.sendContent(request, content, last, callback);
        }
    }

    private void sendHeaders(MetaData.Request request, MetaData.Response response, ByteBuffer content, boolean last, Callback callback) {
        HeadersFrame headersFrame;
        this._responseMetaData = response;
        DataFrame dataFrame = null;
        HeadersFrame trailersFrame = null;
        boolean isHeadRequest = HttpMethod.HEAD.is(request.getMethod());
        boolean hasContent = BufferUtil.hasContent(content) && !isHeadRequest;
        int streamId = this._stream.getId();
        if (HttpStatus.isInterim(response.getStatus())) {
            if (hasContent) {
                callback.failed(new IllegalStateException("Interim response cannot have content"));
                return;
            }
            headersFrame = new HeadersFrame(streamId, response, null, false);
        } else {
            this.committed = true;
            if (last) {
                long realContentLength = BufferUtil.length(content);
                long contentLength = response.getContentLength();
                if (contentLength < 0L) {
                    this._responseMetaData = new MetaData.Response(response.getStatus(), response.getReason(), response.getHttpVersion(), response.getHttpFields(), realContentLength, response.getTrailersSupplier());
                } else if (hasContent && contentLength != realContentLength) {
                    callback.failed(new HttpException.RuntimeException(500, String.format("Incorrect Content-Length %d!=%d", contentLength, realContentLength)));
                    return;
                }
            }
            if (hasContent) {
                headersFrame = new HeadersFrame(streamId, response, null, false);
                if (last) {
                    HttpFields trailers = this.retrieveTrailers();
                    if (trailers == null) {
                        dataFrame = new DataFrame(streamId, content, true);
                    } else {
                        dataFrame = new DataFrame(streamId, content, false);
                        trailersFrame = new HeadersFrame(streamId, new MetaData(HttpVersion.HTTP_2, trailers), null, true);
                    }
                } else {
                    dataFrame = new DataFrame(streamId, content, false);
                }
            } else if (last) {
                if (this.isTunnel(request, response)) {
                    headersFrame = new HeadersFrame(streamId, response, null, false);
                } else {
                    HttpFields trailers = this.retrieveTrailers();
                    if (trailers == null) {
                        headersFrame = new HeadersFrame(streamId, response, null, true);
                    } else {
                        headersFrame = new HeadersFrame(streamId, response, null, false);
                        trailersFrame = new HeadersFrame(streamId, new MetaData(HttpVersion.HTTP_2, trailers), null, true);
                    }
                }
            } else {
                headersFrame = new HeadersFrame(streamId, response, null, false);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Response #{}/{}:{}{} {}{}{}", new Object[]{this._stream.getId(), Integer.toHexString(this._stream.getSession().hashCode()), System.lineSeparator(), HttpVersion.HTTP_2, response.getStatus(), System.lineSeparator(), response.getHttpFields()});
        }
        this._stream.send(new HTTP2Stream.FrameList(headersFrame, dataFrame, trailersFrame), callback);
    }

    private void sendContent(MetaData.Request request, ByteBuffer content, boolean last, Callback callback) {
        boolean hasContent;
        boolean isHeadRequest = HttpMethod.HEAD.is(request.getMethod());
        boolean bl = hasContent = BufferUtil.hasContent(content) && !isHeadRequest;
        if (hasContent || last && !this.isTunnel(request, this._responseMetaData)) {
            if (!hasContent) {
                content = BufferUtil.EMPTY_BUFFER;
            }
            if (last) {
                HttpFields trailers = this.retrieveTrailers();
                if (trailers == null) {
                    this.sendDataFrame(content, true, true, callback);
                } else if (hasContent) {
                    SendTrailers sendTrailers = new SendTrailers(callback, trailers);
                    this.sendDataFrame(content, true, false, sendTrailers);
                } else {
                    this.sendTrailersFrame(new MetaData(HttpVersion.HTTP_2, trailers), callback);
                }
            } else {
                this.sendDataFrame(content, false, false, callback);
            }
        } else {
            callback.succeeded();
        }
    }

    private HttpFields retrieveTrailers() {
        Supplier<HttpFields> supplier = this._responseMetaData.getTrailersSupplier();
        if (supplier == null) {
            return null;
        }
        HttpFields trailers = supplier.get();
        if (trailers == null) {
            return null;
        }
        return trailers.size() == 0 ? null : trailers;
    }

    private boolean isTunnel(MetaData.Request request, MetaData.Response response) {
        return MetaData.isTunnel(request.getMethod(), response.getStatus());
    }

    @Override
    public long getIdleTimeout() {
        return this._stream.getIdleTimeout();
    }

    @Override
    public void setIdleTimeout(long idleTimeoutMs) {
        this._stream.setIdleTimeout(idleTimeoutMs);
    }

    @Override
    public void push(final MetaData.Request resource) {
        if (!this._stream.getSession().isPushEnabled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP/2 push disabled for {}", (Object)resource);
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP/2 push {}", (Object)resource);
        }
        this._stream.push(new PushPromiseFrame(this._stream.getId(), resource), new Promise<Stream>(){

            @Override
            public void succeeded(Stream pushStream) {
                HttpStreamOverHTTP2.this._connection.push((HTTP2Stream)pushStream, resource);
            }

            @Override
            public void failed(Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Could not HTTP/2 push {}", (Object)resource, (Object)x);
                }
            }
        }, null);
    }

    public Runnable onPushRequest(MetaData.Request request) {
        try {
            this._requestMetaData = request;
            Runnable task = this._httpChannel.onRequest(request);
            this._httpChannel.getRequest().setAttribute("org.eclipse.jetty.pushed", Boolean.TRUE);
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP/2 push request #{}/{}:{}{} {} {}{}{}", new Object[]{this._stream.getId(), Integer.toHexString(this._stream.getSession().hashCode()), System.lineSeparator(), request.getMethod(), request.getHttpURI(), request.getHttpVersion(), System.lineSeparator(), request.getHttpFields()});
            }
            return task;
        }
        catch (Throwable x) {
            HttpException httpException;
            if (x instanceof HttpException) {
                HttpException http = (HttpException)((Object)x);
                httpException = http;
            } else {
                httpException = new HttpException.RuntimeException(500, x);
            }
            HttpException httpException2 = httpException;
            return () -> this.onBadMessage(httpException2);
        }
    }

    private void sendDataFrame(ByteBuffer content, boolean lastContent, boolean endStream, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Response #{}/{}: {} content bytes{}", new Object[]{this._stream.getId(), Integer.toHexString(this._stream.getSession().hashCode()), content.remaining(), lastContent ? " (last chunk)" : ""});
        }
        DataFrame frame = new DataFrame(this._stream.getId(), content, endStream);
        this._stream.data(frame, callback);
    }

    private void sendTrailersFrame(MetaData metaData, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Response #{}/{}: trailers", (Object)this._stream.getId(), (Object)Integer.toHexString(this._stream.getSession().hashCode()));
        }
        HeadersFrame frame = new HeadersFrame(this._stream.getId(), metaData, null, true);
        this._stream.headers(frame, callback);
    }

    @Override
    public boolean isCommitted() {
        return this.committed;
    }

    @Override
    public boolean isIdle() {
        return false;
    }

    @Override
    public TunnelSupport getTunnelSupport() {
        return this.tunnelSupport;
    }

    @Override
    public Throwable consumeAvailable() {
        if (this.tunnelSupport != null) {
            return null;
        }
        Throwable result = HttpStream.consumeAvailable(this, this._httpChannel.getConnectionMetaData().getHttpConfiguration());
        if (result != null) {
            this._trailer = null;
            if (this._chunk != null) {
                this._chunk.release();
            }
            this._chunk = Content.Chunk.from(result, true);
        }
        return result;
    }

    @Override
    public void onTimeout(TimeoutException timeout, BiConsumer<Runnable, Boolean> consumer) {
        Runnable task = this._httpChannel.onIdleTimeout(timeout);
        boolean idle = !this._httpChannel.isRequestHandled();
        consumer.accept(task, idle);
    }

    @Override
    public Runnable onFailure(Throwable failure, Callback callback) {
        Runnable runnable = this._httpChannel.onFailure(failure);
        return () -> {
            if (runnable != null) {
                runnable.run();
            }
            callback.succeeded();
        };
    }

    @Override
    public void succeeded() {
        if (!this._stream.isClosed()) {
            if (this.isTunnel(this._requestMetaData, this._responseMetaData)) {
                Connection connection = (Connection)this._httpChannel.getRequest().getAttribute(HttpStream.UPGRADE_CONNECTION_ATTRIBUTE);
                if (connection == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("HTTP2 response #{}/{}: no upgrade connection, resetting stream", (Object)this._stream.getId(), (Object)Integer.toHexString(this._stream.getSession().hashCode()));
                    }
                    this._stream.reset(new ResetFrame(this._stream.getId(), ErrorCode.CANCEL_STREAM_ERROR.code), Callback.NOOP);
                } else {
                    EndPoint endPoint = this.tunnelSupport.getEndPoint();
                    this._stream.setAttachment(endPoint);
                    endPoint.upgrade(connection);
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("HTTP2 response #{}/{}: unconsumed request content, resetting stream", (Object)this._stream.getId(), (Object)Integer.toHexString(this._stream.getSession().hashCode()));
                }
                this._stream.reset(new ResetFrame(this._stream.getId(), ErrorCode.NO_ERROR.code), Callback.NOOP);
            }
        }
        this._httpChannel.recycle();
        this._connection.offerHttpChannel(this._httpChannel);
    }

    @Override
    public void failed(Throwable x) {
        ErrorCode errorCode;
        ErrorCode errorCode2 = errorCode = x == HttpStream.CONTENT_NOT_CONSUMED ? ErrorCode.NO_ERROR : ErrorCode.CANCEL_STREAM_ERROR;
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 response #{}/{} failed {}", new Object[]{this._stream.getId(), Integer.toHexString(this._stream.getSession().hashCode()), errorCode, x});
        }
        this._stream.reset(new ResetFrame(this._stream.getId(), errorCode.code), Callback.NOOP);
    }

    private class TunnelSupportOverHTTP2
    implements TunnelSupport {
        private final String protocol;
        private final EndPoint endPoint;

        private TunnelSupportOverHTTP2(String protocol) {
            this.endPoint = new ServerHTTP2StreamEndPoint(HttpStreamOverHTTP2.this._stream);
            this.protocol = protocol;
        }

        @Override
        public String getProtocol() {
            return this.protocol;
        }

        @Override
        public EndPoint getEndPoint() {
            return this.endPoint;
        }
    }

    private class SendTrailers
    extends Callback.Nested {
        private final HttpFields trailers;

        private SendTrailers(Callback callback, HttpFields trailers) {
            super(callback);
            this.trailers = trailers;
        }

        @Override
        public void succeeded() {
            HttpStreamOverHTTP2.this.sendTrailersFrame(new MetaData(HttpVersion.HTTP_2, this.trailers), this.getCallback());
        }
    }
}

