/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.resource;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.StringTokenizer;
import org.eclipse.jetty.util.FileID;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.resource.CombinedResource;
import org.eclipse.jetty.util.resource.MemoryResource;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollators;
import org.eclipse.jetty.util.resource.ResourceFactoryInternals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ResourceFactory {
    public static final Logger LOG = LoggerFactory.getLogger(ResourceFactory.class);

    public static Resource combine(List<Resource> resources) {
        return CombinedResource.combine(resources);
    }

    public static Resource combine(Resource ... resources) {
        return CombinedResource.combine(List.of(resources));
    }

    public Resource newResource(URI var1);

    @Deprecated(since="12.0.2", forRemoval=true)
    default public Resource newSystemResource(String resource) {
        return this.newClassLoaderResource(resource);
    }

    default public Resource newClassLoaderResource(String resource, boolean searchSystemClassLoader) {
        String[] stringArray;
        if (StringUtil.isBlank(resource)) {
            throw new IllegalArgumentException("Resource String is invalid: " + resource);
        }
        static interface Source {
            public Enumeration<URL> getResources(String var1) throws IOException;
        }
        ArrayList<Source> sources = new ArrayList<Source>();
        sources.add(Thread.currentThread().getContextClassLoader()::getResources);
        sources.add(ResourceFactory.class.getClassLoader()::getResources);
        if (searchSystemClassLoader) {
            sources.add(ClassLoader::getSystemResources);
        }
        ArrayList<Resource> resources = new ArrayList<Resource>();
        if (resource.startsWith("/")) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = resource;
            stringArray = stringArray2;
            stringArray2[1] = resource.substring(1);
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = resource;
        }
        String[] names = stringArray;
        for (Source source : sources) {
            for (String name : names) {
                try {
                    Enumeration<URL> urls = source.getResources(name);
                    while (urls.hasMoreElements()) {
                        Resource r = this.newResource(urls.nextElement().toURI());
                        if (!r.isDirectory()) {
                            return r;
                        }
                        resources.add(r);
                    }
                }
                catch (Throwable e) {
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace("Ignoring bad getResource(): {}", (Object)resource, (Object)e);
                }
            }
        }
        if (resources.isEmpty()) {
            return null;
        }
        if (resources.size() == 1) {
            return (Resource)resources.get(0);
        }
        return ResourceFactory.combine(resources);
    }

    default public Resource newClassLoaderResource(String resource) {
        return this.newClassLoaderResource(resource, true);
    }

    @Deprecated(since="12.0.2", forRemoval=true)
    default public Resource newClassPathResource(String resource) {
        return this.newClassLoaderResource(resource, false);
    }

    default public Resource newMemoryResource(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("URL is null");
        }
        return new MemoryResource(url);
    }

    default public Resource newResource(String resource) {
        if (StringUtil.isBlank(resource)) {
            throw new IllegalArgumentException("Resource String is invalid: " + resource);
        }
        if (URIUtil.hasScheme(resource)) {
            try {
                URI uri = new URI(resource);
                if (ResourceFactory.isSupported(uri)) {
                    return this.newResource(URIUtil.correctURI(uri));
                }
                if (uri.getScheme().length() != 1) {
                    throw new IllegalArgumentException("URI scheme not registered: " + uri.getScheme());
                }
            }
            catch (URISyntaxException x) {
                LOG.trace("ignored", (Throwable)x);
            }
        }
        try {
            Path path = Paths.get(resource, new String[0]);
            URI uri = new URI(path.toUri().toASCIIString());
            return new PathResource(path, uri, true);
        }
        catch (URISyntaxException | InvalidPathException x) {
            LOG.trace("ignored", (Throwable)x);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Input string cannot be converted to URI \"{}\"", (Object)resource);
            }
            throw new IllegalArgumentException("Cannot be converted to URI");
        }
    }

    default public Resource newResource(Path path) {
        if (path == null) {
            throw new IllegalArgumentException("Path is null");
        }
        return this.newResource(path.toUri());
    }

    default public Resource newResource(List<URI> uris) {
        if (uris == null || uris.isEmpty()) {
            throw new IllegalArgumentException("List of URIs is invalid");
        }
        return ResourceFactory.combine(uris.stream().map(this::newResource).toList());
    }

    default public Resource newResource(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("URL is null");
        }
        try {
            return this.newResource(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Error creating resource from URL: " + String.valueOf(url), e);
        }
    }

    default public Resource newJarFileResource(URI uri) {
        if (!uri.getScheme().equalsIgnoreCase("file")) {
            throw new IllegalArgumentException("Not an allowed path: " + String.valueOf(uri));
        }
        return this.newResource(URIUtil.toJarFileUri(uri));
    }

    default public List<Resource> split(String str) {
        ArrayList<Resource> list = new ArrayList<Resource>();
        StringTokenizer tokenizer = new StringTokenizer(str, ",;|");
        while (tokenizer.hasMoreTokens()) {
            String reference = tokenizer.nextToken();
            try {
                if (reference.endsWith("/*") || reference.endsWith("\\*")) {
                    Resource dir = this.newResource(reference.substring(0, reference.length() - 2));
                    if (!dir.isDirectory()) continue;
                    List<Resource> expanded = dir.list();
                    expanded.sort(ResourceCollators.byName(true));
                    expanded.stream().filter(r -> FileID.isLibArchive(r.getName())).forEach(list::add);
                    continue;
                }
                list.add(this.newResource(reference));
            }
            catch (Exception e) {
                LOG.warn("Invalid Resource Reference: " + reference);
                throw e;
            }
        }
        ListIterator<Resource> i = list.listIterator();
        while (i.hasNext()) {
            Resource resource = (Resource)i.next();
            if (!resource.exists() || resource.isDirectory() || !FileID.isLibArchive(resource.getName())) continue;
            i.set(this.newResource(URIUtil.toJarFileUri(resource.getURI())));
        }
        return list;
    }

    public static boolean isSupported(String str) {
        return ResourceFactoryInternals.isSupported(str);
    }

    public static boolean isSupported(URI uri) {
        return ResourceFactoryInternals.isSupported(uri);
    }

    public static void registerResourceFactory(String scheme, ResourceFactory resourceFactory) {
        if (StringUtil.isBlank(scheme)) {
            throw new IllegalArgumentException("Scheme is blank");
        }
        ResourceFactoryInternals.RESOURCE_FACTORIES.put(scheme, resourceFactory);
    }

    public static ResourceFactory unregisterResourceFactory(String scheme) {
        if (StringUtil.isBlank(scheme)) {
            throw new IllegalArgumentException("Scheme is blank");
        }
        return ResourceFactoryInternals.RESOURCE_FACTORIES.remove(scheme);
    }

    public static ResourceFactory root() {
        return ResourceFactoryInternals.ROOT;
    }

    public static Closeable closeable() {
        return new ResourceFactoryInternals.Closeable();
    }

    public static LifeCycle lifecycle() {
        ResourceFactoryInternals.LifeCycle factory = new ResourceFactoryInternals.LifeCycle();
        org.eclipse.jetty.util.component.LifeCycle.start(factory);
        return factory;
    }

    @Deprecated(since="12.0.8", forRemoval=true)
    public static ResourceFactory of(final Resource baseResource) {
        Objects.requireNonNull(baseResource);
        if (baseResource instanceof ResourceFactory) {
            ResourceFactory resourceFactory = (ResourceFactory)((Object)baseResource);
            return resourceFactory;
        }
        return new ResourceFactory(){

            @Override
            public Resource newResource(URI resource) {
                return this.newResource(resource.toString());
            }

            @Override
            public Resource newResource(String resource) {
                return baseResource.resolve(resource);
            }
        };
    }

    public static ResourceFactory of(final Container container) {
        Objects.requireNonNull(container);
        LifeCycle factory = container.getBean(LifeCycle.class);
        if (factory == null) {
            factory = ResourceFactory.lifecycle();
            container.addBean(factory, true);
            final LifeCycle finalFactory = factory;
            container.addEventListener(new LifeCycle.Listener(){

                @Override
                public void lifeCycleStopped(org.eclipse.jetty.util.component.LifeCycle event) {
                    container.removeBean(this);
                    container.removeBean(finalFactory);
                }
            });
        }
        return factory;
    }

    public static interface LifeCycle
    extends org.eclipse.jetty.util.component.LifeCycle,
    ResourceFactory,
    Dumpable {
    }

    public static interface Closeable
    extends ResourceFactory,
    java.io.Closeable {
        @Override
        public void close();
    }
}

