/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.hpack;

import java.nio.ByteBuffer;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.http.compression.HuffmanEncoder;
import org.eclipse.jetty.http.compression.NBitIntegerEncoder;
import org.eclipse.jetty.http.compression.NBitStringEncoder;
import org.eclipse.jetty.http2.hpack.HpackContext;
import org.eclipse.jetty.http2.hpack.HpackException;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HpackEncoder {
    private static final Logger LOG = LoggerFactory.getLogger(HpackEncoder.class);
    private static final HttpField[] STATUSES = new HttpField[599];
    static final EnumSet<HttpHeader> DO_NOT_HUFFMAN = EnumSet.of(HttpHeader.AUTHORIZATION, HttpHeader.CONTENT_MD5, HttpHeader.PROXY_AUTHENTICATE, HttpHeader.PROXY_AUTHORIZATION);
    static final EnumSet<HttpHeader> DO_NOT_INDEX = EnumSet.of(HttpHeader.AUTHORIZATION, new HttpHeader[]{HttpHeader.CONTENT_MD5, HttpHeader.CONTENT_RANGE, HttpHeader.ETAG, HttpHeader.IF_MODIFIED_SINCE, HttpHeader.IF_UNMODIFIED_SINCE, HttpHeader.IF_NONE_MATCH, HttpHeader.IF_RANGE, HttpHeader.IF_MATCH, HttpHeader.LOCATION, HttpHeader.RANGE, HttpHeader.RETRY_AFTER, HttpHeader.LAST_MODIFIED, HttpHeader.SET_COOKIE, HttpHeader.SET_COOKIE2});
    static final EnumSet<HttpHeader> NEVER_INDEX = EnumSet.of(HttpHeader.AUTHORIZATION, HttpHeader.SET_COOKIE, HttpHeader.SET_COOKIE2);
    private static final EnumSet<HttpHeader> IGNORED_HEADERS = EnumSet.of(HttpHeader.CONNECTION, HttpHeader.KEEP_ALIVE, HttpHeader.PROXY_CONNECTION, HttpHeader.TRANSFER_ENCODING, HttpHeader.UPGRADE);
    private static final PreEncodedHttpField TE_TRAILERS = new PreEncodedHttpField(HttpHeader.TE, "trailers");
    private static final PreEncodedHttpField C_SCHEME_HTTP = new PreEncodedHttpField(HttpHeader.C_SCHEME, "http");
    private static final PreEncodedHttpField C_SCHEME_HTTPS = new PreEncodedHttpField(HttpHeader.C_SCHEME, "https");
    private static final EnumMap<HttpMethod, PreEncodedHttpField> C_METHODS = new EnumMap(HttpMethod.class);
    private final HpackContext _context = new HpackContext(0);
    private final boolean _debug = LOG.isDebugEnabled();
    private int _maxTableCapacity;
    private int _tableCapacity;
    private int _maxHeaderListSize;
    private int _headerListSize;
    private boolean _validateEncoding = true;

    public HpackEncoder() {
        this.setMaxTableCapacity(4096);
        this.setTableCapacity(4096);
    }

    public int getMaxTableCapacity() {
        return this._maxTableCapacity;
    }

    public void setMaxTableCapacity(int maxTableSizeLimit) {
        this._maxTableCapacity = maxTableSizeLimit;
    }

    public int getTableCapacity() {
        return this._tableCapacity;
    }

    public void setTableCapacity(int tableCapacity) {
        if (tableCapacity > this.getMaxTableCapacity()) {
            throw new IllegalArgumentException("Max table capacity exceeded");
        }
        this._tableCapacity = tableCapacity;
    }

    public int getMaxHeaderListSize() {
        return this._maxHeaderListSize;
    }

    public void setMaxHeaderListSize(int maxHeaderListSize) {
        this._maxHeaderListSize = maxHeaderListSize;
    }

    public HpackContext getHpackContext() {
        return this._context;
    }

    @Deprecated
    public void setRemoteMaxDynamicTableSize(int maxTableSize) {
        this.setTableCapacity(maxTableSize);
    }

    @Deprecated
    public void setLocalMaxDynamicTableSize(int maxTableSizeLimit) {
        this.setMaxTableCapacity(maxTableSizeLimit);
    }

    public boolean isValidateEncoding() {
        return this._validateEncoding;
    }

    public void setValidateEncoding(boolean validateEncoding) {
        this._validateEncoding = validateEncoding;
    }

    /*
     * WARNING - void declaration
     */
    public void encode(ByteBuffer buffer, MetaData metadata) throws HpackException {
        try {
            int maxHeaderListSize;
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("CtxTbl[%x] encoding", this._context.hashCode()));
            }
            HttpFields fields = metadata.getFields();
            if (this.isValidateEncoding() && fields != null) {
                for (HttpField field : fields) {
                    String name = field.getName();
                    char firstChar = name.charAt(0);
                    if (firstChar > ' ' && firstChar != ':') continue;
                    throw new HpackException.StreamException("Invalid header name: '%s'", name);
                }
            }
            this._headerListSize = 0;
            int pos = buffer.position();
            int tableCapacity = this.getTableCapacity();
            if (tableCapacity != this._context.getMaxDynamicTableSize()) {
                this.encodeMaxDynamicTableSize(buffer, tableCapacity);
            }
            if (metadata.isRequest()) {
                MetaData.Request request = (MetaData.Request)metadata;
                String method = request.getMethod();
                HttpMethod httpMethod = method == null ? null : HttpMethod.fromString(method);
                HttpField methodField = C_METHODS.get((Object)httpMethod);
                this.encode(buffer, methodField == null ? new HttpField(HttpHeader.C_METHOD, method) : methodField);
                this.encode(buffer, new HttpField(HttpHeader.C_AUTHORITY, request.getURI().getAuthority()));
                boolean isConnect = HttpMethod.CONNECT.is(request.getMethod());
                String protocol = request.getProtocol();
                if (!isConnect || protocol != null) {
                    String scheme = request.getURI().getScheme();
                    this.encode(buffer, HttpScheme.HTTPS.is(scheme) ? C_SCHEME_HTTPS : C_SCHEME_HTTP);
                    this.encode(buffer, new HttpField(HttpHeader.C_PATH, request.getURI().getPathQuery()));
                    if (protocol != null) {
                        this.encode(buffer, new HttpField(HttpHeader.C_PROTOCOL, protocol));
                    }
                }
            } else if (metadata.isResponse()) {
                void var8_20;
                HttpField httpField;
                MetaData.Response response = (MetaData.Response)metadata;
                int code = response.getStatus();
                HttpField httpField2 = httpField = code < STATUSES.length ? STATUSES[code] : null;
                if (httpField == null) {
                    HttpField.IntValueHttpField intValueHttpField = new HttpField.IntValueHttpField(HttpHeader.C_STATUS, code);
                }
                this.encode(buffer, (HttpField)var8_20);
            }
            if (fields != null) {
                long l;
                HashSet<String> hopHeaders = null;
                for (String string : fields.getCSV(HttpHeader.CONNECTION, false)) {
                    if (hopHeaders == null) {
                        hopHeaders = new HashSet<String>();
                    }
                    hopHeaders.add(StringUtil.asciiToLowerCase(string));
                }
                boolean contentLengthEncoded = false;
                for (HttpField field : fields) {
                    HttpHeader header = field.getHeader();
                    if (header != null && IGNORED_HEADERS.contains((Object)header)) continue;
                    if (header == HttpHeader.TE) {
                        if (!field.contains("trailers")) continue;
                        this.encode(buffer, TE_TRAILERS);
                        continue;
                    }
                    String name = field.getLowerCaseName();
                    if (hopHeaders != null && hopHeaders.contains(name)) continue;
                    if (header == HttpHeader.CONTENT_LENGTH) {
                        contentLengthEncoded = true;
                    }
                    this.encode(buffer, field);
                }
                if (!contentLengthEncoded && (l = metadata.getContentLength()) >= 0L) {
                    this.encode(buffer, new HttpField(HttpHeader.CONTENT_LENGTH, String.valueOf(l)));
                }
            }
            if ((maxHeaderListSize = this.getMaxHeaderListSize()) > 0 && this._headerListSize > maxHeaderListSize) {
                throw new HpackException.SessionException("Header size %d > %d", this._headerListSize, maxHeaderListSize);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("CtxTbl[%x] encoded %d octets", this._context.hashCode(), buffer.position() - pos));
            }
        }
        catch (HpackException x) {
            throw x;
        }
        catch (Throwable x) {
            HpackException.SessionException failure = new HpackException.SessionException("Could not hpack encode %s", metadata);
            failure.initCause(x);
            throw failure;
        }
    }

    public void encodeMaxDynamicTableSize(ByteBuffer buffer, int maxTableSize) {
        buffer.put((byte)32);
        NBitIntegerEncoder.encode(buffer, 5, maxTableSize);
        this._context.resize(maxTableSize);
    }

    public void encode(ByteBuffer buffer, HttpField field) {
        if (field.getValue() == null) {
            field = new HttpField(field.getHeader(), field.getName(), "");
        }
        int fieldSize = field.getName().length() + field.getValue().length();
        this._headerListSize += fieldSize + 32;
        Object encoding = null;
        HpackContext.Entry entry = this._context.get(field);
        if (entry != null) {
            if (entry.isStatic()) {
                buffer.put(((HpackContext.StaticEntry)entry).getEncodedField());
                if (this._debug) {
                    encoding = "IdxFieldS1";
                }
            } else {
                int index = this._context.index(entry);
                buffer.put((byte)-128);
                NBitIntegerEncoder.encode(buffer, 7, index);
                if (this._debug) {
                    encoding = "IdxField" + (entry.isStatic() ? "S" : "") + NBitIntegerEncoder.octetsNeeded(7, index);
                }
            }
        } else {
            boolean indexed;
            HttpHeader header = field.getHeader();
            if (header == null) {
                HpackContext.Entry name = this._context.get(field.getName());
                if (field instanceof PreEncodedHttpField) {
                    int i = buffer.position();
                    ((PreEncodedHttpField)field).putTo(buffer, HttpVersion.HTTP_2);
                    byte b = buffer.get(i);
                    boolean bl = indexed = b < 0 || b >= 64;
                    if (this._debug) {
                        encoding = indexed ? "PreEncodedIdx" : "PreEncoded";
                    }
                } else if (name == null && fieldSize < this._context.getMaxDynamicTableSize()) {
                    indexed = true;
                    this.encodeName(buffer, (byte)64, 6, field.getName(), null);
                    HpackEncoder.encodeValue(buffer, true, field.getValue());
                    if (this._debug) {
                        encoding = "LitHuffNHuffVIdx";
                    }
                } else {
                    indexed = false;
                    this.encodeName(buffer, (byte)0, 4, field.getName(), null);
                    HpackEncoder.encodeValue(buffer, true, field.getValue());
                    if (this._debug) {
                        encoding = "LitHuffNHuffV!Idx";
                    }
                }
            } else {
                HpackContext.Entry name = this._context.get(header);
                if (field instanceof PreEncodedHttpField) {
                    int i = buffer.position();
                    ((PreEncodedHttpField)field).putTo(buffer, HttpVersion.HTTP_2);
                    byte b = buffer.get(i);
                    boolean bl = indexed = b < 0 || b >= 64;
                    if (this._debug) {
                        encoding = indexed ? "PreEncodedIdx" : "PreEncoded";
                    }
                } else if (DO_NOT_INDEX.contains((Object)header)) {
                    indexed = false;
                    boolean neverIndex = NEVER_INDEX.contains((Object)header);
                    boolean huffman = !DO_NOT_HUFFMAN.contains((Object)header);
                    this.encodeName(buffer, neverIndex ? (byte)16 : 0, 4, header.asString(), name);
                    HpackEncoder.encodeValue(buffer, huffman, field.getValue());
                    if (this._debug) {
                        encoding = "Lit" + (String)(name == null ? "HuffN" : "IdxN" + (name.isStatic() ? "S" : "") + (1 + NBitIntegerEncoder.octetsNeeded(4, this._context.index(name)))) + (huffman ? "HuffV" : "LitV") + (neverIndex ? "!!Idx" : "!Idx");
                    }
                } else if (fieldSize >= this._context.getMaxDynamicTableSize() || header == HttpHeader.CONTENT_LENGTH && !"0".equals(field.getValue())) {
                    indexed = false;
                    this.encodeName(buffer, (byte)0, 4, header.asString(), name);
                    HpackEncoder.encodeValue(buffer, true, field.getValue());
                    if (this._debug) {
                        encoding = "Lit" + (String)(name == null ? "HuffN" : "IdxNS" + (1 + NBitIntegerEncoder.octetsNeeded(4, this._context.index(name)))) + "HuffV!Idx";
                    }
                } else {
                    indexed = true;
                    boolean huffman = !DO_NOT_HUFFMAN.contains((Object)header);
                    this.encodeName(buffer, (byte)64, 6, header.asString(), name);
                    HpackEncoder.encodeValue(buffer, huffman, field.getValue());
                    if (this._debug) {
                        encoding = (String)(name == null ? "LitHuffN" : "LitIdxN" + (name.isStatic() ? "S" : "") + (1 + NBitIntegerEncoder.octetsNeeded(6, this._context.index(name)))) + (huffman ? "HuffVIdx" : "LitVIdx");
                    }
                }
            }
            if (indexed) {
                this._context.add(field);
            }
        }
        if (this._debug && LOG.isDebugEnabled()) {
            LOG.debug("encode {}:'{}' to '{}'", new Object[]{encoding, field, BufferUtil.toHexString(buffer.duplicate().flip())});
        }
    }

    private void encodeName(ByteBuffer buffer, byte mask, int bits, String name, HpackContext.Entry entry) {
        buffer.put(mask);
        if (entry == null) {
            buffer.put((byte)-128);
            NBitIntegerEncoder.encode(buffer, 7, HuffmanEncoder.octetsNeededLowerCase(name));
            HuffmanEncoder.encodeLowerCase(buffer, name);
        } else {
            NBitIntegerEncoder.encode(buffer, bits, this._context.index(entry));
        }
    }

    static void encodeValue(ByteBuffer buffer, boolean huffman, String value) {
        NBitStringEncoder.encode(buffer, 8, value, huffman);
    }

    static {
        for (HttpStatus.Code code : HttpStatus.Code.values()) {
            HpackEncoder.STATUSES[code.getCode()] = new PreEncodedHttpField(HttpHeader.C_STATUS, Integer.toString(code.getCode()));
        }
        for (Enum enum_ : HttpMethod.values()) {
            C_METHODS.put((HttpMethod)enum_, new PreEncodedHttpField(HttpHeader.C_METHOD, ((HttpMethod)enum_).asString()));
        }
    }
}

