/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.handler;

import jakarta.servlet.Servlet;
import java.io.FilePermission;
import org.apache.felix.http.base.internal.context.ExtServletContext;
import org.apache.felix.http.base.internal.handler.ServletHandler;
import org.apache.felix.http.base.internal.runtime.ServletInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class WhiteboardServletHandler
extends ServletHandler {
    private final BundleContext bundleContext;
    private final int multipartErrorCode;
    private final Bundle multipartSecurityContext;

    public WhiteboardServletHandler(long contextServiceId, ExtServletContext context, ServletInfo servletInfo, BundleContext contextBundleContext, Bundle registeringBundle, Bundle httpWhiteboardBundle) {
        super(contextServiceId, context, servletInfo);
        this.bundleContext = contextBundleContext;
        int errorCode = -1;
        if (this.getMultipartConfig() != null && System.getSecurityManager() != null) {
            FilePermission writePerm = new FilePermission(this.getMultipartConfig().multipartLocation, "read,write,delete");
            if (servletInfo.getMultipartConfig().multipartLocation == null) {
                this.multipartSecurityContext = httpWhiteboardBundle;
                if (!httpWhiteboardBundle.hasPermission((Object)writePerm)) {
                    errorCode = 9;
                } else {
                    FilePermission readPerm = new FilePermission(this.getMultipartConfig().multipartLocation, "read");
                    if (!registeringBundle.hasPermission((Object)readPerm)) {
                        errorCode = 10;
                    }
                }
            } else {
                this.multipartSecurityContext = registeringBundle;
                if (!registeringBundle.hasPermission((Object)writePerm)) {
                    errorCode = 8;
                }
                if (!httpWhiteboardBundle.hasPermission((Object)writePerm)) {
                    errorCode = 11;
                }
            }
        } else {
            this.multipartSecurityContext = null;
        }
        this.multipartErrorCode = errorCode;
    }

    @Override
    public int init() {
        if (this.multipartErrorCode != -1) {
            return this.multipartErrorCode;
        }
        if (this.useCount > 0) {
            ++this.useCount;
            return -1;
        }
        this.setServlet((Servlet)this.getServletInfo().getService(this.bundleContext));
        int reason = super.init();
        if (reason != -1) {
            this.getServletInfo().ungetService(this.bundleContext, this.getServlet());
            this.setServlet(null);
        }
        return reason;
    }

    @Override
    public boolean destroy() {
        Servlet s = this.getServlet();
        if (s != null && super.destroy()) {
            this.getServletInfo().ungetService(this.bundleContext, this.getServlet());
            return true;
        }
        return false;
    }

    @Override
    public Bundle getMultipartSecurityContext() {
        return this.multipartSecurityContext;
    }
}

