/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.dispatch;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.felix.http.base.internal.dispatch.InvocationChain;
import org.apache.felix.http.base.internal.dispatch.RequestInfo;
import org.apache.felix.http.base.internal.dispatch.ServletRequestWrapper;
import org.apache.felix.http.base.internal.handler.FilterHandler;
import org.apache.felix.http.base.internal.handler.ServletHandler;
import org.apache.felix.http.base.internal.registry.PerContextHandlerRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ServletResponseWrapper
extends HttpServletResponseWrapper {
    private final HttpServletRequest request;
    private final AtomicInteger invocationCount = new AtomicInteger();
    private final PerContextHandlerRegistry errorRegistry;
    private final String servletName;

    public ServletResponseWrapper(@NotNull HttpServletRequest req, @NotNull HttpServletResponse res, @Nullable String servletName, @Nullable PerContextHandlerRegistry errorRegistry) {
        super(res);
        this.request = req;
        this.servletName = servletName;
        this.errorRegistry = errorRegistry;
    }

    public void sendError(int sc) throws IOException {
        this.sendError(sc, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendError(int code, String message) throws IOException {
        this.resetBuffer();
        this.setStatus(code);
        boolean invokeSuper = true;
        if (this.invocationCount.incrementAndGet() == 1 && code != 204 && code != 304 && code != 206 && code >= 200) {
            ServletHandler errorResolution;
            Throwable exception = (Throwable)this.request.getAttribute("jakarta.servlet.error.exception");
            ServletHandler servletHandler = errorResolution = this.errorRegistry == null ? null : this.errorRegistry.getErrorHandler(code, exception);
            if (errorResolution != null) {
                try {
                    this.request.setAttribute("jakarta.servlet.error.status_code", (Object)code);
                    if (message != null) {
                        this.request.setAttribute("jakarta.servlet.error.message", (Object)message);
                    }
                    this.request.setAttribute("jakarta.servlet.error.request_uri", (Object)this.request.getRequestURI());
                    if (this.servletName != null) {
                        this.request.setAttribute("jakarta.servlet.error.servlet_name", (Object)this.servletName);
                    }
                    String servletPath = null;
                    String pathInfo = this.request.getRequestURI();
                    String queryString = null;
                    RequestInfo requestInfo = new RequestInfo(servletPath, pathInfo, queryString, pathInfo, this.request.getHttpServletMapping().getServletName(), this.request.getHttpServletMapping().getPattern(), this.request.getHttpServletMapping().getMatchValue(), this.request.getHttpServletMapping().getMappingMatch(), false);
                    FilterHandler[] filterHandlers = this.errorRegistry.getFilterHandlers(errorResolution, DispatcherType.ERROR, this.request.getRequestURI());
                    ServletRequestWrapper reqWrapper = new ServletRequestWrapper(this.request, errorResolution.getContext(), requestInfo, null, false, null, null);
                    InvocationChain filterChain = new InvocationChain(errorResolution, filterHandlers);
                    filterChain.doFilter((ServletRequest)reqWrapper, (ServletResponse)this);
                    invokeSuper = false;
                }
                catch (ServletException servletException) {
                }
                finally {
                    this.request.removeAttribute("jakarta.servlet.error.status_code");
                    this.request.removeAttribute("jakarta.servlet.error.message");
                    this.request.removeAttribute("jakarta.servlet.error.request_uri");
                    this.request.removeAttribute("jakarta.servlet.error.servlet_name");
                    this.request.removeAttribute("jakarta.servlet.error.exception");
                    this.request.removeAttribute("jakarta.servlet.error.exception_type");
                }
            }
        }
        if (invokeSuper) {
            super.sendError(code, message);
        }
    }
}

