/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.jetty.internal;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.jetty.internal.JettyConfig;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.RequestLog;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

class LogServiceRequestLog
extends CustomRequestLog {
    public static final String SVC_PROP_NAME = "name";
    public static final String DEFAULT_NAME = "osgi";
    public static final String PREFIX = "REQUEST: ";
    private final String serviceName;
    private volatile ServiceRegistration<RequestLog> registration;

    LogServiceRequestLog(JettyConfig config) {
        super(new RequestLog.Writer(){

            public void write(String requestEntry) throws IOException {
                SystemLogger.LOGGER.info(LogServiceRequestLog.PREFIX.concat(requestEntry));
            }
        }, config.getRequestLogOSGiFormat());
        this.serviceName = config.getRequestLogOSGiServiceName();
    }

    public synchronized void register(BundleContext context) throws IllegalStateException {
        if (this.registration != null) {
            throw new IllegalStateException(((Object)((Object)this)).getClass().getSimpleName() + " already registered");
        }
        Hashtable<String, String> svcProps = new Hashtable<String, String>();
        ((Dictionary)svcProps).put(SVC_PROP_NAME, this.serviceName);
        this.registration = context.registerService(RequestLog.class, (Object)this, svcProps);
    }

    public synchronized void unregister() {
        if (this.registration != null) {
            try {
                this.registration.unregister();
            }
            catch (IllegalStateException illegalStateException) {
            }
            finally {
                this.registration = null;
            }
        }
    }
}

