/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.registry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.felix.http.base.internal.handler.ServletHandler;
import org.apache.felix.http.base.internal.runtime.ServletInfo;
import org.apache.felix.http.base.internal.runtime.dto.BuilderConstants;
import org.apache.felix.http.base.internal.runtime.dto.ErrorPageDTOBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.servlet.runtime.dto.ErrorPageDTO;
import org.osgi.service.servlet.runtime.dto.FailedErrorPageDTO;
import org.osgi.service.servlet.runtime.dto.ServletContextDTO;

public final class ErrorPageRegistry {
    private static final String CLIENT_ERROR = "4xx";
    private static final String SERVER_ERROR = "5xx";
    private static final Pattern ERROR_CODE_PATTERN = Pattern.compile("\\d{3}");
    private static final List<Long> CLIENT_ERROR_CODES = ErrorPageRegistry.hundredOf(400);
    private static final List<Long> SERVER_ERROR_CODES = ErrorPageRegistry.hundredOf(500);
    private final Map<String, List<ServletHandler>> errorMapping = new ConcurrentHashMap<String, List<ServletHandler>>();
    private volatile List<ErrorRegistrationStatus> status = Collections.emptyList();

    private static boolean hasErrorCode(ServletHandler handler, String key) {
        for (String val : handler.getServletInfo().getErrorPage()) {
            if (!key.equals(val)) continue;
            return true;
        }
        return false;
    }

    private static List<Long> hundredOf(int start) {
        ArrayList<Long> result = new ArrayList<Long>();
        for (long i = (long)start; i < (long)(start + 100); ++i) {
            result.add(i);
        }
        return Collections.unmodifiableList(result);
    }

    private static long[] toLongArray(Set<Long> set) {
        long[] codes = BuilderConstants.EMPTY_LONG_ARRAY;
        if (!set.isEmpty()) {
            codes = new long[set.size()];
            int index = 0;
            for (Long code : set) {
                codes[index++] = code;
            }
        }
        return codes;
    }

    private static Set<Long> toLongSet(long[] codes) {
        TreeSet<Long> set = new TreeSet<Long>();
        for (long c : codes) {
            set.add(c);
        }
        return set;
    }

    private static String[] toStringArray(Set<String> set) {
        String[] array = BuilderConstants.EMPTY_STRING_ARRAY;
        if (!set.isEmpty()) {
            array = set.toArray(new String[set.size()]);
        }
        return array;
    }

    private static Set<String> toStringSet(String[] array) {
        TreeSet<String> set = new TreeSet<String>();
        for (String s : array) {
            set.add(s);
        }
        return set;
    }

    private static String parseErrorCodes(Set<Long> codes, String string) {
        if (CLIENT_ERROR.equalsIgnoreCase(string)) {
            codes.addAll(CLIENT_ERROR_CODES);
        } else if (SERVER_ERROR.equalsIgnoreCase(string)) {
            codes.addAll(SERVER_ERROR_CODES);
        } else if (ERROR_CODE_PATTERN.matcher(string).matches()) {
            codes.add(Long.parseLong(string));
        } else {
            return string;
        }
        return null;
    }

    @Nullable
    public static ErrorRegistration getErrorRegistration(@NotNull ServletInfo info) {
        if (info.getErrorPage() != null) {
            TreeSet<Long> errorCodes = new TreeSet<Long>();
            TreeSet<String> exceptions = new TreeSet<String>();
            for (String val : info.getErrorPage()) {
                String exception = ErrorPageRegistry.parseErrorCodes(errorCodes, val);
                if (exception == null) continue;
                exceptions.add(exception);
            }
            long[] codes = ErrorPageRegistry.toLongArray(errorCodes);
            String[] exceptionsArray = ErrorPageRegistry.toStringArray(exceptions);
            return new ErrorRegistration(codes, exceptionsArray);
        }
        return null;
    }

    public synchronized void addServlet(@NotNull ServletHandler handler) {
        ErrorRegistration reg = ErrorPageRegistry.getErrorRegistration(handler.getServletInfo());
        if (reg != null) {
            ErrorRegistrationStatus status = new ErrorRegistrationStatus(handler);
            for (long code : reg.errorCodes) {
                this.addErrorHandling(handler, status, code, null);
            }
            for (String exception : reg.exceptions) {
                this.addErrorHandling(handler, status, 0L, exception);
            }
            ArrayList<ErrorRegistrationStatus> arrayList = new ArrayList<ErrorRegistrationStatus>(this.status);
            arrayList.add(status);
            Collections.sort(arrayList);
            this.status = arrayList;
        }
    }

    public synchronized void removeServlet(@NotNull ServletInfo info, boolean destroy) {
        ErrorRegistration reg = ErrorPageRegistry.getErrorRegistration(info);
        if (reg != null) {
            ArrayList<ErrorRegistrationStatus> newList = new ArrayList<ErrorRegistrationStatus>(this.status);
            Iterator i = newList.iterator();
            while (i.hasNext()) {
                ErrorRegistrationStatus errorRegistrationStatus = (ErrorRegistrationStatus)i.next();
                if (!errorRegistrationStatus.handler.getServletInfo().equals(info)) continue;
                i.remove();
                break;
            }
            this.status = newList;
            for (long code : reg.errorCodes) {
                this.removeErrorHandling(info, code, null);
            }
            for (String exception : reg.exceptions) {
                this.removeErrorHandling(info, 0L, exception);
            }
        }
    }

    public synchronized void cleanup() {
        this.errorMapping.clear();
        this.status = Collections.emptyList();
    }

    private void addErrorHandling(ServletHandler handler, ErrorRegistrationStatus status, long code, String exception) {
        List<ServletHandler> newList;
        String key = exception != null ? exception : String.valueOf(code);
        List<ServletHandler> list = this.errorMapping.get(key);
        if (list == null) {
            newList = Collections.singletonList(handler);
        } else {
            newList = new ArrayList<ServletHandler>(list);
            newList.add(handler);
            Collections.sort(newList);
        }
        if (newList.get(0) == handler) {
            int result = handler.init();
            this.addReason(status, code, exception, result);
            if (result == -1) {
                if (list != null) {
                    ServletHandler old = list.get(0);
                    old.destroy();
                    this.errorMapping.put(key, newList);
                    ErrorRegistrationStatus oldStatus = null;
                    Iterator<ErrorRegistrationStatus> i = this.status.iterator();
                    while (oldStatus == null && i.hasNext()) {
                        ErrorRegistrationStatus current = i.next();
                        if (!current.handler.getServletInfo().equals(old.getServletInfo())) continue;
                        oldStatus = current;
                    }
                    if (oldStatus != null) {
                        this.removeReason(oldStatus, code, exception, -1);
                        boolean addReason = true;
                        if (exception == null) {
                            if (code >= 400L && code < 500L && oldStatus.usesClientErrorCodes && !status.usesClientErrorCodes) {
                                addReason = false;
                            } else if (code >= 500L && code < 600L && oldStatus.usesServerErrorCodes && !status.usesServerErrorCodes) {
                                addReason = false;
                            }
                        }
                        if (addReason) {
                            this.addReason(oldStatus, code, exception, 3);
                        }
                    }
                } else {
                    this.errorMapping.put(key, newList);
                }
            }
        } else {
            boolean addReason = true;
            if (exception == null) {
                if (code >= 400L && code < 500L && status.usesClientErrorCodes && !ErrorPageRegistry.hasErrorCode(newList.get(0), CLIENT_ERROR)) {
                    addReason = false;
                } else if (code >= 500L && code < 600L && status.usesServerErrorCodes && !ErrorPageRegistry.hasErrorCode(newList.get(0), SERVER_ERROR)) {
                    addReason = false;
                }
            }
            if (addReason) {
                this.addReason(status, code, exception, 3);
            }
            this.errorMapping.put(key, newList);
        }
    }

    private void addReason(ErrorRegistrationStatus status, long code, String exception, int reason) {
        ErrorRegistration reg = status.reasonMapping.get(reason);
        if (reg == null) {
            reg = exception != null ? new ErrorRegistration(BuilderConstants.EMPTY_LONG_ARRAY, new String[]{exception}) : new ErrorRegistration(new long[]{code}, BuilderConstants.EMPTY_STRING_ARRAY);
        } else {
            long[] codes = reg.errorCodes;
            String[] exceptions = reg.exceptions;
            if (exception != null) {
                Set<String> set = ErrorPageRegistry.toStringSet(exceptions);
                set.add(exception);
                exceptions = ErrorPageRegistry.toStringArray(set);
            } else {
                Set<Long> set = ErrorPageRegistry.toLongSet(codes);
                set.add(code);
                codes = ErrorPageRegistry.toLongArray(set);
            }
            reg = new ErrorRegistration(codes, exceptions);
        }
        status.reasonMapping.put(reason, reg);
    }

    private void removeReason(ErrorRegistrationStatus status, long code, String exception, int reason) {
        ErrorRegistration reg = status.reasonMapping.get(reason);
        if (reg != null) {
            long[] codes = reg.errorCodes;
            String[] exceptions = reg.exceptions;
            if (exception != null) {
                Set<String> set = ErrorPageRegistry.toStringSet(exceptions);
                set.remove(exception);
                exceptions = ErrorPageRegistry.toStringArray(set);
            } else {
                Set<Long> set = ErrorPageRegistry.toLongSet(codes);
                set.remove(code);
                codes = ErrorPageRegistry.toLongArray(set);
            }
            if (codes.length == 0 && exceptions.length == 0) {
                status.reasonMapping.remove(reason);
            } else {
                status.reasonMapping.put(reason, new ErrorRegistration(codes, exceptions));
            }
        }
    }

    private void removeErrorHandling(ServletInfo info, long code, String exception) {
        String key = exception != null ? exception : String.valueOf(code);
        List<ServletHandler> list = this.errorMapping.get(key);
        if (list != null) {
            int index = 0;
            for (ServletHandler handler : list) {
                if (handler.getServletInfo().equals(info)) {
                    ArrayList<ServletHandler> newList = new ArrayList<ServletHandler>(list);
                    newList.remove(handler);
                    if (index == 0) {
                        handler.destroy();
                        ++index;
                        while (index < list.size()) {
                            ServletHandler next = list.get(index);
                            ErrorRegistrationStatus nextStatus = null;
                            for (ErrorRegistrationStatus s : this.status) {
                                if (!s.handler.getServletInfo().equals(next.getServletInfo())) continue;
                                nextStatus = s;
                                break;
                            }
                            this.removeReason(nextStatus, code, exception, 3);
                            int reason = next.init();
                            this.addReason(nextStatus, code, exception, reason);
                            if (reason == -1) break;
                            newList.remove(next);
                        }
                    }
                    if (newList.isEmpty()) {
                        this.errorMapping.remove(key);
                        break;
                    }
                    this.errorMapping.put(key, newList);
                    break;
                }
                ++index;
            }
        }
    }

    public ServletHandler get(Throwable exception, int errorCode) {
        ServletHandler errorHandler = this.get(exception);
        if (errorHandler != null) {
            return errorHandler;
        }
        return this.get(errorCode);
    }

    private ServletHandler get(long errorCode) {
        List<ServletHandler> list = this.errorMapping.get(String.valueOf(errorCode));
        if (list != null) {
            return list.get(0);
        }
        return null;
    }

    private ServletHandler get(Throwable exception) {
        if (exception == null) {
            return null;
        }
        ServletHandler servletHandler = null;
        Class<?> throwableClass = exception.getClass();
        while (servletHandler == null && throwableClass != null) {
            List<ServletHandler> list = this.errorMapping.get(throwableClass.getName());
            if (list != null) {
                servletHandler = list.get(0);
            }
            if (servletHandler != null || Throwable.class.isAssignableFrom(throwableClass = throwableClass.getSuperclass())) continue;
            throwableClass = null;
        }
        return servletHandler;
    }

    public void getRuntimeInfo(ServletContextDTO dto, Collection<FailedErrorPageDTO> failedErrorPageDTOs) {
        ArrayList<ErrorPageDTO> errorPageDTOs = new ArrayList<ErrorPageDTO>();
        List<ErrorRegistrationStatus> statusList = this.status;
        for (ErrorRegistrationStatus status : statusList) {
            for (Map.Entry<Integer, ErrorRegistration> entry : status.reasonMapping.entrySet()) {
                ErrorPageDTO state = ErrorPageDTOBuilder.build(status.getHandler(), entry.getKey());
                state.errorCodes = Arrays.copyOf(entry.getValue().errorCodes, entry.getValue().errorCodes.length);
                state.exceptions = Arrays.copyOf(entry.getValue().exceptions, entry.getValue().exceptions.length);
                if (entry.getKey() == -1) {
                    errorPageDTOs.add(state);
                    continue;
                }
                failedErrorPageDTOs.add((FailedErrorPageDTO)state);
            }
        }
        if (!errorPageDTOs.isEmpty()) {
            dto.errorPageDTOs = errorPageDTOs.toArray(new ErrorPageDTO[errorPageDTOs.size()]);
        }
    }

    static final class ErrorRegistrationStatus
    implements Comparable<ErrorRegistrationStatus> {
        private final ServletHandler handler;
        public final Map<Integer, ErrorRegistration> reasonMapping = new HashMap<Integer, ErrorRegistration>();
        public final boolean usesClientErrorCodes;
        public final boolean usesServerErrorCodes;

        public ErrorRegistrationStatus(ServletHandler handler) {
            this.handler = handler;
            this.usesClientErrorCodes = ErrorPageRegistry.hasErrorCode(handler, ErrorPageRegistry.CLIENT_ERROR);
            this.usesServerErrorCodes = ErrorPageRegistry.hasErrorCode(handler, ErrorPageRegistry.SERVER_ERROR);
        }

        public ServletHandler getHandler() {
            return this.handler;
        }

        @Override
        public int compareTo(ErrorRegistrationStatus o) {
            return this.handler.compareTo(o.getHandler());
        }
    }

    public static final class ErrorRegistration {
        public final long[] errorCodes;
        public final String[] exceptions;

        public ErrorRegistration(long[] errorCodes, String[] exceptions) {
            this.errorCodes = errorCodes;
            this.exceptions = exceptions;
        }
    }
}

