/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.dispatch;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestAttributeEvent;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletMapping;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.Part;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.felix.http.base.internal.context.ExtServletContext;
import org.apache.felix.http.base.internal.dispatch.MultipartConfig;
import org.apache.felix.http.base.internal.dispatch.RequestInfo;
import org.apache.felix.http.base.internal.handler.HttpSessionWrapper;
import org.apache.felix.http.base.internal.util.UriUtils;
import org.osgi.framework.Bundle;
import org.osgi.service.useradmin.Authorization;

final class ServletRequestWrapper
extends HttpServletRequestWrapper {
    private static final List<String> FORBIDDEN_ATTRIBUTES = Arrays.asList("jakarta.servlet.forward.context_path", "jakarta.servlet.forward.mapping", "jakarta.servlet.forward.path_info", "jakarta.servlet.forward.query_string", "jakarta.servlet.forward.request_uri", "jakarta.servlet.forward.servlet_path", "jakarta.servlet.include.context_path", "jakarta.servlet.include.mapping", "jakarta.servlet.include.path_info", "jakarta.servlet.include.query_string", "jakarta.servlet.include.request_uri", "jakarta.servlet.include.servlet_path");
    private static final String POST_METHOD = "POST";
    private final DispatcherType type;
    private final RequestInfo requestInfo;
    private final ExtServletContext servletContext;
    private final boolean asyncSupported;
    private final MultipartConfig multipartConfig;
    private final Bundle bundleForSecurityCheck;
    private Collection<Part> parts;

    public ServletRequestWrapper(HttpServletRequest req, ExtServletContext servletContext, RequestInfo requestInfo, DispatcherType type, boolean asyncSupported, MultipartConfig multipartConfig, Bundle bundleForSecurityCheck) {
        super(req);
        this.asyncSupported = asyncSupported;
        this.multipartConfig = multipartConfig;
        this.servletContext = servletContext;
        this.requestInfo = requestInfo;
        this.type = type;
        this.bundleForSecurityCheck = bundleForSecurityCheck;
    }

    public Object getAttribute(String name) {
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        if (this.isInclusionDispatcher() && !this.requestInfo.nameMatch) {
            if ("jakarta.servlet.include.request_uri".equals(name)) {
                return this.requestInfo.requestURI;
            }
            if ("jakarta.servlet.include.context_path".equals(name)) {
                return request.getContextPath();
            }
            if ("jakarta.servlet.include.servlet_path".equals(name)) {
                return this.requestInfo.servletPath;
            }
            if ("jakarta.servlet.include.path_info".equals(name)) {
                return this.requestInfo.pathInfo;
            }
            if ("jakarta.servlet.include.query_string".equals(name)) {
                return this.requestInfo.queryString;
            }
            if ("jakarta.servlet.include.mapping".equals(name)) {
                return this.requestInfo;
            }
        } else if (this.isForwardingDispatcher() && !this.requestInfo.nameMatch) {
            if ("jakarta.servlet.forward.request_uri".equals(name)) {
                return super.getRequestURI();
            }
            if ("jakarta.servlet.forward.context_path".equals(name)) {
                return request.getContextPath();
            }
            if ("jakarta.servlet.forward.servlet_path".equals(name)) {
                return super.getServletPath();
            }
            if ("jakarta.servlet.forward.path_info".equals(name)) {
                return super.getPathInfo();
            }
            if ("jakarta.servlet.forward.query_string".equals(name)) {
                return super.getQueryString();
            }
            if ("jakarta.servlet.forward.mapping".equals(name)) {
                return super.getHttpServletMapping();
            }
        }
        if (FORBIDDEN_ATTRIBUTES.contains(name)) {
            return null;
        }
        return super.getAttribute(name);
    }

    public String getAuthType() {
        String authType = (String)this.getAttribute("org.osgi.service.http.authentication.type");
        if (authType == null) {
            authType = super.getAuthType();
        }
        return authType;
    }

    public String getContextPath() {
        return this.getServletContext().getContextPath();
    }

    public DispatcherType getDispatcherType() {
        return this.type == null ? super.getDispatcherType() : this.type;
    }

    public String getPathInfo() {
        if (this.isInclusionDispatcher()) {
            return super.getPathInfo();
        }
        return this.requestInfo.pathInfo;
    }

    public String getPathTranslated() {
        String info = this.getPathInfo();
        return null == info ? null : this.getRealPath(info);
    }

    public String getRemoteUser() {
        String remoteUser = (String)this.getAttribute("org.osgi.service.http.authentication.remote.user");
        if (remoteUser != null) {
            return remoteUser;
        }
        return super.getRemoteUser();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        boolean relPath;
        if (path == null) {
            return null;
        }
        boolean bl = relPath = !path.startsWith("/") && !"".equals(path);
        if (relPath) {
            path = UriUtils.concat(this.getServletPath(), path);
        }
        return this.servletContext.getRequestDispatcher(path);
    }

    public String getRequestURI() {
        if (this.isInclusionDispatcher()) {
            return super.getRequestURI();
        }
        return this.requestInfo.requestURI;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public String getServletPath() {
        if (this.isInclusionDispatcher()) {
            return super.getServletPath();
        }
        return this.requestInfo.servletPath;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        HttpSession session = super.getSession(create);
        if (session == null) {
            return null;
        }
        if (!create && !HttpSessionWrapper.hasSession(this.servletContext.getServletContextName(), session)) {
            return null;
        }
        return new HttpSessionWrapper(session, this.servletContext, this.servletContext.getConfig(), false);
    }

    public boolean isUserInRole(String role) {
        Object authorization = this.getAttribute("org.osgi.service.useradmin.authorization");
        if (authorization instanceof Authorization) {
            return ((Authorization)authorization).hasRole(role);
        }
        return super.isUserInRole(role);
    }

    public void setAttribute(String name, Object value) {
        if (value == null) {
            this.removeAttribute(name);
        }
        Object oldValue = this.getAttribute(name);
        super.setAttribute(name, value);
        if (this.servletContext.getServletRequestAttributeListener() != null) {
            if (oldValue == null) {
                this.servletContext.getServletRequestAttributeListener().attributeAdded(new ServletRequestAttributeEvent((ServletContext)this.servletContext, (ServletRequest)this, name, value));
            } else {
                this.servletContext.getServletRequestAttributeListener().attributeReplaced(new ServletRequestAttributeEvent((ServletContext)this.servletContext, (ServletRequest)this, name, oldValue));
            }
        }
    }

    public void removeAttribute(String name) {
        Object oldValue = this.getAttribute(name);
        if (oldValue != null) {
            super.removeAttribute(name);
            if (this.servletContext.getServletRequestAttributeListener() != null) {
                this.servletContext.getServletRequestAttributeListener().attributeRemoved(new ServletRequestAttributeEvent((ServletContext)this.servletContext, (ServletRequest)this, name, oldValue));
            }
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "->" + super.getRequest();
    }

    private boolean isForwardingDispatcher() {
        return DispatcherType.FORWARD == this.type;
    }

    private boolean isInclusionDispatcher() {
        return DispatcherType.INCLUDE == this.type;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        if (!this.asyncSupported) {
            throw new IllegalStateException();
        }
        return super.startAsync();
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        if (!this.asyncSupported) {
            throw new IllegalStateException();
        }
        return super.startAsync(servletRequest, servletResponse);
    }

    public boolean isAsyncSupported() {
        return this.asyncSupported;
    }

    private Collection<Part> checkMultipart() throws IOException, ServletException {
        if (this.parts == null) {
            final RequestContext multipartContext = !POST_METHOD.equalsIgnoreCase(this.getMethod()) ? null : new RequestContext(){

                @Override
                public InputStream getInputStream() throws IOException {
                    return ServletRequestWrapper.this.getInputStream();
                }

                @Override
                public String getContentType() {
                    return ServletRequestWrapper.this.getContentType();
                }

                @Override
                public int getContentLength() {
                    return ServletRequestWrapper.this.getContentLength();
                }

                @Override
                public String getCharacterEncoding() {
                    return ServletRequestWrapper.this.getCharacterEncoding();
                }
            };
            if (multipartContext != null && FileUploadBase.isMultipartContent(multipartContext)) {
                if (this.multipartConfig == null) {
                    throw new IllegalStateException("Multipart not enabled for servlet.");
                }
                if (System.getSecurityManager() == null) {
                    this.handleMultipart(multipartContext);
                } else {
                    AccessControlContext ctx = (AccessControlContext)this.bundleForSecurityCheck.adapt(AccessControlContext.class);
                    IOException ioe = AccessController.doPrivileged(new PrivilegedAction<IOException>(){

                        @Override
                        public IOException run() {
                            try {
                                ServletRequestWrapper.this.handleMultipart(multipartContext);
                            }
                            catch (IOException ioe) {
                                return ioe;
                            }
                            return null;
                        }
                    }, ctx);
                    if (ioe != null) {
                        throw ioe;
                    }
                }
            } else {
                throw new ServletException("Not a multipart request");
            }
        }
        return this.parts;
    }

    private void handleMultipart(RequestContext multipartContext) throws IOException {
        FileUpload upload = new FileUpload();
        upload.setSizeMax(this.multipartConfig.multipartMaxRequestSize);
        upload.setFileSizeMax(this.multipartConfig.multipartMaxFileSize);
        upload.setFileItemFactory(new DiskFileItemFactory(this.multipartConfig.multipartThreshold, new File(this.multipartConfig.multipartLocation)));
        List<FileItem> items = null;
        try {
            items = upload.parseRequest(multipartContext);
        }
        catch (FileUploadException fue) {
            throw new IOException("Error parsing multipart request", fue);
        }
        this.parts = new ArrayList<Part>();
        for (final FileItem item : items) {
            this.parts.add(new Part(){

                public InputStream getInputStream() throws IOException {
                    return item.getInputStream();
                }

                public String getContentType() {
                    return item.getContentType();
                }

                public String getName() {
                    return item.getFieldName();
                }

                public String getSubmittedFileName() {
                    return item.getName();
                }

                public long getSize() {
                    return item.getSize();
                }

                public void write(String fileName) throws IOException {
                    try {
                        item.write(new File(fileName));
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                }

                public void delete() throws IOException {
                    item.delete();
                }

                public String getHeader(String name) {
                    return item.getHeaders().getHeader(name);
                }

                public Collection<String> getHeaders(String name) {
                    ArrayList<String> values = new ArrayList<String>();
                    Iterator<String> iter = item.getHeaders().getHeaders(name);
                    while (iter.hasNext()) {
                        values.add(iter.next());
                    }
                    return values;
                }

                public Collection<String> getHeaderNames() {
                    ArrayList<String> names = new ArrayList<String>();
                    Iterator<String> iter = item.getHeaders().getHeaderNames();
                    while (iter.hasNext()) {
                        names.add(iter.next());
                    }
                    return names;
                }
            });
        }
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return this.checkMultipart();
    }

    public Part getPart(String name) throws IOException, ServletException {
        Collection<Part> parts = this.checkMultipart();
        for (Part p : parts) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public HttpServletMapping getHttpServletMapping() {
        return this.requestInfo;
    }
}

