/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.handler;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.File;
import java.io.IOException;
import org.apache.felix.http.base.internal.context.ExtServletContext;
import org.apache.felix.http.base.internal.dispatch.MultipartConfig;
import org.apache.felix.http.base.internal.handler.ServletConfigImpl;
import org.apache.felix.http.base.internal.jakartawrappers.ServletWrapper;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.base.internal.runtime.ServletInfo;
import org.osgi.framework.Bundle;

public abstract class ServletHandler
implements Comparable<ServletHandler> {
    private static final String TEMP_DIR = System.getProperty("java.io.tmpdir");
    private static final String JAVA_SERVLET_TEMP_DIR_PROP = "jakarta.servlet.content.tempdir";
    private final long contextServiceId;
    private final ServletInfo servletInfo;
    private final ExtServletContext context;
    private volatile Servlet servlet;
    protected volatile int useCount;
    private final MultipartConfig mpConfig;

    public ServletHandler(long contextServiceId, ExtServletContext context, ServletInfo servletInfo) {
        this.contextServiceId = contextServiceId;
        this.context = context;
        this.servletInfo = servletInfo;
        MultipartConfig origConfig = servletInfo.getMultipartConfig();
        if (origConfig != null) {
            String location = origConfig.multipartLocation;
            if (location != null && location.trim().length() == 0) {
                location = null;
            }
            if (location == null) {
                Object obj;
                Object object = obj = context == null ? null : context.getAttribute(JAVA_SERVLET_TEMP_DIR_PROP);
                if (obj != null) {
                    location = obj instanceof File ? ((File)obj).getAbsolutePath() : obj.toString();
                }
            }
            if (location == null) {
                location = TEMP_DIR;
            }
            this.mpConfig = new MultipartConfig(origConfig.multipartThreshold, location, origConfig.multipartMaxFileSize, origConfig.multipartMaxRequestSize);
        } else {
            this.mpConfig = null;
        }
    }

    @Override
    public int compareTo(ServletHandler other) {
        return this.servletInfo.compareTo(other.servletInfo);
    }

    public long getContextServiceId() {
        return this.contextServiceId;
    }

    public ExtServletContext getContext() {
        return this.context;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    protected void setServlet(Servlet s) {
        this.servlet = s;
    }

    public void handle(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        Servlet local = this.servlet;
        if (local == null) {
            throw new ServletException("Servlet has been unregistered");
        }
        local.service(req, res);
    }

    public ServletInfo getServletInfo() {
        return this.servletInfo;
    }

    public String getName() {
        Servlet local;
        String name = this.servletInfo.getName();
        if (name == null && (local = this.servlet) != null) {
            name = local instanceof ServletWrapper ? ((ServletWrapper)local).getServlet().getClass().getName() : local.getClass().getName();
        }
        return name;
    }

    public int init() {
        if (this.useCount > 0) {
            ++this.useCount;
            return -1;
        }
        if (this.servlet == null) {
            return 5;
        }
        try {
            this.servlet.init((ServletConfig)new ServletConfigImpl(this.getName(), this.getContext(), this.getServletInfo().getInitParameters()));
        }
        catch (Exception e) {
            SystemLogger.error(this.getServletInfo().getServiceReference(), "Error during calling init() on servlet " + this.servletInfo.getClassName(this.servlet), e);
            return 4;
        }
        ++this.useCount;
        return -1;
    }

    public boolean destroy() {
        if (this.servlet == null) {
            return false;
        }
        --this.useCount;
        if (this.useCount == 0) {
            try {
                this.servlet.destroy();
            }
            catch (Exception ignore) {
                SystemLogger.error(this.getServletInfo().getServiceReference(), "Error during calling destroy() on servlet " + this.servletInfo.getClassName(this.servlet), ignore);
            }
            this.servlet = null;
            return true;
        }
        return false;
    }

    public boolean dispose() {
        this.useCount = 1;
        return this.destroy();
    }

    public int hashCode() {
        return 31 + this.servletInfo.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ServletHandler other = (ServletHandler)obj;
        return this.servletInfo.equals(other.servletInfo);
    }

    public MultipartConfig getMultipartConfig() {
        return this.mpConfig;
    }

    public Bundle getMultipartSecurityContext() {
        return null;
    }
}

