/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncListener;
import javax.servlet.DispatcherType;
import javax.servlet.MultipartConfigElement;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HostPortHttpField;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.server.AsyncAttributes;
import org.eclipse.jetty.server.AsyncContextEvent;
import org.eclipse.jetty.server.AsyncContextState;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.CookieCutter;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.MultiPartFormDataCompliance;
import org.eclipse.jetty.server.MultiParts;
import org.eclipse.jetty.server.PushBuilder;
import org.eclipse.jetty.server.PushBuilderImpl;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServletAttributes;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.session.Session;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.AttributesMap;
import org.eclipse.jetty.util.HostPort;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.UrlEncoded;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class Request
implements HttpServletRequest {
    public static final String MULTIPART_CONFIG_ELEMENT = "org.eclipse.jetty.multipartConfig";
    public static final String MULTIPARTS = "org.eclipse.jetty.multiParts";
    private static final Logger LOG = Log.getLogger(Request.class);
    private static final Collection<Locale> __defaultLocale = Collections.singleton(Locale.getDefault());
    private static final int INPUT_NONE = 0;
    private static final int INPUT_STREAM = 1;
    private static final int INPUT_READER = 2;
    private static final MultiMap<String> NO_PARAMS = new MultiMap();
    private final HttpChannel _channel;
    private final List<ServletRequestAttributeListener> _requestAttributeListeners = new ArrayList<ServletRequestAttributeListener>();
    private final HttpInput _input;
    private MetaData.Request _metaData;
    private String _originalURI;
    private String _contextPath;
    private String _servletPath;
    private String _pathInfo;
    private Object _asyncNotSupportedSource = null;
    private boolean _secure;
    private boolean _newContext;
    private boolean _cookiesExtracted = false;
    private boolean _handled = false;
    private boolean _contentParamsExtracted;
    private boolean _requestedSessionIdFromCookie = false;
    private Attributes _attributes;
    private Authentication _authentication;
    private String _contentType;
    private String _characterEncoding;
    private ContextHandler.Context _context;
    private ContextHandler.Context _errorContext;
    private CookieCutter _cookies;
    private DispatcherType _dispatcherType;
    private int _inputState = 0;
    private BufferedReader _reader;
    private String _readerEncoding;
    private MultiMap<String> _queryParameters;
    private MultiMap<String> _contentParameters;
    private MultiMap<String> _parameters;
    private String _queryEncoding;
    private InetSocketAddress _remote;
    private String _requestedSessionId;
    private UserIdentity.Scope _scope;
    private HttpSession _session;
    private SessionHandler _sessionHandler;
    private long _timeStamp;
    private MultiParts _multiParts;
    private AsyncContextState _async;
    private List<Session> _sessions;

    private static boolean isNoParams(MultiMap<String> inputParameters) {
        boolean isNoParams = inputParameters == NO_PARAMS;
        return isNoParams;
    }

    public static Request getBaseRequest(ServletRequest request) {
        if (request instanceof Request) {
            return (Request)request;
        }
        Object channel = request.getAttribute(HttpChannel.class.getName());
        if (channel instanceof HttpChannel) {
            return ((HttpChannel)channel).getRequest();
        }
        while (request instanceof ServletRequestWrapper) {
            request = ((ServletRequestWrapper)request).getRequest();
        }
        if (request instanceof Request) {
            return (Request)request;
        }
        return null;
    }

    public Request(HttpChannel channel, HttpInput input) {
        this._channel = channel;
        this._input = input;
    }

    public HttpFields getHttpFields() {
        MetaData.Request metadata = this._metaData;
        return metadata == null ? null : metadata.getFields();
    }

    public HttpFields getTrailers() {
        MetaData.Request metadata = this._metaData;
        Supplier<HttpFields> trailers = metadata == null ? null : metadata.getTrailerSupplier();
        return trailers == null ? null : trailers.get();
    }

    public HttpInput getHttpInput() {
        return this._input;
    }

    public boolean isPush() {
        return Boolean.TRUE.equals(this.getAttribute("org.eclipse.jetty.pushed"));
    }

    public boolean isPushSupported() {
        return !this.isPush() && this.getHttpChannel().getHttpTransport().isPushSupported();
    }

    public PushBuilder getPushBuilder() {
        if (!this.isPushSupported()) {
            return null;
        }
        HttpFields fields = new HttpFields(this.getHttpFields().size() + 5);
        boolean conditional = false;
        block7: for (HttpField field : this.getHttpFields()) {
            HttpHeader header = field.getHeader();
            if (header == null) {
                fields.add(field);
                continue;
            }
            switch (header) {
                case IF_MATCH: 
                case IF_RANGE: 
                case IF_UNMODIFIED_SINCE: 
                case RANGE: 
                case EXPECT: 
                case REFERER: 
                case COOKIE: {
                    continue block7;
                }
                case AUTHORIZATION: {
                    continue block7;
                }
                case IF_NONE_MATCH: 
                case IF_MODIFIED_SINCE: {
                    conditional = true;
                    continue block7;
                }
            }
            fields.add(field);
        }
        String id = null;
        try {
            HttpSession session = this.getSession();
            if (session != null) {
                session.getLastAccessedTime();
                id = session.getId();
            } else {
                id = this.getRequestedSessionId();
            }
        }
        catch (IllegalStateException e) {
            id = this.getRequestedSessionId();
        }
        PushBuilderImpl builder = new PushBuilderImpl(this, fields, this.getMethod(), this.getQueryString(), id, conditional);
        builder.addHeader("referer", this.getRequestURL().toString());
        return builder;
    }

    public void addEventListener(EventListener listener) {
        if (listener instanceof ServletRequestAttributeListener) {
            this._requestAttributeListeners.add((ServletRequestAttributeListener)listener);
        }
        if (listener instanceof AsyncListener) {
            throw new IllegalArgumentException(listener.getClass().toString());
        }
    }

    public void enterSession(HttpSession s) {
        if (!(s instanceof Session)) {
            return;
        }
        if (this._sessions == null) {
            this._sessions = new ArrayList<Session>();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request {} entering session={}", this, s);
        }
        this._sessions.add((Session)s);
    }

    private void leaveSession(Session session) {
        ServletContext ctx;
        ContextHandler handler;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request {} leaving session {}", this, session);
        }
        if ((handler = ContextHandler.getContextHandler(ctx = session.getServletContext())) == null) {
            session.getSessionHandler().complete(session);
        } else {
            handler.handle(this, () -> session.getSessionHandler().complete(session));
        }
    }

    private void commitSession(Session session) {
        ServletContext ctx;
        ContextHandler handler;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response {} committing for session {}", this, session);
        }
        if ((handler = ContextHandler.getContextHandler(ctx = session.getServletContext())) == null) {
            session.getSessionHandler().commit(session);
        } else {
            handler.handle(this, () -> session.getSessionHandler().commit(session));
        }
    }

    private MultiMap<String> getParameters() {
        if (!this._contentParamsExtracted) {
            this._contentParamsExtracted = true;
            if (this._contentParameters == null) {
                try {
                    this.extractContentParameters();
                }
                catch (IllegalArgumentException | IllegalStateException e) {
                    LOG.warn(e.toString(), new Object[0]);
                    throw new BadMessageException("Unable to parse form content", e);
                }
            }
        }
        if (this._queryParameters == null) {
            try {
                this.extractQueryParameters();
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                throw new BadMessageException("Unable to parse URI query", e);
            }
        }
        if (Request.isNoParams(this._queryParameters) || this._queryParameters.size() == 0) {
            this._parameters = this._contentParameters;
        } else if (Request.isNoParams(this._contentParameters) || this._contentParameters.size() == 0) {
            this._parameters = this._queryParameters;
        } else if (this._parameters == null) {
            this._parameters = new MultiMap();
            this._parameters.addAllValues(this._queryParameters);
            this._parameters.addAllValues(this._contentParameters);
        }
        MultiMap<String> parameters = this._parameters;
        return parameters == null ? NO_PARAMS : parameters;
    }

    private void extractQueryParameters() {
        MetaData.Request metadata = this._metaData;
        if (metadata == null || metadata.getURI() == null || !metadata.getURI().hasQuery()) {
            this._queryParameters = NO_PARAMS;
        } else {
            this._queryParameters = new MultiMap();
            if (this._queryEncoding == null) {
                metadata.getURI().decodeQueryTo(this._queryParameters);
            } else {
                try {
                    metadata.getURI().decodeQueryTo(this._queryParameters, this._queryEncoding);
                }
                catch (UnsupportedEncodingException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.warn(e);
                    }
                    LOG.warn(e.toString(), new Object[0]);
                }
            }
        }
    }

    private boolean isContentEncodingSupported() {
        String contentEncoding = this.getHttpFields().get(HttpHeader.CONTENT_ENCODING);
        if (contentEncoding == null) {
            return true;
        }
        return HttpHeaderValue.IDENTITY.is(contentEncoding);
    }

    private void extractContentParameters() {
        String contentType = this.getContentType();
        if (contentType == null || contentType.isEmpty()) {
            this._contentParameters = NO_PARAMS;
        } else {
            this._contentParameters = new MultiMap();
            int contentLength = this.getContentLength();
            if (contentLength != 0 && this._inputState == 0) {
                String baseType = HttpFields.valueParameters(contentType, null);
                if (MimeTypes.Type.FORM_ENCODED.is(baseType) && this._channel.getHttpConfiguration().isFormEncodedMethod(this.getMethod())) {
                    if (this._metaData != null && !this.isContentEncodingSupported()) {
                        throw new BadMessageException(415, "Unsupported Content-Encoding");
                    }
                    this.extractFormParameters(this._contentParameters);
                } else if (MimeTypes.Type.MULTIPART_FORM_DATA.is(baseType) && this.getAttribute(MULTIPART_CONFIG_ELEMENT) != null && this._multiParts == null) {
                    try {
                        if (this._metaData != null && !this.isContentEncodingSupported()) {
                            throw new BadMessageException(415, "Unsupported Content-Encoding");
                        }
                        this.getParts(this._contentParameters);
                    }
                    catch (IOException e) {
                        LOG.debug(e);
                        throw new RuntimeIOException(e);
                    }
                }
            }
        }
    }

    public void extractFormParameters(MultiMap<String> params) {
        try {
            int maxFormContentSize = 200000;
            int maxFormKeys = 1000;
            if (this._context != null) {
                ContextHandler contextHandler = this._context.getContextHandler();
                maxFormContentSize = contextHandler.getMaxFormContentSize();
                maxFormKeys = contextHandler.getMaxFormKeys();
            } else {
                maxFormContentSize = this.lookupServerAttribute("org.eclipse.jetty.server.Request.maxFormContentSize", maxFormContentSize);
                maxFormKeys = this.lookupServerAttribute("org.eclipse.jetty.server.Request.maxFormKeys", maxFormKeys);
            }
            int contentLength = this.getContentLength();
            if (maxFormContentSize >= 0 && contentLength > maxFormContentSize) {
                throw new IllegalStateException("Form is larger than max length " + maxFormContentSize);
            }
            ServletInputStream in = this.getInputStream();
            if (this._input.isAsync()) {
                throw new IllegalStateException("Cannot extract parameters with async IO");
            }
            UrlEncoded.decodeTo((InputStream)in, params, this.getCharacterEncoding(), maxFormContentSize, maxFormKeys);
        }
        catch (IOException e) {
            LOG.debug(e);
            throw new RuntimeIOException(e);
        }
    }

    private int lookupServerAttribute(String key, int dftValue) {
        Object attribute = this._channel.getServer().getAttribute(key);
        if (attribute instanceof Number) {
            return ((Number)attribute).intValue();
        }
        if (attribute instanceof String) {
            return Integer.parseInt((String)attribute);
        }
        return dftValue;
    }

    public AsyncContext getAsyncContext() {
        HttpChannelState state = this.getHttpChannelState();
        if (this._async == null || !state.isAsyncStarted()) {
            throw new IllegalStateException(state.getStatusString());
        }
        return this._async;
    }

    public HttpChannelState getHttpChannelState() {
        return this._channel.getState();
    }

    public Object getAttribute(String name) {
        if (name.startsWith("org.eclipse.jetty")) {
            if (Server.class.getName().equals(name)) {
                return this._channel.getServer();
            }
            if (HttpChannel.class.getName().equals(name)) {
                return this._channel;
            }
            if (HttpConnection.class.getName().equals(name) && this._channel.getHttpTransport() instanceof HttpConnection) {
                return this._channel.getHttpTransport();
            }
        }
        return this._attributes == null ? null : this._attributes.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        if (this._attributes == null) {
            return Collections.enumeration(Collections.emptyList());
        }
        return AttributesMap.getAttributeNamesCopy(this._attributes);
    }

    public Attributes getAttributes() {
        if (this._attributes == null) {
            this._attributes = new ServletAttributes();
        }
        return this._attributes;
    }

    public Authentication getAuthentication() {
        return this._authentication;
    }

    public String getAuthType() {
        if (this._authentication instanceof Authentication.Deferred) {
            this.setAuthentication(((Authentication.Deferred)this._authentication).authenticate((ServletRequest)this));
        }
        if (this._authentication instanceof Authentication.User) {
            return ((Authentication.User)this._authentication).getAuthMethod();
        }
        return null;
    }

    public String getCharacterEncoding() {
        String contentType;
        if (this._characterEncoding == null && (contentType = this.getContentType()) != null) {
            String charset;
            MimeTypes.Type mime = MimeTypes.CACHE.get(contentType);
            String string = charset = mime == null || mime.getCharset() == null ? MimeTypes.getCharsetFromContentType(contentType) : mime.getCharset().toString();
            if (charset != null) {
                this._characterEncoding = charset;
            }
        }
        return this._characterEncoding;
    }

    public HttpChannel getHttpChannel() {
        return this._channel;
    }

    public int getContentLength() {
        MetaData.Request metadata = this._metaData;
        if (metadata == null) {
            return -1;
        }
        long contentLength = metadata.getContentLength();
        if (contentLength != Long.MIN_VALUE) {
            if (contentLength > Integer.MAX_VALUE) {
                return -1;
            }
            return (int)contentLength;
        }
        return (int)metadata.getFields().getLongField(HttpHeader.CONTENT_LENGTH.asString());
    }

    public long getContentLengthLong() {
        MetaData.Request metadata = this._metaData;
        if (metadata == null) {
            return -1L;
        }
        if (metadata.getContentLength() != Long.MIN_VALUE) {
            return metadata.getContentLength();
        }
        return metadata.getFields().getLongField(HttpHeader.CONTENT_LENGTH.asString());
    }

    public long getContentRead() {
        return this._input.getContentConsumed();
    }

    public String getContentType() {
        if (this._contentType == null) {
            MetaData.Request metadata = this._metaData;
            this._contentType = metadata == null ? null : metadata.getFields().get(HttpHeader.CONTENT_TYPE);
        }
        return this._contentType;
    }

    public ContextHandler.Context getContext() {
        return this._context;
    }

    public ContextHandler.Context getErrorContext() {
        ContextHandler handler;
        if (this.isAsyncStarted() && (handler = this._channel.getState().getContextHandler()) != null) {
            return handler.getServletContext();
        }
        return this._errorContext;
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public Cookie[] getCookies() {
        MetaData.Request metadata = this._metaData;
        if (metadata == null || this._cookiesExtracted) {
            if (this._cookies == null || this._cookies.getCookies().length == 0) {
                return null;
            }
            return this._cookies.getCookies();
        }
        this._cookiesExtracted = true;
        for (HttpField field : metadata.getFields()) {
            if (field.getHeader() != HttpHeader.COOKIE) continue;
            if (this._cookies == null) {
                this._cookies = new CookieCutter(this.getHttpChannel().getHttpConfiguration().getRequestCookieCompliance());
            }
            this._cookies.addCookieField(field.getValue());
        }
        if (this._cookies == null || this._cookies.getCookies().length == 0) {
            return null;
        }
        return this._cookies.getCookies();
    }

    public long getDateHeader(String name) {
        MetaData.Request metadata = this._metaData;
        return metadata == null ? -1L : metadata.getFields().getDateField(name);
    }

    public DispatcherType getDispatcherType() {
        return this._dispatcherType;
    }

    public String getHeader(String name) {
        MetaData.Request metadata = this._metaData;
        return metadata == null ? null : metadata.getFields().get(name);
    }

    public Enumeration<String> getHeaderNames() {
        MetaData.Request metadata = this._metaData;
        return metadata == null ? Collections.emptyEnumeration() : metadata.getFields().getFieldNames();
    }

    public Enumeration<String> getHeaders(String name) {
        MetaData.Request metadata = this._metaData;
        if (metadata == null) {
            return Collections.emptyEnumeration();
        }
        Enumeration<String> e = metadata.getFields().getValues(name);
        if (e == null) {
            return Collections.enumeration(Collections.emptyList());
        }
        return e;
    }

    public int getInputState() {
        return this._inputState;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this._inputState != 0 && this._inputState != 1) {
            throw new IllegalStateException("READER");
        }
        this._inputState = 1;
        if (this._channel.isExpecting100Continue()) {
            this._channel.continue100(this._input.available());
        }
        return this._input;
    }

    public int getIntHeader(String name) {
        MetaData.Request metadata = this._metaData;
        return metadata == null ? -1 : (int)metadata.getFields().getLongField(name);
    }

    public Locale getLocale() {
        MetaData.Request metadata = this._metaData;
        if (metadata == null) {
            return Locale.getDefault();
        }
        List<String> acceptable = metadata.getFields().getQualityCSV(HttpHeader.ACCEPT_LANGUAGE);
        if (acceptable.isEmpty()) {
            return Locale.getDefault();
        }
        String language = acceptable.get(0);
        language = HttpFields.stripParameters(language);
        String country = "";
        int dash = language.indexOf(45);
        if (dash > -1) {
            country = language.substring(dash + 1).trim();
            language = language.substring(0, dash).trim();
        }
        return new Locale(language, country);
    }

    public Enumeration<Locale> getLocales() {
        MetaData.Request metadata = this._metaData;
        if (metadata == null) {
            return Collections.enumeration(__defaultLocale);
        }
        List<String> acceptable = metadata.getFields().getQualityCSV(HttpHeader.ACCEPT_LANGUAGE);
        if (acceptable.isEmpty()) {
            return Collections.enumeration(__defaultLocale);
        }
        List locales = acceptable.stream().map(language -> {
            language = HttpFields.stripParameters(language);
            String country = "";
            int dash = language.indexOf(45);
            if (dash > -1) {
                country = language.substring(dash + 1).trim();
                language = language.substring(0, dash).trim();
            }
            return new Locale((String)language, country);
        }).collect(Collectors.toList());
        return Collections.enumeration(locales);
    }

    public String getLocalAddr() {
        if (this._channel != null) {
            InetSocketAddress local = this._channel.getLocalAddress();
            if (local == null) {
                return "";
            }
            InetAddress address = local.getAddress();
            String result = address == null ? local.getHostString() : address.getHostAddress();
            return this.formatAddrOrHost(result);
        }
        return "";
    }

    public String getLocalName() {
        if (this._channel != null) {
            String localName = this._channel.getLocalName();
            return this.formatAddrOrHost(localName);
        }
        return "";
    }

    public int getLocalPort() {
        int localPort;
        if (this._channel != null && (localPort = this._channel.getLocalPort()) > 0) {
            return localPort;
        }
        return 0;
    }

    public String getMethod() {
        MetaData.Request metadata = this._metaData;
        return metadata == null ? null : metadata.getMethod();
    }

    public String getParameter(String name) {
        return this.getParameters().getValue(name, 0);
    }

    public Map<String, String[]> getParameterMap() {
        return Collections.unmodifiableMap(this.getParameters().toStringArrayMap());
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.getParameters().keySet());
    }

    public String[] getParameterValues(String name) {
        List<String> vals = this.getParameters().getValues(name);
        if (vals == null) {
            return null;
        }
        return vals.toArray(new String[vals.size()]);
    }

    public MultiMap<String> getQueryParameters() {
        return this._queryParameters;
    }

    public void setQueryParameters(MultiMap<String> queryParameters) {
        this._queryParameters = queryParameters;
    }

    public void setContentParameters(MultiMap<String> contentParameters) {
        this._contentParameters = contentParameters;
    }

    public void resetParameters() {
        this._parameters = null;
    }

    public String getPathInfo() {
        return this._pathInfo;
    }

    public String getPathTranslated() {
        if (this._pathInfo == null || this._context == null) {
            return null;
        }
        return this._context.getRealPath(this._pathInfo);
    }

    public String getProtocol() {
        MetaData.Request metadata = this._metaData;
        if (metadata == null) {
            return null;
        }
        HttpVersion version = metadata.getHttpVersion();
        if (version == null) {
            return null;
        }
        return version.toString();
    }

    public HttpVersion getHttpVersion() {
        MetaData.Request metadata = this._metaData;
        return metadata == null ? null : metadata.getHttpVersion();
    }

    public String getQueryEncoding() {
        return this._queryEncoding;
    }

    public String getQueryString() {
        MetaData.Request metadata = this._metaData;
        return metadata == null ? null : metadata.getURI().getQuery();
    }

    public BufferedReader getReader() throws IOException {
        if (this._inputState != 0 && this._inputState != 2) {
            throw new IllegalStateException("STREAMED");
        }
        if (this._inputState == 2) {
            return this._reader;
        }
        String encoding = this.getCharacterEncoding();
        if (encoding == null) {
            encoding = "iso-8859-1";
        }
        if (this._reader == null || !encoding.equalsIgnoreCase(this._readerEncoding)) {
            final ServletInputStream in = this.getInputStream();
            this._readerEncoding = encoding;
            this._reader = new BufferedReader(new InputStreamReader((InputStream)in, encoding)){

                @Override
                public void close() throws IOException {
                    in.close();
                }
            };
        }
        this._inputState = 2;
        return this._reader;
    }

    public String getRealPath(String path) {
        if (this._context == null) {
            return null;
        }
        return this._context.getRealPath(path);
    }

    public InetSocketAddress getRemoteInetSocketAddress() {
        InetSocketAddress remote = this._remote;
        if (remote == null) {
            remote = this._channel.getRemoteAddress();
        }
        return remote;
    }

    public String getRemoteAddr() {
        InetSocketAddress remote = this._remote;
        if (remote == null) {
            remote = this._channel.getRemoteAddress();
        }
        if (remote == null) {
            return "";
        }
        InetAddress address = remote.getAddress();
        String result = address == null ? remote.getHostString() : address.getHostAddress();
        return this.formatAddrOrHost(result);
    }

    public String getRemoteHost() {
        InetSocketAddress remote = this._remote;
        if (remote == null) {
            remote = this._channel.getRemoteAddress();
        }
        if (remote == null) {
            return "";
        }
        return this.formatAddrOrHost(remote.getHostString());
    }

    public int getRemotePort() {
        InetSocketAddress remote = this._remote;
        if (remote == null) {
            remote = this._channel.getRemoteAddress();
        }
        return remote == null ? 0 : remote.getPort();
    }

    public String getRemoteUser() {
        Principal p = this.getUserPrincipal();
        if (p == null) {
            return null;
        }
        return p.getName();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if ((path = URIUtil.compactPath(path)) == null || this._context == null) {
            return null;
        }
        if (!path.startsWith("/")) {
            String relTo = URIUtil.addPaths(this._servletPath, this._pathInfo);
            int slash = relTo.lastIndexOf("/");
            relTo = slash > 1 ? relTo.substring(0, slash + 1) : "/";
            path = URIUtil.addPaths(relTo, path);
        }
        return this._context.getRequestDispatcher(path);
    }

    public String getRequestedSessionId() {
        return this._requestedSessionId;
    }

    public String getRequestURI() {
        MetaData.Request metadata = this._metaData;
        return metadata == null ? null : metadata.getURI().getPath();
    }

    public StringBuffer getRequestURL() {
        StringBuffer url = new StringBuffer(128);
        URIUtil.appendSchemeHostPort(url, this.getScheme(), this.getServerName(), this.getServerPort());
        String path = this.getRequestURI();
        if (path != null) {
            url.append(path);
        }
        return url;
    }

    public Response getResponse() {
        return this._channel.getResponse();
    }

    public StringBuilder getRootURL() {
        StringBuilder url = new StringBuilder(128);
        URIUtil.appendSchemeHostPort(url, this.getScheme(), this.getServerName(), this.getServerPort());
        return url;
    }

    public String getScheme() {
        MetaData.Request metadata = this._metaData;
        String scheme = metadata == null ? null : metadata.getURI().getScheme();
        return scheme == null ? HttpScheme.HTTP.asString() : scheme;
    }

    public String getServerName() {
        String name;
        MetaData.Request metadata = this._metaData;
        String string = name = metadata == null ? null : this.formatAddrOrHost(metadata.getURI().getHost());
        if (name != null) {
            return name;
        }
        return this.findServerName();
    }

    private String findServerName() {
        HostPort serverAuthority;
        HttpField host;
        MetaData.Request metadata = this._metaData;
        HttpField httpField = host = metadata == null ? null : metadata.getFields().getField(HttpHeader.HOST);
        if (host != null) {
            if (!(host instanceof HostPortHttpField) && host.getValue() != null && !host.getValue().isEmpty()) {
                host = new HostPortHttpField(host.getValue());
            }
            if (host instanceof HostPortHttpField) {
                HostPortHttpField authority = (HostPortHttpField)host;
                metadata.getURI().setAuthority(authority.getHost(), authority.getPort());
                return this.formatAddrOrHost(authority.getHost());
            }
        }
        if (this._channel != null && (serverAuthority = this._channel.getServerAuthority()) != null) {
            return this.formatAddrOrHost(serverAuthority.getHost());
        }
        String name = this.getLocalName();
        if (name != null) {
            return this.formatAddrOrHost(name);
        }
        return "";
    }

    public int getServerPort() {
        int port;
        MetaData.Request metadata = this._metaData;
        HttpURI uri = metadata == null ? null : metadata.getURI();
        int n = port = uri == null || uri.getHost() == null ? this.findServerPort() : uri.getPort();
        if (port <= 0) {
            if (HttpScheme.HTTPS.is(this.getScheme())) {
                return 443;
            }
            return 80;
        }
        return port;
    }

    private int findServerPort() {
        HostPort serverAuthority;
        HttpField host;
        MetaData.Request metadata = this._metaData;
        HttpField httpField = host = metadata == null ? null : metadata.getFields().getField(HttpHeader.HOST);
        if (host != null) {
            HostPortHttpField authority;
            HostPortHttpField hostPortHttpField = authority = host instanceof HostPortHttpField ? (HostPortHttpField)host : new HostPortHttpField(host.getValue());
            if (authority.getHostPort().hasHost() && authority.getHostPort().hasPort()) {
                metadata.getURI().setAuthority(authority.getHost(), authority.getPort());
                return authority.getPort();
            }
        }
        if (this._channel != null && (serverAuthority = this._channel.getServerAuthority()) != null) {
            return serverAuthority.getPort();
        }
        return this.getLocalPort();
    }

    public ServletContext getServletContext() {
        return this._context;
    }

    public String getServletName() {
        if (this._scope != null) {
            return this._scope.getName();
        }
        return null;
    }

    public String getServletPath() {
        if (this._servletPath == null) {
            this._servletPath = "";
        }
        return this._servletPath;
    }

    public ServletResponse getServletResponse() {
        return this._channel.getResponse();
    }

    public String changeSessionId() {
        HttpSession session = this.getSession(false);
        if (session == null) {
            throw new IllegalStateException("No session");
        }
        if (session instanceof Session) {
            Session s = (Session)session;
            s.renewId(this);
            if (this.getRemoteUser() != null) {
                s.setAttribute("org.eclipse.jetty.security.sessionCreatedSecure", Boolean.TRUE);
            }
            if (s.isIdChanged() && this._sessionHandler.isUsingCookies()) {
                this._channel.getResponse().replaceCookie(this._sessionHandler.getSessionCookie(s, this.getContextPath(), this.isSecure()));
            }
        }
        return session.getId();
    }

    public void onCompleted() {
        if (this._sessions != null) {
            for (Session s : this._sessions) {
                this.leaveSession(s);
            }
        }
    }

    public void onResponseCommit() {
        if (this._sessions != null) {
            for (Session s : this._sessions) {
                this.commitSession(s);
            }
        }
    }

    public HttpSession getSession(SessionHandler sessionHandler) {
        if (this._sessions == null || this._sessions.size() == 0 || sessionHandler == null) {
            return null;
        }
        HttpSession session = null;
        for (HttpSession httpSession : this._sessions) {
            Session ss = (Session)Session.class.cast(httpSession);
            if (sessionHandler != ss.getSessionHandler()) continue;
            session = httpSession;
            if (!ss.isValid()) continue;
            return session;
        }
        return session;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        if (this._session != null) {
            if (this._sessionHandler != null && !this._sessionHandler.isValid(this._session)) {
                this._session = null;
            } else {
                return this._session;
            }
        }
        if (!create) {
            return null;
        }
        if (this.getResponse().isCommitted()) {
            throw new IllegalStateException("Response is committed");
        }
        if (this._sessionHandler == null) {
            throw new IllegalStateException("No SessionManager");
        }
        this._session = this._sessionHandler.newHttpSession(this);
        if (this._session == null) {
            throw new IllegalStateException("Create session failed");
        }
        HttpCookie cookie = this._sessionHandler.getSessionCookie(this._session, this.getContextPath(), this.isSecure());
        if (cookie != null) {
            this._channel.getResponse().replaceCookie(cookie);
        }
        return this._session;
    }

    public SessionHandler getSessionHandler() {
        return this._sessionHandler;
    }

    public long getTimeStamp() {
        return this._timeStamp;
    }

    public HttpURI getHttpURI() {
        MetaData.Request metadata = this._metaData;
        return metadata == null ? null : metadata.getURI();
    }

    public String getOriginalURI() {
        return this._originalURI;
    }

    public void setHttpURI(HttpURI uri) {
        MetaData.Request metadata = this._metaData;
        metadata.setURI(uri);
    }

    public UserIdentity getUserIdentity() {
        if (this._authentication instanceof Authentication.Deferred) {
            this.setAuthentication(((Authentication.Deferred)this._authentication).authenticate((ServletRequest)this));
        }
        if (this._authentication instanceof Authentication.User) {
            return ((Authentication.User)this._authentication).getUserIdentity();
        }
        return null;
    }

    public UserIdentity getResolvedUserIdentity() {
        if (this._authentication instanceof Authentication.User) {
            return ((Authentication.User)this._authentication).getUserIdentity();
        }
        return null;
    }

    public UserIdentity.Scope getUserIdentityScope() {
        return this._scope;
    }

    public Principal getUserPrincipal() {
        if (this._authentication instanceof Authentication.Deferred) {
            this.setAuthentication(((Authentication.Deferred)this._authentication).authenticate((ServletRequest)this));
        }
        if (this._authentication instanceof Authentication.User) {
            UserIdentity user = ((Authentication.User)this._authentication).getUserIdentity();
            return user.getUserPrincipal();
        }
        return null;
    }

    public boolean isHandled() {
        return this._handled;
    }

    public boolean isAsyncStarted() {
        return this.getHttpChannelState().isAsyncStarted();
    }

    public boolean isAsyncSupported() {
        return this._asyncNotSupportedSource == null;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this._requestedSessionId != null && this._requestedSessionIdFromCookie;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this._requestedSessionId != null && !this._requestedSessionIdFromCookie;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this._requestedSessionId != null && !this._requestedSessionIdFromCookie;
    }

    public boolean isRequestedSessionIdValid() {
        if (this._requestedSessionId == null) {
            return false;
        }
        HttpSession session = this.getSession(false);
        return session != null && this._sessionHandler.getSessionIdManager().getId(this._requestedSessionId).equals(this._sessionHandler.getId(session));
    }

    public boolean isSecure() {
        return this._secure;
    }

    public void setSecure(boolean secure) {
        this._secure = secure;
    }

    public boolean isUserInRole(String role) {
        if (this._authentication instanceof Authentication.Deferred) {
            this.setAuthentication(((Authentication.Deferred)this._authentication).authenticate((ServletRequest)this));
        }
        if (this._authentication instanceof Authentication.User) {
            return ((Authentication.User)this._authentication).isUserInRole(this._scope, role);
        }
        return false;
    }

    public void setMetaData(MetaData.Request request) {
        String path;
        String encoded;
        if (this._metaData == null && this._input != null && this._channel != null) {
            this._input.recycle();
            this._channel.getResponse().getHttpOutput().reopen();
        }
        this._metaData = request;
        this.setMethod(request.getMethod());
        HttpURI uri = request.getURI();
        if (uri.hasViolations()) {
            Connection connection;
            Connection connection2 = connection = this._channel == null ? null : this._channel.getConnection();
            HttpCompliance compliance = connection instanceof HttpConnection ? ((HttpConnection)connection).getHttpCompliance() : (this._channel != null ? this._channel.getConnector().getBean(HttpCompliance.class) : null);
            String badMessage = HttpCompliance.checkUriCompliance(compliance, uri);
            if (badMessage != null) {
                throw new BadMessageException(badMessage);
            }
        }
        if (HttpMethod.CONNECT.is(request.getMethod())) {
            this._originalURI = uri.getAuthority();
            encoded = "/";
        } else {
            this._originalURI = uri.isAbsolute() && request.getHttpVersion() != HttpVersion.HTTP_2 ? uri.toString() : uri.getPathQuery();
            encoded = uri.getPath();
        }
        if (encoded == null) {
            path = uri.isAbsolute() ? "/" : null;
            uri.setPath(path);
        } else {
            path = encoded.startsWith("/") ? (encoded.length() == 1 ? "/" : uri.getDecodedPath()) : ("*".equals(encoded) || HttpMethod.CONNECT.is(this.getMethod()) ? encoded : null);
        }
        if (path == null || path.isEmpty()) {
            this.setPathInfo(encoded == null ? "" : encoded);
            throw new BadMessageException(400, "Bad URI");
        }
        this.setPathInfo(path);
    }

    public MetaData.Request getMetaData() {
        return this._metaData;
    }

    public boolean hasMetaData() {
        return this._metaData != null;
    }

    protected void recycle() {
        if (this._context != null) {
            throw new IllegalStateException("Request in context!");
        }
        if (this._reader != null && this._inputState == 2) {
            try {
                int r = this._reader.read();
                while (r != -1) {
                    r = this._reader.read();
                }
            }
            catch (Exception e) {
                LOG.ignore(e);
                this._reader = null;
                this._readerEncoding = null;
            }
        }
        this.getHttpChannelState().recycle();
        this._requestAttributeListeners.clear();
        this._metaData = null;
        this._originalURI = null;
        this._contextPath = null;
        this._servletPath = null;
        this._pathInfo = null;
        this._asyncNotSupportedSource = null;
        this._secure = false;
        this._newContext = false;
        this._cookiesExtracted = false;
        this._handled = false;
        this._contentParamsExtracted = false;
        this._requestedSessionIdFromCookie = false;
        this._attributes = Attributes.unwrap(this._attributes);
        if (this._attributes != null) {
            if (ServletAttributes.class.equals(this._attributes.getClass())) {
                this._attributes.clearAttributes();
            } else {
                this._attributes = null;
            }
        }
        this.setAuthentication(Authentication.NOT_CHECKED);
        this._contentType = null;
        this._characterEncoding = null;
        this._context = null;
        this._errorContext = null;
        if (this._cookies != null) {
            this._cookies.reset();
        }
        this._dispatcherType = null;
        this._inputState = 0;
        this._queryParameters = null;
        this._contentParameters = null;
        this._parameters = null;
        this._queryEncoding = null;
        this._remote = null;
        this._requestedSessionId = null;
        this._scope = null;
        this._session = null;
        this._sessionHandler = null;
        this._timeStamp = 0L;
        this._multiParts = null;
        if (this._async != null) {
            this._async.reset();
        }
        this._async = null;
        this._sessions = null;
    }

    public void removeAttribute(String name) {
        Object oldValue;
        Object object = oldValue = this._attributes == null ? null : this._attributes.getAttribute(name);
        if (this._attributes != null) {
            this._attributes.removeAttribute(name);
        }
        if (oldValue != null && !this._requestAttributeListeners.isEmpty()) {
            ServletRequestAttributeEvent event = new ServletRequestAttributeEvent((ServletContext)this._context, (ServletRequest)this, name, oldValue);
            for (ServletRequestAttributeListener listener : this._requestAttributeListeners) {
                listener.attributeRemoved(event);
            }
        }
    }

    public void removeEventListener(EventListener listener) {
        this._requestAttributeListeners.remove(listener);
    }

    public void setAsyncSupported(boolean supported, Object source) {
        this._asyncNotSupportedSource = supported ? null : (source == null ? "unknown" : source);
    }

    public void setAttribute(String name, Object value) {
        Object oldValue;
        Object object = oldValue = this._attributes == null ? null : this._attributes.getAttribute(name);
        if ("org.eclipse.jetty.server.Request.queryEncoding".equals(name)) {
            this.setQueryEncoding(value == null ? null : value.toString());
        } else if ("org.eclipse.jetty.server.sendContent".equals(name)) {
            LOG.warn("Deprecated: org.eclipse.jetty.server.sendContent", new Object[0]);
        }
        if (this._attributes == null) {
            this._attributes = new ServletAttributes();
        }
        this._attributes.setAttribute(name, value);
        if (!this._requestAttributeListeners.isEmpty()) {
            ServletRequestAttributeEvent event = new ServletRequestAttributeEvent((ServletContext)this._context, (ServletRequest)this, name, oldValue == null ? value : oldValue);
            for (ServletRequestAttributeListener l : this._requestAttributeListeners) {
                if (oldValue == null) {
                    l.attributeAdded(event);
                    continue;
                }
                if (value == null) {
                    l.attributeRemoved(event);
                    continue;
                }
                l.attributeReplaced(event);
            }
        }
    }

    public void setAttributes(Attributes attributes) {
        this._attributes = attributes;
    }

    public void setAsyncAttributes() {
        Attributes baseAttributes;
        String queryString;
        String pathInfo;
        String servletPath;
        String contextPath;
        if (this.getAttribute("javax.servlet.async.request_uri") != null) {
            return;
        }
        String requestURI = (String)this.getAttribute("javax.servlet.forward.request_uri");
        if (requestURI != null) {
            contextPath = (String)this.getAttribute("javax.servlet.forward.context_path");
            servletPath = (String)this.getAttribute("javax.servlet.forward.servlet_path");
            pathInfo = (String)this.getAttribute("javax.servlet.forward.path_info");
            queryString = (String)this.getAttribute("javax.servlet.forward.query_string");
        } else {
            requestURI = this.getRequestURI();
            contextPath = this.getContextPath();
            servletPath = this.getServletPath();
            pathInfo = this.getPathInfo();
            queryString = this.getQueryString();
        }
        if (this._attributes == null) {
            this._attributes = baseAttributes = new ServletAttributes();
        } else {
            baseAttributes = Attributes.unwrap(this._attributes);
        }
        if (baseAttributes instanceof ServletAttributes) {
            ServletAttributes servletAttributes = (ServletAttributes)baseAttributes;
            servletAttributes.setAsyncAttributes(requestURI, contextPath, servletPath, pathInfo, queryString);
        } else {
            AsyncAttributes.applyAsyncAttributes(this._attributes, requestURI, contextPath, servletPath, pathInfo, queryString);
        }
    }

    public void setAuthentication(Authentication authentication) {
        this._authentication = authentication;
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        if (this._inputState != 0) {
            return;
        }
        this._characterEncoding = encoding;
        if (!StringUtil.isUTF8(encoding)) {
            try {
                Charset.forName(encoding);
            }
            catch (UnsupportedCharsetException e) {
                throw new UnsupportedEncodingException(e.getMessage());
            }
        }
    }

    public void setCharacterEncodingUnchecked(String encoding) {
        this._characterEncoding = encoding;
    }

    public void setContentType(String contentType) {
        this._contentType = contentType;
    }

    public void setContext(ContextHandler.Context context) {
        boolean bl = this._newContext = this._context != context;
        if (context == null) {
            this._context = null;
        } else {
            this._context = context;
            this._errorContext = context;
        }
    }

    public boolean takeNewContext() {
        boolean nc = this._newContext;
        this._newContext = false;
        return nc;
    }

    public void setContextPath(String contextPath) {
        this._contextPath = contextPath;
    }

    public void setCookies(Cookie[] cookies) {
        if (this._cookies == null) {
            this._cookies = new CookieCutter(this.getHttpChannel().getHttpConfiguration().getRequestCookieCompliance());
        }
        this._cookies.setCookies(cookies);
    }

    public void setDispatcherType(DispatcherType type) {
        this._dispatcherType = type;
    }

    public void setHandled(boolean h) {
        this._handled = h;
    }

    public void setMethod(String method) {
        MetaData.Request metadata = this._metaData;
        if (metadata != null) {
            metadata.setMethod(method);
        }
    }

    public void setHttpVersion(HttpVersion version) {
        MetaData.Request metadata = this._metaData;
        if (metadata != null) {
            metadata.setHttpVersion(version);
        }
    }

    public boolean isHead() {
        MetaData.Request metadata = this._metaData;
        return metadata != null && HttpMethod.HEAD.is(metadata.getMethod());
    }

    public void setPathInfo(String pathInfo) {
        this._pathInfo = pathInfo;
    }

    public void setQueryEncoding(String queryEncoding) {
        this._queryEncoding = queryEncoding;
    }

    public void setQueryString(String queryString) {
        MetaData.Request metadata = this._metaData;
        if (metadata != null) {
            metadata.getURI().setQuery(queryString);
        }
        this._queryEncoding = null;
    }

    public void setRemoteAddr(InetSocketAddress addr) {
        this._remote = addr;
    }

    public void setRequestedSessionId(String requestedSessionId) {
        this._requestedSessionId = requestedSessionId;
    }

    public void setRequestedSessionIdFromCookie(boolean requestedSessionIdCookie) {
        this._requestedSessionIdFromCookie = requestedSessionIdCookie;
    }

    public void setURIPathQuery(String requestURI) {
        MetaData.Request metadata = this._metaData;
        if (metadata != null) {
            metadata.getURI().setPathQuery(requestURI);
        }
    }

    public void setScheme(String scheme) {
        MetaData.Request metadata = this._metaData;
        if (metadata != null) {
            metadata.getURI().setScheme(scheme);
        }
    }

    public void setAuthority(String host, int port) {
        MetaData.Request metadata = this._metaData;
        if (metadata != null) {
            metadata.getURI().setAuthority(host, port);
        }
    }

    public void setServletPath(String servletPath) {
        this._servletPath = servletPath;
    }

    public void setSession(HttpSession session) {
        this._session = session;
    }

    public void setSessionHandler(SessionHandler sessionHandler) {
        this._sessionHandler = sessionHandler;
    }

    public void setTimeStamp(long ts) {
        this._timeStamp = ts;
    }

    public void setUserIdentityScope(UserIdentity.Scope scope) {
        this._scope = scope;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        if (this._asyncNotSupportedSource != null) {
            throw new IllegalStateException("!asyncSupported: " + this._asyncNotSupportedSource);
        }
        HttpChannelState state = this.getHttpChannelState();
        if (this._async == null) {
            this._async = new AsyncContextState(state);
        }
        AsyncContextEvent event = new AsyncContextEvent(this._context, this._async, state, this, (ServletRequest)this, (ServletResponse)this.getResponse());
        state.startAsync(event);
        return this._async;
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        if (this._asyncNotSupportedSource != null) {
            throw new IllegalStateException("!asyncSupported: " + this._asyncNotSupportedSource);
        }
        HttpChannelState state = this.getHttpChannelState();
        if (this._async == null) {
            this._async = new AsyncContextState(state);
        }
        AsyncContextEvent event = new AsyncContextEvent(this._context, this._async, state, this, servletRequest, servletResponse);
        event.setDispatchContext(this.getServletContext());
        String uri = Request.unwrap(servletRequest).getRequestURI();
        uri = this._contextPath != null && uri.startsWith(this._contextPath) ? uri.substring(this._contextPath.length()) : URIUtil.encodePath(URIUtil.addPaths(this.getServletPath(), this.getPathInfo()));
        event.setDispatchPath(uri);
        state.startAsync(event);
        return this._async;
    }

    public static HttpServletRequest unwrap(ServletRequest servletRequest) {
        if (servletRequest instanceof HttpServletRequestWrapper) {
            return (HttpServletRequestWrapper)servletRequest;
        }
        if (servletRequest instanceof ServletRequestWrapper) {
            return Request.unwrap(((ServletRequestWrapper)servletRequest).getRequest());
        }
        return (HttpServletRequest)servletRequest;
    }

    public String toString() {
        return String.format("%s%s%s %s%s@%x", this.getClass().getSimpleName(), this._handled ? "[" : "(", this.getMethod(), this.getHttpURI(), this._handled ? "]" : ")", this.hashCode());
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        if (this._authentication instanceof Authentication.Deferred) {
            this.setAuthentication(((Authentication.Deferred)this._authentication).authenticate((ServletRequest)this, (ServletResponse)response));
            return !(this._authentication instanceof Authentication.ResponseSent);
        }
        response.sendError(401);
        return false;
    }

    public Part getPart(String name) throws IOException, ServletException {
        this.getParts();
        return this._multiParts.getPart(name);
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        String contentType = this.getContentType();
        if (contentType == null || !MimeTypes.Type.MULTIPART_FORM_DATA.is(HttpFields.valueParameters(contentType, null))) {
            throw new ServletException("Unsupported Content-Type [" + contentType + "], expected [multipart/form-data]");
        }
        return this.getParts(null);
    }

    private Collection<Part> getParts(MultiMap<String> params) throws IOException {
        if (this._multiParts == null) {
            this._multiParts = (MultiParts)this.getAttribute(MULTIPARTS);
        }
        if (this._multiParts == null) {
            ByteArrayOutputStream os;
            MultipartConfigElement config = (MultipartConfigElement)this.getAttribute(MULTIPART_CONFIG_ELEMENT);
            if (config == null) {
                throw new IllegalStateException("No multipart config for servlet");
            }
            this._multiParts = this.newMultiParts(config);
            this.setAttribute(MULTIPARTS, this._multiParts);
            Collection<Part> parts = this._multiParts.getParts();
            String formCharset = null;
            Part charsetPart = this._multiParts.getPart("_charset_");
            if (charsetPart != null) {
                try (InputStream is = charsetPart.getInputStream();){
                    os = new ByteArrayOutputStream();
                    IO.copy(is, os);
                    formCharset = new String(os.toByteArray(), StandardCharsets.UTF_8);
                }
            }
            Charset defaultCharset = formCharset != null ? Charset.forName(formCharset) : (this.getCharacterEncoding() != null ? Charset.forName(this.getCharacterEncoding()) : StandardCharsets.UTF_8);
            os = null;
            for (Part p : parts) {
                if (p.getSubmittedFileName() != null) continue;
                String charset = null;
                if (p.getContentType() != null) {
                    charset = MimeTypes.getCharsetFromContentType(p.getContentType());
                }
                try (InputStream is = p.getInputStream();){
                    if (os == null) {
                        os = new ByteArrayOutputStream();
                    }
                    IO.copy(is, os);
                    String content = new String(os.toByteArray(), charset == null ? defaultCharset : Charset.forName(charset));
                    if (this._contentParameters == null) {
                        this._contentParameters = params == null ? new MultiMap() : params;
                    }
                    this._contentParameters.add(p.getName(), content);
                }
                os.reset();
            }
        }
        return this._multiParts.getParts();
    }

    private MultiParts newMultiParts(MultipartConfigElement config) throws IOException {
        MultiPartFormDataCompliance compliance = this.getHttpChannel().getHttpConfiguration().getMultipartFormDataCompliance();
        if (LOG.isDebugEnabled()) {
            LOG.debug("newMultiParts {} {}", new Object[]{compliance, this});
        }
        switch (compliance) {
            case RFC7578: {
                return new MultiParts.MultiPartsHttpParser((InputStream)this.getInputStream(), this.getContentType(), config, this._context != null ? (File)this._context.getAttribute("javax.servlet.context.tempdir") : null, this);
            }
        }
        return new MultiParts.MultiPartsUtilParser((InputStream)this.getInputStream(), this.getContentType(), config, this._context != null ? (File)this._context.getAttribute("javax.servlet.context.tempdir") : null, this);
    }

    public void login(String username, String password) throws ServletException {
        Authentication auth;
        if (this._authentication instanceof Authentication.LoginAuthentication) {
            auth = ((Authentication.LoginAuthentication)this._authentication).login(username, password, (ServletRequest)this);
            if (auth == null) {
                throw new Authentication.Failed("Authentication failed for username '" + username + "'");
            }
        } else {
            throw new Authentication.Failed("Authenticated failed for username '" + username + "'. Already authenticated as " + this._authentication);
        }
        this._authentication = auth;
    }

    public void logout() throws ServletException {
        if (this._authentication instanceof Authentication.LogoutAuthentication) {
            this._authentication = ((Authentication.LogoutAuthentication)this._authentication).logout((ServletRequest)this);
        }
    }

    public void mergeQueryParameters(String oldQuery, String newQuery, boolean updateQueryString) {
        MultiMap<String> mergedQueryParams;
        MultiMap<String> oldQueryParams;
        MultiMap<String> newQueryParams = null;
        if (newQuery != null) {
            newQueryParams = new MultiMap<String>();
            try {
                UrlEncoded.decodeTo(newQuery, newQueryParams, UrlEncoded.ENCODING);
            }
            catch (Exception e) {
                throw new BadMessageException(500, "Bad query encoding", e);
            }
        }
        if ((oldQueryParams = this._queryParameters) == null && oldQuery != null) {
            oldQueryParams = new MultiMap();
            try {
                UrlEncoded.decodeTo(oldQuery, oldQueryParams, this.getQueryEncoding());
            }
            catch (Throwable ex) {
                throw new BadMessageException(400, "Bad query encoding", ex);
            }
        }
        if (newQueryParams == null || newQueryParams.size() == 0) {
            mergedQueryParams = oldQueryParams == null ? NO_PARAMS : oldQueryParams;
        } else if (oldQueryParams == null || oldQueryParams.size() == 0) {
            mergedQueryParams = newQueryParams == null ? NO_PARAMS : newQueryParams;
        } else {
            mergedQueryParams = new MultiMap<String>(newQueryParams);
            mergedQueryParams.addAllValues(oldQueryParams);
        }
        this.setQueryParameters(mergedQueryParams);
        this.resetParameters();
        if (updateQueryString) {
            if (newQuery == null) {
                this.setQueryString(oldQuery);
            } else if (oldQuery == null) {
                this.setQueryString(newQuery);
            } else {
                StringBuilder mergedQuery = new StringBuilder();
                if (newQuery != null) {
                    mergedQuery.append(newQuery);
                }
                for (Map.Entry entry : mergedQueryParams.entrySet()) {
                    if (newQueryParams != null && newQueryParams.containsKey(entry.getKey())) continue;
                    for (String value : (List)entry.getValue()) {
                        if (mergedQuery.length() > 0) {
                            mergedQuery.append("&");
                        }
                        URIUtil.encodePath(mergedQuery, (String)entry.getKey());
                        mergedQuery.append('=');
                        URIUtil.encodePath(mergedQuery, value);
                    }
                }
                this.setQueryString(mergedQuery.toString());
            }
        }
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        throw new ServletException("HttpServletRequest.upgrade() not supported in Jetty");
    }

    private String formatAddrOrHost(String name) {
        return this._channel == null ? HostPort.normalizeHost(name) : this._channel.formatAddrOrHost(name);
    }
}

