/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import org.eclipse.jetty.http2.FlowControlStrategy;
import org.eclipse.jetty.http2.HTTP2Session;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.frames.Frame;
import org.eclipse.jetty.http2.frames.WindowUpdateFrame;
import org.eclipse.jetty.http2.hpack.HpackException;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HTTP2Flusher
extends IteratingCallback
implements Dumpable {
    private static final Logger LOG = Log.getLogger(HTTP2Flusher.class);
    private static final ByteBuffer[] EMPTY_BYTE_BUFFERS = new ByteBuffer[0];
    private final Queue<WindowEntry> windows = new ArrayDeque<WindowEntry>();
    private final Deque<Entry> entries = new ArrayDeque<Entry>();
    private final Queue<Entry> pendingEntries = new ArrayDeque<Entry>();
    private final Collection<Entry> processedEntries = new ArrayList<Entry>();
    private final HTTP2Session session;
    private final ByteBufferPool.Lease lease;
    private Throwable terminated;
    private Entry stalledEntry;

    public HTTP2Flusher(HTTP2Session session) {
        this.session = session;
        this.lease = new ByteBufferPool.Lease(session.getGenerator().getByteBufferPool());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void window(IStream stream, WindowUpdateFrame frame) {
        Throwable closed;
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            closed = this.terminated;
            if (closed == null) {
                this.windows.offer(new WindowEntry(stream, frame));
            }
        }
        if (closed == null) {
            this.iterate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prepend(Entry entry) {
        Throwable closed;
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            closed = this.terminated;
            if (closed == null) {
                this.entries.offerFirst(entry);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Prepended {}, entries={}", entry, this.entries.size());
                }
            }
        }
        if (closed == null) {
            return true;
        }
        this.closed(entry, closed);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean append(Entry entry) {
        Throwable closed;
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            closed = this.terminated;
            if (closed == null) {
                this.entries.offer(entry);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Appended {}, entries={}", entry, this.entries.size());
                }
            }
        }
        if (closed == null) {
            return true;
        }
        this.closed(entry, closed);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getWindowQueueSize() {
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            return this.windows.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFrameQueueSize() {
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            return this.entries.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IteratingCallback.Action process() throws Throwable {
        block25: {
            int writeThreshold;
            Entry entry;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Flushing {}", this.session);
            }
            HTTP2Flusher hTTP2Flusher = this;
            synchronized (hTTP2Flusher) {
                WindowEntry windowEntry;
                if (this.terminated != null) {
                    throw this.terminated;
                }
                while ((windowEntry = this.windows.poll()) != null) {
                    windowEntry.perform();
                }
                while ((entry = this.entries.poll()) != null) {
                    this.pendingEntries.offer(entry);
                }
            }
            if (this.pendingEntries.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Flushed {}", this.session);
                }
                return IteratingCallback.Action.IDLE;
            }
            do {
                boolean progress = false;
                if (this.pendingEntries.isEmpty()) break block25;
                Iterator pending = this.pendingEntries.iterator();
                while (pending.hasNext()) {
                    entry = (Entry)pending.next();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Processing {}", entry);
                    }
                    if (entry.isStale()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Stale {}", entry);
                        }
                        entry.failed(new EofException("reset"));
                        pending.remove();
                        continue;
                    }
                    try {
                        if (entry.generate(this.lease)) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Generated {} frame bytes for {}", entry.getFrameBytesGenerated(), entry);
                            }
                            progress = true;
                            if (!this.processedEntries.contains(entry)) {
                                this.processedEntries.add(entry);
                            }
                            if (entry.getDataBytesRemaining() != 0) continue;
                            pending.remove();
                            continue;
                        }
                        if (this.session.getSendWindow() > 0 || this.stalledEntry != null) continue;
                        this.stalledEntry = entry;
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Flow control stalled at {}", entry);
                    }
                    catch (HpackException.StreamException failure) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Failure generating " + entry, failure);
                        }
                        entry.failed(failure);
                        pending.remove();
                    }
                    catch (Throwable failure) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Failure generating " + entry, failure);
                        }
                        this.failed(failure);
                        return IteratingCallback.Action.SUCCEEDED;
                    }
                }
                if (!progress || this.stalledEntry != null) break block25;
                writeThreshold = this.session.getWriteThreshold();
            } while (this.lease.getTotalLength() < (long)writeThreshold);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Write threshold {} exceeded", writeThreshold);
            }
        }
        List<ByteBuffer> byteBuffers = this.lease.getByteBuffers();
        if (byteBuffers.isEmpty()) {
            this.finish();
            return IteratingCallback.Action.IDLE;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Writing {} buffers ({} bytes) - entries processed/pending {}/{}: {}/{}", byteBuffers.size(), this.lease.getTotalLength(), this.processedEntries.size(), this.pendingEntries.size(), this.processedEntries, this.pendingEntries);
        }
        this.session.getEndPoint().write(this, byteBuffers.toArray(EMPTY_BYTE_BUFFERS));
        return IteratingCallback.Action.SCHEDULED;
    }

    void onFlushed(long bytes) throws IOException {
        for (Entry entry : this.processedEntries) {
            bytes = entry.onFlushed(bytes);
        }
    }

    @Override
    public void succeeded() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Written {} buffers - entries processed/pending {}/{}: {}/{}", this.lease.getByteBuffers().size(), this.processedEntries.size(), this.pendingEntries.size(), this.processedEntries, this.pendingEntries);
        }
        this.finish();
        super.succeeded();
    }

    private void finish() {
        this.lease.recycle();
        this.processedEntries.forEach(Callback.Nested::succeeded);
        this.processedEntries.clear();
        if (this.stalledEntry != null) {
            Entry entry;
            int size = this.pendingEntries.size();
            for (int i = 0; i < size && (entry = this.pendingEntries.peek()) != this.stalledEntry; ++i) {
                this.pendingEntries.poll();
                this.pendingEntries.offer(entry);
            }
            this.stalledEntry = null;
        }
    }

    @Override
    protected void onCompleteSuccess() {
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onCompleteFailure(Throwable x) {
        HashSet<Entry> allEntries;
        Throwable closed;
        this.lease.recycle();
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            closed = this.terminated;
            this.terminated = x;
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("%s, entries processed/pending/queued=%d/%d/%d", closed != null ? "Closing" : "Failing", this.processedEntries.size(), this.pendingEntries.size(), this.entries.size()), x);
            }
            allEntries = new HashSet<Entry>(this.entries);
            this.entries.clear();
        }
        allEntries.addAll(this.processedEntries);
        this.processedEntries.clear();
        allEntries.addAll(this.pendingEntries);
        this.pendingEntries.clear();
        allEntries.forEach(entry -> entry.failed(x));
        if (closed == null) {
            this.session.abort(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminate(Throwable cause) {
        Throwable closed;
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            closed = this.terminated;
            this.terminated = cause;
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}", closed != null ? "Terminated" : "Terminating");
            }
        }
        if (closed == null) {
            this.iterate();
        }
    }

    private void closed(Entry entry, Throwable failure) {
        entry.failed(failure);
    }

    @Override
    public String dump() {
        return Dumpable.dump(this);
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        out.append(this.toString()).append(System.lineSeparator());
    }

    @Override
    public String toString() {
        return String.format("%s[window_queue=%d,frame_queue=%d,processed/pending=%d/%d]", super.toString(), this.getWindowQueueSize(), this.getFrameQueueSize(), this.processedEntries.size(), this.pendingEntries.size());
    }

    private class WindowEntry {
        private final IStream stream;
        private final WindowUpdateFrame frame;

        public WindowEntry(IStream stream, WindowUpdateFrame frame) {
            this.stream = stream;
            this.frame = frame;
        }

        public void perform() {
            FlowControlStrategy flowControl = HTTP2Flusher.this.session.getFlowControlStrategy();
            flowControl.onWindowUpdate(HTTP2Flusher.this.session, this.stream, this.frame);
        }
    }

    public static abstract class Entry
    extends Callback.Nested {
        protected final Frame frame;
        protected final IStream stream;

        protected Entry(Frame frame, IStream stream, Callback callback) {
            super(callback);
            this.frame = frame;
            this.stream = stream;
        }

        public abstract int getFrameBytesGenerated();

        public int getDataBytesRemaining() {
            return 0;
        }

        protected abstract boolean generate(ByteBufferPool.Lease var1) throws HpackException;

        public abstract long onFlushed(long var1) throws IOException;

        @Override
        public void failed(Throwable x) {
            if (this.stream != null) {
                this.stream.close();
                this.stream.getSession().removeStream(this.stream);
            }
            super.failed(x);
        }

        private boolean isStale() {
            if (this.isProtocolFrame(this.frame)) {
                return false;
            }
            if (this.stream == null) {
                return true;
            }
            return this.stream.isResetOrFailed();
        }

        private boolean isProtocolFrame(Frame frame) {
            switch (frame.getType()) {
                case DATA: 
                case HEADERS: 
                case PUSH_PROMISE: 
                case CONTINUATION: {
                    return false;
                }
                case PRIORITY: 
                case RST_STREAM: 
                case SETTINGS: 
                case PING: 
                case GO_AWAY: 
                case WINDOW_UPDATE: 
                case PREFACE: 
                case DISCONNECT: {
                    return true;
                }
            }
            throw new IllegalStateException();
        }

        public String toString() {
            return this.frame.toString();
        }
    }
}

