/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.inventoryprinter.impl;

import jakarta.json.Json;
import jakarta.json.stream.JsonGenerator;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.felix.inventory.Format;
import org.apache.felix.inventory.InventoryPrinter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.servlet.runtime.HttpServiceRuntime;
import org.osgi.service.servlet.runtime.dto.RuntimeDTO;
import org.osgi.service.servlet.runtime.dto.ServletContextDTO;
import org.osgi.service.servlet.runtime.dto.ServletDTO;

public class HttpInventoryPrinter
implements InventoryPrinter {
    private final BundleContext context;
    private final HttpServiceRuntime runtime;

    public HttpInventoryPrinter(BundleContext context, HttpServiceRuntime runtime) {
        this.context = context;
        this.runtime = runtime;
    }

    public void print(PrintWriter printWriter, Format format, boolean isZip) {
        if (format == Format.TEXT) {
            this.printConfiguration(printWriter);
        } else if (format == Format.JSON) {
            this.printConfigurationJSON(printWriter);
        }
    }

    private String getValueAsString(Object value) {
        if (value.getClass().isArray()) {
            if (value instanceof long[]) {
                return Arrays.toString((long[])value);
            }
            if (value instanceof int[]) {
                return Arrays.toString((int[])value);
            }
            if (value instanceof double[]) {
                return Arrays.toString((double[])value);
            }
            if (value instanceof byte[]) {
                return Arrays.toString((byte[])value);
            }
            if (value instanceof float[]) {
                return Arrays.toString((float[])value);
            }
            if (value instanceof short[]) {
                return Arrays.toString((short[])value);
            }
            if (value instanceof boolean[]) {
                return Arrays.toString((boolean[])value);
            }
            if (value instanceof char[]) {
                return Arrays.toString((char[])value);
            }
            return Arrays.toString((Object[])value);
        }
        return value.toString();
    }

    private String getContextPath(String path) {
        if (path.length() == 0) {
            return "<root>";
        }
        return path;
    }

    private String getErrorText(int reason) {
        switch (reason) {
            case 4: {
                return "Exception on init";
            }
            case 1: {
                return "No match";
            }
            case 7: {
                return "In use";
            }
            case 5: {
                return "Not gettable";
            }
            case 2: {
                return "Context failure";
            }
            case 3: {
                return "Shadowed";
            }
            case 6: {
                return "Invalid";
            }
        }
        return "unknown (".concat(String.valueOf(reason)).concat(")");
    }

    private ServiceReference<?> getServiceReference(long serviceId) {
        if (serviceId > 0L) {
            try {
                ServiceReference[] ref = this.context.getServiceReferences((String)null, "(service.id=" + String.valueOf(serviceId) + ")");
                if (ref != null && ref.length > 0) {
                    return ref[0];
                }
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    private void printServiceIdAndRanking(PrintWriter pw, ServiceReference<?> ref, long serviceId) {
        Object obj;
        pw.print("Service ID : ");
        pw.println(String.valueOf(serviceId));
        int ranking = 0;
        if (ref != null && (obj = ref.getProperty("service.ranking")) instanceof Integer) {
            ranking = (Integer)obj;
        }
        pw.print("Ranking : ");
        pw.println(String.valueOf(ranking));
        if (ref != null) {
            pw.print("Bundle : ");
            pw.print(ref.getBundle().getSymbolicName());
            pw.print(" <");
            pw.print(String.valueOf(ref.getBundle().getBundleId()));
            pw.println(">");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void printConfiguration(PrintWriter pw) {
        int n;
        ArrayList<String> patterns;
        RuntimeDTO dto = this.runtime.getRuntimeDTO();
        pw.println("HTTP Service Details");
        pw.println("====================");
        pw.println();
        pw.println("Runtime Properties");
        pw.println("------------------");
        for (Map.Entry prop : dto.serviceDTO.properties.entrySet()) {
            pw.print((String)prop.getKey());
            pw.print(" : ");
            pw.println(this.getValueAsString(prop.getValue()));
        }
        pw.println();
        for (ServletContextDTO servletContextDTO : dto.servletContextDTOs) {
            pw.print("Servlet Context ");
            pw.println(servletContextDTO.name);
            pw.println("-----------------------------------------------");
            pw.print("Path : ");
            pw.println(this.getContextPath(servletContextDTO.contextPath));
            this.printServiceIdAndRanking(pw, this.getServiceReference(servletContextDTO.serviceId), servletContextDTO.serviceId);
            pw.println();
            if (servletContextDTO.servletDTOs.length > 0) {
                pw.println("Servlets");
                for (ServletDTO servletDTO : servletContextDTO.servletDTOs) {
                    pw.print("Patterns : ");
                    pw.println(this.getValueAsString(servletDTO.patterns));
                    pw.print("Name : ");
                    pw.println(servletDTO.name);
                    pw.print("async : ");
                    pw.println(String.valueOf(servletDTO.asyncSupported));
                    this.printServiceIdAndRanking(pw, this.getServiceReference(servletDTO.serviceId), servletDTO.serviceId);
                    pw.println();
                }
                pw.println();
            }
            if (servletContextDTO.filterDTOs.length > 0) {
                pw.println("Filters");
                for (ServletDTO servletDTO : servletContextDTO.filterDTOs) {
                    ArrayList<String> patterns2 = new ArrayList<String>();
                    patterns2.addAll(Arrays.asList(servletDTO.patterns));
                    patterns2.addAll(Arrays.asList(servletDTO.regexs));
                    for (String name : servletDTO.servletNames) {
                        patterns2.add("Servlet : " + name);
                    }
                    Collections.sort(patterns2);
                    pw.print("Patterns : ");
                    pw.println(patterns2);
                    pw.print("Name : ");
                    pw.println(servletDTO.name);
                    pw.print("async : ");
                    pw.println(String.valueOf(servletDTO.asyncSupported));
                    pw.print("dispatcher : ");
                    pw.println(this.getValueAsString(servletDTO.dispatcher));
                    this.printServiceIdAndRanking(pw, this.getServiceReference(servletDTO.serviceId), servletDTO.serviceId);
                    pw.println();
                }
                pw.println();
            }
            if (servletContextDTO.resourceDTOs.length > 0) {
                pw.println("Resources");
                for (ServletDTO servletDTO : servletContextDTO.resourceDTOs) {
                    pw.print("Patterns : ");
                    pw.println(this.getValueAsString(servletDTO.patterns));
                    pw.print("Prefix : ");
                    pw.println(servletDTO.prefix);
                    this.printServiceIdAndRanking(pw, this.getServiceReference(servletDTO.serviceId), servletDTO.serviceId);
                    pw.println();
                }
                pw.println();
            }
            if (servletContextDTO.errorPageDTOs.length > 0) {
                pw.println("Error Pages");
                for (ServletDTO servletDTO : servletContextDTO.errorPageDTOs) {
                    ArrayList<String> patterns2 = new ArrayList<String>();
                    for (long p : servletDTO.errorCodes) {
                        patterns2.add(String.valueOf(p));
                    }
                    for (String p : servletDTO.exceptions) {
                        patterns2.add(p);
                    }
                    pw.print("Patterns : ");
                    pw.println(patterns2);
                    pw.print("Name : ");
                    pw.println(servletDTO.name);
                    pw.print("async : ");
                    pw.println(String.valueOf(servletDTO.asyncSupported));
                    this.printServiceIdAndRanking(pw, this.getServiceReference(servletDTO.serviceId), servletDTO.serviceId);
                    pw.println();
                }
                pw.println();
            }
            if (servletContextDTO.listenerDTOs.length > 0) {
                pw.println("Listeners");
                for (ServletDTO servletDTO : servletContextDTO.listenerDTOs) {
                    pw.print("Types : ");
                    pw.println(this.getValueAsString(servletDTO.types));
                    this.printServiceIdAndRanking(pw, this.getServiceReference(servletDTO.serviceId), servletDTO.serviceId);
                    pw.println();
                }
                pw.println();
            }
            pw.println();
        }
        if (dto.failedServletContextDTOs.length > 0) {
            for (ServletContextDTO servletContextDTO : dto.failedServletContextDTOs) {
                pw.print("Failed Servlet Context ");
                pw.println(servletContextDTO.name);
                pw.println("-----------------------------------------------");
                pw.print("Reason : ");
                pw.println(this.getErrorText(servletContextDTO.failureReason));
                pw.print("Path : ");
                pw.println(this.getContextPath(servletContextDTO.contextPath));
                this.printServiceIdAndRanking(pw, this.getServiceReference(servletContextDTO.serviceId), servletContextDTO.serviceId);
                pw.println();
            }
        }
        if (dto.failedServletDTOs.length > 0) {
            pw.println("Failed Servlets");
            for (ServletContextDTO servletContextDTO : dto.failedServletDTOs) {
                pw.print("Patterns : ");
                pw.println(this.getValueAsString(servletContextDTO.patterns));
                pw.print("Reason : ");
                pw.println(this.getErrorText(servletContextDTO.failureReason));
                pw.print("Name : ");
                pw.println(servletContextDTO.name);
                pw.print("async : ");
                pw.println(String.valueOf(servletContextDTO.asyncSupported));
                this.printServiceIdAndRanking(pw, this.getServiceReference(servletContextDTO.serviceId), servletContextDTO.serviceId);
                pw.println();
            }
            pw.println();
        }
        if (dto.failedFilterDTOs.length > 0) {
            pw.println("Failed Filters");
            for (ServletContextDTO servletContextDTO : dto.failedFilterDTOs) {
                void var10_34;
                patterns = new ArrayList<String>();
                patterns.addAll(Arrays.asList(servletContextDTO.patterns));
                patterns.addAll(Arrays.asList(servletContextDTO.regexs));
                String[] stringArray = servletContextDTO.servletNames;
                n = stringArray.length;
                boolean bl = false;
                while (var10_34 < n) {
                    String name = stringArray[var10_34];
                    patterns.add("Servlet : " + name);
                    ++var10_34;
                }
                Collections.sort(patterns);
                pw.print("Patterns : ");
                pw.println(patterns);
                pw.print("Reason : ");
                pw.println(this.getErrorText(servletContextDTO.failureReason));
                pw.print("Name : ");
                pw.println(servletContextDTO.name);
                pw.print("async : ");
                pw.println(String.valueOf(servletContextDTO.asyncSupported));
                pw.print("dispatcher : ");
                pw.println(this.getValueAsString(servletContextDTO.dispatcher));
                this.printServiceIdAndRanking(pw, this.getServiceReference(servletContextDTO.serviceId), servletContextDTO.serviceId);
                pw.println();
            }
            pw.println();
        }
        if (dto.failedResourceDTOs.length > 0) {
            pw.println("Failed Resources");
            for (ServletContextDTO servletContextDTO : dto.failedResourceDTOs) {
                pw.print("Patterns : ");
                pw.println(this.getValueAsString(servletContextDTO.patterns));
                pw.print("Reason : ");
                pw.println(this.getErrorText(servletContextDTO.failureReason));
                pw.print("Prefix : ");
                pw.println(servletContextDTO.prefix);
                this.printServiceIdAndRanking(pw, this.getServiceReference(servletContextDTO.serviceId), servletContextDTO.serviceId);
                pw.println();
            }
            pw.println();
        }
        if (dto.failedErrorPageDTOs.length > 0) {
            pw.println("Failed Error Pages");
            for (ServletContextDTO servletContextDTO : dto.failedErrorPageDTOs) {
                void var10_37;
                int n2;
                patterns = new ArrayList();
                long[] lArray = servletContextDTO.errorCodes;
                n = lArray.length;
                boolean bl = false;
                while (n2 < n) {
                    long p = lArray[n2];
                    patterns.add(String.valueOf(p));
                    ++n2;
                }
                String[] stringArray = servletContextDTO.exceptions;
                n = stringArray.length;
                n2 = 0;
                while (var10_37 < n) {
                    String p = stringArray[var10_37];
                    patterns.add(p);
                    ++var10_37;
                }
                pw.print("Patterns : ");
                pw.println(patterns);
                pw.print("Reason : ");
                pw.println(this.getErrorText(servletContextDTO.failureReason));
                pw.print("Name : ");
                pw.println(servletContextDTO.name);
                pw.print("async : ");
                pw.println(String.valueOf(servletContextDTO.asyncSupported));
                this.printServiceIdAndRanking(pw, this.getServiceReference(servletContextDTO.serviceId), servletContextDTO.serviceId);
                pw.println();
            }
            pw.println();
        }
        if (dto.failedListenerDTOs.length > 0) {
            pw.println("Failed Listeners");
            for (ServletContextDTO servletContextDTO : dto.failedListenerDTOs) {
                pw.print("Types : ");
                pw.println(this.getValueAsString(servletContextDTO.types));
                pw.print("Reason : ");
                pw.println(this.getErrorText(servletContextDTO.failureReason));
                this.printServiceIdAndRanking(pw, this.getServiceReference(servletContextDTO.serviceId), servletContextDTO.serviceId);
                pw.println();
            }
            pw.println();
        }
        pw.println();
    }

    private void writeServiceIdAndRanking(JsonGenerator gen, ServiceReference<?> ref, long serviceId) {
        Object obj;
        gen.write("service.id", serviceId);
        int ranking = 0;
        if (ref != null && (obj = ref.getProperty("service.ranking")) instanceof Integer) {
            ranking = (Integer)obj;
        }
        gen.write("service.ranking", ranking);
        if (ref != null) {
            gen.write("bundle.id", ref.getBundle().getBundleId());
        }
    }

    private void writeValueAsStringOrStringArray(JsonGenerator gen, String name, Object value) {
        if (value.getClass().isArray()) {
            gen.writeStartArray(name);
            for (int i = 0; i < Array.getLength(value); ++i) {
                Object v = Array.get(value, i);
                if (v instanceof Long) {
                    gen.write(((Long)v).longValue());
                    continue;
                }
                if (v instanceof Integer) {
                    gen.write(((Integer)v).intValue());
                    continue;
                }
                if (v instanceof Double) {
                    gen.write(((Double)v).doubleValue());
                    continue;
                }
                if (v instanceof Byte) {
                    gen.write((int)((Byte)v).byteValue());
                    continue;
                }
                if (v instanceof Float) {
                    gen.write((double)((Float)v).floatValue());
                    continue;
                }
                if (v instanceof Short) {
                    gen.write((int)((Short)v).shortValue());
                    continue;
                }
                if (v instanceof Boolean) {
                    gen.write(((Boolean)v).booleanValue());
                    continue;
                }
                if (v instanceof Character) {
                    gen.write((int)((Character)v).charValue());
                    continue;
                }
                gen.write(v.toString());
            }
            gen.writeEnd();
        } else {
            gen.write(name, value.toString());
        }
    }

    private void writeRuntime(JsonGenerator gen, RuntimeDTO dto) {
        gen.writeStartObject("runtime");
        gen.writeStartObject("properties");
        for (Map.Entry prop : dto.serviceDTO.properties.entrySet()) {
            this.writeValueAsStringOrStringArray(gen, (String)prop.getKey(), prop.getValue());
        }
        gen.writeEnd();
        gen.writeEnd();
    }

    private void writeContext(JsonGenerator gen, ServletContextDTO ctxDto) {
        gen.writeStartObject();
        gen.write("name", ctxDto.name);
        gen.write("path", ctxDto.contextPath);
        this.writeServiceIdAndRanking(gen, this.getServiceReference(ctxDto.serviceId), ctxDto.serviceId);
        gen.writeStartArray("servlets");
        for (ServletDTO servletDTO : ctxDto.servletDTOs) {
            gen.writeStartObject();
            gen.write("name", servletDTO.name);
            this.writeValueAsStringOrStringArray(gen, "patterns", servletDTO.patterns);
            gen.write("asyncSupported", servletDTO.asyncSupported);
            this.writeServiceIdAndRanking(gen, this.getServiceReference(servletDTO.serviceId), servletDTO.serviceId);
            gen.writeEnd();
        }
        gen.writeEnd();
        gen.writeStartArray("filters");
        for (ServletDTO servletDTO : ctxDto.filterDTOs) {
            gen.writeStartObject();
            gen.write("name", servletDTO.name);
            this.writeValueAsStringOrStringArray(gen, "patterns", servletDTO.patterns);
            this.writeValueAsStringOrStringArray(gen, "regexs", servletDTO.regexs);
            this.writeValueAsStringOrStringArray(gen, "servletNames", servletDTO.servletNames);
            gen.write("asyncSupported", servletDTO.asyncSupported);
            this.writeValueAsStringOrStringArray(gen, "dispatcher", servletDTO.dispatcher);
            this.writeServiceIdAndRanking(gen, this.getServiceReference(servletDTO.serviceId), servletDTO.serviceId);
            gen.writeEnd();
        }
        gen.writeEnd();
        gen.writeStartArray("resources");
        for (ServletDTO servletDTO : ctxDto.resourceDTOs) {
            gen.writeStartObject();
            this.writeValueAsStringOrStringArray(gen, "patterns", servletDTO.patterns);
            gen.write("prefix", servletDTO.prefix);
            this.writeServiceIdAndRanking(gen, this.getServiceReference(servletDTO.serviceId), servletDTO.serviceId);
            gen.writeEnd();
        }
        gen.writeEnd();
        gen.writeStartArray("errorPages");
        for (ServletDTO servletDTO : ctxDto.errorPageDTOs) {
            gen.writeStartObject();
            gen.write("name", servletDTO.name);
            this.writeValueAsStringOrStringArray(gen, "exceptions", servletDTO.exceptions);
            this.writeValueAsStringOrStringArray(gen, "errorCodes", servletDTO.errorCodes);
            gen.write("asyncSupported", servletDTO.asyncSupported);
            this.writeServiceIdAndRanking(gen, this.getServiceReference(servletDTO.serviceId), servletDTO.serviceId);
            gen.writeEnd();
        }
        gen.writeEnd();
        gen.writeStartArray("listeners");
        for (ServletDTO servletDTO : ctxDto.listenerDTOs) {
            gen.writeStartObject();
            this.writeValueAsStringOrStringArray(gen, "types", servletDTO.types);
            this.writeServiceIdAndRanking(gen, this.getServiceReference(servletDTO.serviceId), servletDTO.serviceId);
            gen.writeEnd();
        }
        gen.writeEnd();
        gen.writeEnd();
    }

    private void printConfigurationJSON(PrintWriter pw) {
        RuntimeDTO dto = this.runtime.getRuntimeDTO();
        try (JsonGenerator gen = Json.createGenerator((Writer)pw);){
            gen.writeStartObject();
            this.writeRuntime(gen, dto);
            gen.writeStartArray("contexts");
            for (ServletContextDTO servletContextDTO : dto.servletContextDTOs) {
                this.writeContext(gen, servletContextDTO);
            }
            gen.writeEnd();
            gen.writeStartArray("failedContexts");
            for (ServletContextDTO servletContextDTO : dto.failedServletContextDTOs) {
                gen.writeStartObject();
                gen.write("name", servletContextDTO.name);
                gen.write("path", servletContextDTO.contextPath);
                gen.write("failureReason", servletContextDTO.failureReason);
                gen.write("failureReasonText", this.getErrorText(servletContextDTO.failureReason));
                this.writeServiceIdAndRanking(gen, this.getServiceReference(servletContextDTO.serviceId), servletContextDTO.serviceId);
                gen.writeEnd();
            }
            gen.writeEnd();
            gen.writeStartArray("failedServlets");
            for (ServletContextDTO servletContextDTO : dto.failedServletDTOs) {
                gen.writeStartObject();
                gen.write("name", servletContextDTO.name);
                this.writeValueAsStringOrStringArray(gen, "patterns", servletContextDTO.patterns);
                gen.write("asyncSupported", servletContextDTO.asyncSupported);
                gen.write("failureReason", servletContextDTO.failureReason);
                gen.write("failureReasonText", this.getErrorText(servletContextDTO.failureReason));
                this.writeServiceIdAndRanking(gen, this.getServiceReference(servletContextDTO.serviceId), servletContextDTO.serviceId);
                gen.writeEnd();
            }
            gen.writeEnd();
            gen.writeStartArray("failedFilters");
            for (ServletContextDTO servletContextDTO : dto.failedFilterDTOs) {
                gen.writeStartObject();
                gen.write("name", servletContextDTO.name);
                this.writeValueAsStringOrStringArray(gen, "patterns", servletContextDTO.patterns);
                this.writeValueAsStringOrStringArray(gen, "regexs", servletContextDTO.regexs);
                this.writeValueAsStringOrStringArray(gen, "servletNames", servletContextDTO.servletNames);
                gen.write("asyncSupported", servletContextDTO.asyncSupported);
                this.writeValueAsStringOrStringArray(gen, "dispatcher", servletContextDTO.dispatcher);
                gen.write("failureReason", servletContextDTO.failureReason);
                gen.write("failureReasonText", this.getErrorText(servletContextDTO.failureReason));
                this.writeServiceIdAndRanking(gen, this.getServiceReference(servletContextDTO.serviceId), servletContextDTO.serviceId);
                gen.writeEnd();
            }
            gen.writeEnd();
            gen.writeStartArray("failedResources");
            for (ServletContextDTO servletContextDTO : dto.failedResourceDTOs) {
                gen.writeStartObject();
                this.writeValueAsStringOrStringArray(gen, "patterns", servletContextDTO.patterns);
                gen.write("prefix", servletContextDTO.prefix);
                gen.write("failureReason", servletContextDTO.failureReason);
                gen.write("failureReasonText", this.getErrorText(servletContextDTO.failureReason));
                this.writeServiceIdAndRanking(gen, this.getServiceReference(servletContextDTO.serviceId), servletContextDTO.serviceId);
                gen.writeEnd();
            }
            gen.writeEnd();
            gen.writeStartArray("failedErrorPages");
            for (ServletContextDTO servletContextDTO : dto.failedErrorPageDTOs) {
                gen.writeStartObject();
                gen.write("name", servletContextDTO.name);
                this.writeValueAsStringOrStringArray(gen, "exceptions", servletContextDTO.exceptions);
                this.writeValueAsStringOrStringArray(gen, "errorCodes", servletContextDTO.errorCodes);
                gen.write("asyncSupported", servletContextDTO.asyncSupported);
                gen.write("failureReason", servletContextDTO.failureReason);
                gen.write("failureReasonText", this.getErrorText(servletContextDTO.failureReason));
                this.writeServiceIdAndRanking(gen, this.getServiceReference(servletContextDTO.serviceId), servletContextDTO.serviceId);
                gen.writeEnd();
            }
            gen.writeEnd();
            gen.writeStartArray("failedListeners");
            for (ServletContextDTO servletContextDTO : dto.failedListenerDTOs) {
                gen.writeStartObject();
                this.writeValueAsStringOrStringArray(gen, "types", servletContextDTO.types);
                gen.write("failureReason", servletContextDTO.failureReason);
                gen.write("failureReasonText", this.getErrorText(servletContextDTO.failureReason));
                this.writeServiceIdAndRanking(gen, this.getServiceReference(servletContextDTO.serviceId), servletContextDTO.serviceId);
                gen.writeEnd();
            }
            gen.writeEnd();
            gen.writeEnd();
        }
    }
}

