/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.registry;

import java.util.regex.Pattern;
import javax.servlet.http.MappingMatch;
import org.apache.felix.http.base.internal.handler.ServletHandler;
import org.apache.felix.http.base.internal.registry.PathResolution;
import org.apache.felix.http.base.internal.registry.PathResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PathResolverFactory {
    @NotNull
    public static PathResolver createPatternMatcher(@Nullable ServletHandler handler, @NotNull String pattern) {
        if (pattern.length() == 0) {
            return new RootMatcher(handler);
        }
        if (pattern.equals("/")) {
            return new DefaultMatcher(handler);
        }
        if (pattern.startsWith("*.")) {
            return new ExtensionMatcher(handler, pattern);
        }
        if (pattern.endsWith("/*")) {
            return new PathMatcher(handler, pattern);
        }
        if (handler != null && handler.getContextServiceId() == -1L) {
            return new ExactAndPathMatcher(handler, pattern);
        }
        return new ExactMatcher(handler, pattern);
    }

    @NotNull
    public static PathResolver createRegexMatcher(@NotNull String regex) {
        return new RegexMatcher(regex);
    }

    public static final class RegexMatcher
    extends AbstractMatcher {
        private final Pattern pattern;

        public RegexMatcher(String regex) {
            super(null, regex, 0);
            this.pattern = Pattern.compile(regex);
        }

        @Override
        @Nullable
        public PathResolution resolve(@NotNull String uri) {
            if (this.pattern.matcher(uri).matches()) {
                PathResolution pr = new PathResolution();
                pr.pathInfo = null;
                pr.servletPath = uri;
                pr.requestURI = uri;
                pr.matchedPattern = this.getPattern();
                pr.match = MappingMatch.PATH;
                pr.matchValue = uri;
                return pr;
            }
            return null;
        }

        @Override
        public int getOrdering() {
            return this.pattern.toString().length();
        }
    }

    public static final class ExtensionMatcher
    extends AbstractMatcher {
        private final String extension;

        public ExtensionMatcher(ServletHandler handler, String pattern) {
            super(handler, pattern, 3);
            this.extension = pattern.substring(1);
        }

        @Override
        public PathResolution resolve(String uri) {
            if (uri.endsWith(this.extension)) {
                PathResolution pr = new PathResolution();
                pr.pathInfo = null;
                pr.servletPath = uri;
                pr.requestURI = uri;
                pr.handler = this.getServletHandler();
                pr.matchedPattern = this.getPattern();
                pr.match = MappingMatch.EXTENSION;
                int pos = uri.lastIndexOf("/");
                pr.matchValue = uri.substring(pos + 1, uri.length() - this.extension.length());
                return pr;
            }
            return null;
        }

        @Override
        public int getOrdering() {
            return this.extension.length();
        }
    }

    public static final class PathMatcher
    extends AbstractMatcher {
        private final String prefix;
        private final String path;

        public PathMatcher(ServletHandler handler, String pattern) {
            super(handler, pattern, 4);
            this.prefix = pattern.substring(0, pattern.length() - 1);
            this.path = pattern.substring(0, pattern.length() - 2);
        }

        @Override
        public PathResolution resolve(String uri) {
            if (uri.equals(this.path)) {
                PathResolution pr = new PathResolution();
                pr.servletPath = this.path;
                pr.pathInfo = null;
                pr.requestURI = uri;
                pr.handler = this.getServletHandler();
                pr.matchedPattern = this.getPattern();
                pr.match = MappingMatch.PATH;
                pr.matchValue = uri.length() > 0 ? uri.substring(1) : "";
                return pr;
            }
            if (uri.startsWith(this.prefix)) {
                PathResolution pr = new PathResolution();
                pr.servletPath = this.prefix.substring(0, this.prefix.length() - 1);
                pr.pathInfo = uri.substring(pr.servletPath.length());
                pr.requestURI = uri;
                pr.handler = this.getServletHandler();
                pr.matchedPattern = this.getPattern();
                pr.match = MappingMatch.PATH;
                pr.matchValue = uri.substring(this.prefix.length(), uri.length());
                return pr;
            }
            return null;
        }

        @Override
        public int getOrdering() {
            return this.prefix.length() + 1;
        }
    }

    public static final class ExactMatcher
    extends AbstractMatcher {
        private final String path;

        public ExactMatcher(ServletHandler handler, String pattern) {
            super(handler, pattern, 5);
            this.path = pattern;
        }

        @Override
        public PathResolution resolve(String uri) {
            if (uri.equals(this.path)) {
                PathResolution pr = new PathResolution();
                pr.servletPath = uri;
                pr.pathInfo = null;
                pr.requestURI = uri;
                pr.handler = this.getServletHandler();
                pr.matchedPattern = this.getPattern();
                pr.match = MappingMatch.EXACT;
                int pos = uri.lastIndexOf("/");
                pr.matchValue = uri.substring(pos + 1, uri.length());
                return pr;
            }
            return null;
        }

        @Override
        public int getOrdering() {
            return this.path.length();
        }
    }

    public static final class ExactAndPathMatcher
    extends AbstractMatcher {
        private final String path;
        private final String prefix;

        public ExactAndPathMatcher(ServletHandler handler, String pattern) {
            super(handler, pattern, 5);
            this.path = pattern;
            this.prefix = pattern.concat("/");
        }

        @Override
        public PathResolution resolve(String uri) {
            if (uri.equals(this.path)) {
                PathResolution pr = new PathResolution();
                pr.pathInfo = null;
                pr.servletPath = uri;
                pr.requestURI = uri;
                pr.handler = this.getServletHandler();
                pr.matchedPattern = this.getPattern();
                pr.match = MappingMatch.EXACT;
                int pos = uri.lastIndexOf("/");
                pr.matchValue = uri.substring(pos + 1, uri.length());
                return pr;
            }
            if (uri.startsWith(this.prefix)) {
                PathResolution pr = new PathResolution();
                pr.servletPath = this.prefix.substring(0, this.prefix.length() - 1);
                pr.pathInfo = uri.substring(pr.servletPath.length());
                pr.requestURI = uri;
                pr.handler = this.getServletHandler();
                pr.matchedPattern = this.getPattern();
                pr.match = MappingMatch.PATH;
                int pos = uri.lastIndexOf("/");
                pr.matchValue = uri.substring(pos + 1, uri.length());
                return pr;
            }
            return null;
        }

        @Override
        public int getOrdering() {
            return this.path.length();
        }
    }

    public static final class DefaultMatcher
    extends AbstractMatcher {
        public DefaultMatcher(ServletHandler handler) {
            super(handler, "/", 1);
        }

        @Override
        public PathResolution resolve(String uri) {
            PathResolution pr = new PathResolution();
            pr.pathInfo = null;
            pr.servletPath = uri;
            pr.requestURI = uri;
            pr.handler = this.getServletHandler();
            pr.matchedPattern = this.getPattern();
            pr.match = MappingMatch.DEFAULT;
            pr.matchValue = "";
            return pr;
        }
    }

    public static final class RootMatcher
    extends AbstractMatcher {
        public RootMatcher(ServletHandler handler) {
            super(handler, "", 2);
        }

        @Override
        public PathResolution resolve(String uri) {
            if (uri.length() == 0 || uri.equals("/")) {
                PathResolution pr = new PathResolution();
                pr.pathInfo = "/";
                pr.servletPath = "";
                pr.requestURI = uri;
                pr.handler = this.getServletHandler();
                pr.matchedPattern = this.getPattern();
                pr.match = MappingMatch.CONTEXT_ROOT;
                pr.matchValue = this.getPattern();
                return pr;
            }
            return null;
        }
    }

    public static abstract class AbstractMatcher
    implements PathResolver {
        private final int ranking;
        private final String pattern;
        private final ServletHandler handler;

        public AbstractMatcher(ServletHandler handler, String pattern, int ranking) {
            this.handler = handler;
            this.ranking = ranking;
            this.pattern = pattern;
        }

        @Override
        public int compareTo(PathResolver o) {
            int result = o.getRanking() - this.ranking;
            if (result == 0) {
                result = o.getOrdering() - this.getOrdering();
            }
            return result;
        }

        @Override
        public ServletHandler getServletHandler() {
            return this.handler;
        }

        @Override
        public int getRanking() {
            return this.ranking;
        }

        @Override
        public int getOrdering() {
            return 0;
        }

        @Override
        public String getPattern() {
            return this.pattern;
        }

        public int hashCode() {
            return this.pattern.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            AbstractMatcher other = (AbstractMatcher)obj;
            return this.pattern.equals(other.pattern);
        }
    }
}

