/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.api.execution;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.osgi.annotation.versioning.ProviderType;
import org.osgi.framework.ServiceReference;

@ProviderType
public class HealthCheckMetadata {
    private final String name;
    private final String mbeanName;
    private final String title;
    private final long serviceId;
    private final List<String> tags;
    private final String asyncCronExpression;
    private final Long asyncIntervalInSec;
    private final ServiceReference serviceReference;
    private final Long resultCacheTtlInMs;
    private final Long keepNonOkResultsStickyForSec;
    @Deprecated
    private final Long warningsStickForMinutes;
    @Deprecated
    private final String WARNINGS_STICK_FOR_MINUTES = "hc.warningsStickForMinutes";

    public HealthCheckMetadata(ServiceReference ref) {
        this.serviceId = (Long)ref.getProperty("service.id");
        this.name = (String)ref.getProperty("hc.name");
        this.mbeanName = (String)ref.getProperty("hc.mbean.name");
        this.title = this.getHealthCheckTitle(ref);
        this.tags = this.arrayPropertyToListOfStr(ref.getProperty("hc.tags"));
        this.asyncCronExpression = (String)ref.getProperty("hc.async.cronExpression");
        this.asyncIntervalInSec = this.toLong(ref.getProperty("hc.async.intervalInSec"));
        this.resultCacheTtlInMs = (Long)ref.getProperty("hc.resultCacheTtlInMs");
        this.keepNonOkResultsStickyForSec = this.toLong(ref.getProperty("hc.keepNonOkResultsStickyForSec"));
        this.warningsStickForMinutes = this.toLong(ref.getProperty("hc.warningsStickForMinutes"));
        this.serviceReference = ref;
    }

    private Long toLong(Object configValue) {
        if (configValue == null) {
            return null;
        }
        if (configValue instanceof Long) {
            return (Long)configValue;
        }
        return Long.valueOf(configValue.toString());
    }

    public String getName() {
        return this.name;
    }

    public String getMBeanName() {
        return this.mbeanName;
    }

    public String getTitle() {
        return this.title;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String getAsyncCronExpression() {
        return this.asyncCronExpression;
    }

    public Long getAsyncIntervalInSec() {
        return this.asyncIntervalInSec;
    }

    public long getServiceId() {
        return this.serviceId;
    }

    public ServiceReference getServiceReference() {
        return this.serviceReference;
    }

    public Long getResultCacheTtlInMs() {
        return this.resultCacheTtlInMs;
    }

    public Long getKeepNonOkResultsStickyForSec() {
        if (this.keepNonOkResultsStickyForSec == null && this.warningsStickForMinutes != null) {
            return this.warningsStickForMinutes * 60L;
        }
        return this.keepNonOkResultsStickyForSec;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.serviceId ^ this.serviceId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HealthCheckMetadata)) {
            return false;
        }
        HealthCheckMetadata other = (HealthCheckMetadata)obj;
        return this.serviceId == other.serviceId;
    }

    public String toString() {
        return "HealthCheck '" + this.name + "'";
    }

    private String getHealthCheckTitle(ServiceReference ref) {
        Object val;
        String name = (String)ref.getProperty("hc.name");
        if ((name == null || name.isEmpty()) && (val = ref.getProperty("service.description")) != null) {
            name = val.toString();
        }
        if (name == null || name.isEmpty()) {
            name = "HealthCheck:" + ref.getProperty("service.id");
            val = ref.getProperty("service.pid");
            String pid = null;
            if (val instanceof String) {
                pid = (String)val;
            } else if (val instanceof String[]) {
                pid = Arrays.toString((String[])val);
            }
            if (pid != null && !pid.isEmpty()) {
                name = name + " (" + pid + ")";
            }
        }
        return name;
    }

    private List<String> arrayPropertyToListOfStr(Object arrayProp) {
        LinkedList<String> res = new LinkedList<String>();
        if (arrayProp instanceof String) {
            res.add((String)arrayProp);
        } else if (arrayProp instanceof String[]) {
            res.addAll(Arrays.asList((String[])arrayProp));
        }
        return res;
    }
}

