/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.converter;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.osgi.util.converter.ArrayDelegate;
import org.osgi.util.converter.CollectionDelegate;
import org.osgi.util.converter.ConvertingImpl;

class ListDelegate<T>
implements List<T> {
    private volatile List<T> delegate;
    private volatile boolean cloned;
    private final ConvertingImpl convertingImpl;

    static <T> List<T> forArray(Object arr, ConvertingImpl converting) {
        return new ListDelegate(new ArrayDelegate(arr), converting);
    }

    static <T> List<T> forCollection(Collection<T> object, ConvertingImpl converting) {
        if (object instanceof List) {
            return new ListDelegate<T>((List)object, converting);
        }
        return new ListDelegate<T>(new CollectionDelegate<T>(object), converting);
    }

    private ListDelegate(List<T> del, ConvertingImpl conv) {
        this.delegate = del;
        this.convertingImpl = conv;
    }

    private void cloneDelegate() {
        if (this.cloned) {
            return;
        }
        this.cloned = true;
        this.delegate = new ArrayList<Object>(Arrays.asList(this.toArray()));
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.containsAll(Collections.singletonList(o));
    }

    @Override
    public Iterator<T> iterator() {
        return this.listIterator();
    }

    @Override
    public Object[] toArray() {
        return this.toArray((X[])new Object[this.size()]);
    }

    @Override
    public <X> X[] toArray(X[] a) {
        int mySize = this.size();
        if (Array.getLength(a) < this.size()) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), mySize);
        }
        for (int i = 0; i < a.length; ++i) {
            a[i] = mySize > i ? this.get(i) : null;
        }
        return a;
    }

    @Override
    public boolean add(T e) {
        this.cloneDelegate();
        return this.delegate.add(e);
    }

    @Override
    public boolean remove(Object o) {
        this.cloneDelegate();
        return this.delegate.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        List<Object> l = Arrays.asList(this.toArray());
        for (Object o : c) {
            if (l.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.cloneDelegate();
        return this.delegate.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        this.cloneDelegate();
        return this.delegate.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.cloneDelegate();
        return this.delegate.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.cloneDelegate();
        return this.delegate.retainAll(c);
    }

    @Override
    public void clear() {
        this.cloned = true;
        this.delegate = new ArrayList<T>();
    }

    @Override
    public T get(int index) {
        return (T)this.convertingImpl.convertCollectionValue(this.delegate.get(index));
    }

    @Override
    public T set(int index, T element) {
        this.cloneDelegate();
        return this.delegate.set(index, element);
    }

    @Override
    public void add(int index, T element) {
        this.cloneDelegate();
        this.delegate.add(index, element);
    }

    @Override
    public T remove(int index) {
        this.cloneDelegate();
        return this.delegate.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.delegate.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.delegate.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return Arrays.asList(this.toArray()).listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return Arrays.asList(this.toArray()).listIterator(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return Arrays.asList(this.toArray()).subList(fromIndex, toIndex);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof List)) {
            return false;
        }
        ArrayList l1 = new ArrayList(this);
        ArrayList l2 = new ArrayList((List)obj);
        return l1.equals(l2);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

