/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.connect;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.felix.connect.Revision;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileVisitor;
import org.jboss.vfs.VisitorAttributes;

public class VFSRevision
implements Revision {
    private final URL m_url;
    private final long m_lastModified;
    private final Map<String, VirtualFile> m_entries = new HashMap<String, VirtualFile>();

    public VFSRevision(URL url, long lastModified) {
        this.m_url = url;
        this.m_lastModified = lastModified;
    }

    @Override
    public long getLastModified() {
        return this.m_lastModified;
    }

    @Override
    public Enumeration<String> getEntries() {
        try {
            this.loadEntries();
            return Collections.enumeration(this.m_entries.keySet());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public URL getEntry(String entryName) {
        try {
            this.loadEntries();
            VirtualFile vfile = this.m_entries.get(entryName);
            return vfile != null ? vfile.toURL() : null;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private synchronized void loadEntries() throws URISyntaxException, IOException {
        if (this.m_entries.size() == 0) {
            VirtualFile root = VFS.getChild((URI)this.m_url.toURI());
            final String uriPath = this.m_url.toURI().getPath();
            root.visit(new VirtualFileVisitor(){

                public void visit(VirtualFile vfile) {
                    String entryPath = vfile.getPathName().substring(uriPath.length());
                    VFSRevision.this.m_entries.put(entryPath, vfile);
                }

                public VisitorAttributes getAttributes() {
                    return VisitorAttributes.RECURSE_LEAVES_ONLY;
                }
            });
        }
    }
}

