/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.configurator.impl.model;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.List;
import org.apache.felix.configurator.impl.model.ConfigPolicy;
import org.apache.felix.configurator.impl.model.ConfigState;
import org.apache.felix.configurator.impl.model.ReflectionUtil;

public class Config
implements Serializable,
Comparable<Config> {
    private static final long serialVersionUID = 1L;
    private static final int VERSION = 1;
    private final String pid;
    private final int ranking;
    private final long bundleId;
    private final ConfigPolicy policy;
    private final Dictionary<String, Object> properties;
    private volatile int index = 0;
    private volatile ConfigState state = ConfigState.INSTALL;
    private volatile List<File> files;

    public Config(String pid, Dictionary<String, Object> properties, long bundleId, int ranking, ConfigPolicy policy) {
        this.pid = pid;
        this.ranking = ranking;
        this.bundleId = bundleId;
        this.properties = properties;
        this.policy = policy;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeObject(this.pid);
        out.writeObject(this.properties);
        out.writeObject(this.policy.name());
        out.writeLong(this.bundleId);
        out.writeInt(this.ranking);
        out.writeInt(this.index);
        out.writeObject(this.state.name());
        out.writeObject(this.files);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version < 1 || version > 1) {
            throw new ClassNotFoundException(this.getClass().getName());
        }
        ReflectionUtil.setField(this, "pid", in.readObject());
        ReflectionUtil.setField(this, "properties", in.readObject());
        ReflectionUtil.setField(this, "policy", (Object)ConfigPolicy.valueOf((String)in.readObject()));
        ReflectionUtil.setField(this, "bundleId", in.readLong());
        ReflectionUtil.setField(this, "ranking", in.readInt());
        this.index = in.readInt();
        this.state = ConfigState.valueOf((String)in.readObject());
        this.files = (List)in.readObject();
    }

    public String getPid() {
        return this.pid;
    }

    public int getRanking() {
        return this.ranking;
    }

    public long getBundleId() {
        return this.bundleId;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int value) {
        this.index = value;
    }

    public ConfigState getState() {
        return this.state;
    }

    public void setState(ConfigState value) {
        this.state = value;
    }

    public ConfigPolicy getPolicy() {
        return this.policy;
    }

    public Dictionary<String, Object> getProperties() {
        return this.properties;
    }

    public void setFiles(List<File> f) {
        this.files = f;
    }

    public List<File> getFiles() {
        return this.files;
    }

    @Override
    public int compareTo(Config o) {
        if (this.getRanking() > o.getRanking()) {
            return -1;
        }
        if (this.getRanking() == o.getRanking()) {
            if (this.getBundleId() < o.getBundleId()) {
                return -1;
            }
            if (this.getBundleId() == o.getBundleId()) {
                return this.getIndex() - o.getIndex();
            }
        }
        return 1;
    }

    public String toString() {
        return "Config [pid=" + this.pid + ", ranking=" + this.ranking + ", bundleId=" + this.bundleId + ", index=" + this.index + ", properties=" + this.properties + ", policy=" + (Object)((Object)this.policy) + ", state=" + (Object)((Object)this.state) + "]";
    }
}

