/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.configurator.impl.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.felix.configurator.impl.model.Config;
import org.apache.felix.configurator.impl.model.ConfigState;
import org.apache.felix.configurator.impl.model.ReflectionUtil;

public class ConfigList
implements Serializable,
Iterable<Config> {
    private static final long serialVersionUID = 1L;
    private static final int VERSION = 1;
    private final List<Config> configurations = new ArrayList<Config>();
    private volatile long changeCount = -1L;
    private volatile boolean hasChanges;
    private volatile Config lastInstalled;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeObject(this.configurations);
        out.writeObject(this.lastInstalled);
        out.writeLong(this.changeCount);
        out.writeBoolean(this.hasChanges);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version < 1 || version > 1) {
            throw new ClassNotFoundException(this.getClass().getName());
        }
        ReflectionUtil.setField(this, "configurations", in.readObject());
        this.lastInstalled = (Config)in.readObject();
        this.changeCount = in.readLong();
        this.hasChanges = in.readBoolean();
    }

    public boolean hasChanges() {
        return this.hasChanges;
    }

    public void setHasChanges(boolean value) {
        this.hasChanges = this.hasChanges;
    }

    public void add(Config c) {
        this.hasChanges = true;
        this.configurations.add(c);
        Collections.sort(this.configurations);
    }

    public void addAll(ConfigList configs) {
        this.hasChanges = true;
        block0: for (Config cfg : configs) {
            for (Config current : this.configurations) {
                if (current.getBundleId() != cfg.getBundleId() || current.getRanking() != cfg.getRanking()) continue;
                if (current.getState() != ConfigState.UNINSTALL) continue block0;
                cfg.setState(ConfigState.INSTALLED);
                current.setState(ConfigState.UNINSTALLED);
                continue block0;
            }
        }
        this.configurations.addAll(configs.configurations);
        Collections.sort(this.configurations);
    }

    public int size() {
        return this.configurations.size();
    }

    @Override
    public Iterator<Config> iterator() {
        return this.configurations.iterator();
    }

    public long getChangeCount() {
        return this.changeCount;
    }

    public void setChangeCount(long value) {
        this.changeCount = value;
    }

    public Config getLastInstalled() {
        return this.lastInstalled;
    }

    public void setLastInstalled(Config lastInstalled) {
        this.lastInstalled = lastInstalled;
    }

    public void uninstall(long bundleId) {
        for (Config cfg : this.configurations) {
            if (cfg.getBundleId() != bundleId) continue;
            this.hasChanges = true;
            if (cfg.getState() == ConfigState.INSTALLED) {
                cfg.setState(ConfigState.UNINSTALL);
                continue;
            }
            cfg.setState(ConfigState.UNINSTALLED);
        }
    }

    public String toString() {
        return "ConfigList [configurations=" + this.configurations + ", changeCount=" + this.changeCount + ", hasChanges=" + this.hasChanges + ", lastInstalled=" + this.lastInstalled + "]";
    }
}

