/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.configadmin.plugin.interpolation;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.configadmin.plugin.interpolation.Activator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationPlugin;
import org.osgi.util.converter.Converters;
import org.slf4j.Logger;

class InterpolationConfigurationPlugin
implements ConfigurationPlugin {
    private static final String PREFIX = "$[";
    private static final String SUFFIX = "]";
    private static final String ENV_PREFIX = "$[env:";
    private static final Pattern ENV_PATTERN = InterpolationConfigurationPlugin.createPattern("$[env:");
    private static final String PROP_PREFIX = "$[prop:";
    private static final Pattern PROP_PATTERN = InterpolationConfigurationPlugin.createPattern("$[prop:");
    private static final String SECRET_PREFIX = "$[secret:";
    private static final Pattern SECRET_PATTERN = InterpolationConfigurationPlugin.createPattern("$[secret:");
    private static final Map<String, Class<?>> TYPE_MAP = new HashMap();
    private final BundleContext context;
    private final File directory;

    private static Pattern createPattern(String prefix) {
        return Pattern.compile("\\Q" + prefix + "\\E.+?\\Q" + SUFFIX + "\\E");
    }

    InterpolationConfigurationPlugin(BundleContext bc, String dir) {
        this.context = bc;
        if (dir != null) {
            this.directory = new File(dir);
            this.getLog().info("Configured directory for secrets: {}", (Object)dir);
        } else {
            this.directory = null;
        }
    }

    private Logger getLog() {
        return Activator.LOG;
    }

    public void modifyConfiguration(ServiceReference<?> reference, Dictionary<String, Object> properties) {
        Enumeration<String> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String sv;
            int idx;
            String key = keys.nextElement();
            Object val = properties.get(key);
            if (!(val instanceof String) || (idx = (sv = (String)val).indexOf(PREFIX)) == -1) continue;
            String varStart = sv.substring(idx);
            Object pid = properties.get("service.pid");
            Object newVal = null;
            if (varStart.startsWith(SECRET_PREFIX)) {
                newVal = this.replaceVariablesFromFile(key, sv, pid);
            } else if (varStart.startsWith(ENV_PREFIX)) {
                newVal = this.replaceVariablesFromEnvironment(key, sv, pid);
            } else if (varStart.startsWith(PROP_PREFIX)) {
                newVal = this.replaceVariablesFromProperties(key, sv, pid);
            }
            if (newVal == null || newVal.equals(sv)) continue;
            properties.put(key, newVal);
            this.getLog().info("Replaced value of configuration property '{}' for PID {}", (Object)key, pid);
        }
    }

    Object replaceVariablesFromEnvironment(String key, String value, Object pid) {
        return this.replaceVariables(ENV_PREFIX, ENV_PATTERN, key, value, pid, n -> System.getenv(n));
    }

    Object replaceVariablesFromProperties(String key, String value, Object pid) {
        return this.replaceVariables(PROP_PREFIX, PROP_PATTERN, key, value, pid, n -> this.context.getProperty(n));
    }

    Object replaceVariablesFromFile(String key, String value, Object pid) {
        if (this.directory == null) {
            this.getLog().warn("Cannot replace property value {} for PID {}. No directory configured via framework property org.apache.felix.configadmin.plugin.interpolation.dir", (Object)key, pid);
            return null;
        }
        return this.replaceVariables(SECRET_PREFIX, SECRET_PATTERN, key, value, pid, n -> {
            byte[] bytes;
            if (n.contains("..")) {
                this.getLog().error("Illegal secret location: " + n + " Going up in the directory structure is not allowed");
                return null;
            }
            File file = new File(this.directory, (String)n);
            if (!file.isFile()) {
                this.getLog().warn("Cannot replace variable. Configured path is not a regular file: " + file);
                return null;
            }
            try {
                bytes = Files.readAllBytes(file.toPath());
            }
            catch (IOException e) {
                this.getLog().error("Problem replacing configuration property '{}' for PID {} from file {}", new Object[]{key, pid, file, e});
                return null;
            }
            return new String(bytes).trim();
        });
    }

    Object replaceVariables(String prefix, Pattern pattern, String key, String value, Object pid, Function<String, String> valueSource) {
        Matcher m = pattern.matcher(value);
        StringBuffer sb = new StringBuffer();
        String type = null;
        while (m.find()) {
            Map<Object, Object> directives;
            int endIdx;
            String var = m.group();
            int len = var.length();
            int idx = var.indexOf(59);
            if (idx >= 0) {
                endIdx = idx;
                directives = this.parseDirectives(var.substring(idx, len - SUFFIX.length()));
            } else {
                endIdx = len - SUFFIX.length();
                directives = Collections.emptyMap();
            }
            String varName = var.substring(prefix.length(), endIdx);
            String replacement = valueSource.apply(varName);
            if (replacement != null) {
                m.appendReplacement(sb, Matcher.quoteReplacement(replacement));
            } else {
                String defVal = (String)directives.get("default");
                if (defVal != null) {
                    m.appendReplacement(sb, Matcher.quoteReplacement(defVal));
                }
            }
            type = (String)directives.get("type");
        }
        m.appendTail(sb);
        return this.convertType(type, sb.toString());
    }

    private Map<String, String> parseDirectives(String dirString) {
        HashMap<String, String> dirs = new HashMap<String, String>();
        for (String dir : dirString.split(";")) {
            String[] kv = dir.split("=");
            if (kv.length != 2) continue;
            dirs.put(kv[0], kv[1]);
        }
        return dirs;
    }

    private Object convertType(String type, String s) {
        if (type == null) {
            return s;
        }
        Class<?> cls = TYPE_MAP.get(type);
        if (cls != null) {
            return Converters.standardConverter().convert((Object)s).to(cls);
        }
        this.getLog().warn("Cannot convert to type: " + type);
        return s;
    }

    static {
        TYPE_MAP.put("String", String.class);
        TYPE_MAP.put("Integer", Integer.class);
        TYPE_MAP.put("int", Integer.class);
        TYPE_MAP.put("Long", Long.class);
        TYPE_MAP.put("long", Long.class);
        TYPE_MAP.put("Float", Float.class);
        TYPE_MAP.put("float", Float.class);
        TYPE_MAP.put("Double", Double.class);
        TYPE_MAP.put("double", Double.class);
        TYPE_MAP.put("Byte", Byte.class);
        TYPE_MAP.put("byte", Byte.class);
        TYPE_MAP.put("Short", Short.class);
        TYPE_MAP.put("short", Short.class);
        TYPE_MAP.put("Character", Character.class);
        TYPE_MAP.put("char", Character.class);
        TYPE_MAP.put("Boolean", Boolean.class);
        TYPE_MAP.put("boolean", Boolean.class);
        TYPE_MAP.put("String[]", String[].class);
        TYPE_MAP.put("Integer[]", Integer[].class);
        TYPE_MAP.put("int[]", int[].class);
        TYPE_MAP.put("Long[]", Long[].class);
        TYPE_MAP.put("long[]", long[].class);
        TYPE_MAP.put("Float[]", Float[].class);
        TYPE_MAP.put("float[]", float[].class);
        TYPE_MAP.put("Double[]", Double[].class);
        TYPE_MAP.put("double[]", double[].class);
        TYPE_MAP.put("Byte[]", Byte[].class);
        TYPE_MAP.put("byte[]", byte[].class);
        TYPE_MAP.put("Short[]", Short[].class);
        TYPE_MAP.put("short[]", short[].class);
        TYPE_MAP.put("Boolean[]", Boolean[].class);
        TYPE_MAP.put("boolean[]", boolean[].class);
        TYPE_MAP.put("Character[]", Character[].class);
        TYPE_MAP.put("char[]", char[].class);
    }
}

