/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.json.impl;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.apache.felix.cm.json.ConfigurationReader;
import org.apache.felix.cm.json.ConfigurationResource;
import org.apache.felix.cm.json.Configurations;
import org.apache.felix.cm.json.impl.JsonSupport;
import org.apache.felix.cm.json.impl.TypeConverter;
import org.osgi.util.converter.Converters;
import org.osgi.util.converter.Converting;

public class ConfigurationReaderImpl
implements ConfigurationReader,
ConfigurationReader.Builder {
    private boolean closed = false;
    private Reader reader;
    private JsonObject jsonObject;
    private boolean verifyAsBundleResource = false;
    private String identifier;
    private final List<String> errors = new ArrayList<String>();
    private ConfigurationReader.BinaryHandler binaryHandler;
    private ConfigurationReader.ConfiguratorPropertyHandler propertyHandler;

    @Override
    public ConfigurationReader.Builder verifyAsBundleResource(boolean flag) {
        this.verifyAsBundleResource = flag;
        return this;
    }

    @Override
    public ConfigurationReader.Builder withIdentifier(String value) {
        this.identifier = value;
        return this;
    }

    @Override
    public ConfigurationReader.Builder withBinaryHandler(ConfigurationReader.BinaryHandler handler) {
        this.binaryHandler = handler;
        return this;
    }

    @Override
    public ConfigurationReader.Builder withConfiguratorPropertyHandler(ConfigurationReader.ConfiguratorPropertyHandler handler) {
        this.propertyHandler = handler;
        return this;
    }

    @Override
    public ConfigurationReader build(Reader reader) {
        this.reader = reader;
        return this;
    }

    @Override
    public ConfigurationReader build(JsonObject object) {
        this.jsonObject = object;
        return this;
    }

    @Override
    public List<String> getIgnoredErrors() {
        return this.errors;
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            this.throwIOException("Reader already closed");
        }
        this.closed = true;
    }

    @Override
    public Hashtable<String, Object> readConfiguration() throws IOException {
        this.checkClosed();
        if (this.reader != null) {
            try {
                this.jsonObject = JsonSupport.parseJson(this.identifier, this.reader);
            }
            catch (JsonException jpe) {
                throw new IOException("Invalid JSON " + jpe.getMessage(), jpe);
            }
        }
        return this.readSingleConfiguration("<configuration>", this.jsonObject);
    }

    @Override
    public ConfigurationResource readConfigurationResource() throws IOException {
        this.checkClosed();
        if (this.reader != null) {
            try {
                this.jsonObject = JsonSupport.parseJson(this.identifier, this.reader);
            }
            catch (JsonException jpe) {
                throw new IOException("Invalid JSON " + jpe.getMessage(), jpe);
            }
        }
        this.verifyJsonResource();
        ConfigurationResource resource = new ConfigurationResource();
        for (Map.Entry entry : this.jsonObject.entrySet()) {
            if (((String)entry.getKey()).startsWith(":configurator:")) {
                resource.getProperties().put((String)entry.getKey(), JsonSupport.convertToObject((JsonValue)entry.getValue()));
                continue;
            }
            if (((JsonValue)entry.getValue()).getValueType() != JsonValue.ValueType.OBJECT) {
                this.addError("Ignoring property (not a configuration) : ".concat((String)entry.getKey()));
                resource.getProperties().put((String)entry.getKey(), JsonSupport.convertToObject((JsonValue)entry.getValue()));
                continue;
            }
            Hashtable<String, Object> properties = this.readSingleConfiguration((String)entry.getKey(), ((JsonValue)entry.getValue()).asJsonObject());
            if (properties == null) continue;
            resource.getConfigurations().put((String)entry.getKey(), properties);
        }
        return resource;
    }

    private void addError(String msg) {
        if (this.identifier == null) {
            this.errors.add(msg);
        } else {
            this.errors.add(this.identifier.concat(" : ").concat(msg));
        }
    }

    private void throwIOException(String msg) throws IOException {
        if (this.identifier == null) {
            throw new IOException(msg);
        }
        throw new IOException(this.identifier.concat(" : ").concat(msg));
    }

    private void verifyJsonResource() throws IOException {
        Object version = JsonSupport.convertToObject((JsonValue)this.jsonObject.get((Object)":configurator:resource-version"));
        if (version != null) {
            int v = (Integer)((Converting)Converters.standardConverter().convert(version).defaultValue((Object)-1)).to(Integer.class);
            if (v == -1) {
                this.throwIOException("Invalid resource version information : ".concat(version.toString()));
            }
            if (v != 1) {
                this.throwIOException("Unknown resource version : ".concat(version.toString()));
            }
        }
        if (!this.verifyAsBundleResource) {
            Object rsrcName;
            Object rsrcVersion = JsonSupport.convertToObject((JsonValue)this.jsonObject.get((Object)":configurator:version"));
            if (rsrcVersion == null) {
                this.throwIOException("Missing version information");
            }
            if (!(rsrcVersion instanceof String)) {
                this.throwIOException("Invalid version information : ".concat(rsrcVersion.toString()));
            }
            if ((rsrcName = JsonSupport.convertToObject((JsonValue)this.jsonObject.get((Object)":configurator:symbolic-name"))) == null) {
                this.throwIOException("Missing symbolic name information");
            }
            if (!(rsrcName instanceof String)) {
                this.throwIOException("Invalid symbolic name information : ".concat(rsrcVersion.toString()));
            }
        }
    }

    private Hashtable<String, Object> readSingleConfiguration(String pid, JsonObject propertyMap) throws IOException {
        Hashtable<String, Object> properties = Configurations.newConfiguration();
        boolean valid = true;
        for (Map.Entry propEntry : propertyMap.entrySet()) {
            String mapKey = (String)propEntry.getKey();
            KeyInfo keyInfo = new KeyInfo(mapKey);
            if (keyInfo.isBinary) {
                if (!this.verifyAsBundleResource) {
                    this.throwIOException("PID ".concat(pid).concat(" : Properties of type binary not allowed for non bundle resource : ").concat(keyInfo.propertyKey));
                }
                if (this.binaryHandler == null) {
                    this.throwIOException("PID ".concat(pid).concat(" : No handler configured for binary property : ").concat(keyInfo.propertyKey));
                }
                if (keyInfo.isInternal) {
                    this.throwIOException("PID ".concat(pid).concat(" : Binary values are not allowed for configurator properties : ").concat(keyInfo.propertyKey));
                }
            }
            if (keyInfo.isInternal) {
                Object value = JsonSupport.convertToObject((JsonValue)propEntry.getValue());
                if (this.propertyHandler == null) {
                    properties.put(keyInfo.propertyKey, value);
                    continue;
                }
                this.propertyHandler.handleConfiguratorProperty(pid, keyInfo.propertyKey, value);
                continue;
            }
            Object convertedVal = TypeConverter.convertObjectToType((JsonValue)propEntry.getValue(), keyInfo.typeInfo);
            if (convertedVal == TypeConverter.CONVERSION_FAILED) {
                String msg = "PID ".concat(pid).concat(" : Invalid value/type for configuration : ").concat(mapKey).concat(" : ").concat(((JsonValue)propEntry.getValue()).toString());
                if (!this.verifyAsBundleResource) {
                    this.throwIOException(msg);
                }
                this.addError(msg);
                valid = false;
                break;
            }
            if (keyInfo.isBinary) {
                if (convertedVal instanceof String) {
                    String path = (String)convertedVal;
                    convertedVal = this.binaryHandler.handleBinaryValue(pid, keyInfo.propertyKey, path);
                } else {
                    String[] array;
                    String[] paths = convertedVal;
                    convertedVal = array = new String[paths.length];
                    for (int i = 0; i < paths.length; ++i) {
                        array[i] = this.binaryHandler.handleBinaryValue(pid, keyInfo.propertyKey, paths[i]);
                        if (array[i] != null) continue;
                        convertedVal = null;
                    }
                }
            }
            if (convertedVal == null) {
                valid = false;
                continue;
            }
            properties.put(keyInfo.propertyKey, convertedVal);
        }
        return valid ? properties : null;
    }

    public static final class KeyInfo {
        public final String propertyKey;
        public final String typeInfo;
        public final boolean isInternal;
        public final boolean isBinary;

        public KeyInfo(String mapKey) {
            this.isInternal = mapKey.startsWith(":configurator:");
            String key = mapKey;
            if (this.isInternal) {
                key = key.substring(":configurator:".length());
            }
            int pos = key.indexOf(58);
            String typeInfo = null;
            if (pos != -1) {
                typeInfo = key.substring(pos + 1);
                key = key.substring(0, pos);
            }
            this.propertyKey = key;
            this.typeInfo = typeInfo;
            this.isBinary = "binary".equals(typeInfo) || "binary[]".equals(typeInfo);
        }
    }
}

