/*
* Licensed to the Apache Software Foundation (ASF) under one
* or more contributor license agreements.  See the NOTICE file
* distributed with this work for additional information
* regarding copyright ownership.  The ASF licenses this file
* to you under the Apache License, Version 2.0 (the
* "License"); you may not use this file except in compliance
* with the License.  You may obtain a copy of the License at
*
*   http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing,
* software distributed under the License is distributed on an
* "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
* KIND, either express or implied.  See the License for the
* specific language governing permissions and limitations
* under the License.
*/

export {install as GridSimpleComponent} from '../component/grid/installSimple';
export {install as GridComponent} from '../component/grid/install';

export {install as PolarComponent} from '../component/polar/install';
export {install as RadarComponent} from '../component/radar/install';

export {install as GeoComponent} from '../component/geo/install';

export {install as SingleAxisComponent} from '../component/singleAxis/install';
export {install as ParallelComponent} from '../component/parallel/install';
export {install as CalendarComponent} from '../component/calendar/install';

export {install as GraphicComponent} from '../component/graphic/install';

export {install as ToolboxComponent} from '../component/toolbox/install';

export {install as TooltipComponent} from '../component/tooltip/install';

export {install as AxisPointerComponent} from '../component/axisPointer/install';
export {install as BrushComponent} from '../component/brush/install';
export {install as TitleComponent} from '../component/title/install';
export {install as TimelineComponent} from '../component/timeline/install';
export {install as MarkPointComponent} from '../component/marker/installMarkPoint';
export {install as MarkLineComponent} from '../component/marker/installMarkLine';
export {install as MarkAreaComponent} from '../component/marker/installMarkArea';

export {install as LegendComponent} from '../component/legend/install';
export {install as LegendScrollComponent} from '../component/legend/installLegendScroll';
export {install as LegendPlainComponent} from '../component/legend/installLegendPlain';

export {install as DataZoomComponent} from '../component/dataZoom/install';
export {install as DataZoomInsideComponent} from '../component/dataZoom/installDataZoomInside';
export {install as DataZoomSliderComponent} from '../component/dataZoom/installDataZoomSlider';

export {install as VisualMapComponent} from '../component/visualMap/install';

export {install as VisualMapContinuousComponent} from '../component/visualMap/installVisualMapContinuous';

export {install as VisualMapPiecewiseComponent} from '../component/visualMap/installVisualMapPiecewise';

export {install as AriaComponent} from '../component/aria/install';

export {install as TransformComponent} from '../component/transform/install';

export {install as DatasetComponent} from '../component/dataset/install';



export {
    GridComponentOption,

    PolarComponentOption,

    RadarComponentOption,

    GeoComponentOption,

    SingleAxisComponentOption,
    ParallelComponentOption,
    CalendarComponentOption,

    GraphicComponentOption,

    ToolboxComponentOption,

    TooltipComponentOption,

    AxisPointerComponentOption,
    BrushComponentOption,
    TitleComponentOption,
    TimelineComponentOption,
    MarkPointComponentOption,
    MarkLineComponentOption,
    MarkAreaComponentOption,

    LegendComponentOption,

    DataZoomComponentOption,

    VisualMapComponentOption,

    AriaComponentOption,

    DatasetComponentOption
} from './option';

