/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.dubbo.metrics.metrics.service;

import org.apache.dubbo.metrics.model.MetricsCategory;
import org.apache.dubbo.metrics.service.MetricsEntity;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

import java.util.HashMap;
import java.util.Map;

class MetricsEntityTest {

    private static String name;
    private static Map<String, String> tags;
    private static MetricsCategory category;
    private static Object value;

    @BeforeAll
    public static void setup() {
        name = "test";
        tags = new HashMap<>();
        category = MetricsCategory.REQUESTS;
        value = 1;
    }

    @Test
    void test() {
        MetricsEntity entity = new MetricsEntity(name, tags, category, value);
        Assertions.assertEquals(entity.getName(), name);
        Assertions.assertEquals(entity.getTags(), tags);
        Assertions.assertEquals(entity.getCategory(), category);
        Assertions.assertEquals(entity.getValue(), value);
    }
}
