/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.alibaba.dubbo.common.version;


import com.alibaba.dubbo.common.Version;
import org.junit.Assert;
import org.junit.Test;

public class VersionTest {

    @Test
    public void testGetProtocolVersion() {
        Assert.assertEquals(Version.getProtocolVersion(), Version.DEFAULT_DUBBO_PROTOCOL_VERSION);
    }

    @Test
    public void testSupportResponseAttatchment() {
        Assert.assertTrue(Version.isSupportResponseAttatchment("2.0.2"));
        Assert.assertTrue(Version.isSupportResponseAttatchment("2.0.3"));
        Assert.assertFalse(Version.isSupportResponseAttatchment("2.0.0"));
        Assert.assertFalse(Version.isSupportResponseAttatchment("1.0.0"));
        Assert.assertTrue(Version.isSupportResponseAttatchment("2.6.6-stable"));

        Assert.assertFalse(Version.isSupportResponseAttatchment("2.0.contains"));
        Assert.assertFalse(Version.isSupportResponseAttatchment("version.string"));
        Assert.assertFalse(Version.isSupportResponseAttatchment("prefix2.0"));
    }
}
