/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.drill.exec.server.rest;

import org.apache.drill.exec.ExecConstants;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;

/**
 * Quick-and-dirty tool to run the Web UI for debugging without having
 * to wait or a full build to run using {@code drillbit.sh}.
 */
public class InteractiveUI extends ClusterTest {

  public static void main(String[] args) {
    ClusterFixtureBuilder builder = new ClusterFixtureBuilder();
    builder.configBuilder().put(ExecConstants.HTTP_ENABLE, true);
    try {
      startCluster(builder);
      while (true) {
        Thread.sleep(1000);
      }
    } catch (Exception e) {
      // TODO Auto-generated catch block
      e.printStackTrace();
    }
  }
}
