/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: BitData.proto

package org.apache.drill.exec.proto;

public final class BitData {
  private BitData() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  /**
   * Protobuf enum {@code exec.bit.data.RpcType}
   */
  public enum RpcType
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>HANDSHAKE = 0;</code>
     */
    HANDSHAKE(0),
    /**
     * <code>ACK = 1;</code>
     */
    ACK(1),
    /**
     * <code>GOODBYE = 2;</code>
     */
    GOODBYE(2),
    /**
     * <pre>
     * send record batch, returns Ack
     * </pre>
     *
     * <code>REQ_RECORD_BATCH = 3;</code>
     */
    REQ_RECORD_BATCH(3),
    /**
     * <pre>
     * both bit request and response
     * </pre>
     *
     * <code>SASL_MESSAGE = 4;</code>
     */
    SASL_MESSAGE(4),
    /**
     * <pre>
     * send runtime filter data from HashJoin to Foreman, from Foreman to Scan nodes.
     * </pre>
     *
     * <code>REQ_RUNTIME_FILTER = 5;</code>
     */
    REQ_RUNTIME_FILTER(5),
    ;

    /**
     * <code>HANDSHAKE = 0;</code>
     */
    public static final int HANDSHAKE_VALUE = 0;
    /**
     * <code>ACK = 1;</code>
     */
    public static final int ACK_VALUE = 1;
    /**
     * <code>GOODBYE = 2;</code>
     */
    public static final int GOODBYE_VALUE = 2;
    /**
     * <pre>
     * send record batch, returns Ack
     * </pre>
     *
     * <code>REQ_RECORD_BATCH = 3;</code>
     */
    public static final int REQ_RECORD_BATCH_VALUE = 3;
    /**
     * <pre>
     * both bit request and response
     * </pre>
     *
     * <code>SASL_MESSAGE = 4;</code>
     */
    public static final int SASL_MESSAGE_VALUE = 4;
    /**
     * <pre>
     * send runtime filter data from HashJoin to Foreman, from Foreman to Scan nodes.
     * </pre>
     *
     * <code>REQ_RUNTIME_FILTER = 5;</code>
     */
    public static final int REQ_RUNTIME_FILTER_VALUE = 5;


    public final int getNumber() {
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RpcType valueOf(int value) {
      return forNumber(value);
    }

    public static RpcType forNumber(int value) {
      switch (value) {
        case 0: return HANDSHAKE;
        case 1: return ACK;
        case 2: return GOODBYE;
        case 3: return REQ_RECORD_BATCH;
        case 4: return SASL_MESSAGE;
        case 5: return REQ_RUNTIME_FILTER;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RpcType>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        RpcType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<RpcType>() {
            public RpcType findValueByNumber(int number) {
              return RpcType.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.BitData.getDescriptor().getEnumTypes().get(0);
    }

    private static final RpcType[] VALUES = values();

    public static RpcType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RpcType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:exec.bit.data.RpcType)
  }

  public interface BitClientHandshakeOrBuilder extends
      // @@protoc_insertion_point(interface_extends:exec.bit.data.BitClientHandshake)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional int32 rpc_version = 1;</code>
     */
    boolean hasRpcVersion();
    /**
     * <code>optional int32 rpc_version = 1;</code>
     */
    int getRpcVersion();

    /**
     * <code>optional .exec.shared.RpcChannel channel = 2 [default = BIT_DATA];</code>
     */
    boolean hasChannel();
    /**
     * <code>optional .exec.shared.RpcChannel channel = 2 [default = BIT_DATA];</code>
     */
    org.apache.drill.exec.proto.UserBitShared.RpcChannel getChannel();
  }
  /**
   * Protobuf type {@code exec.bit.data.BitClientHandshake}
   */
  public  static final class BitClientHandshake extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:exec.bit.data.BitClientHandshake)
      BitClientHandshakeOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use BitClientHandshake.newBuilder() to construct.
    private BitClientHandshake(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private BitClientHandshake() {
      rpcVersion_ = 0;
      channel_ = 1;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private BitClientHandshake(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8: {
              bitField0_ |= 0x00000001;
              rpcVersion_ = input.readInt32();
              break;
            }
            case 16: {
              int rawValue = input.readEnum();
                @SuppressWarnings("deprecation")
              org.apache.drill.exec.proto.UserBitShared.RpcChannel value = org.apache.drill.exec.proto.UserBitShared.RpcChannel.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(2, rawValue);
              } else {
                bitField0_ |= 0x00000002;
                channel_ = rawValue;
              }
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.BitData.internal_static_exec_bit_data_BitClientHandshake_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.BitData.internal_static_exec_bit_data_BitClientHandshake_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.BitData.BitClientHandshake.class, org.apache.drill.exec.proto.BitData.BitClientHandshake.Builder.class);
    }

    private int bitField0_;
    public static final int RPC_VERSION_FIELD_NUMBER = 1;
    private int rpcVersion_;
    /**
     * <code>optional int32 rpc_version = 1;</code>
     */
    public boolean hasRpcVersion() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional int32 rpc_version = 1;</code>
     */
    public int getRpcVersion() {
      return rpcVersion_;
    }

    public static final int CHANNEL_FIELD_NUMBER = 2;
    private int channel_;
    /**
     * <code>optional .exec.shared.RpcChannel channel = 2 [default = BIT_DATA];</code>
     */
    public boolean hasChannel() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional .exec.shared.RpcChannel channel = 2 [default = BIT_DATA];</code>
     */
    public org.apache.drill.exec.proto.UserBitShared.RpcChannel getChannel() {
      @SuppressWarnings("deprecation")
      org.apache.drill.exec.proto.UserBitShared.RpcChannel result = org.apache.drill.exec.proto.UserBitShared.RpcChannel.valueOf(channel_);
      return result == null ? org.apache.drill.exec.proto.UserBitShared.RpcChannel.BIT_DATA : result;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeInt32(1, rpcVersion_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeEnum(2, channel_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(1, rpcVersion_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(2, channel_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.drill.exec.proto.BitData.BitClientHandshake)) {
        return super.equals(obj);
      }
      org.apache.drill.exec.proto.BitData.BitClientHandshake other = (org.apache.drill.exec.proto.BitData.BitClientHandshake) obj;

      boolean result = true;
      result = result && (hasRpcVersion() == other.hasRpcVersion());
      if (hasRpcVersion()) {
        result = result && (getRpcVersion()
            == other.getRpcVersion());
      }
      result = result && (hasChannel() == other.hasChannel());
      if (hasChannel()) {
        result = result && channel_ == other.channel_;
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasRpcVersion()) {
        hash = (37 * hash) + RPC_VERSION_FIELD_NUMBER;
        hash = (53 * hash) + getRpcVersion();
      }
      if (hasChannel()) {
        hash = (37 * hash) + CHANNEL_FIELD_NUMBER;
        hash = (53 * hash) + channel_;
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.drill.exec.proto.BitData.BitClientHandshake parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.BitData.BitClientHandshake parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitData.BitClientHandshake parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.BitData.BitClientHandshake parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitData.BitClientHandshake parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.BitData.BitClientHandshake parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitData.BitClientHandshake parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.BitData.BitClientHandshake parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitData.BitClientHandshake parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.BitData.BitClientHandshake parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitData.BitClientHandshake parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.BitData.BitClientHandshake parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.drill.exec.proto.BitData.BitClientHandshake prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.bit.data.BitClientHandshake}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:exec.bit.data.BitClientHandshake)
        org.apache.drill.exec.proto.BitData.BitClientHandshakeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.BitData.internal_static_exec_bit_data_BitClientHandshake_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.BitData.internal_static_exec_bit_data_BitClientHandshake_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.BitData.BitClientHandshake.class, org.apache.drill.exec.proto.BitData.BitClientHandshake.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.BitData.BitClientHandshake.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        rpcVersion_ = 0;
        bitField0_ = (bitField0_ & ~0x00000001);
        channel_ = 1;
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.BitData.internal_static_exec_bit_data_BitClientHandshake_descriptor;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.BitData.BitClientHandshake getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.BitData.BitClientHandshake.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.BitData.BitClientHandshake build() {
        org.apache.drill.exec.proto.BitData.BitClientHandshake result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.BitData.BitClientHandshake buildPartial() {
        org.apache.drill.exec.proto.BitData.BitClientHandshake result = new org.apache.drill.exec.proto.BitData.BitClientHandshake(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.rpcVersion_ = rpcVersion_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.channel_ = channel_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.BitData.BitClientHandshake) {
          return mergeFrom((org.apache.drill.exec.proto.BitData.BitClientHandshake)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.BitData.BitClientHandshake other) {
        if (other == org.apache.drill.exec.proto.BitData.BitClientHandshake.getDefaultInstance()) return this;
        if (other.hasRpcVersion()) {
          setRpcVersion(other.getRpcVersion());
        }
        if (other.hasChannel()) {
          setChannel(other.getChannel());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.BitData.BitClientHandshake parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.BitData.BitClientHandshake) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private int rpcVersion_ ;
      /**
       * <code>optional int32 rpc_version = 1;</code>
       */
      public boolean hasRpcVersion() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional int32 rpc_version = 1;</code>
       */
      public int getRpcVersion() {
        return rpcVersion_;
      }
      /**
       * <code>optional int32 rpc_version = 1;</code>
       */
      public Builder setRpcVersion(int value) {
        bitField0_ |= 0x00000001;
        rpcVersion_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 rpc_version = 1;</code>
       */
      public Builder clearRpcVersion() {
        bitField0_ = (bitField0_ & ~0x00000001);
        rpcVersion_ = 0;
        onChanged();
        return this;
      }

      private int channel_ = 1;
      /**
       * <code>optional .exec.shared.RpcChannel channel = 2 [default = BIT_DATA];</code>
       */
      public boolean hasChannel() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional .exec.shared.RpcChannel channel = 2 [default = BIT_DATA];</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.RpcChannel getChannel() {
        @SuppressWarnings("deprecation")
        org.apache.drill.exec.proto.UserBitShared.RpcChannel result = org.apache.drill.exec.proto.UserBitShared.RpcChannel.valueOf(channel_);
        return result == null ? org.apache.drill.exec.proto.UserBitShared.RpcChannel.BIT_DATA : result;
      }
      /**
       * <code>optional .exec.shared.RpcChannel channel = 2 [default = BIT_DATA];</code>
       */
      public Builder setChannel(org.apache.drill.exec.proto.UserBitShared.RpcChannel value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        channel_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <code>optional .exec.shared.RpcChannel channel = 2 [default = BIT_DATA];</code>
       */
      public Builder clearChannel() {
        bitField0_ = (bitField0_ & ~0x00000002);
        channel_ = 1;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:exec.bit.data.BitClientHandshake)
    }

    // @@protoc_insertion_point(class_scope:exec.bit.data.BitClientHandshake)
    private static final org.apache.drill.exec.proto.BitData.BitClientHandshake DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.drill.exec.proto.BitData.BitClientHandshake();
    }

    public static org.apache.drill.exec.proto.BitData.BitClientHandshake getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<BitClientHandshake>
        PARSER = new com.google.protobuf.AbstractParser<BitClientHandshake>() {
      @java.lang.Override
      public BitClientHandshake parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new BitClientHandshake(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<BitClientHandshake> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BitClientHandshake> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.drill.exec.proto.BitData.BitClientHandshake getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface BitServerHandshakeOrBuilder extends
      // @@protoc_insertion_point(interface_extends:exec.bit.data.BitServerHandshake)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional int32 rpc_version = 1;</code>
     */
    boolean hasRpcVersion();
    /**
     * <code>optional int32 rpc_version = 1;</code>
     */
    int getRpcVersion();

    /**
     * <code>repeated string authenticationMechanisms = 2;</code>
     */
    java.util.List<java.lang.String>
        getAuthenticationMechanismsList();
    /**
     * <code>repeated string authenticationMechanisms = 2;</code>
     */
    int getAuthenticationMechanismsCount();
    /**
     * <code>repeated string authenticationMechanisms = 2;</code>
     */
    java.lang.String getAuthenticationMechanisms(int index);
    /**
     * <code>repeated string authenticationMechanisms = 2;</code>
     */
    com.google.protobuf.ByteString
        getAuthenticationMechanismsBytes(int index);
  }
  /**
   * Protobuf type {@code exec.bit.data.BitServerHandshake}
   */
  public  static final class BitServerHandshake extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:exec.bit.data.BitServerHandshake)
      BitServerHandshakeOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use BitServerHandshake.newBuilder() to construct.
    private BitServerHandshake(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private BitServerHandshake() {
      rpcVersion_ = 0;
      authenticationMechanisms_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private BitServerHandshake(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8: {
              bitField0_ |= 0x00000001;
              rpcVersion_ = input.readInt32();
              break;
            }
            case 18: {
              com.google.protobuf.ByteString bs = input.readBytes();
              if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
                authenticationMechanisms_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000002;
              }
              authenticationMechanisms_.add(bs);
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
          authenticationMechanisms_ = authenticationMechanisms_.getUnmodifiableView();
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.BitData.internal_static_exec_bit_data_BitServerHandshake_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.BitData.internal_static_exec_bit_data_BitServerHandshake_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.BitData.BitServerHandshake.class, org.apache.drill.exec.proto.BitData.BitServerHandshake.Builder.class);
    }

    private int bitField0_;
    public static final int RPC_VERSION_FIELD_NUMBER = 1;
    private int rpcVersion_;
    /**
     * <code>optional int32 rpc_version = 1;</code>
     */
    public boolean hasRpcVersion() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional int32 rpc_version = 1;</code>
     */
    public int getRpcVersion() {
      return rpcVersion_;
    }

    public static final int AUTHENTICATIONMECHANISMS_FIELD_NUMBER = 2;
    private com.google.protobuf.LazyStringList authenticationMechanisms_;
    /**
     * <code>repeated string authenticationMechanisms = 2;</code>
     */
    public com.google.protobuf.ProtocolStringList
        getAuthenticationMechanismsList() {
      return authenticationMechanisms_;
    }
    /**
     * <code>repeated string authenticationMechanisms = 2;</code>
     */
    public int getAuthenticationMechanismsCount() {
      return authenticationMechanisms_.size();
    }
    /**
     * <code>repeated string authenticationMechanisms = 2;</code>
     */
    public java.lang.String getAuthenticationMechanisms(int index) {
      return authenticationMechanisms_.get(index);
    }
    /**
     * <code>repeated string authenticationMechanisms = 2;</code>
     */
    public com.google.protobuf.ByteString
        getAuthenticationMechanismsBytes(int index) {
      return authenticationMechanisms_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeInt32(1, rpcVersion_);
      }
      for (int i = 0; i < authenticationMechanisms_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, authenticationMechanisms_.getRaw(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(1, rpcVersion_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < authenticationMechanisms_.size(); i++) {
          dataSize += computeStringSizeNoTag(authenticationMechanisms_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getAuthenticationMechanismsList().size();
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.drill.exec.proto.BitData.BitServerHandshake)) {
        return super.equals(obj);
      }
      org.apache.drill.exec.proto.BitData.BitServerHandshake other = (org.apache.drill.exec.proto.BitData.BitServerHandshake) obj;

      boolean result = true;
      result = result && (hasRpcVersion() == other.hasRpcVersion());
      if (hasRpcVersion()) {
        result = result && (getRpcVersion()
            == other.getRpcVersion());
      }
      result = result && getAuthenticationMechanismsList()
          .equals(other.getAuthenticationMechanismsList());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasRpcVersion()) {
        hash = (37 * hash) + RPC_VERSION_FIELD_NUMBER;
        hash = (53 * hash) + getRpcVersion();
      }
      if (getAuthenticationMechanismsCount() > 0) {
        hash = (37 * hash) + AUTHENTICATIONMECHANISMS_FIELD_NUMBER;
        hash = (53 * hash) + getAuthenticationMechanismsList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.drill.exec.proto.BitData.BitServerHandshake parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.BitData.BitServerHandshake parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitData.BitServerHandshake parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.BitData.BitServerHandshake parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitData.BitServerHandshake parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.BitData.BitServerHandshake parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitData.BitServerHandshake parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.BitData.BitServerHandshake parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitData.BitServerHandshake parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.BitData.BitServerHandshake parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitData.BitServerHandshake parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.BitData.BitServerHandshake parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.drill.exec.proto.BitData.BitServerHandshake prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.bit.data.BitServerHandshake}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:exec.bit.data.BitServerHandshake)
        org.apache.drill.exec.proto.BitData.BitServerHandshakeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.BitData.internal_static_exec_bit_data_BitServerHandshake_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.BitData.internal_static_exec_bit_data_BitServerHandshake_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.BitData.BitServerHandshake.class, org.apache.drill.exec.proto.BitData.BitServerHandshake.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.BitData.BitServerHandshake.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        rpcVersion_ = 0;
        bitField0_ = (bitField0_ & ~0x00000001);
        authenticationMechanisms_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.BitData.internal_static_exec_bit_data_BitServerHandshake_descriptor;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.BitData.BitServerHandshake getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.BitData.BitServerHandshake.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.BitData.BitServerHandshake build() {
        org.apache.drill.exec.proto.BitData.BitServerHandshake result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.BitData.BitServerHandshake buildPartial() {
        org.apache.drill.exec.proto.BitData.BitServerHandshake result = new org.apache.drill.exec.proto.BitData.BitServerHandshake(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.rpcVersion_ = rpcVersion_;
        if (((bitField0_ & 0x00000002) == 0x00000002)) {
          authenticationMechanisms_ = authenticationMechanisms_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.authenticationMechanisms_ = authenticationMechanisms_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.BitData.BitServerHandshake) {
          return mergeFrom((org.apache.drill.exec.proto.BitData.BitServerHandshake)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.BitData.BitServerHandshake other) {
        if (other == org.apache.drill.exec.proto.BitData.BitServerHandshake.getDefaultInstance()) return this;
        if (other.hasRpcVersion()) {
          setRpcVersion(other.getRpcVersion());
        }
        if (!other.authenticationMechanisms_.isEmpty()) {
          if (authenticationMechanisms_.isEmpty()) {
            authenticationMechanisms_ = other.authenticationMechanisms_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureAuthenticationMechanismsIsMutable();
            authenticationMechanisms_.addAll(other.authenticationMechanisms_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.BitData.BitServerHandshake parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.BitData.BitServerHandshake) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private int rpcVersion_ ;
      /**
       * <code>optional int32 rpc_version = 1;</code>
       */
      public boolean hasRpcVersion() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional int32 rpc_version = 1;</code>
       */
      public int getRpcVersion() {
        return rpcVersion_;
      }
      /**
       * <code>optional int32 rpc_version = 1;</code>
       */
      public Builder setRpcVersion(int value) {
        bitField0_ |= 0x00000001;
        rpcVersion_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 rpc_version = 1;</code>
       */
      public Builder clearRpcVersion() {
        bitField0_ = (bitField0_ & ~0x00000001);
        rpcVersion_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList authenticationMechanisms_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensureAuthenticationMechanismsIsMutable() {
        if (!((bitField0_ & 0x00000002) == 0x00000002)) {
          authenticationMechanisms_ = new com.google.protobuf.LazyStringArrayList(authenticationMechanisms_);
          bitField0_ |= 0x00000002;
         }
      }
      /**
       * <code>repeated string authenticationMechanisms = 2;</code>
       */
      public com.google.protobuf.ProtocolStringList
          getAuthenticationMechanismsList() {
        return authenticationMechanisms_.getUnmodifiableView();
      }
      /**
       * <code>repeated string authenticationMechanisms = 2;</code>
       */
      public int getAuthenticationMechanismsCount() {
        return authenticationMechanisms_.size();
      }
      /**
       * <code>repeated string authenticationMechanisms = 2;</code>
       */
      public java.lang.String getAuthenticationMechanisms(int index) {
        return authenticationMechanisms_.get(index);
      }
      /**
       * <code>repeated string authenticationMechanisms = 2;</code>
       */
      public com.google.protobuf.ByteString
          getAuthenticationMechanismsBytes(int index) {
        return authenticationMechanisms_.getByteString(index);
      }
      /**
       * <code>repeated string authenticationMechanisms = 2;</code>
       */
      public Builder setAuthenticationMechanisms(
          int index, java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureAuthenticationMechanismsIsMutable();
        authenticationMechanisms_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string authenticationMechanisms = 2;</code>
       */
      public Builder addAuthenticationMechanisms(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureAuthenticationMechanismsIsMutable();
        authenticationMechanisms_.add(value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string authenticationMechanisms = 2;</code>
       */
      public Builder addAllAuthenticationMechanisms(
          java.lang.Iterable<java.lang.String> values) {
        ensureAuthenticationMechanismsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, authenticationMechanisms_);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string authenticationMechanisms = 2;</code>
       */
      public Builder clearAuthenticationMechanisms() {
        authenticationMechanisms_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string authenticationMechanisms = 2;</code>
       */
      public Builder addAuthenticationMechanismsBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureAuthenticationMechanismsIsMutable();
        authenticationMechanisms_.add(value);
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:exec.bit.data.BitServerHandshake)
    }

    // @@protoc_insertion_point(class_scope:exec.bit.data.BitServerHandshake)
    private static final org.apache.drill.exec.proto.BitData.BitServerHandshake DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.drill.exec.proto.BitData.BitServerHandshake();
    }

    public static org.apache.drill.exec.proto.BitData.BitServerHandshake getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<BitServerHandshake>
        PARSER = new com.google.protobuf.AbstractParser<BitServerHandshake>() {
      @java.lang.Override
      public BitServerHandshake parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new BitServerHandshake(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<BitServerHandshake> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BitServerHandshake> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.drill.exec.proto.BitData.BitServerHandshake getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface FragmentRecordBatchOrBuilder extends
      // @@protoc_insertion_point(interface_extends:exec.bit.data.FragmentRecordBatch)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional .exec.shared.QueryId query_id = 1;</code>
     */
    boolean hasQueryId();
    /**
     * <code>optional .exec.shared.QueryId query_id = 1;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.QueryId getQueryId();
    /**
     * <code>optional .exec.shared.QueryId query_id = 1;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder getQueryIdOrBuilder();

    /**
     * <code>optional int32 receiving_major_fragment_id = 2;</code>
     */
    boolean hasReceivingMajorFragmentId();
    /**
     * <code>optional int32 receiving_major_fragment_id = 2;</code>
     */
    int getReceivingMajorFragmentId();

    /**
     * <code>repeated int32 receiving_minor_fragment_id = 3;</code>
     */
    java.util.List<java.lang.Integer> getReceivingMinorFragmentIdList();
    /**
     * <code>repeated int32 receiving_minor_fragment_id = 3;</code>
     */
    int getReceivingMinorFragmentIdCount();
    /**
     * <code>repeated int32 receiving_minor_fragment_id = 3;</code>
     */
    int getReceivingMinorFragmentId(int index);

    /**
     * <code>optional int32 sending_major_fragment_id = 4;</code>
     */
    boolean hasSendingMajorFragmentId();
    /**
     * <code>optional int32 sending_major_fragment_id = 4;</code>
     */
    int getSendingMajorFragmentId();

    /**
     * <code>optional int32 sending_minor_fragment_id = 5;</code>
     */
    boolean hasSendingMinorFragmentId();
    /**
     * <code>optional int32 sending_minor_fragment_id = 5;</code>
     */
    int getSendingMinorFragmentId();

    /**
     * <code>optional .exec.shared.RecordBatchDef def = 6;</code>
     */
    boolean hasDef();
    /**
     * <code>optional .exec.shared.RecordBatchDef def = 6;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.RecordBatchDef getDef();
    /**
     * <code>optional .exec.shared.RecordBatchDef def = 6;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.RecordBatchDefOrBuilder getDefOrBuilder();

    /**
     * <code>optional bool isLastBatch = 7;</code>
     */
    boolean hasIsLastBatch();
    /**
     * <code>optional bool isLastBatch = 7;</code>
     */
    boolean getIsLastBatch();
  }
  /**
   * Protobuf type {@code exec.bit.data.FragmentRecordBatch}
   */
  public  static final class FragmentRecordBatch extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:exec.bit.data.FragmentRecordBatch)
      FragmentRecordBatchOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use FragmentRecordBatch.newBuilder() to construct.
    private FragmentRecordBatch(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private FragmentRecordBatch() {
      receivingMajorFragmentId_ = 0;
      receivingMinorFragmentId_ = java.util.Collections.emptyList();
      sendingMajorFragmentId_ = 0;
      sendingMinorFragmentId_ = 0;
      isLastBatch_ = false;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private FragmentRecordBatch(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              org.apache.drill.exec.proto.UserBitShared.QueryId.Builder subBuilder = null;
              if (((bitField0_ & 0x00000001) == 0x00000001)) {
                subBuilder = queryId_.toBuilder();
              }
              queryId_ = input.readMessage(org.apache.drill.exec.proto.UserBitShared.QueryId.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(queryId_);
                queryId_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000001;
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              receivingMajorFragmentId_ = input.readInt32();
              break;
            }
            case 24: {
              if (!((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
                receivingMinorFragmentId_ = new java.util.ArrayList<java.lang.Integer>();
                mutable_bitField0_ |= 0x00000004;
              }
              receivingMinorFragmentId_.add(input.readInt32());
              break;
            }
            case 26: {
              int length = input.readRawVarint32();
              int limit = input.pushLimit(length);
              if (!((mutable_bitField0_ & 0x00000004) == 0x00000004) && input.getBytesUntilLimit() > 0) {
                receivingMinorFragmentId_ = new java.util.ArrayList<java.lang.Integer>();
                mutable_bitField0_ |= 0x00000004;
              }
              while (input.getBytesUntilLimit() > 0) {
                receivingMinorFragmentId_.add(input.readInt32());
              }
              input.popLimit(limit);
              break;
            }
            case 32: {
              bitField0_ |= 0x00000004;
              sendingMajorFragmentId_ = input.readInt32();
              break;
            }
            case 40: {
              bitField0_ |= 0x00000008;
              sendingMinorFragmentId_ = input.readInt32();
              break;
            }
            case 50: {
              org.apache.drill.exec.proto.UserBitShared.RecordBatchDef.Builder subBuilder = null;
              if (((bitField0_ & 0x00000010) == 0x00000010)) {
                subBuilder = def_.toBuilder();
              }
              def_ = input.readMessage(org.apache.drill.exec.proto.UserBitShared.RecordBatchDef.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(def_);
                def_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000010;
              break;
            }
            case 56: {
              bitField0_ |= 0x00000020;
              isLastBatch_ = input.readBool();
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
          receivingMinorFragmentId_ = java.util.Collections.unmodifiableList(receivingMinorFragmentId_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.BitData.internal_static_exec_bit_data_FragmentRecordBatch_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.BitData.internal_static_exec_bit_data_FragmentRecordBatch_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.BitData.FragmentRecordBatch.class, org.apache.drill.exec.proto.BitData.FragmentRecordBatch.Builder.class);
    }

    private int bitField0_;
    public static final int QUERY_ID_FIELD_NUMBER = 1;
    private org.apache.drill.exec.proto.UserBitShared.QueryId queryId_;
    /**
     * <code>optional .exec.shared.QueryId query_id = 1;</code>
     */
    public boolean hasQueryId() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional .exec.shared.QueryId query_id = 1;</code>
     */
    public org.apache.drill.exec.proto.UserBitShared.QueryId getQueryId() {
      return queryId_ == null ? org.apache.drill.exec.proto.UserBitShared.QueryId.getDefaultInstance() : queryId_;
    }
    /**
     * <code>optional .exec.shared.QueryId query_id = 1;</code>
     */
    public org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder getQueryIdOrBuilder() {
      return queryId_ == null ? org.apache.drill.exec.proto.UserBitShared.QueryId.getDefaultInstance() : queryId_;
    }

    public static final int RECEIVING_MAJOR_FRAGMENT_ID_FIELD_NUMBER = 2;
    private int receivingMajorFragmentId_;
    /**
     * <code>optional int32 receiving_major_fragment_id = 2;</code>
     */
    public boolean hasReceivingMajorFragmentId() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional int32 receiving_major_fragment_id = 2;</code>
     */
    public int getReceivingMajorFragmentId() {
      return receivingMajorFragmentId_;
    }

    public static final int RECEIVING_MINOR_FRAGMENT_ID_FIELD_NUMBER = 3;
    private java.util.List<java.lang.Integer> receivingMinorFragmentId_;
    /**
     * <code>repeated int32 receiving_minor_fragment_id = 3;</code>
     */
    public java.util.List<java.lang.Integer>
        getReceivingMinorFragmentIdList() {
      return receivingMinorFragmentId_;
    }
    /**
     * <code>repeated int32 receiving_minor_fragment_id = 3;</code>
     */
    public int getReceivingMinorFragmentIdCount() {
      return receivingMinorFragmentId_.size();
    }
    /**
     * <code>repeated int32 receiving_minor_fragment_id = 3;</code>
     */
    public int getReceivingMinorFragmentId(int index) {
      return receivingMinorFragmentId_.get(index);
    }

    public static final int SENDING_MAJOR_FRAGMENT_ID_FIELD_NUMBER = 4;
    private int sendingMajorFragmentId_;
    /**
     * <code>optional int32 sending_major_fragment_id = 4;</code>
     */
    public boolean hasSendingMajorFragmentId() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional int32 sending_major_fragment_id = 4;</code>
     */
    public int getSendingMajorFragmentId() {
      return sendingMajorFragmentId_;
    }

    public static final int SENDING_MINOR_FRAGMENT_ID_FIELD_NUMBER = 5;
    private int sendingMinorFragmentId_;
    /**
     * <code>optional int32 sending_minor_fragment_id = 5;</code>
     */
    public boolean hasSendingMinorFragmentId() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional int32 sending_minor_fragment_id = 5;</code>
     */
    public int getSendingMinorFragmentId() {
      return sendingMinorFragmentId_;
    }

    public static final int DEF_FIELD_NUMBER = 6;
    private org.apache.drill.exec.proto.UserBitShared.RecordBatchDef def_;
    /**
     * <code>optional .exec.shared.RecordBatchDef def = 6;</code>
     */
    public boolean hasDef() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     * <code>optional .exec.shared.RecordBatchDef def = 6;</code>
     */
    public org.apache.drill.exec.proto.UserBitShared.RecordBatchDef getDef() {
      return def_ == null ? org.apache.drill.exec.proto.UserBitShared.RecordBatchDef.getDefaultInstance() : def_;
    }
    /**
     * <code>optional .exec.shared.RecordBatchDef def = 6;</code>
     */
    public org.apache.drill.exec.proto.UserBitShared.RecordBatchDefOrBuilder getDefOrBuilder() {
      return def_ == null ? org.apache.drill.exec.proto.UserBitShared.RecordBatchDef.getDefaultInstance() : def_;
    }

    public static final int ISLASTBATCH_FIELD_NUMBER = 7;
    private boolean isLastBatch_;
    /**
     * <code>optional bool isLastBatch = 7;</code>
     */
    public boolean hasIsLastBatch() {
      return ((bitField0_ & 0x00000020) == 0x00000020);
    }
    /**
     * <code>optional bool isLastBatch = 7;</code>
     */
    public boolean getIsLastBatch() {
      return isLastBatch_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, getQueryId());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeInt32(2, receivingMajorFragmentId_);
      }
      for (int i = 0; i < receivingMinorFragmentId_.size(); i++) {
        output.writeInt32(3, receivingMinorFragmentId_.get(i));
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeInt32(4, sendingMajorFragmentId_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeInt32(5, sendingMinorFragmentId_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        output.writeMessage(6, getDef());
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        output.writeBool(7, isLastBatch_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getQueryId());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(2, receivingMajorFragmentId_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < receivingMinorFragmentId_.size(); i++) {
          dataSize += com.google.protobuf.CodedOutputStream
            .computeInt32SizeNoTag(receivingMinorFragmentId_.get(i));
        }
        size += dataSize;
        size += 1 * getReceivingMinorFragmentIdList().size();
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(4, sendingMajorFragmentId_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(5, sendingMinorFragmentId_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(6, getDef());
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(7, isLastBatch_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.drill.exec.proto.BitData.FragmentRecordBatch)) {
        return super.equals(obj);
      }
      org.apache.drill.exec.proto.BitData.FragmentRecordBatch other = (org.apache.drill.exec.proto.BitData.FragmentRecordBatch) obj;

      boolean result = true;
      result = result && (hasQueryId() == other.hasQueryId());
      if (hasQueryId()) {
        result = result && getQueryId()
            .equals(other.getQueryId());
      }
      result = result && (hasReceivingMajorFragmentId() == other.hasReceivingMajorFragmentId());
      if (hasReceivingMajorFragmentId()) {
        result = result && (getReceivingMajorFragmentId()
            == other.getReceivingMajorFragmentId());
      }
      result = result && getReceivingMinorFragmentIdList()
          .equals(other.getReceivingMinorFragmentIdList());
      result = result && (hasSendingMajorFragmentId() == other.hasSendingMajorFragmentId());
      if (hasSendingMajorFragmentId()) {
        result = result && (getSendingMajorFragmentId()
            == other.getSendingMajorFragmentId());
      }
      result = result && (hasSendingMinorFragmentId() == other.hasSendingMinorFragmentId());
      if (hasSendingMinorFragmentId()) {
        result = result && (getSendingMinorFragmentId()
            == other.getSendingMinorFragmentId());
      }
      result = result && (hasDef() == other.hasDef());
      if (hasDef()) {
        result = result && getDef()
            .equals(other.getDef());
      }
      result = result && (hasIsLastBatch() == other.hasIsLastBatch());
      if (hasIsLastBatch()) {
        result = result && (getIsLastBatch()
            == other.getIsLastBatch());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasQueryId()) {
        hash = (37 * hash) + QUERY_ID_FIELD_NUMBER;
        hash = (53 * hash) + getQueryId().hashCode();
      }
      if (hasReceivingMajorFragmentId()) {
        hash = (37 * hash) + RECEIVING_MAJOR_FRAGMENT_ID_FIELD_NUMBER;
        hash = (53 * hash) + getReceivingMajorFragmentId();
      }
      if (getReceivingMinorFragmentIdCount() > 0) {
        hash = (37 * hash) + RECEIVING_MINOR_FRAGMENT_ID_FIELD_NUMBER;
        hash = (53 * hash) + getReceivingMinorFragmentIdList().hashCode();
      }
      if (hasSendingMajorFragmentId()) {
        hash = (37 * hash) + SENDING_MAJOR_FRAGMENT_ID_FIELD_NUMBER;
        hash = (53 * hash) + getSendingMajorFragmentId();
      }
      if (hasSendingMinorFragmentId()) {
        hash = (37 * hash) + SENDING_MINOR_FRAGMENT_ID_FIELD_NUMBER;
        hash = (53 * hash) + getSendingMinorFragmentId();
      }
      if (hasDef()) {
        hash = (37 * hash) + DEF_FIELD_NUMBER;
        hash = (53 * hash) + getDef().hashCode();
      }
      if (hasIsLastBatch()) {
        hash = (37 * hash) + ISLASTBATCH_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
            getIsLastBatch());
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.drill.exec.proto.BitData.FragmentRecordBatch parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.BitData.FragmentRecordBatch parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitData.FragmentRecordBatch parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.BitData.FragmentRecordBatch parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitData.FragmentRecordBatch parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.BitData.FragmentRecordBatch parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitData.FragmentRecordBatch parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.BitData.FragmentRecordBatch parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitData.FragmentRecordBatch parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.BitData.FragmentRecordBatch parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitData.FragmentRecordBatch parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.BitData.FragmentRecordBatch parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.drill.exec.proto.BitData.FragmentRecordBatch prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.bit.data.FragmentRecordBatch}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:exec.bit.data.FragmentRecordBatch)
        org.apache.drill.exec.proto.BitData.FragmentRecordBatchOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.BitData.internal_static_exec_bit_data_FragmentRecordBatch_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.BitData.internal_static_exec_bit_data_FragmentRecordBatch_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.BitData.FragmentRecordBatch.class, org.apache.drill.exec.proto.BitData.FragmentRecordBatch.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.BitData.FragmentRecordBatch.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getQueryIdFieldBuilder();
          getDefFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (queryIdBuilder_ == null) {
          queryId_ = null;
        } else {
          queryIdBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        receivingMajorFragmentId_ = 0;
        bitField0_ = (bitField0_ & ~0x00000002);
        receivingMinorFragmentId_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        sendingMajorFragmentId_ = 0;
        bitField0_ = (bitField0_ & ~0x00000008);
        sendingMinorFragmentId_ = 0;
        bitField0_ = (bitField0_ & ~0x00000010);
        if (defBuilder_ == null) {
          def_ = null;
        } else {
          defBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000020);
        isLastBatch_ = false;
        bitField0_ = (bitField0_ & ~0x00000040);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.BitData.internal_static_exec_bit_data_FragmentRecordBatch_descriptor;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.BitData.FragmentRecordBatch getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.BitData.FragmentRecordBatch.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.BitData.FragmentRecordBatch build() {
        org.apache.drill.exec.proto.BitData.FragmentRecordBatch result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.BitData.FragmentRecordBatch buildPartial() {
        org.apache.drill.exec.proto.BitData.FragmentRecordBatch result = new org.apache.drill.exec.proto.BitData.FragmentRecordBatch(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (queryIdBuilder_ == null) {
          result.queryId_ = queryId_;
        } else {
          result.queryId_ = queryIdBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.receivingMajorFragmentId_ = receivingMajorFragmentId_;
        if (((bitField0_ & 0x00000004) == 0x00000004)) {
          receivingMinorFragmentId_ = java.util.Collections.unmodifiableList(receivingMinorFragmentId_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.receivingMinorFragmentId_ = receivingMinorFragmentId_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000004;
        }
        result.sendingMajorFragmentId_ = sendingMajorFragmentId_;
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000008;
        }
        result.sendingMinorFragmentId_ = sendingMinorFragmentId_;
        if (((from_bitField0_ & 0x00000020) == 0x00000020)) {
          to_bitField0_ |= 0x00000010;
        }
        if (defBuilder_ == null) {
          result.def_ = def_;
        } else {
          result.def_ = defBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000040) == 0x00000040)) {
          to_bitField0_ |= 0x00000020;
        }
        result.isLastBatch_ = isLastBatch_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.BitData.FragmentRecordBatch) {
          return mergeFrom((org.apache.drill.exec.proto.BitData.FragmentRecordBatch)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.BitData.FragmentRecordBatch other) {
        if (other == org.apache.drill.exec.proto.BitData.FragmentRecordBatch.getDefaultInstance()) return this;
        if (other.hasQueryId()) {
          mergeQueryId(other.getQueryId());
        }
        if (other.hasReceivingMajorFragmentId()) {
          setReceivingMajorFragmentId(other.getReceivingMajorFragmentId());
        }
        if (!other.receivingMinorFragmentId_.isEmpty()) {
          if (receivingMinorFragmentId_.isEmpty()) {
            receivingMinorFragmentId_ = other.receivingMinorFragmentId_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureReceivingMinorFragmentIdIsMutable();
            receivingMinorFragmentId_.addAll(other.receivingMinorFragmentId_);
          }
          onChanged();
        }
        if (other.hasSendingMajorFragmentId()) {
          setSendingMajorFragmentId(other.getSendingMajorFragmentId());
        }
        if (other.hasSendingMinorFragmentId()) {
          setSendingMinorFragmentId(other.getSendingMinorFragmentId());
        }
        if (other.hasDef()) {
          mergeDef(other.getDef());
        }
        if (other.hasIsLastBatch()) {
          setIsLastBatch(other.getIsLastBatch());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.BitData.FragmentRecordBatch parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.BitData.FragmentRecordBatch) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private org.apache.drill.exec.proto.UserBitShared.QueryId queryId_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserBitShared.QueryId, org.apache.drill.exec.proto.UserBitShared.QueryId.Builder, org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder> queryIdBuilder_;
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      public boolean hasQueryId() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.QueryId getQueryId() {
        if (queryIdBuilder_ == null) {
          return queryId_ == null ? org.apache.drill.exec.proto.UserBitShared.QueryId.getDefaultInstance() : queryId_;
        } else {
          return queryIdBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      public Builder setQueryId(org.apache.drill.exec.proto.UserBitShared.QueryId value) {
        if (queryIdBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          queryId_ = value;
          onChanged();
        } else {
          queryIdBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      public Builder setQueryId(
          org.apache.drill.exec.proto.UserBitShared.QueryId.Builder builderForValue) {
        if (queryIdBuilder_ == null) {
          queryId_ = builderForValue.build();
          onChanged();
        } else {
          queryIdBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      public Builder mergeQueryId(org.apache.drill.exec.proto.UserBitShared.QueryId value) {
        if (queryIdBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001) &&
              queryId_ != null &&
              queryId_ != org.apache.drill.exec.proto.UserBitShared.QueryId.getDefaultInstance()) {
            queryId_ =
              org.apache.drill.exec.proto.UserBitShared.QueryId.newBuilder(queryId_).mergeFrom(value).buildPartial();
          } else {
            queryId_ = value;
          }
          onChanged();
        } else {
          queryIdBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      public Builder clearQueryId() {
        if (queryIdBuilder_ == null) {
          queryId_ = null;
          onChanged();
        } else {
          queryIdBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.QueryId.Builder getQueryIdBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getQueryIdFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder getQueryIdOrBuilder() {
        if (queryIdBuilder_ != null) {
          return queryIdBuilder_.getMessageOrBuilder();
        } else {
          return queryId_ == null ?
              org.apache.drill.exec.proto.UserBitShared.QueryId.getDefaultInstance() : queryId_;
        }
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserBitShared.QueryId, org.apache.drill.exec.proto.UserBitShared.QueryId.Builder, org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder> 
          getQueryIdFieldBuilder() {
        if (queryIdBuilder_ == null) {
          queryIdBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.drill.exec.proto.UserBitShared.QueryId, org.apache.drill.exec.proto.UserBitShared.QueryId.Builder, org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder>(
                  getQueryId(),
                  getParentForChildren(),
                  isClean());
          queryId_ = null;
        }
        return queryIdBuilder_;
      }

      private int receivingMajorFragmentId_ ;
      /**
       * <code>optional int32 receiving_major_fragment_id = 2;</code>
       */
      public boolean hasReceivingMajorFragmentId() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional int32 receiving_major_fragment_id = 2;</code>
       */
      public int getReceivingMajorFragmentId() {
        return receivingMajorFragmentId_;
      }
      /**
       * <code>optional int32 receiving_major_fragment_id = 2;</code>
       */
      public Builder setReceivingMajorFragmentId(int value) {
        bitField0_ |= 0x00000002;
        receivingMajorFragmentId_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 receiving_major_fragment_id = 2;</code>
       */
      public Builder clearReceivingMajorFragmentId() {
        bitField0_ = (bitField0_ & ~0x00000002);
        receivingMajorFragmentId_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<java.lang.Integer> receivingMinorFragmentId_ = java.util.Collections.emptyList();
      private void ensureReceivingMinorFragmentIdIsMutable() {
        if (!((bitField0_ & 0x00000004) == 0x00000004)) {
          receivingMinorFragmentId_ = new java.util.ArrayList<java.lang.Integer>(receivingMinorFragmentId_);
          bitField0_ |= 0x00000004;
         }
      }
      /**
       * <code>repeated int32 receiving_minor_fragment_id = 3;</code>
       */
      public java.util.List<java.lang.Integer>
          getReceivingMinorFragmentIdList() {
        return java.util.Collections.unmodifiableList(receivingMinorFragmentId_);
      }
      /**
       * <code>repeated int32 receiving_minor_fragment_id = 3;</code>
       */
      public int getReceivingMinorFragmentIdCount() {
        return receivingMinorFragmentId_.size();
      }
      /**
       * <code>repeated int32 receiving_minor_fragment_id = 3;</code>
       */
      public int getReceivingMinorFragmentId(int index) {
        return receivingMinorFragmentId_.get(index);
      }
      /**
       * <code>repeated int32 receiving_minor_fragment_id = 3;</code>
       */
      public Builder setReceivingMinorFragmentId(
          int index, int value) {
        ensureReceivingMinorFragmentIdIsMutable();
        receivingMinorFragmentId_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated int32 receiving_minor_fragment_id = 3;</code>
       */
      public Builder addReceivingMinorFragmentId(int value) {
        ensureReceivingMinorFragmentIdIsMutable();
        receivingMinorFragmentId_.add(value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated int32 receiving_minor_fragment_id = 3;</code>
       */
      public Builder addAllReceivingMinorFragmentId(
          java.lang.Iterable<? extends java.lang.Integer> values) {
        ensureReceivingMinorFragmentIdIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, receivingMinorFragmentId_);
        onChanged();
        return this;
      }
      /**
       * <code>repeated int32 receiving_minor_fragment_id = 3;</code>
       */
      public Builder clearReceivingMinorFragmentId() {
        receivingMinorFragmentId_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }

      private int sendingMajorFragmentId_ ;
      /**
       * <code>optional int32 sending_major_fragment_id = 4;</code>
       */
      public boolean hasSendingMajorFragmentId() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional int32 sending_major_fragment_id = 4;</code>
       */
      public int getSendingMajorFragmentId() {
        return sendingMajorFragmentId_;
      }
      /**
       * <code>optional int32 sending_major_fragment_id = 4;</code>
       */
      public Builder setSendingMajorFragmentId(int value) {
        bitField0_ |= 0x00000008;
        sendingMajorFragmentId_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 sending_major_fragment_id = 4;</code>
       */
      public Builder clearSendingMajorFragmentId() {
        bitField0_ = (bitField0_ & ~0x00000008);
        sendingMajorFragmentId_ = 0;
        onChanged();
        return this;
      }

      private int sendingMinorFragmentId_ ;
      /**
       * <code>optional int32 sending_minor_fragment_id = 5;</code>
       */
      public boolean hasSendingMinorFragmentId() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       * <code>optional int32 sending_minor_fragment_id = 5;</code>
       */
      public int getSendingMinorFragmentId() {
        return sendingMinorFragmentId_;
      }
      /**
       * <code>optional int32 sending_minor_fragment_id = 5;</code>
       */
      public Builder setSendingMinorFragmentId(int value) {
        bitField0_ |= 0x00000010;
        sendingMinorFragmentId_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 sending_minor_fragment_id = 5;</code>
       */
      public Builder clearSendingMinorFragmentId() {
        bitField0_ = (bitField0_ & ~0x00000010);
        sendingMinorFragmentId_ = 0;
        onChanged();
        return this;
      }

      private org.apache.drill.exec.proto.UserBitShared.RecordBatchDef def_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserBitShared.RecordBatchDef, org.apache.drill.exec.proto.UserBitShared.RecordBatchDef.Builder, org.apache.drill.exec.proto.UserBitShared.RecordBatchDefOrBuilder> defBuilder_;
      /**
       * <code>optional .exec.shared.RecordBatchDef def = 6;</code>
       */
      public boolean hasDef() {
        return ((bitField0_ & 0x00000020) == 0x00000020);
      }
      /**
       * <code>optional .exec.shared.RecordBatchDef def = 6;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.RecordBatchDef getDef() {
        if (defBuilder_ == null) {
          return def_ == null ? org.apache.drill.exec.proto.UserBitShared.RecordBatchDef.getDefaultInstance() : def_;
        } else {
          return defBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.shared.RecordBatchDef def = 6;</code>
       */
      public Builder setDef(org.apache.drill.exec.proto.UserBitShared.RecordBatchDef value) {
        if (defBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          def_ = value;
          onChanged();
        } else {
          defBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000020;
        return this;
      }
      /**
       * <code>optional .exec.shared.RecordBatchDef def = 6;</code>
       */
      public Builder setDef(
          org.apache.drill.exec.proto.UserBitShared.RecordBatchDef.Builder builderForValue) {
        if (defBuilder_ == null) {
          def_ = builderForValue.build();
          onChanged();
        } else {
          defBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000020;
        return this;
      }
      /**
       * <code>optional .exec.shared.RecordBatchDef def = 6;</code>
       */
      public Builder mergeDef(org.apache.drill.exec.proto.UserBitShared.RecordBatchDef value) {
        if (defBuilder_ == null) {
          if (((bitField0_ & 0x00000020) == 0x00000020) &&
              def_ != null &&
              def_ != org.apache.drill.exec.proto.UserBitShared.RecordBatchDef.getDefaultInstance()) {
            def_ =
              org.apache.drill.exec.proto.UserBitShared.RecordBatchDef.newBuilder(def_).mergeFrom(value).buildPartial();
          } else {
            def_ = value;
          }
          onChanged();
        } else {
          defBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000020;
        return this;
      }
      /**
       * <code>optional .exec.shared.RecordBatchDef def = 6;</code>
       */
      public Builder clearDef() {
        if (defBuilder_ == null) {
          def_ = null;
          onChanged();
        } else {
          defBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000020);
        return this;
      }
      /**
       * <code>optional .exec.shared.RecordBatchDef def = 6;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.RecordBatchDef.Builder getDefBuilder() {
        bitField0_ |= 0x00000020;
        onChanged();
        return getDefFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.shared.RecordBatchDef def = 6;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.RecordBatchDefOrBuilder getDefOrBuilder() {
        if (defBuilder_ != null) {
          return defBuilder_.getMessageOrBuilder();
        } else {
          return def_ == null ?
              org.apache.drill.exec.proto.UserBitShared.RecordBatchDef.getDefaultInstance() : def_;
        }
      }
      /**
       * <code>optional .exec.shared.RecordBatchDef def = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserBitShared.RecordBatchDef, org.apache.drill.exec.proto.UserBitShared.RecordBatchDef.Builder, org.apache.drill.exec.proto.UserBitShared.RecordBatchDefOrBuilder> 
          getDefFieldBuilder() {
        if (defBuilder_ == null) {
          defBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.drill.exec.proto.UserBitShared.RecordBatchDef, org.apache.drill.exec.proto.UserBitShared.RecordBatchDef.Builder, org.apache.drill.exec.proto.UserBitShared.RecordBatchDefOrBuilder>(
                  getDef(),
                  getParentForChildren(),
                  isClean());
          def_ = null;
        }
        return defBuilder_;
      }

      private boolean isLastBatch_ ;
      /**
       * <code>optional bool isLastBatch = 7;</code>
       */
      public boolean hasIsLastBatch() {
        return ((bitField0_ & 0x00000040) == 0x00000040);
      }
      /**
       * <code>optional bool isLastBatch = 7;</code>
       */
      public boolean getIsLastBatch() {
        return isLastBatch_;
      }
      /**
       * <code>optional bool isLastBatch = 7;</code>
       */
      public Builder setIsLastBatch(boolean value) {
        bitField0_ |= 0x00000040;
        isLastBatch_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool isLastBatch = 7;</code>
       */
      public Builder clearIsLastBatch() {
        bitField0_ = (bitField0_ & ~0x00000040);
        isLastBatch_ = false;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:exec.bit.data.FragmentRecordBatch)
    }

    // @@protoc_insertion_point(class_scope:exec.bit.data.FragmentRecordBatch)
    private static final org.apache.drill.exec.proto.BitData.FragmentRecordBatch DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.drill.exec.proto.BitData.FragmentRecordBatch();
    }

    public static org.apache.drill.exec.proto.BitData.FragmentRecordBatch getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<FragmentRecordBatch>
        PARSER = new com.google.protobuf.AbstractParser<FragmentRecordBatch>() {
      @java.lang.Override
      public FragmentRecordBatch parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new FragmentRecordBatch(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<FragmentRecordBatch> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FragmentRecordBatch> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.drill.exec.proto.BitData.FragmentRecordBatch getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface RuntimeFilterBDefOrBuilder extends
      // @@protoc_insertion_point(interface_extends:exec.bit.data.RuntimeFilterBDef)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional .exec.shared.QueryId query_id = 1;</code>
     */
    boolean hasQueryId();
    /**
     * <code>optional .exec.shared.QueryId query_id = 1;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.QueryId getQueryId();
    /**
     * <code>optional .exec.shared.QueryId query_id = 1;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder getQueryIdOrBuilder();

    /**
     * <code>optional int32 major_fragment_id = 2;</code>
     */
    boolean hasMajorFragmentId();
    /**
     * <code>optional int32 major_fragment_id = 2;</code>
     */
    int getMajorFragmentId();

    /**
     * <code>optional int32 minor_fragment_id = 3;</code>
     */
    boolean hasMinorFragmentId();
    /**
     * <code>optional int32 minor_fragment_id = 3;</code>
     */
    int getMinorFragmentId();

    /**
     * <pre>
     * true means sending to foreman,false means sending to scan nodes
     * </pre>
     *
     * <code>optional bool to_foreman = 4;</code>
     */
    boolean hasToForeman();
    /**
     * <pre>
     * true means sending to foreman,false means sending to scan nodes
     * </pre>
     *
     * <code>optional bool to_foreman = 4;</code>
     */
    boolean getToForeman();

    /**
     * <code>repeated int32 bloom_filter_size_in_bytes = 5;</code>
     */
    java.util.List<java.lang.Integer> getBloomFilterSizeInBytesList();
    /**
     * <code>repeated int32 bloom_filter_size_in_bytes = 5;</code>
     */
    int getBloomFilterSizeInBytesCount();
    /**
     * <code>repeated int32 bloom_filter_size_in_bytes = 5;</code>
     */
    int getBloomFilterSizeInBytes(int index);

    /**
     * <pre>
     * probe fields with corresponding BloomFilters
     * </pre>
     *
     * <code>repeated string probe_fields = 6;</code>
     */
    java.util.List<java.lang.String>
        getProbeFieldsList();
    /**
     * <pre>
     * probe fields with corresponding BloomFilters
     * </pre>
     *
     * <code>repeated string probe_fields = 6;</code>
     */
    int getProbeFieldsCount();
    /**
     * <pre>
     * probe fields with corresponding BloomFilters
     * </pre>
     *
     * <code>repeated string probe_fields = 6;</code>
     */
    java.lang.String getProbeFields(int index);
    /**
     * <pre>
     * probe fields with corresponding BloomFilters
     * </pre>
     *
     * <code>repeated string probe_fields = 6;</code>
     */
    com.google.protobuf.ByteString
        getProbeFieldsBytes(int index);

    /**
     * <pre>
     * the operator id of the HashJoin which generates this RuntimeFilter
     * </pre>
     *
     * <code>optional int32 hj_op_id = 7;</code>
     */
    boolean hasHjOpId();
    /**
     * <pre>
     * the operator id of the HashJoin which generates this RuntimeFilter
     * </pre>
     *
     * <code>optional int32 hj_op_id = 7;</code>
     */
    int getHjOpId();

    /**
     * <pre>
     * the runtime filter identifier
     * </pre>
     *
     * <code>optional int64 rf_identifier = 8;</code>
     */
    boolean hasRfIdentifier();
    /**
     * <pre>
     * the runtime filter identifier
     * </pre>
     *
     * <code>optional int64 rf_identifier = 8;</code>
     */
    long getRfIdentifier();
  }
  /**
   * Protobuf type {@code exec.bit.data.RuntimeFilterBDef}
   */
  public  static final class RuntimeFilterBDef extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:exec.bit.data.RuntimeFilterBDef)
      RuntimeFilterBDefOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use RuntimeFilterBDef.newBuilder() to construct.
    private RuntimeFilterBDef(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private RuntimeFilterBDef() {
      majorFragmentId_ = 0;
      minorFragmentId_ = 0;
      toForeman_ = false;
      bloomFilterSizeInBytes_ = java.util.Collections.emptyList();
      probeFields_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      hjOpId_ = 0;
      rfIdentifier_ = 0L;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private RuntimeFilterBDef(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              org.apache.drill.exec.proto.UserBitShared.QueryId.Builder subBuilder = null;
              if (((bitField0_ & 0x00000001) == 0x00000001)) {
                subBuilder = queryId_.toBuilder();
              }
              queryId_ = input.readMessage(org.apache.drill.exec.proto.UserBitShared.QueryId.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(queryId_);
                queryId_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000001;
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              majorFragmentId_ = input.readInt32();
              break;
            }
            case 24: {
              bitField0_ |= 0x00000004;
              minorFragmentId_ = input.readInt32();
              break;
            }
            case 32: {
              bitField0_ |= 0x00000008;
              toForeman_ = input.readBool();
              break;
            }
            case 40: {
              if (!((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
                bloomFilterSizeInBytes_ = new java.util.ArrayList<java.lang.Integer>();
                mutable_bitField0_ |= 0x00000010;
              }
              bloomFilterSizeInBytes_.add(input.readInt32());
              break;
            }
            case 42: {
              int length = input.readRawVarint32();
              int limit = input.pushLimit(length);
              if (!((mutable_bitField0_ & 0x00000010) == 0x00000010) && input.getBytesUntilLimit() > 0) {
                bloomFilterSizeInBytes_ = new java.util.ArrayList<java.lang.Integer>();
                mutable_bitField0_ |= 0x00000010;
              }
              while (input.getBytesUntilLimit() > 0) {
                bloomFilterSizeInBytes_.add(input.readInt32());
              }
              input.popLimit(limit);
              break;
            }
            case 50: {
              com.google.protobuf.ByteString bs = input.readBytes();
              if (!((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
                probeFields_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000020;
              }
              probeFields_.add(bs);
              break;
            }
            case 56: {
              bitField0_ |= 0x00000010;
              hjOpId_ = input.readInt32();
              break;
            }
            case 64: {
              bitField0_ |= 0x00000020;
              rfIdentifier_ = input.readInt64();
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
          bloomFilterSizeInBytes_ = java.util.Collections.unmodifiableList(bloomFilterSizeInBytes_);
        }
        if (((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
          probeFields_ = probeFields_.getUnmodifiableView();
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.BitData.internal_static_exec_bit_data_RuntimeFilterBDef_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.BitData.internal_static_exec_bit_data_RuntimeFilterBDef_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.BitData.RuntimeFilterBDef.class, org.apache.drill.exec.proto.BitData.RuntimeFilterBDef.Builder.class);
    }

    private int bitField0_;
    public static final int QUERY_ID_FIELD_NUMBER = 1;
    private org.apache.drill.exec.proto.UserBitShared.QueryId queryId_;
    /**
     * <code>optional .exec.shared.QueryId query_id = 1;</code>
     */
    public boolean hasQueryId() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional .exec.shared.QueryId query_id = 1;</code>
     */
    public org.apache.drill.exec.proto.UserBitShared.QueryId getQueryId() {
      return queryId_ == null ? org.apache.drill.exec.proto.UserBitShared.QueryId.getDefaultInstance() : queryId_;
    }
    /**
     * <code>optional .exec.shared.QueryId query_id = 1;</code>
     */
    public org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder getQueryIdOrBuilder() {
      return queryId_ == null ? org.apache.drill.exec.proto.UserBitShared.QueryId.getDefaultInstance() : queryId_;
    }

    public static final int MAJOR_FRAGMENT_ID_FIELD_NUMBER = 2;
    private int majorFragmentId_;
    /**
     * <code>optional int32 major_fragment_id = 2;</code>
     */
    public boolean hasMajorFragmentId() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional int32 major_fragment_id = 2;</code>
     */
    public int getMajorFragmentId() {
      return majorFragmentId_;
    }

    public static final int MINOR_FRAGMENT_ID_FIELD_NUMBER = 3;
    private int minorFragmentId_;
    /**
     * <code>optional int32 minor_fragment_id = 3;</code>
     */
    public boolean hasMinorFragmentId() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional int32 minor_fragment_id = 3;</code>
     */
    public int getMinorFragmentId() {
      return minorFragmentId_;
    }

    public static final int TO_FOREMAN_FIELD_NUMBER = 4;
    private boolean toForeman_;
    /**
     * <pre>
     * true means sending to foreman,false means sending to scan nodes
     * </pre>
     *
     * <code>optional bool to_foreman = 4;</code>
     */
    public boolean hasToForeman() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <pre>
     * true means sending to foreman,false means sending to scan nodes
     * </pre>
     *
     * <code>optional bool to_foreman = 4;</code>
     */
    public boolean getToForeman() {
      return toForeman_;
    }

    public static final int BLOOM_FILTER_SIZE_IN_BYTES_FIELD_NUMBER = 5;
    private java.util.List<java.lang.Integer> bloomFilterSizeInBytes_;
    /**
     * <code>repeated int32 bloom_filter_size_in_bytes = 5;</code>
     */
    public java.util.List<java.lang.Integer>
        getBloomFilterSizeInBytesList() {
      return bloomFilterSizeInBytes_;
    }
    /**
     * <code>repeated int32 bloom_filter_size_in_bytes = 5;</code>
     */
    public int getBloomFilterSizeInBytesCount() {
      return bloomFilterSizeInBytes_.size();
    }
    /**
     * <code>repeated int32 bloom_filter_size_in_bytes = 5;</code>
     */
    public int getBloomFilterSizeInBytes(int index) {
      return bloomFilterSizeInBytes_.get(index);
    }

    public static final int PROBE_FIELDS_FIELD_NUMBER = 6;
    private com.google.protobuf.LazyStringList probeFields_;
    /**
     * <pre>
     * probe fields with corresponding BloomFilters
     * </pre>
     *
     * <code>repeated string probe_fields = 6;</code>
     */
    public com.google.protobuf.ProtocolStringList
        getProbeFieldsList() {
      return probeFields_;
    }
    /**
     * <pre>
     * probe fields with corresponding BloomFilters
     * </pre>
     *
     * <code>repeated string probe_fields = 6;</code>
     */
    public int getProbeFieldsCount() {
      return probeFields_.size();
    }
    /**
     * <pre>
     * probe fields with corresponding BloomFilters
     * </pre>
     *
     * <code>repeated string probe_fields = 6;</code>
     */
    public java.lang.String getProbeFields(int index) {
      return probeFields_.get(index);
    }
    /**
     * <pre>
     * probe fields with corresponding BloomFilters
     * </pre>
     *
     * <code>repeated string probe_fields = 6;</code>
     */
    public com.google.protobuf.ByteString
        getProbeFieldsBytes(int index) {
      return probeFields_.getByteString(index);
    }

    public static final int HJ_OP_ID_FIELD_NUMBER = 7;
    private int hjOpId_;
    /**
     * <pre>
     * the operator id of the HashJoin which generates this RuntimeFilter
     * </pre>
     *
     * <code>optional int32 hj_op_id = 7;</code>
     */
    public boolean hasHjOpId() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     * <pre>
     * the operator id of the HashJoin which generates this RuntimeFilter
     * </pre>
     *
     * <code>optional int32 hj_op_id = 7;</code>
     */
    public int getHjOpId() {
      return hjOpId_;
    }

    public static final int RF_IDENTIFIER_FIELD_NUMBER = 8;
    private long rfIdentifier_;
    /**
     * <pre>
     * the runtime filter identifier
     * </pre>
     *
     * <code>optional int64 rf_identifier = 8;</code>
     */
    public boolean hasRfIdentifier() {
      return ((bitField0_ & 0x00000020) == 0x00000020);
    }
    /**
     * <pre>
     * the runtime filter identifier
     * </pre>
     *
     * <code>optional int64 rf_identifier = 8;</code>
     */
    public long getRfIdentifier() {
      return rfIdentifier_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, getQueryId());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeInt32(2, majorFragmentId_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeInt32(3, minorFragmentId_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeBool(4, toForeman_);
      }
      for (int i = 0; i < bloomFilterSizeInBytes_.size(); i++) {
        output.writeInt32(5, bloomFilterSizeInBytes_.get(i));
      }
      for (int i = 0; i < probeFields_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, probeFields_.getRaw(i));
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        output.writeInt32(7, hjOpId_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        output.writeInt64(8, rfIdentifier_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getQueryId());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(2, majorFragmentId_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(3, minorFragmentId_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(4, toForeman_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < bloomFilterSizeInBytes_.size(); i++) {
          dataSize += com.google.protobuf.CodedOutputStream
            .computeInt32SizeNoTag(bloomFilterSizeInBytes_.get(i));
        }
        size += dataSize;
        size += 1 * getBloomFilterSizeInBytesList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < probeFields_.size(); i++) {
          dataSize += computeStringSizeNoTag(probeFields_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getProbeFieldsList().size();
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(7, hjOpId_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt64Size(8, rfIdentifier_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.drill.exec.proto.BitData.RuntimeFilterBDef)) {
        return super.equals(obj);
      }
      org.apache.drill.exec.proto.BitData.RuntimeFilterBDef other = (org.apache.drill.exec.proto.BitData.RuntimeFilterBDef) obj;

      boolean result = true;
      result = result && (hasQueryId() == other.hasQueryId());
      if (hasQueryId()) {
        result = result && getQueryId()
            .equals(other.getQueryId());
      }
      result = result && (hasMajorFragmentId() == other.hasMajorFragmentId());
      if (hasMajorFragmentId()) {
        result = result && (getMajorFragmentId()
            == other.getMajorFragmentId());
      }
      result = result && (hasMinorFragmentId() == other.hasMinorFragmentId());
      if (hasMinorFragmentId()) {
        result = result && (getMinorFragmentId()
            == other.getMinorFragmentId());
      }
      result = result && (hasToForeman() == other.hasToForeman());
      if (hasToForeman()) {
        result = result && (getToForeman()
            == other.getToForeman());
      }
      result = result && getBloomFilterSizeInBytesList()
          .equals(other.getBloomFilterSizeInBytesList());
      result = result && getProbeFieldsList()
          .equals(other.getProbeFieldsList());
      result = result && (hasHjOpId() == other.hasHjOpId());
      if (hasHjOpId()) {
        result = result && (getHjOpId()
            == other.getHjOpId());
      }
      result = result && (hasRfIdentifier() == other.hasRfIdentifier());
      if (hasRfIdentifier()) {
        result = result && (getRfIdentifier()
            == other.getRfIdentifier());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasQueryId()) {
        hash = (37 * hash) + QUERY_ID_FIELD_NUMBER;
        hash = (53 * hash) + getQueryId().hashCode();
      }
      if (hasMajorFragmentId()) {
        hash = (37 * hash) + MAJOR_FRAGMENT_ID_FIELD_NUMBER;
        hash = (53 * hash) + getMajorFragmentId();
      }
      if (hasMinorFragmentId()) {
        hash = (37 * hash) + MINOR_FRAGMENT_ID_FIELD_NUMBER;
        hash = (53 * hash) + getMinorFragmentId();
      }
      if (hasToForeman()) {
        hash = (37 * hash) + TO_FOREMAN_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
            getToForeman());
      }
      if (getBloomFilterSizeInBytesCount() > 0) {
        hash = (37 * hash) + BLOOM_FILTER_SIZE_IN_BYTES_FIELD_NUMBER;
        hash = (53 * hash) + getBloomFilterSizeInBytesList().hashCode();
      }
      if (getProbeFieldsCount() > 0) {
        hash = (37 * hash) + PROBE_FIELDS_FIELD_NUMBER;
        hash = (53 * hash) + getProbeFieldsList().hashCode();
      }
      if (hasHjOpId()) {
        hash = (37 * hash) + HJ_OP_ID_FIELD_NUMBER;
        hash = (53 * hash) + getHjOpId();
      }
      if (hasRfIdentifier()) {
        hash = (37 * hash) + RF_IDENTIFIER_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
            getRfIdentifier());
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.drill.exec.proto.BitData.RuntimeFilterBDef parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.BitData.RuntimeFilterBDef parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitData.RuntimeFilterBDef parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.BitData.RuntimeFilterBDef parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitData.RuntimeFilterBDef parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.BitData.RuntimeFilterBDef parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitData.RuntimeFilterBDef parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.BitData.RuntimeFilterBDef parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitData.RuntimeFilterBDef parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.BitData.RuntimeFilterBDef parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitData.RuntimeFilterBDef parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.drill.exec.proto.BitData.RuntimeFilterBDef parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.drill.exec.proto.BitData.RuntimeFilterBDef prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.bit.data.RuntimeFilterBDef}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:exec.bit.data.RuntimeFilterBDef)
        org.apache.drill.exec.proto.BitData.RuntimeFilterBDefOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.BitData.internal_static_exec_bit_data_RuntimeFilterBDef_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.BitData.internal_static_exec_bit_data_RuntimeFilterBDef_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.BitData.RuntimeFilterBDef.class, org.apache.drill.exec.proto.BitData.RuntimeFilterBDef.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.BitData.RuntimeFilterBDef.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getQueryIdFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (queryIdBuilder_ == null) {
          queryId_ = null;
        } else {
          queryIdBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        majorFragmentId_ = 0;
        bitField0_ = (bitField0_ & ~0x00000002);
        minorFragmentId_ = 0;
        bitField0_ = (bitField0_ & ~0x00000004);
        toForeman_ = false;
        bitField0_ = (bitField0_ & ~0x00000008);
        bloomFilterSizeInBytes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        probeFields_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000020);
        hjOpId_ = 0;
        bitField0_ = (bitField0_ & ~0x00000040);
        rfIdentifier_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000080);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.BitData.internal_static_exec_bit_data_RuntimeFilterBDef_descriptor;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.BitData.RuntimeFilterBDef getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.BitData.RuntimeFilterBDef.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.BitData.RuntimeFilterBDef build() {
        org.apache.drill.exec.proto.BitData.RuntimeFilterBDef result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.drill.exec.proto.BitData.RuntimeFilterBDef buildPartial() {
        org.apache.drill.exec.proto.BitData.RuntimeFilterBDef result = new org.apache.drill.exec.proto.BitData.RuntimeFilterBDef(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (queryIdBuilder_ == null) {
          result.queryId_ = queryId_;
        } else {
          result.queryId_ = queryIdBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.majorFragmentId_ = majorFragmentId_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.minorFragmentId_ = minorFragmentId_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.toForeman_ = toForeman_;
        if (((bitField0_ & 0x00000010) == 0x00000010)) {
          bloomFilterSizeInBytes_ = java.util.Collections.unmodifiableList(bloomFilterSizeInBytes_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.bloomFilterSizeInBytes_ = bloomFilterSizeInBytes_;
        if (((bitField0_ & 0x00000020) == 0x00000020)) {
          probeFields_ = probeFields_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.probeFields_ = probeFields_;
        if (((from_bitField0_ & 0x00000040) == 0x00000040)) {
          to_bitField0_ |= 0x00000010;
        }
        result.hjOpId_ = hjOpId_;
        if (((from_bitField0_ & 0x00000080) == 0x00000080)) {
          to_bitField0_ |= 0x00000020;
        }
        result.rfIdentifier_ = rfIdentifier_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.BitData.RuntimeFilterBDef) {
          return mergeFrom((org.apache.drill.exec.proto.BitData.RuntimeFilterBDef)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.BitData.RuntimeFilterBDef other) {
        if (other == org.apache.drill.exec.proto.BitData.RuntimeFilterBDef.getDefaultInstance()) return this;
        if (other.hasQueryId()) {
          mergeQueryId(other.getQueryId());
        }
        if (other.hasMajorFragmentId()) {
          setMajorFragmentId(other.getMajorFragmentId());
        }
        if (other.hasMinorFragmentId()) {
          setMinorFragmentId(other.getMinorFragmentId());
        }
        if (other.hasToForeman()) {
          setToForeman(other.getToForeman());
        }
        if (!other.bloomFilterSizeInBytes_.isEmpty()) {
          if (bloomFilterSizeInBytes_.isEmpty()) {
            bloomFilterSizeInBytes_ = other.bloomFilterSizeInBytes_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureBloomFilterSizeInBytesIsMutable();
            bloomFilterSizeInBytes_.addAll(other.bloomFilterSizeInBytes_);
          }
          onChanged();
        }
        if (!other.probeFields_.isEmpty()) {
          if (probeFields_.isEmpty()) {
            probeFields_ = other.probeFields_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureProbeFieldsIsMutable();
            probeFields_.addAll(other.probeFields_);
          }
          onChanged();
        }
        if (other.hasHjOpId()) {
          setHjOpId(other.getHjOpId());
        }
        if (other.hasRfIdentifier()) {
          setRfIdentifier(other.getRfIdentifier());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.BitData.RuntimeFilterBDef parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.BitData.RuntimeFilterBDef) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private org.apache.drill.exec.proto.UserBitShared.QueryId queryId_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserBitShared.QueryId, org.apache.drill.exec.proto.UserBitShared.QueryId.Builder, org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder> queryIdBuilder_;
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      public boolean hasQueryId() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.QueryId getQueryId() {
        if (queryIdBuilder_ == null) {
          return queryId_ == null ? org.apache.drill.exec.proto.UserBitShared.QueryId.getDefaultInstance() : queryId_;
        } else {
          return queryIdBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      public Builder setQueryId(org.apache.drill.exec.proto.UserBitShared.QueryId value) {
        if (queryIdBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          queryId_ = value;
          onChanged();
        } else {
          queryIdBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      public Builder setQueryId(
          org.apache.drill.exec.proto.UserBitShared.QueryId.Builder builderForValue) {
        if (queryIdBuilder_ == null) {
          queryId_ = builderForValue.build();
          onChanged();
        } else {
          queryIdBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      public Builder mergeQueryId(org.apache.drill.exec.proto.UserBitShared.QueryId value) {
        if (queryIdBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001) &&
              queryId_ != null &&
              queryId_ != org.apache.drill.exec.proto.UserBitShared.QueryId.getDefaultInstance()) {
            queryId_ =
              org.apache.drill.exec.proto.UserBitShared.QueryId.newBuilder(queryId_).mergeFrom(value).buildPartial();
          } else {
            queryId_ = value;
          }
          onChanged();
        } else {
          queryIdBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      public Builder clearQueryId() {
        if (queryIdBuilder_ == null) {
          queryId_ = null;
          onChanged();
        } else {
          queryIdBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.QueryId.Builder getQueryIdBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getQueryIdFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder getQueryIdOrBuilder() {
        if (queryIdBuilder_ != null) {
          return queryIdBuilder_.getMessageOrBuilder();
        } else {
          return queryId_ == null ?
              org.apache.drill.exec.proto.UserBitShared.QueryId.getDefaultInstance() : queryId_;
        }
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.drill.exec.proto.UserBitShared.QueryId, org.apache.drill.exec.proto.UserBitShared.QueryId.Builder, org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder> 
          getQueryIdFieldBuilder() {
        if (queryIdBuilder_ == null) {
          queryIdBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.drill.exec.proto.UserBitShared.QueryId, org.apache.drill.exec.proto.UserBitShared.QueryId.Builder, org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder>(
                  getQueryId(),
                  getParentForChildren(),
                  isClean());
          queryId_ = null;
        }
        return queryIdBuilder_;
      }

      private int majorFragmentId_ ;
      /**
       * <code>optional int32 major_fragment_id = 2;</code>
       */
      public boolean hasMajorFragmentId() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional int32 major_fragment_id = 2;</code>
       */
      public int getMajorFragmentId() {
        return majorFragmentId_;
      }
      /**
       * <code>optional int32 major_fragment_id = 2;</code>
       */
      public Builder setMajorFragmentId(int value) {
        bitField0_ |= 0x00000002;
        majorFragmentId_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 major_fragment_id = 2;</code>
       */
      public Builder clearMajorFragmentId() {
        bitField0_ = (bitField0_ & ~0x00000002);
        majorFragmentId_ = 0;
        onChanged();
        return this;
      }

      private int minorFragmentId_ ;
      /**
       * <code>optional int32 minor_fragment_id = 3;</code>
       */
      public boolean hasMinorFragmentId() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional int32 minor_fragment_id = 3;</code>
       */
      public int getMinorFragmentId() {
        return minorFragmentId_;
      }
      /**
       * <code>optional int32 minor_fragment_id = 3;</code>
       */
      public Builder setMinorFragmentId(int value) {
        bitField0_ |= 0x00000004;
        minorFragmentId_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 minor_fragment_id = 3;</code>
       */
      public Builder clearMinorFragmentId() {
        bitField0_ = (bitField0_ & ~0x00000004);
        minorFragmentId_ = 0;
        onChanged();
        return this;
      }

      private boolean toForeman_ ;
      /**
       * <pre>
       * true means sending to foreman,false means sending to scan nodes
       * </pre>
       *
       * <code>optional bool to_foreman = 4;</code>
       */
      public boolean hasToForeman() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <pre>
       * true means sending to foreman,false means sending to scan nodes
       * </pre>
       *
       * <code>optional bool to_foreman = 4;</code>
       */
      public boolean getToForeman() {
        return toForeman_;
      }
      /**
       * <pre>
       * true means sending to foreman,false means sending to scan nodes
       * </pre>
       *
       * <code>optional bool to_foreman = 4;</code>
       */
      public Builder setToForeman(boolean value) {
        bitField0_ |= 0x00000008;
        toForeman_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * true means sending to foreman,false means sending to scan nodes
       * </pre>
       *
       * <code>optional bool to_foreman = 4;</code>
       */
      public Builder clearToForeman() {
        bitField0_ = (bitField0_ & ~0x00000008);
        toForeman_ = false;
        onChanged();
        return this;
      }

      private java.util.List<java.lang.Integer> bloomFilterSizeInBytes_ = java.util.Collections.emptyList();
      private void ensureBloomFilterSizeInBytesIsMutable() {
        if (!((bitField0_ & 0x00000010) == 0x00000010)) {
          bloomFilterSizeInBytes_ = new java.util.ArrayList<java.lang.Integer>(bloomFilterSizeInBytes_);
          bitField0_ |= 0x00000010;
         }
      }
      /**
       * <code>repeated int32 bloom_filter_size_in_bytes = 5;</code>
       */
      public java.util.List<java.lang.Integer>
          getBloomFilterSizeInBytesList() {
        return java.util.Collections.unmodifiableList(bloomFilterSizeInBytes_);
      }
      /**
       * <code>repeated int32 bloom_filter_size_in_bytes = 5;</code>
       */
      public int getBloomFilterSizeInBytesCount() {
        return bloomFilterSizeInBytes_.size();
      }
      /**
       * <code>repeated int32 bloom_filter_size_in_bytes = 5;</code>
       */
      public int getBloomFilterSizeInBytes(int index) {
        return bloomFilterSizeInBytes_.get(index);
      }
      /**
       * <code>repeated int32 bloom_filter_size_in_bytes = 5;</code>
       */
      public Builder setBloomFilterSizeInBytes(
          int index, int value) {
        ensureBloomFilterSizeInBytesIsMutable();
        bloomFilterSizeInBytes_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated int32 bloom_filter_size_in_bytes = 5;</code>
       */
      public Builder addBloomFilterSizeInBytes(int value) {
        ensureBloomFilterSizeInBytesIsMutable();
        bloomFilterSizeInBytes_.add(value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated int32 bloom_filter_size_in_bytes = 5;</code>
       */
      public Builder addAllBloomFilterSizeInBytes(
          java.lang.Iterable<? extends java.lang.Integer> values) {
        ensureBloomFilterSizeInBytesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, bloomFilterSizeInBytes_);
        onChanged();
        return this;
      }
      /**
       * <code>repeated int32 bloom_filter_size_in_bytes = 5;</code>
       */
      public Builder clearBloomFilterSizeInBytes() {
        bloomFilterSizeInBytes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList probeFields_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensureProbeFieldsIsMutable() {
        if (!((bitField0_ & 0x00000020) == 0x00000020)) {
          probeFields_ = new com.google.protobuf.LazyStringArrayList(probeFields_);
          bitField0_ |= 0x00000020;
         }
      }
      /**
       * <pre>
       * probe fields with corresponding BloomFilters
       * </pre>
       *
       * <code>repeated string probe_fields = 6;</code>
       */
      public com.google.protobuf.ProtocolStringList
          getProbeFieldsList() {
        return probeFields_.getUnmodifiableView();
      }
      /**
       * <pre>
       * probe fields with corresponding BloomFilters
       * </pre>
       *
       * <code>repeated string probe_fields = 6;</code>
       */
      public int getProbeFieldsCount() {
        return probeFields_.size();
      }
      /**
       * <pre>
       * probe fields with corresponding BloomFilters
       * </pre>
       *
       * <code>repeated string probe_fields = 6;</code>
       */
      public java.lang.String getProbeFields(int index) {
        return probeFields_.get(index);
      }
      /**
       * <pre>
       * probe fields with corresponding BloomFilters
       * </pre>
       *
       * <code>repeated string probe_fields = 6;</code>
       */
      public com.google.protobuf.ByteString
          getProbeFieldsBytes(int index) {
        return probeFields_.getByteString(index);
      }
      /**
       * <pre>
       * probe fields with corresponding BloomFilters
       * </pre>
       *
       * <code>repeated string probe_fields = 6;</code>
       */
      public Builder setProbeFields(
          int index, java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureProbeFieldsIsMutable();
        probeFields_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * probe fields with corresponding BloomFilters
       * </pre>
       *
       * <code>repeated string probe_fields = 6;</code>
       */
      public Builder addProbeFields(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureProbeFieldsIsMutable();
        probeFields_.add(value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * probe fields with corresponding BloomFilters
       * </pre>
       *
       * <code>repeated string probe_fields = 6;</code>
       */
      public Builder addAllProbeFields(
          java.lang.Iterable<java.lang.String> values) {
        ensureProbeFieldsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, probeFields_);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * probe fields with corresponding BloomFilters
       * </pre>
       *
       * <code>repeated string probe_fields = 6;</code>
       */
      public Builder clearProbeFields() {
        probeFields_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * probe fields with corresponding BloomFilters
       * </pre>
       *
       * <code>repeated string probe_fields = 6;</code>
       */
      public Builder addProbeFieldsBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureProbeFieldsIsMutable();
        probeFields_.add(value);
        onChanged();
        return this;
      }

      private int hjOpId_ ;
      /**
       * <pre>
       * the operator id of the HashJoin which generates this RuntimeFilter
       * </pre>
       *
       * <code>optional int32 hj_op_id = 7;</code>
       */
      public boolean hasHjOpId() {
        return ((bitField0_ & 0x00000040) == 0x00000040);
      }
      /**
       * <pre>
       * the operator id of the HashJoin which generates this RuntimeFilter
       * </pre>
       *
       * <code>optional int32 hj_op_id = 7;</code>
       */
      public int getHjOpId() {
        return hjOpId_;
      }
      /**
       * <pre>
       * the operator id of the HashJoin which generates this RuntimeFilter
       * </pre>
       *
       * <code>optional int32 hj_op_id = 7;</code>
       */
      public Builder setHjOpId(int value) {
        bitField0_ |= 0x00000040;
        hjOpId_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * the operator id of the HashJoin which generates this RuntimeFilter
       * </pre>
       *
       * <code>optional int32 hj_op_id = 7;</code>
       */
      public Builder clearHjOpId() {
        bitField0_ = (bitField0_ & ~0x00000040);
        hjOpId_ = 0;
        onChanged();
        return this;
      }

      private long rfIdentifier_ ;
      /**
       * <pre>
       * the runtime filter identifier
       * </pre>
       *
       * <code>optional int64 rf_identifier = 8;</code>
       */
      public boolean hasRfIdentifier() {
        return ((bitField0_ & 0x00000080) == 0x00000080);
      }
      /**
       * <pre>
       * the runtime filter identifier
       * </pre>
       *
       * <code>optional int64 rf_identifier = 8;</code>
       */
      public long getRfIdentifier() {
        return rfIdentifier_;
      }
      /**
       * <pre>
       * the runtime filter identifier
       * </pre>
       *
       * <code>optional int64 rf_identifier = 8;</code>
       */
      public Builder setRfIdentifier(long value) {
        bitField0_ |= 0x00000080;
        rfIdentifier_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * the runtime filter identifier
       * </pre>
       *
       * <code>optional int64 rf_identifier = 8;</code>
       */
      public Builder clearRfIdentifier() {
        bitField0_ = (bitField0_ & ~0x00000080);
        rfIdentifier_ = 0L;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:exec.bit.data.RuntimeFilterBDef)
    }

    // @@protoc_insertion_point(class_scope:exec.bit.data.RuntimeFilterBDef)
    private static final org.apache.drill.exec.proto.BitData.RuntimeFilterBDef DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.drill.exec.proto.BitData.RuntimeFilterBDef();
    }

    public static org.apache.drill.exec.proto.BitData.RuntimeFilterBDef getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<RuntimeFilterBDef>
        PARSER = new com.google.protobuf.AbstractParser<RuntimeFilterBDef>() {
      @java.lang.Override
      public RuntimeFilterBDef parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new RuntimeFilterBDef(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<RuntimeFilterBDef> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<RuntimeFilterBDef> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.drill.exec.proto.BitData.RuntimeFilterBDef getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_exec_bit_data_BitClientHandshake_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_exec_bit_data_BitClientHandshake_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_exec_bit_data_BitServerHandshake_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_exec_bit_data_BitServerHandshake_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_exec_bit_data_FragmentRecordBatch_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_exec_bit_data_FragmentRecordBatch_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_exec_bit_data_RuntimeFilterBDef_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_exec_bit_data_RuntimeFilterBDef_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\rBitData.proto\022\rexec.bit.data\032\025Executio" +
      "nProtos.proto\032\022Coordination.proto\032\023UserB" +
      "itShared.proto\"]\n\022BitClientHandshake\022\023\n\013" +
      "rpc_version\030\001 \001(\005\0222\n\007channel\030\002 \001(\0162\027.exe" +
      "c.shared.RpcChannel:\010BIT_DATA\"K\n\022BitServ" +
      "erHandshake\022\023\n\013rpc_version\030\001 \001(\005\022 \n\030auth" +
      "enticationMechanisms\030\002 \003(\t\"\214\002\n\023FragmentR" +
      "ecordBatch\022&\n\010query_id\030\001 \001(\0132\024.exec.shar" +
      "ed.QueryId\022#\n\033receiving_major_fragment_i" +
      "d\030\002 \001(\005\022#\n\033receiving_minor_fragment_id\030\003" +
      " \003(\005\022!\n\031sending_major_fragment_id\030\004 \001(\005\022" +
      "!\n\031sending_minor_fragment_id\030\005 \001(\005\022(\n\003de" +
      "f\030\006 \001(\0132\033.exec.shared.RecordBatchDef\022\023\n\013" +
      "isLastBatch\030\007 \001(\010\"\350\001\n\021RuntimeFilterBDef\022" +
      "&\n\010query_id\030\001 \001(\0132\024.exec.shared.QueryId\022" +
      "\031\n\021major_fragment_id\030\002 \001(\005\022\031\n\021minor_frag" +
      "ment_id\030\003 \001(\005\022\022\n\nto_foreman\030\004 \001(\010\022\"\n\032blo" +
      "om_filter_size_in_bytes\030\005 \003(\005\022\024\n\014probe_f" +
      "ields\030\006 \003(\t\022\020\n\010hj_op_id\030\007 \001(\005\022\025\n\rrf_iden" +
      "tifier\030\010 \001(\003*n\n\007RpcType\022\r\n\tHANDSHAKE\020\000\022\007" +
      "\n\003ACK\020\001\022\013\n\007GOODBYE\020\002\022\024\n\020REQ_RECORD_BATCH" +
      "\020\003\022\020\n\014SASL_MESSAGE\020\004\022\026\n\022REQ_RUNTIME_FILT" +
      "ER\020\005B(\n\033org.apache.drill.exec.protoB\007Bit" +
      "DataH\001"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          org.apache.drill.exec.proto.ExecProtos.getDescriptor(),
          org.apache.drill.exec.proto.CoordinationProtos.getDescriptor(),
          org.apache.drill.exec.proto.UserBitShared.getDescriptor(),
        }, assigner);
    internal_static_exec_bit_data_BitClientHandshake_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_exec_bit_data_BitClientHandshake_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_exec_bit_data_BitClientHandshake_descriptor,
        new java.lang.String[] { "RpcVersion", "Channel", });
    internal_static_exec_bit_data_BitServerHandshake_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_exec_bit_data_BitServerHandshake_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_exec_bit_data_BitServerHandshake_descriptor,
        new java.lang.String[] { "RpcVersion", "AuthenticationMechanisms", });
    internal_static_exec_bit_data_FragmentRecordBatch_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_exec_bit_data_FragmentRecordBatch_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_exec_bit_data_FragmentRecordBatch_descriptor,
        new java.lang.String[] { "QueryId", "ReceivingMajorFragmentId", "ReceivingMinorFragmentId", "SendingMajorFragmentId", "SendingMinorFragmentId", "Def", "IsLastBatch", });
    internal_static_exec_bit_data_RuntimeFilterBDef_descriptor =
      getDescriptor().getMessageTypes().get(3);
    internal_static_exec_bit_data_RuntimeFilterBDef_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_exec_bit_data_RuntimeFilterBDef_descriptor,
        new java.lang.String[] { "QueryId", "MajorFragmentId", "MinorFragmentId", "ToForeman", "BloomFilterSizeInBytes", "ProbeFields", "HjOpId", "RfIdentifier", });
    org.apache.drill.exec.proto.ExecProtos.getDescriptor();
    org.apache.drill.exec.proto.CoordinationProtos.getDescriptor();
    org.apache.drill.exec.proto.UserBitShared.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
