/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by http://code.google.com/p/protostuff/ ... DO NOT EDIT!
// Generated from protobuf

package org.apache.drill.exec.proto.beans;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;

import com.dyuproject.protostuff.GraphIOUtil;
import com.dyuproject.protostuff.Input;
import com.dyuproject.protostuff.Message;
import com.dyuproject.protostuff.Output;
import com.dyuproject.protostuff.Schema;

public final class ServerMeta implements Externalizable, Message<ServerMeta>, Schema<ServerMeta>
{

    public static Schema<ServerMeta> getSchema()
    {
        return DEFAULT_INSTANCE;
    }

    public static ServerMeta getDefaultInstance()
    {
        return DEFAULT_INSTANCE;
    }

    static final ServerMeta DEFAULT_INSTANCE = new ServerMeta();

    
    private Boolean allTablesSelectable;
    private Boolean blobIncludedInMaxRowSize;
    private Boolean catalogAtStart;
    private String catalogSeparator;
    private String catalogTerm;
    private List<CollateSupport> collateSupport;
    private Boolean columnAliasingSupported;
    private List<ConvertSupport> convertSupport;
    private CorrelationNamesSupport correlationNamesSupport;
    private List<String> dateTimeFunctions;
    private List<DateTimeLiteralsSupport> dateTimeLiteralsSupport;
    private GroupBySupport groupBySupport;
    private IdentifierCasing identifierCasing;
    private String identifierQuoteString;
    private Boolean likeEscapeClauseSupported;
    private int maxBinaryLiteralLength;
    private int maxCatalogNameLength;
    private int maxCharLiteralLength;
    private int maxColumnNameLength;
    private int maxColumnsInGroupBy;
    private int maxColumnsInOrderBy;
    private int maxColumnsInSelect;
    private int maxCursorNameLength;
    private int maxLogicalLobSize;
    private int maxRowSize;
    private int maxSchemaNameLength;
    private int maxStatementLength;
    private int maxStatements;
    private int maxTableNameLength;
    private int maxTablesInSelect;
    private int maxUserNameLength;
    private NullCollation nullCollation;
    private Boolean nullPlusNonNullEqualsNull;
    private List<String> numericFunctions;
    private List<OrderBySupport> orderBySupport;
    private List<OuterJoinSupport> outerJoinSupport;
    private IdentifierCasing quotedIdentifierCasing;
    private Boolean readOnly;
    private String schemaTerm;
    private String searchEscapeString;
    private Boolean selectForUpdateSupported;
    private String specialCharacters;
    private List<String> sqlKeywords;
    private List<String> stringFunctions;
    private List<SubQuerySupport> subquerySupport;
    private List<String> systemFunctions;
    private String tableTerm;
    private Boolean transactionSupported;
    private List<UnionSupport> unionSupport;
    private String currentSchema;

    public ServerMeta()
    {
        
    }

    // getters and setters

    // allTablesSelectable

    public Boolean getAllTablesSelectable()
    {
        return allTablesSelectable;
    }

    public ServerMeta setAllTablesSelectable(Boolean allTablesSelectable)
    {
        this.allTablesSelectable = allTablesSelectable;
        return this;
    }

    // blobIncludedInMaxRowSize

    public Boolean getBlobIncludedInMaxRowSize()
    {
        return blobIncludedInMaxRowSize;
    }

    public ServerMeta setBlobIncludedInMaxRowSize(Boolean blobIncludedInMaxRowSize)
    {
        this.blobIncludedInMaxRowSize = blobIncludedInMaxRowSize;
        return this;
    }

    // catalogAtStart

    public Boolean getCatalogAtStart()
    {
        return catalogAtStart;
    }

    public ServerMeta setCatalogAtStart(Boolean catalogAtStart)
    {
        this.catalogAtStart = catalogAtStart;
        return this;
    }

    // catalogSeparator

    public String getCatalogSeparator()
    {
        return catalogSeparator;
    }

    public ServerMeta setCatalogSeparator(String catalogSeparator)
    {
        this.catalogSeparator = catalogSeparator;
        return this;
    }

    // catalogTerm

    public String getCatalogTerm()
    {
        return catalogTerm;
    }

    public ServerMeta setCatalogTerm(String catalogTerm)
    {
        this.catalogTerm = catalogTerm;
        return this;
    }

    // collateSupport

    public List<CollateSupport> getCollateSupportList()
    {
        return collateSupport;
    }

    public ServerMeta setCollateSupportList(List<CollateSupport> collateSupport)
    {
        this.collateSupport = collateSupport;
        return this;
    }

    // columnAliasingSupported

    public Boolean getColumnAliasingSupported()
    {
        return columnAliasingSupported;
    }

    public ServerMeta setColumnAliasingSupported(Boolean columnAliasingSupported)
    {
        this.columnAliasingSupported = columnAliasingSupported;
        return this;
    }

    // convertSupport

    public List<ConvertSupport> getConvertSupportList()
    {
        return convertSupport;
    }

    public ServerMeta setConvertSupportList(List<ConvertSupport> convertSupport)
    {
        this.convertSupport = convertSupport;
        return this;
    }

    // correlationNamesSupport

    public CorrelationNamesSupport getCorrelationNamesSupport()
    {
        return correlationNamesSupport == null ? CorrelationNamesSupport.CN_NONE : correlationNamesSupport;
    }

    public ServerMeta setCorrelationNamesSupport(CorrelationNamesSupport correlationNamesSupport)
    {
        this.correlationNamesSupport = correlationNamesSupport;
        return this;
    }

    // dateTimeFunctions

    public List<String> getDateTimeFunctionsList()
    {
        return dateTimeFunctions;
    }

    public ServerMeta setDateTimeFunctionsList(List<String> dateTimeFunctions)
    {
        this.dateTimeFunctions = dateTimeFunctions;
        return this;
    }

    // dateTimeLiteralsSupport

    public List<DateTimeLiteralsSupport> getDateTimeLiteralsSupportList()
    {
        return dateTimeLiteralsSupport;
    }

    public ServerMeta setDateTimeLiteralsSupportList(List<DateTimeLiteralsSupport> dateTimeLiteralsSupport)
    {
        this.dateTimeLiteralsSupport = dateTimeLiteralsSupport;
        return this;
    }

    // groupBySupport

    public GroupBySupport getGroupBySupport()
    {
        return groupBySupport == null ? GroupBySupport.GB_NONE : groupBySupport;
    }

    public ServerMeta setGroupBySupport(GroupBySupport groupBySupport)
    {
        this.groupBySupport = groupBySupport;
        return this;
    }

    // identifierCasing

    public IdentifierCasing getIdentifierCasing()
    {
        return identifierCasing == null ? IdentifierCasing.IC_UNKNOWN : identifierCasing;
    }

    public ServerMeta setIdentifierCasing(IdentifierCasing identifierCasing)
    {
        this.identifierCasing = identifierCasing;
        return this;
    }

    // identifierQuoteString

    public String getIdentifierQuoteString()
    {
        return identifierQuoteString;
    }

    public ServerMeta setIdentifierQuoteString(String identifierQuoteString)
    {
        this.identifierQuoteString = identifierQuoteString;
        return this;
    }

    // likeEscapeClauseSupported

    public Boolean getLikeEscapeClauseSupported()
    {
        return likeEscapeClauseSupported;
    }

    public ServerMeta setLikeEscapeClauseSupported(Boolean likeEscapeClauseSupported)
    {
        this.likeEscapeClauseSupported = likeEscapeClauseSupported;
        return this;
    }

    // maxBinaryLiteralLength

    public int getMaxBinaryLiteralLength()
    {
        return maxBinaryLiteralLength;
    }

    public ServerMeta setMaxBinaryLiteralLength(int maxBinaryLiteralLength)
    {
        this.maxBinaryLiteralLength = maxBinaryLiteralLength;
        return this;
    }

    // maxCatalogNameLength

    public int getMaxCatalogNameLength()
    {
        return maxCatalogNameLength;
    }

    public ServerMeta setMaxCatalogNameLength(int maxCatalogNameLength)
    {
        this.maxCatalogNameLength = maxCatalogNameLength;
        return this;
    }

    // maxCharLiteralLength

    public int getMaxCharLiteralLength()
    {
        return maxCharLiteralLength;
    }

    public ServerMeta setMaxCharLiteralLength(int maxCharLiteralLength)
    {
        this.maxCharLiteralLength = maxCharLiteralLength;
        return this;
    }

    // maxColumnNameLength

    public int getMaxColumnNameLength()
    {
        return maxColumnNameLength;
    }

    public ServerMeta setMaxColumnNameLength(int maxColumnNameLength)
    {
        this.maxColumnNameLength = maxColumnNameLength;
        return this;
    }

    // maxColumnsInGroupBy

    public int getMaxColumnsInGroupBy()
    {
        return maxColumnsInGroupBy;
    }

    public ServerMeta setMaxColumnsInGroupBy(int maxColumnsInGroupBy)
    {
        this.maxColumnsInGroupBy = maxColumnsInGroupBy;
        return this;
    }

    // maxColumnsInOrderBy

    public int getMaxColumnsInOrderBy()
    {
        return maxColumnsInOrderBy;
    }

    public ServerMeta setMaxColumnsInOrderBy(int maxColumnsInOrderBy)
    {
        this.maxColumnsInOrderBy = maxColumnsInOrderBy;
        return this;
    }

    // maxColumnsInSelect

    public int getMaxColumnsInSelect()
    {
        return maxColumnsInSelect;
    }

    public ServerMeta setMaxColumnsInSelect(int maxColumnsInSelect)
    {
        this.maxColumnsInSelect = maxColumnsInSelect;
        return this;
    }

    // maxCursorNameLength

    public int getMaxCursorNameLength()
    {
        return maxCursorNameLength;
    }

    public ServerMeta setMaxCursorNameLength(int maxCursorNameLength)
    {
        this.maxCursorNameLength = maxCursorNameLength;
        return this;
    }

    // maxLogicalLobSize

    public int getMaxLogicalLobSize()
    {
        return maxLogicalLobSize;
    }

    public ServerMeta setMaxLogicalLobSize(int maxLogicalLobSize)
    {
        this.maxLogicalLobSize = maxLogicalLobSize;
        return this;
    }

    // maxRowSize

    public int getMaxRowSize()
    {
        return maxRowSize;
    }

    public ServerMeta setMaxRowSize(int maxRowSize)
    {
        this.maxRowSize = maxRowSize;
        return this;
    }

    // maxSchemaNameLength

    public int getMaxSchemaNameLength()
    {
        return maxSchemaNameLength;
    }

    public ServerMeta setMaxSchemaNameLength(int maxSchemaNameLength)
    {
        this.maxSchemaNameLength = maxSchemaNameLength;
        return this;
    }

    // maxStatementLength

    public int getMaxStatementLength()
    {
        return maxStatementLength;
    }

    public ServerMeta setMaxStatementLength(int maxStatementLength)
    {
        this.maxStatementLength = maxStatementLength;
        return this;
    }

    // maxStatements

    public int getMaxStatements()
    {
        return maxStatements;
    }

    public ServerMeta setMaxStatements(int maxStatements)
    {
        this.maxStatements = maxStatements;
        return this;
    }

    // maxTableNameLength

    public int getMaxTableNameLength()
    {
        return maxTableNameLength;
    }

    public ServerMeta setMaxTableNameLength(int maxTableNameLength)
    {
        this.maxTableNameLength = maxTableNameLength;
        return this;
    }

    // maxTablesInSelect

    public int getMaxTablesInSelect()
    {
        return maxTablesInSelect;
    }

    public ServerMeta setMaxTablesInSelect(int maxTablesInSelect)
    {
        this.maxTablesInSelect = maxTablesInSelect;
        return this;
    }

    // maxUserNameLength

    public int getMaxUserNameLength()
    {
        return maxUserNameLength;
    }

    public ServerMeta setMaxUserNameLength(int maxUserNameLength)
    {
        this.maxUserNameLength = maxUserNameLength;
        return this;
    }

    // nullCollation

    public NullCollation getNullCollation()
    {
        return nullCollation == null ? NullCollation.NC_UNKNOWN : nullCollation;
    }

    public ServerMeta setNullCollation(NullCollation nullCollation)
    {
        this.nullCollation = nullCollation;
        return this;
    }

    // nullPlusNonNullEqualsNull

    public Boolean getNullPlusNonNullEqualsNull()
    {
        return nullPlusNonNullEqualsNull;
    }

    public ServerMeta setNullPlusNonNullEqualsNull(Boolean nullPlusNonNullEqualsNull)
    {
        this.nullPlusNonNullEqualsNull = nullPlusNonNullEqualsNull;
        return this;
    }

    // numericFunctions

    public List<String> getNumericFunctionsList()
    {
        return numericFunctions;
    }

    public ServerMeta setNumericFunctionsList(List<String> numericFunctions)
    {
        this.numericFunctions = numericFunctions;
        return this;
    }

    // orderBySupport

    public List<OrderBySupport> getOrderBySupportList()
    {
        return orderBySupport;
    }

    public ServerMeta setOrderBySupportList(List<OrderBySupport> orderBySupport)
    {
        this.orderBySupport = orderBySupport;
        return this;
    }

    // outerJoinSupport

    public List<OuterJoinSupport> getOuterJoinSupportList()
    {
        return outerJoinSupport;
    }

    public ServerMeta setOuterJoinSupportList(List<OuterJoinSupport> outerJoinSupport)
    {
        this.outerJoinSupport = outerJoinSupport;
        return this;
    }

    // quotedIdentifierCasing

    public IdentifierCasing getQuotedIdentifierCasing()
    {
        return quotedIdentifierCasing == null ? IdentifierCasing.IC_UNKNOWN : quotedIdentifierCasing;
    }

    public ServerMeta setQuotedIdentifierCasing(IdentifierCasing quotedIdentifierCasing)
    {
        this.quotedIdentifierCasing = quotedIdentifierCasing;
        return this;
    }

    // readOnly

    public Boolean getReadOnly()
    {
        return readOnly;
    }

    public ServerMeta setReadOnly(Boolean readOnly)
    {
        this.readOnly = readOnly;
        return this;
    }

    // schemaTerm

    public String getSchemaTerm()
    {
        return schemaTerm;
    }

    public ServerMeta setSchemaTerm(String schemaTerm)
    {
        this.schemaTerm = schemaTerm;
        return this;
    }

    // searchEscapeString

    public String getSearchEscapeString()
    {
        return searchEscapeString;
    }

    public ServerMeta setSearchEscapeString(String searchEscapeString)
    {
        this.searchEscapeString = searchEscapeString;
        return this;
    }

    // selectForUpdateSupported

    public Boolean getSelectForUpdateSupported()
    {
        return selectForUpdateSupported;
    }

    public ServerMeta setSelectForUpdateSupported(Boolean selectForUpdateSupported)
    {
        this.selectForUpdateSupported = selectForUpdateSupported;
        return this;
    }

    // specialCharacters

    public String getSpecialCharacters()
    {
        return specialCharacters;
    }

    public ServerMeta setSpecialCharacters(String specialCharacters)
    {
        this.specialCharacters = specialCharacters;
        return this;
    }

    // sqlKeywords

    public List<String> getSqlKeywordsList()
    {
        return sqlKeywords;
    }

    public ServerMeta setSqlKeywordsList(List<String> sqlKeywords)
    {
        this.sqlKeywords = sqlKeywords;
        return this;
    }

    // stringFunctions

    public List<String> getStringFunctionsList()
    {
        return stringFunctions;
    }

    public ServerMeta setStringFunctionsList(List<String> stringFunctions)
    {
        this.stringFunctions = stringFunctions;
        return this;
    }

    // subquerySupport

    public List<SubQuerySupport> getSubquerySupportList()
    {
        return subquerySupport;
    }

    public ServerMeta setSubquerySupportList(List<SubQuerySupport> subquerySupport)
    {
        this.subquerySupport = subquerySupport;
        return this;
    }

    // systemFunctions

    public List<String> getSystemFunctionsList()
    {
        return systemFunctions;
    }

    public ServerMeta setSystemFunctionsList(List<String> systemFunctions)
    {
        this.systemFunctions = systemFunctions;
        return this;
    }

    // tableTerm

    public String getTableTerm()
    {
        return tableTerm;
    }

    public ServerMeta setTableTerm(String tableTerm)
    {
        this.tableTerm = tableTerm;
        return this;
    }

    // transactionSupported

    public Boolean getTransactionSupported()
    {
        return transactionSupported;
    }

    public ServerMeta setTransactionSupported(Boolean transactionSupported)
    {
        this.transactionSupported = transactionSupported;
        return this;
    }

    // unionSupport

    public List<UnionSupport> getUnionSupportList()
    {
        return unionSupport;
    }

    public ServerMeta setUnionSupportList(List<UnionSupport> unionSupport)
    {
        this.unionSupport = unionSupport;
        return this;
    }

    // currentSchema

    public String getCurrentSchema()
    {
        return currentSchema;
    }

    public ServerMeta setCurrentSchema(String currentSchema)
    {
        this.currentSchema = currentSchema;
        return this;
    }

    // java serialization

    public void readExternal(ObjectInput in) throws IOException
    {
        GraphIOUtil.mergeDelimitedFrom(in, this, this);
    }

    public void writeExternal(ObjectOutput out) throws IOException
    {
        GraphIOUtil.writeDelimitedTo(out, this, this);
    }

    // message method

    public Schema<ServerMeta> cachedSchema()
    {
        return DEFAULT_INSTANCE;
    }

    // schema methods

    public ServerMeta newMessage()
    {
        return new ServerMeta();
    }

    public Class<ServerMeta> typeClass()
    {
        return ServerMeta.class;
    }

    public String messageName()
    {
        return ServerMeta.class.getSimpleName();
    }

    public String messageFullName()
    {
        return ServerMeta.class.getName();
    }

    public boolean isInitialized(ServerMeta message)
    {
        return true;
    }

    public void mergeFrom(Input input, ServerMeta message) throws IOException
    {
        for(int number = input.readFieldNumber(this);; number = input.readFieldNumber(this))
        {
            switch(number)
            {
                case 0:
                    return;
                case 1:
                    message.allTablesSelectable = input.readBool();
                    break;
                case 2:
                    message.blobIncludedInMaxRowSize = input.readBool();
                    break;
                case 3:
                    message.catalogAtStart = input.readBool();
                    break;
                case 4:
                    message.catalogSeparator = input.readString();
                    break;
                case 5:
                    message.catalogTerm = input.readString();
                    break;
                case 6:
                    if(message.collateSupport == null)
                        message.collateSupport = new ArrayList<CollateSupport>();
                    message.collateSupport.add(CollateSupport.valueOf(input.readEnum()));
                    break;
                case 7:
                    message.columnAliasingSupported = input.readBool();
                    break;
                case 8:
                    if(message.convertSupport == null)
                        message.convertSupport = new ArrayList<ConvertSupport>();
                    message.convertSupport.add(input.mergeObject(null, ConvertSupport.getSchema()));
                    break;

                case 9:
                    message.correlationNamesSupport = CorrelationNamesSupport.valueOf(input.readEnum());
                    break;
                case 10:
                    if(message.dateTimeFunctions == null)
                        message.dateTimeFunctions = new ArrayList<String>();
                    message.dateTimeFunctions.add(input.readString());
                    break;
                case 11:
                    if(message.dateTimeLiteralsSupport == null)
                        message.dateTimeLiteralsSupport = new ArrayList<DateTimeLiteralsSupport>();
                    message.dateTimeLiteralsSupport.add(DateTimeLiteralsSupport.valueOf(input.readEnum()));
                    break;
                case 12:
                    message.groupBySupport = GroupBySupport.valueOf(input.readEnum());
                    break;
                case 13:
                    message.identifierCasing = IdentifierCasing.valueOf(input.readEnum());
                    break;
                case 14:
                    message.identifierQuoteString = input.readString();
                    break;
                case 15:
                    message.likeEscapeClauseSupported = input.readBool();
                    break;
                case 16:
                    message.maxBinaryLiteralLength = input.readUInt32();
                    break;
                case 17:
                    message.maxCatalogNameLength = input.readUInt32();
                    break;
                case 18:
                    message.maxCharLiteralLength = input.readUInt32();
                    break;
                case 19:
                    message.maxColumnNameLength = input.readUInt32();
                    break;
                case 20:
                    message.maxColumnsInGroupBy = input.readUInt32();
                    break;
                case 21:
                    message.maxColumnsInOrderBy = input.readUInt32();
                    break;
                case 22:
                    message.maxColumnsInSelect = input.readUInt32();
                    break;
                case 23:
                    message.maxCursorNameLength = input.readUInt32();
                    break;
                case 24:
                    message.maxLogicalLobSize = input.readUInt32();
                    break;
                case 25:
                    message.maxRowSize = input.readUInt32();
                    break;
                case 26:
                    message.maxSchemaNameLength = input.readUInt32();
                    break;
                case 27:
                    message.maxStatementLength = input.readUInt32();
                    break;
                case 28:
                    message.maxStatements = input.readUInt32();
                    break;
                case 29:
                    message.maxTableNameLength = input.readUInt32();
                    break;
                case 30:
                    message.maxTablesInSelect = input.readUInt32();
                    break;
                case 31:
                    message.maxUserNameLength = input.readUInt32();
                    break;
                case 32:
                    message.nullCollation = NullCollation.valueOf(input.readEnum());
                    break;
                case 33:
                    message.nullPlusNonNullEqualsNull = input.readBool();
                    break;
                case 34:
                    if(message.numericFunctions == null)
                        message.numericFunctions = new ArrayList<String>();
                    message.numericFunctions.add(input.readString());
                    break;
                case 35:
                    if(message.orderBySupport == null)
                        message.orderBySupport = new ArrayList<OrderBySupport>();
                    message.orderBySupport.add(OrderBySupport.valueOf(input.readEnum()));
                    break;
                case 36:
                    if(message.outerJoinSupport == null)
                        message.outerJoinSupport = new ArrayList<OuterJoinSupport>();
                    message.outerJoinSupport.add(OuterJoinSupport.valueOf(input.readEnum()));
                    break;
                case 37:
                    message.quotedIdentifierCasing = IdentifierCasing.valueOf(input.readEnum());
                    break;
                case 38:
                    message.readOnly = input.readBool();
                    break;
                case 39:
                    message.schemaTerm = input.readString();
                    break;
                case 40:
                    message.searchEscapeString = input.readString();
                    break;
                case 41:
                    message.selectForUpdateSupported = input.readBool();
                    break;
                case 42:
                    message.specialCharacters = input.readString();
                    break;
                case 43:
                    if(message.sqlKeywords == null)
                        message.sqlKeywords = new ArrayList<String>();
                    message.sqlKeywords.add(input.readString());
                    break;
                case 44:
                    if(message.stringFunctions == null)
                        message.stringFunctions = new ArrayList<String>();
                    message.stringFunctions.add(input.readString());
                    break;
                case 45:
                    if(message.subquerySupport == null)
                        message.subquerySupport = new ArrayList<SubQuerySupport>();
                    message.subquerySupport.add(SubQuerySupport.valueOf(input.readEnum()));
                    break;
                case 46:
                    if(message.systemFunctions == null)
                        message.systemFunctions = new ArrayList<String>();
                    message.systemFunctions.add(input.readString());
                    break;
                case 47:
                    message.tableTerm = input.readString();
                    break;
                case 48:
                    message.transactionSupported = input.readBool();
                    break;
                case 49:
                    if(message.unionSupport == null)
                        message.unionSupport = new ArrayList<UnionSupport>();
                    message.unionSupport.add(UnionSupport.valueOf(input.readEnum()));
                    break;
                case 50:
                    message.currentSchema = input.readString();
                    break;
                default:
                    input.handleUnknownField(number, this);
            }   
        }
    }


    public void writeTo(Output output, ServerMeta message) throws IOException
    {
        if(message.allTablesSelectable != null)
            output.writeBool(1, message.allTablesSelectable, false);

        if(message.blobIncludedInMaxRowSize != null)
            output.writeBool(2, message.blobIncludedInMaxRowSize, false);

        if(message.catalogAtStart != null)
            output.writeBool(3, message.catalogAtStart, false);

        if(message.catalogSeparator != null)
            output.writeString(4, message.catalogSeparator, false);

        if(message.catalogTerm != null)
            output.writeString(5, message.catalogTerm, false);

        if(message.collateSupport != null)
        {
            for(CollateSupport collateSupport : message.collateSupport)
            {
                if(collateSupport != null)
                    output.writeEnum(6, collateSupport.number, true);
            }
        }

        if(message.columnAliasingSupported != null)
            output.writeBool(7, message.columnAliasingSupported, false);

        if(message.convertSupport != null)
        {
            for(ConvertSupport convertSupport : message.convertSupport)
            {
                if(convertSupport != null)
                    output.writeObject(8, convertSupport, ConvertSupport.getSchema(), true);
            }
        }


        if(message.correlationNamesSupport != null)
             output.writeEnum(9, message.correlationNamesSupport.number, false);

        if(message.dateTimeFunctions != null)
        {
            for(String dateTimeFunctions : message.dateTimeFunctions)
            {
                if(dateTimeFunctions != null)
                    output.writeString(10, dateTimeFunctions, true);
            }
        }

        if(message.dateTimeLiteralsSupport != null)
        {
            for(DateTimeLiteralsSupport dateTimeLiteralsSupport : message.dateTimeLiteralsSupport)
            {
                if(dateTimeLiteralsSupport != null)
                    output.writeEnum(11, dateTimeLiteralsSupport.number, true);
            }
        }

        if(message.groupBySupport != null)
             output.writeEnum(12, message.groupBySupport.number, false);

        if(message.identifierCasing != null)
             output.writeEnum(13, message.identifierCasing.number, false);

        if(message.identifierQuoteString != null)
            output.writeString(14, message.identifierQuoteString, false);

        if(message.likeEscapeClauseSupported != null)
            output.writeBool(15, message.likeEscapeClauseSupported, false);

        if(message.maxBinaryLiteralLength != 0)
            output.writeUInt32(16, message.maxBinaryLiteralLength, false);

        if(message.maxCatalogNameLength != 0)
            output.writeUInt32(17, message.maxCatalogNameLength, false);

        if(message.maxCharLiteralLength != 0)
            output.writeUInt32(18, message.maxCharLiteralLength, false);

        if(message.maxColumnNameLength != 0)
            output.writeUInt32(19, message.maxColumnNameLength, false);

        if(message.maxColumnsInGroupBy != 0)
            output.writeUInt32(20, message.maxColumnsInGroupBy, false);

        if(message.maxColumnsInOrderBy != 0)
            output.writeUInt32(21, message.maxColumnsInOrderBy, false);

        if(message.maxColumnsInSelect != 0)
            output.writeUInt32(22, message.maxColumnsInSelect, false);

        if(message.maxCursorNameLength != 0)
            output.writeUInt32(23, message.maxCursorNameLength, false);

        if(message.maxLogicalLobSize != 0)
            output.writeUInt32(24, message.maxLogicalLobSize, false);

        if(message.maxRowSize != 0)
            output.writeUInt32(25, message.maxRowSize, false);

        if(message.maxSchemaNameLength != 0)
            output.writeUInt32(26, message.maxSchemaNameLength, false);

        if(message.maxStatementLength != 0)
            output.writeUInt32(27, message.maxStatementLength, false);

        if(message.maxStatements != 0)
            output.writeUInt32(28, message.maxStatements, false);

        if(message.maxTableNameLength != 0)
            output.writeUInt32(29, message.maxTableNameLength, false);

        if(message.maxTablesInSelect != 0)
            output.writeUInt32(30, message.maxTablesInSelect, false);

        if(message.maxUserNameLength != 0)
            output.writeUInt32(31, message.maxUserNameLength, false);

        if(message.nullCollation != null)
             output.writeEnum(32, message.nullCollation.number, false);

        if(message.nullPlusNonNullEqualsNull != null)
            output.writeBool(33, message.nullPlusNonNullEqualsNull, false);

        if(message.numericFunctions != null)
        {
            for(String numericFunctions : message.numericFunctions)
            {
                if(numericFunctions != null)
                    output.writeString(34, numericFunctions, true);
            }
        }

        if(message.orderBySupport != null)
        {
            for(OrderBySupport orderBySupport : message.orderBySupport)
            {
                if(orderBySupport != null)
                    output.writeEnum(35, orderBySupport.number, true);
            }
        }

        if(message.outerJoinSupport != null)
        {
            for(OuterJoinSupport outerJoinSupport : message.outerJoinSupport)
            {
                if(outerJoinSupport != null)
                    output.writeEnum(36, outerJoinSupport.number, true);
            }
        }

        if(message.quotedIdentifierCasing != null)
             output.writeEnum(37, message.quotedIdentifierCasing.number, false);

        if(message.readOnly != null)
            output.writeBool(38, message.readOnly, false);

        if(message.schemaTerm != null)
            output.writeString(39, message.schemaTerm, false);

        if(message.searchEscapeString != null)
            output.writeString(40, message.searchEscapeString, false);

        if(message.selectForUpdateSupported != null)
            output.writeBool(41, message.selectForUpdateSupported, false);

        if(message.specialCharacters != null)
            output.writeString(42, message.specialCharacters, false);

        if(message.sqlKeywords != null)
        {
            for(String sqlKeywords : message.sqlKeywords)
            {
                if(sqlKeywords != null)
                    output.writeString(43, sqlKeywords, true);
            }
        }

        if(message.stringFunctions != null)
        {
            for(String stringFunctions : message.stringFunctions)
            {
                if(stringFunctions != null)
                    output.writeString(44, stringFunctions, true);
            }
        }

        if(message.subquerySupport != null)
        {
            for(SubQuerySupport subquerySupport : message.subquerySupport)
            {
                if(subquerySupport != null)
                    output.writeEnum(45, subquerySupport.number, true);
            }
        }

        if(message.systemFunctions != null)
        {
            for(String systemFunctions : message.systemFunctions)
            {
                if(systemFunctions != null)
                    output.writeString(46, systemFunctions, true);
            }
        }

        if(message.tableTerm != null)
            output.writeString(47, message.tableTerm, false);

        if(message.transactionSupported != null)
            output.writeBool(48, message.transactionSupported, false);

        if(message.unionSupport != null)
        {
            for(UnionSupport unionSupport : message.unionSupport)
            {
                if(unionSupport != null)
                    output.writeEnum(49, unionSupport.number, true);
            }
        }

        if(message.currentSchema != null)
            output.writeString(50, message.currentSchema, false);
    }

    public String getFieldName(int number)
    {
        switch(number)
        {
            case 1: return "allTablesSelectable";
            case 2: return "blobIncludedInMaxRowSize";
            case 3: return "catalogAtStart";
            case 4: return "catalogSeparator";
            case 5: return "catalogTerm";
            case 6: return "collateSupport";
            case 7: return "columnAliasingSupported";
            case 8: return "convertSupport";
            case 9: return "correlationNamesSupport";
            case 10: return "dateTimeFunctions";
            case 11: return "dateTimeLiteralsSupport";
            case 12: return "groupBySupport";
            case 13: return "identifierCasing";
            case 14: return "identifierQuoteString";
            case 15: return "likeEscapeClauseSupported";
            case 16: return "maxBinaryLiteralLength";
            case 17: return "maxCatalogNameLength";
            case 18: return "maxCharLiteralLength";
            case 19: return "maxColumnNameLength";
            case 20: return "maxColumnsInGroupBy";
            case 21: return "maxColumnsInOrderBy";
            case 22: return "maxColumnsInSelect";
            case 23: return "maxCursorNameLength";
            case 24: return "maxLogicalLobSize";
            case 25: return "maxRowSize";
            case 26: return "maxSchemaNameLength";
            case 27: return "maxStatementLength";
            case 28: return "maxStatements";
            case 29: return "maxTableNameLength";
            case 30: return "maxTablesInSelect";
            case 31: return "maxUserNameLength";
            case 32: return "nullCollation";
            case 33: return "nullPlusNonNullEqualsNull";
            case 34: return "numericFunctions";
            case 35: return "orderBySupport";
            case 36: return "outerJoinSupport";
            case 37: return "quotedIdentifierCasing";
            case 38: return "readOnly";
            case 39: return "schemaTerm";
            case 40: return "searchEscapeString";
            case 41: return "selectForUpdateSupported";
            case 42: return "specialCharacters";
            case 43: return "sqlKeywords";
            case 44: return "stringFunctions";
            case 45: return "subquerySupport";
            case 46: return "systemFunctions";
            case 47: return "tableTerm";
            case 48: return "transactionSupported";
            case 49: return "unionSupport";
            case 50: return "currentSchema";
            default: return null;
        }
    }

    public int getFieldNumber(String name)
    {
        final Integer number = __fieldMap.get(name);
        return number == null ? 0 : number.intValue();
    }

    private static final java.util.HashMap<String,Integer> __fieldMap = new java.util.HashMap<String,Integer>();
    static
    {
        __fieldMap.put("allTablesSelectable", 1);
        __fieldMap.put("blobIncludedInMaxRowSize", 2);
        __fieldMap.put("catalogAtStart", 3);
        __fieldMap.put("catalogSeparator", 4);
        __fieldMap.put("catalogTerm", 5);
        __fieldMap.put("collateSupport", 6);
        __fieldMap.put("columnAliasingSupported", 7);
        __fieldMap.put("convertSupport", 8);
        __fieldMap.put("correlationNamesSupport", 9);
        __fieldMap.put("dateTimeFunctions", 10);
        __fieldMap.put("dateTimeLiteralsSupport", 11);
        __fieldMap.put("groupBySupport", 12);
        __fieldMap.put("identifierCasing", 13);
        __fieldMap.put("identifierQuoteString", 14);
        __fieldMap.put("likeEscapeClauseSupported", 15);
        __fieldMap.put("maxBinaryLiteralLength", 16);
        __fieldMap.put("maxCatalogNameLength", 17);
        __fieldMap.put("maxCharLiteralLength", 18);
        __fieldMap.put("maxColumnNameLength", 19);
        __fieldMap.put("maxColumnsInGroupBy", 20);
        __fieldMap.put("maxColumnsInOrderBy", 21);
        __fieldMap.put("maxColumnsInSelect", 22);
        __fieldMap.put("maxCursorNameLength", 23);
        __fieldMap.put("maxLogicalLobSize", 24);
        __fieldMap.put("maxRowSize", 25);
        __fieldMap.put("maxSchemaNameLength", 26);
        __fieldMap.put("maxStatementLength", 27);
        __fieldMap.put("maxStatements", 28);
        __fieldMap.put("maxTableNameLength", 29);
        __fieldMap.put("maxTablesInSelect", 30);
        __fieldMap.put("maxUserNameLength", 31);
        __fieldMap.put("nullCollation", 32);
        __fieldMap.put("nullPlusNonNullEqualsNull", 33);
        __fieldMap.put("numericFunctions", 34);
        __fieldMap.put("orderBySupport", 35);
        __fieldMap.put("outerJoinSupport", 36);
        __fieldMap.put("quotedIdentifierCasing", 37);
        __fieldMap.put("readOnly", 38);
        __fieldMap.put("schemaTerm", 39);
        __fieldMap.put("searchEscapeString", 40);
        __fieldMap.put("selectForUpdateSupported", 41);
        __fieldMap.put("specialCharacters", 42);
        __fieldMap.put("sqlKeywords", 43);
        __fieldMap.put("stringFunctions", 44);
        __fieldMap.put("subquerySupport", 45);
        __fieldMap.put("systemFunctions", 46);
        __fieldMap.put("tableTerm", 47);
        __fieldMap.put("transactionSupported", 48);
        __fieldMap.put("unionSupport", 49);
        __fieldMap.put("currentSchema", 50);
    }
    
}
