/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by http://code.google.com/p/protostuff/ ... DO NOT EDIT!
// Generated from protobuf

package org.apache.drill.exec.proto.beans;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;

import com.dyuproject.protostuff.GraphIOUtil;
import com.dyuproject.protostuff.Input;
import com.dyuproject.protostuff.Message;
import com.dyuproject.protostuff.Output;
import com.dyuproject.protostuff.Schema;
import com.dyuproject.protostuff.UninitializedMessageException;

public final class QueryPlanFragments implements Externalizable, Message<QueryPlanFragments>, Schema<QueryPlanFragments>
{

    public static Schema<QueryPlanFragments> getSchema()
    {
        return DEFAULT_INSTANCE;
    }

    public static QueryPlanFragments getDefaultInstance()
    {
        return DEFAULT_INSTANCE;
    }

    static final QueryPlanFragments DEFAULT_INSTANCE = new QueryPlanFragments();

    
    private QueryResult.QueryState status;
    private QueryId queryId;
    private List<PlanFragment> fragments;
    private DrillPBError error;

    public QueryPlanFragments()
    {
        
    }

    public QueryPlanFragments(
        QueryResult.QueryState status
    )
    {
        this.status = status;
    }

    // getters and setters

    // status

    public QueryResult.QueryState getStatus()
    {
        return status;
    }

    public QueryPlanFragments setStatus(QueryResult.QueryState status)
    {
        this.status = status;
        return this;
    }

    // queryId

    public QueryId getQueryId()
    {
        return queryId;
    }

    public QueryPlanFragments setQueryId(QueryId queryId)
    {
        this.queryId = queryId;
        return this;
    }

    // fragments

    public List<PlanFragment> getFragmentsList()
    {
        return fragments;
    }

    public QueryPlanFragments setFragmentsList(List<PlanFragment> fragments)
    {
        this.fragments = fragments;
        return this;
    }

    // error

    public DrillPBError getError()
    {
        return error;
    }

    public QueryPlanFragments setError(DrillPBError error)
    {
        this.error = error;
        return this;
    }

    // java serialization

    public void readExternal(ObjectInput in) throws IOException
    {
        GraphIOUtil.mergeDelimitedFrom(in, this, this);
    }

    public void writeExternal(ObjectOutput out) throws IOException
    {
        GraphIOUtil.writeDelimitedTo(out, this, this);
    }

    // message method

    public Schema<QueryPlanFragments> cachedSchema()
    {
        return DEFAULT_INSTANCE;
    }

    // schema methods

    public QueryPlanFragments newMessage()
    {
        return new QueryPlanFragments();
    }

    public Class<QueryPlanFragments> typeClass()
    {
        return QueryPlanFragments.class;
    }

    public String messageName()
    {
        return QueryPlanFragments.class.getSimpleName();
    }

    public String messageFullName()
    {
        return QueryPlanFragments.class.getName();
    }

    public boolean isInitialized(QueryPlanFragments message)
    {
        return 
            message.status != null;
    }

    public void mergeFrom(Input input, QueryPlanFragments message) throws IOException
    {
        for(int number = input.readFieldNumber(this);; number = input.readFieldNumber(this))
        {
            switch(number)
            {
                case 0:
                    return;
                case 1:
                    message.status = QueryResult.QueryState.valueOf(input.readEnum());
                    break;
                case 2:
                    message.queryId = input.mergeObject(message.queryId, QueryId.getSchema());
                    break;

                case 3:
                    if(message.fragments == null)
                        message.fragments = new ArrayList<PlanFragment>();
                    message.fragments.add(input.mergeObject(null, PlanFragment.getSchema()));
                    break;

                case 4:
                    message.error = input.mergeObject(message.error, DrillPBError.getSchema());
                    break;

                default:
                    input.handleUnknownField(number, this);
            }   
        }
    }


    public void writeTo(Output output, QueryPlanFragments message) throws IOException
    {
        if(message.status == null)
            throw new UninitializedMessageException(message);
        output.writeEnum(1, message.status.number, false);

        if(message.queryId != null)
             output.writeObject(2, message.queryId, QueryId.getSchema(), false);


        if(message.fragments != null)
        {
            for(PlanFragment fragments : message.fragments)
            {
                if(fragments != null)
                    output.writeObject(3, fragments, PlanFragment.getSchema(), true);
            }
        }


        if(message.error != null)
             output.writeObject(4, message.error, DrillPBError.getSchema(), false);

    }

    public String getFieldName(int number)
    {
        switch(number)
        {
            case 1: return "status";
            case 2: return "queryId";
            case 3: return "fragments";
            case 4: return "error";
            default: return null;
        }
    }

    public int getFieldNumber(String name)
    {
        final Integer number = __fieldMap.get(name);
        return number == null ? 0 : number.intValue();
    }

    private static final java.util.HashMap<String,Integer> __fieldMap = new java.util.HashMap<String,Integer>();
    static
    {
        __fieldMap.put("status", 1);
        __fieldMap.put("queryId", 2);
        __fieldMap.put("fragments", 3);
        __fieldMap.put("error", 4);
    }
    
}
