/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by http://code.google.com/p/protostuff/ ... DO NOT EDIT!
// Generated from protobuf

package org.apache.drill.exec.proto.beans;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;

import com.dyuproject.protostuff.GraphIOUtil;
import com.dyuproject.protostuff.Input;
import com.dyuproject.protostuff.Message;
import com.dyuproject.protostuff.Output;
import com.dyuproject.protostuff.Schema;

public final class GetTablesReq implements Externalizable, Message<GetTablesReq>, Schema<GetTablesReq>
{

    public static Schema<GetTablesReq> getSchema()
    {
        return DEFAULT_INSTANCE;
    }

    public static GetTablesReq getDefaultInstance()
    {
        return DEFAULT_INSTANCE;
    }

    static final GetTablesReq DEFAULT_INSTANCE = new GetTablesReq();

    
    private LikeFilter catalogNameFilter;
    private LikeFilter schemaNameFilter;
    private LikeFilter tableNameFilter;
    private List<String> tableTypeFilter;

    public GetTablesReq()
    {
        
    }

    // getters and setters

    // catalogNameFilter

    public LikeFilter getCatalogNameFilter()
    {
        return catalogNameFilter;
    }

    public GetTablesReq setCatalogNameFilter(LikeFilter catalogNameFilter)
    {
        this.catalogNameFilter = catalogNameFilter;
        return this;
    }

    // schemaNameFilter

    public LikeFilter getSchemaNameFilter()
    {
        return schemaNameFilter;
    }

    public GetTablesReq setSchemaNameFilter(LikeFilter schemaNameFilter)
    {
        this.schemaNameFilter = schemaNameFilter;
        return this;
    }

    // tableNameFilter

    public LikeFilter getTableNameFilter()
    {
        return tableNameFilter;
    }

    public GetTablesReq setTableNameFilter(LikeFilter tableNameFilter)
    {
        this.tableNameFilter = tableNameFilter;
        return this;
    }

    // tableTypeFilter

    public List<String> getTableTypeFilterList()
    {
        return tableTypeFilter;
    }

    public GetTablesReq setTableTypeFilterList(List<String> tableTypeFilter)
    {
        this.tableTypeFilter = tableTypeFilter;
        return this;
    }

    // java serialization

    public void readExternal(ObjectInput in) throws IOException
    {
        GraphIOUtil.mergeDelimitedFrom(in, this, this);
    }

    public void writeExternal(ObjectOutput out) throws IOException
    {
        GraphIOUtil.writeDelimitedTo(out, this, this);
    }

    // message method

    public Schema<GetTablesReq> cachedSchema()
    {
        return DEFAULT_INSTANCE;
    }

    // schema methods

    public GetTablesReq newMessage()
    {
        return new GetTablesReq();
    }

    public Class<GetTablesReq> typeClass()
    {
        return GetTablesReq.class;
    }

    public String messageName()
    {
        return GetTablesReq.class.getSimpleName();
    }

    public String messageFullName()
    {
        return GetTablesReq.class.getName();
    }

    public boolean isInitialized(GetTablesReq message)
    {
        return true;
    }

    public void mergeFrom(Input input, GetTablesReq message) throws IOException
    {
        for(int number = input.readFieldNumber(this);; number = input.readFieldNumber(this))
        {
            switch(number)
            {
                case 0:
                    return;
                case 1:
                    message.catalogNameFilter = input.mergeObject(message.catalogNameFilter, LikeFilter.getSchema());
                    break;

                case 2:
                    message.schemaNameFilter = input.mergeObject(message.schemaNameFilter, LikeFilter.getSchema());
                    break;

                case 3:
                    message.tableNameFilter = input.mergeObject(message.tableNameFilter, LikeFilter.getSchema());
                    break;

                case 4:
                    if(message.tableTypeFilter == null)
                        message.tableTypeFilter = new ArrayList<String>();
                    message.tableTypeFilter.add(input.readString());
                    break;
                default:
                    input.handleUnknownField(number, this);
            }   
        }
    }


    public void writeTo(Output output, GetTablesReq message) throws IOException
    {
        if(message.catalogNameFilter != null)
             output.writeObject(1, message.catalogNameFilter, LikeFilter.getSchema(), false);


        if(message.schemaNameFilter != null)
             output.writeObject(2, message.schemaNameFilter, LikeFilter.getSchema(), false);


        if(message.tableNameFilter != null)
             output.writeObject(3, message.tableNameFilter, LikeFilter.getSchema(), false);


        if(message.tableTypeFilter != null)
        {
            for(String tableTypeFilter : message.tableTypeFilter)
            {
                if(tableTypeFilter != null)
                    output.writeString(4, tableTypeFilter, true);
            }
        }
    }

    public String getFieldName(int number)
    {
        switch(number)
        {
            case 1: return "catalogNameFilter";
            case 2: return "schemaNameFilter";
            case 3: return "tableNameFilter";
            case 4: return "tableTypeFilter";
            default: return null;
        }
    }

    public int getFieldNumber(String name)
    {
        final Integer number = __fieldMap.get(name);
        return number == null ? 0 : number.intValue();
    }

    private static final java.util.HashMap<String,Integer> __fieldMap = new java.util.HashMap<String,Integer>();
    static
    {
        __fieldMap.put("catalogNameFilter", 1);
        __fieldMap.put("schemaNameFilter", 2);
        __fieldMap.put("tableNameFilter", 3);
        __fieldMap.put("tableTypeFilter", 4);
    }
    
}
