/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: BitControl.proto

package org.apache.drill.exec.proto;

public final class BitControl {
  private BitControl() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
  }
  /**
   * Protobuf enum {@code exec.bit.control.RpcType}
   *
   * <pre>
   *&#47;/// BitControl RPC ///////
   * </pre>
   */
  public enum RpcType
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>HANDSHAKE = 0;</code>
     */
    HANDSHAKE(0, 0),
    /**
     * <code>ACK = 1;</code>
     */
    ACK(1, 1),
    /**
     * <code>GOODBYE = 2;</code>
     */
    GOODBYE(2, 2),
    /**
     * <code>REQ_INITIALIZE_FRAGMENTS = 3;</code>
     *
     * <pre>
     * bit requests
     * </pre>
     */
    REQ_INITIALIZE_FRAGMENTS(3, 3),
    /**
     * <code>REQ_CANCEL_FRAGMENT = 6;</code>
     *
     * <pre>
     * send a cancellation message for a fragment, returns Ack
     * </pre>
     */
    REQ_CANCEL_FRAGMENT(4, 6),
    /**
     * <code>REQ_RECEIVER_FINISHED = 7;</code>
     */
    REQ_RECEIVER_FINISHED(5, 7),
    /**
     * <code>REQ_FRAGMENT_STATUS = 8;</code>
     *
     * <pre>
     * send a fragment status, return Ack
     * </pre>
     */
    REQ_FRAGMENT_STATUS(6, 8),
    /**
     * <code>REQ_BIT_STATUS = 9;</code>
     *
     * <pre>
     * get bit status.
     * </pre>
     */
    REQ_BIT_STATUS(7, 9),
    /**
     * <code>REQ_QUERY_STATUS = 10;</code>
     */
    REQ_QUERY_STATUS(8, 10),
    /**
     * <code>REQ_QUERY_CANCEL = 15;</code>
     */
    REQ_QUERY_CANCEL(9, 15),
    /**
     * <code>REQ_UNPAUSE_FRAGMENT = 16;</code>
     *
     * <pre>
     * send a resume message for a fragment, returns Ack
     * </pre>
     */
    REQ_UNPAUSE_FRAGMENT(10, 16),
    /**
     * <code>REQ_CUSTOM = 17;</code>
     */
    REQ_CUSTOM(11, 17),
    /**
     * <code>RESP_FRAGMENT_HANDLE = 11;</code>
     *
     * <pre>
     * bit responses
     * </pre>
     */
    RESP_FRAGMENT_HANDLE(12, 11),
    /**
     * <code>RESP_FRAGMENT_STATUS = 12;</code>
     */
    RESP_FRAGMENT_STATUS(13, 12),
    /**
     * <code>RESP_BIT_STATUS = 13;</code>
     */
    RESP_BIT_STATUS(14, 13),
    /**
     * <code>RESP_QUERY_STATUS = 14;</code>
     */
    RESP_QUERY_STATUS(15, 14),
    /**
     * <code>RESP_CUSTOM = 18;</code>
     */
    RESP_CUSTOM(16, 18),
    /**
     * <code>SASL_MESSAGE = 19;</code>
     *
     * <pre>
     * both bit request and response
     * </pre>
     */
    SASL_MESSAGE(17, 19),
    ;

    /**
     * <code>HANDSHAKE = 0;</code>
     */
    public static final int HANDSHAKE_VALUE = 0;
    /**
     * <code>ACK = 1;</code>
     */
    public static final int ACK_VALUE = 1;
    /**
     * <code>GOODBYE = 2;</code>
     */
    public static final int GOODBYE_VALUE = 2;
    /**
     * <code>REQ_INITIALIZE_FRAGMENTS = 3;</code>
     *
     * <pre>
     * bit requests
     * </pre>
     */
    public static final int REQ_INITIALIZE_FRAGMENTS_VALUE = 3;
    /**
     * <code>REQ_CANCEL_FRAGMENT = 6;</code>
     *
     * <pre>
     * send a cancellation message for a fragment, returns Ack
     * </pre>
     */
    public static final int REQ_CANCEL_FRAGMENT_VALUE = 6;
    /**
     * <code>REQ_RECEIVER_FINISHED = 7;</code>
     */
    public static final int REQ_RECEIVER_FINISHED_VALUE = 7;
    /**
     * <code>REQ_FRAGMENT_STATUS = 8;</code>
     *
     * <pre>
     * send a fragment status, return Ack
     * </pre>
     */
    public static final int REQ_FRAGMENT_STATUS_VALUE = 8;
    /**
     * <code>REQ_BIT_STATUS = 9;</code>
     *
     * <pre>
     * get bit status.
     * </pre>
     */
    public static final int REQ_BIT_STATUS_VALUE = 9;
    /**
     * <code>REQ_QUERY_STATUS = 10;</code>
     */
    public static final int REQ_QUERY_STATUS_VALUE = 10;
    /**
     * <code>REQ_QUERY_CANCEL = 15;</code>
     */
    public static final int REQ_QUERY_CANCEL_VALUE = 15;
    /**
     * <code>REQ_UNPAUSE_FRAGMENT = 16;</code>
     *
     * <pre>
     * send a resume message for a fragment, returns Ack
     * </pre>
     */
    public static final int REQ_UNPAUSE_FRAGMENT_VALUE = 16;
    /**
     * <code>REQ_CUSTOM = 17;</code>
     */
    public static final int REQ_CUSTOM_VALUE = 17;
    /**
     * <code>RESP_FRAGMENT_HANDLE = 11;</code>
     *
     * <pre>
     * bit responses
     * </pre>
     */
    public static final int RESP_FRAGMENT_HANDLE_VALUE = 11;
    /**
     * <code>RESP_FRAGMENT_STATUS = 12;</code>
     */
    public static final int RESP_FRAGMENT_STATUS_VALUE = 12;
    /**
     * <code>RESP_BIT_STATUS = 13;</code>
     */
    public static final int RESP_BIT_STATUS_VALUE = 13;
    /**
     * <code>RESP_QUERY_STATUS = 14;</code>
     */
    public static final int RESP_QUERY_STATUS_VALUE = 14;
    /**
     * <code>RESP_CUSTOM = 18;</code>
     */
    public static final int RESP_CUSTOM_VALUE = 18;
    /**
     * <code>SASL_MESSAGE = 19;</code>
     *
     * <pre>
     * both bit request and response
     * </pre>
     */
    public static final int SASL_MESSAGE_VALUE = 19;


    public final int getNumber() { return value; }

    public static RpcType valueOf(int value) {
      switch (value) {
        case 0: return HANDSHAKE;
        case 1: return ACK;
        case 2: return GOODBYE;
        case 3: return REQ_INITIALIZE_FRAGMENTS;
        case 6: return REQ_CANCEL_FRAGMENT;
        case 7: return REQ_RECEIVER_FINISHED;
        case 8: return REQ_FRAGMENT_STATUS;
        case 9: return REQ_BIT_STATUS;
        case 10: return REQ_QUERY_STATUS;
        case 15: return REQ_QUERY_CANCEL;
        case 16: return REQ_UNPAUSE_FRAGMENT;
        case 17: return REQ_CUSTOM;
        case 11: return RESP_FRAGMENT_HANDLE;
        case 12: return RESP_FRAGMENT_STATUS;
        case 13: return RESP_BIT_STATUS;
        case 14: return RESP_QUERY_STATUS;
        case 18: return RESP_CUSTOM;
        case 19: return SASL_MESSAGE;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RpcType>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static com.google.protobuf.Internal.EnumLiteMap<RpcType>
        internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<RpcType>() {
            public RpcType findValueByNumber(int number) {
              return RpcType.valueOf(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(index);
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.BitControl.getDescriptor().getEnumTypes().get(0);
    }

    private static final RpcType[] VALUES = values();

    public static RpcType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int index;
    private final int value;

    private RpcType(int index, int value) {
      this.index = index;
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:exec.bit.control.RpcType)
  }

  public interface BitControlHandshakeOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // optional int32 rpc_version = 1;
    /**
     * <code>optional int32 rpc_version = 1;</code>
     */
    boolean hasRpcVersion();
    /**
     * <code>optional int32 rpc_version = 1;</code>
     */
    int getRpcVersion();

    // optional .exec.shared.RpcChannel channel = 2 [default = BIT_CONTROL];
    /**
     * <code>optional .exec.shared.RpcChannel channel = 2 [default = BIT_CONTROL];</code>
     */
    boolean hasChannel();
    /**
     * <code>optional .exec.shared.RpcChannel channel = 2 [default = BIT_CONTROL];</code>
     */
    org.apache.drill.exec.proto.UserBitShared.RpcChannel getChannel();

    // optional .exec.DrillbitEndpoint endpoint = 3;
    /**
     * <code>optional .exec.DrillbitEndpoint endpoint = 3;</code>
     */
    boolean hasEndpoint();
    /**
     * <code>optional .exec.DrillbitEndpoint endpoint = 3;</code>
     */
    org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint getEndpoint();
    /**
     * <code>optional .exec.DrillbitEndpoint endpoint = 3;</code>
     */
    org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpointOrBuilder getEndpointOrBuilder();

    // repeated string authenticationMechanisms = 4;
    /**
     * <code>repeated string authenticationMechanisms = 4;</code>
     */
    java.util.List<java.lang.String>
    getAuthenticationMechanismsList();
    /**
     * <code>repeated string authenticationMechanisms = 4;</code>
     */
    int getAuthenticationMechanismsCount();
    /**
     * <code>repeated string authenticationMechanisms = 4;</code>
     */
    java.lang.String getAuthenticationMechanisms(int index);
    /**
     * <code>repeated string authenticationMechanisms = 4;</code>
     */
    com.google.protobuf.ByteString
        getAuthenticationMechanismsBytes(int index);
  }
  /**
   * Protobuf type {@code exec.bit.control.BitControlHandshake}
   */
  public static final class BitControlHandshake extends
      com.google.protobuf.GeneratedMessage
      implements BitControlHandshakeOrBuilder {
    // Use BitControlHandshake.newBuilder() to construct.
    private BitControlHandshake(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private BitControlHandshake(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final BitControlHandshake defaultInstance;
    public static BitControlHandshake getDefaultInstance() {
      return defaultInstance;
    }

    public BitControlHandshake getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private BitControlHandshake(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              bitField0_ |= 0x00000001;
              rpcVersion_ = input.readInt32();
              break;
            }
            case 16: {
              int rawValue = input.readEnum();
              org.apache.drill.exec.proto.UserBitShared.RpcChannel value = org.apache.drill.exec.proto.UserBitShared.RpcChannel.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(2, rawValue);
              } else {
                bitField0_ |= 0x00000002;
                channel_ = value;
              }
              break;
            }
            case 26: {
              org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.Builder subBuilder = null;
              if (((bitField0_ & 0x00000004) == 0x00000004)) {
                subBuilder = endpoint_.toBuilder();
              }
              endpoint_ = input.readMessage(org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(endpoint_);
                endpoint_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000004;
              break;
            }
            case 34: {
              if (!((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
                authenticationMechanisms_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000008;
              }
              authenticationMechanisms_.add(input.readBytes());
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
          authenticationMechanisms_ = new com.google.protobuf.UnmodifiableLazyStringList(authenticationMechanisms_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_BitControlHandshake_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_BitControlHandshake_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.BitControl.BitControlHandshake.class, org.apache.drill.exec.proto.BitControl.BitControlHandshake.Builder.class);
    }

    public static com.google.protobuf.Parser<BitControlHandshake> PARSER =
        new com.google.protobuf.AbstractParser<BitControlHandshake>() {
      public BitControlHandshake parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new BitControlHandshake(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<BitControlHandshake> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // optional int32 rpc_version = 1;
    public static final int RPC_VERSION_FIELD_NUMBER = 1;
    private int rpcVersion_;
    /**
     * <code>optional int32 rpc_version = 1;</code>
     */
    public boolean hasRpcVersion() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional int32 rpc_version = 1;</code>
     */
    public int getRpcVersion() {
      return rpcVersion_;
    }

    // optional .exec.shared.RpcChannel channel = 2 [default = BIT_CONTROL];
    public static final int CHANNEL_FIELD_NUMBER = 2;
    private org.apache.drill.exec.proto.UserBitShared.RpcChannel channel_;
    /**
     * <code>optional .exec.shared.RpcChannel channel = 2 [default = BIT_CONTROL];</code>
     */
    public boolean hasChannel() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional .exec.shared.RpcChannel channel = 2 [default = BIT_CONTROL];</code>
     */
    public org.apache.drill.exec.proto.UserBitShared.RpcChannel getChannel() {
      return channel_;
    }

    // optional .exec.DrillbitEndpoint endpoint = 3;
    public static final int ENDPOINT_FIELD_NUMBER = 3;
    private org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint endpoint_;
    /**
     * <code>optional .exec.DrillbitEndpoint endpoint = 3;</code>
     */
    public boolean hasEndpoint() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional .exec.DrillbitEndpoint endpoint = 3;</code>
     */
    public org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint getEndpoint() {
      return endpoint_;
    }
    /**
     * <code>optional .exec.DrillbitEndpoint endpoint = 3;</code>
     */
    public org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpointOrBuilder getEndpointOrBuilder() {
      return endpoint_;
    }

    // repeated string authenticationMechanisms = 4;
    public static final int AUTHENTICATIONMECHANISMS_FIELD_NUMBER = 4;
    private com.google.protobuf.LazyStringList authenticationMechanisms_;
    /**
     * <code>repeated string authenticationMechanisms = 4;</code>
     */
    public java.util.List<java.lang.String>
        getAuthenticationMechanismsList() {
      return authenticationMechanisms_;
    }
    /**
     * <code>repeated string authenticationMechanisms = 4;</code>
     */
    public int getAuthenticationMechanismsCount() {
      return authenticationMechanisms_.size();
    }
    /**
     * <code>repeated string authenticationMechanisms = 4;</code>
     */
    public java.lang.String getAuthenticationMechanisms(int index) {
      return authenticationMechanisms_.get(index);
    }
    /**
     * <code>repeated string authenticationMechanisms = 4;</code>
     */
    public com.google.protobuf.ByteString
        getAuthenticationMechanismsBytes(int index) {
      return authenticationMechanisms_.getByteString(index);
    }

    private void initFields() {
      rpcVersion_ = 0;
      channel_ = org.apache.drill.exec.proto.UserBitShared.RpcChannel.BIT_CONTROL;
      endpoint_ = org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.getDefaultInstance();
      authenticationMechanisms_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeInt32(1, rpcVersion_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeEnum(2, channel_.getNumber());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeMessage(3, endpoint_);
      }
      for (int i = 0; i < authenticationMechanisms_.size(); i++) {
        output.writeBytes(4, authenticationMechanisms_.getByteString(i));
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(1, rpcVersion_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(2, channel_.getNumber());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, endpoint_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < authenticationMechanisms_.size(); i++) {
          dataSize += com.google.protobuf.CodedOutputStream
            .computeBytesSizeNoTag(authenticationMechanisms_.getByteString(i));
        }
        size += dataSize;
        size += 1 * getAuthenticationMechanismsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.BitControl.BitControlHandshake parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.BitControl.BitControlHandshake parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitControl.BitControlHandshake parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.BitControl.BitControlHandshake parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitControl.BitControlHandshake parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.BitControl.BitControlHandshake parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitControl.BitControlHandshake parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.BitControl.BitControlHandshake parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitControl.BitControlHandshake parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.BitControl.BitControlHandshake parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.BitControl.BitControlHandshake prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.bit.control.BitControlHandshake}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.BitControl.BitControlHandshakeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_BitControlHandshake_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_BitControlHandshake_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.BitControl.BitControlHandshake.class, org.apache.drill.exec.proto.BitControl.BitControlHandshake.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.BitControl.BitControlHandshake.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getEndpointFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        rpcVersion_ = 0;
        bitField0_ = (bitField0_ & ~0x00000001);
        channel_ = org.apache.drill.exec.proto.UserBitShared.RpcChannel.BIT_CONTROL;
        bitField0_ = (bitField0_ & ~0x00000002);
        if (endpointBuilder_ == null) {
          endpoint_ = org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.getDefaultInstance();
        } else {
          endpointBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        authenticationMechanisms_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_BitControlHandshake_descriptor;
      }

      public org.apache.drill.exec.proto.BitControl.BitControlHandshake getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.BitControl.BitControlHandshake.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.BitControl.BitControlHandshake build() {
        org.apache.drill.exec.proto.BitControl.BitControlHandshake result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.BitControl.BitControlHandshake buildPartial() {
        org.apache.drill.exec.proto.BitControl.BitControlHandshake result = new org.apache.drill.exec.proto.BitControl.BitControlHandshake(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.rpcVersion_ = rpcVersion_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.channel_ = channel_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        if (endpointBuilder_ == null) {
          result.endpoint_ = endpoint_;
        } else {
          result.endpoint_ = endpointBuilder_.build();
        }
        if (((bitField0_ & 0x00000008) == 0x00000008)) {
          authenticationMechanisms_ = new com.google.protobuf.UnmodifiableLazyStringList(
              authenticationMechanisms_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.authenticationMechanisms_ = authenticationMechanisms_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.BitControl.BitControlHandshake) {
          return mergeFrom((org.apache.drill.exec.proto.BitControl.BitControlHandshake)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.BitControl.BitControlHandshake other) {
        if (other == org.apache.drill.exec.proto.BitControl.BitControlHandshake.getDefaultInstance()) return this;
        if (other.hasRpcVersion()) {
          setRpcVersion(other.getRpcVersion());
        }
        if (other.hasChannel()) {
          setChannel(other.getChannel());
        }
        if (other.hasEndpoint()) {
          mergeEndpoint(other.getEndpoint());
        }
        if (!other.authenticationMechanisms_.isEmpty()) {
          if (authenticationMechanisms_.isEmpty()) {
            authenticationMechanisms_ = other.authenticationMechanisms_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureAuthenticationMechanismsIsMutable();
            authenticationMechanisms_.addAll(other.authenticationMechanisms_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.BitControl.BitControlHandshake parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.BitControl.BitControlHandshake) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // optional int32 rpc_version = 1;
      private int rpcVersion_ ;
      /**
       * <code>optional int32 rpc_version = 1;</code>
       */
      public boolean hasRpcVersion() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional int32 rpc_version = 1;</code>
       */
      public int getRpcVersion() {
        return rpcVersion_;
      }
      /**
       * <code>optional int32 rpc_version = 1;</code>
       */
      public Builder setRpcVersion(int value) {
        bitField0_ |= 0x00000001;
        rpcVersion_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 rpc_version = 1;</code>
       */
      public Builder clearRpcVersion() {
        bitField0_ = (bitField0_ & ~0x00000001);
        rpcVersion_ = 0;
        onChanged();
        return this;
      }

      // optional .exec.shared.RpcChannel channel = 2 [default = BIT_CONTROL];
      private org.apache.drill.exec.proto.UserBitShared.RpcChannel channel_ = org.apache.drill.exec.proto.UserBitShared.RpcChannel.BIT_CONTROL;
      /**
       * <code>optional .exec.shared.RpcChannel channel = 2 [default = BIT_CONTROL];</code>
       */
      public boolean hasChannel() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional .exec.shared.RpcChannel channel = 2 [default = BIT_CONTROL];</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.RpcChannel getChannel() {
        return channel_;
      }
      /**
       * <code>optional .exec.shared.RpcChannel channel = 2 [default = BIT_CONTROL];</code>
       */
      public Builder setChannel(org.apache.drill.exec.proto.UserBitShared.RpcChannel value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        channel_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .exec.shared.RpcChannel channel = 2 [default = BIT_CONTROL];</code>
       */
      public Builder clearChannel() {
        bitField0_ = (bitField0_ & ~0x00000002);
        channel_ = org.apache.drill.exec.proto.UserBitShared.RpcChannel.BIT_CONTROL;
        onChanged();
        return this;
      }

      // optional .exec.DrillbitEndpoint endpoint = 3;
      private org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint endpoint_ = org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint, org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.Builder, org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpointOrBuilder> endpointBuilder_;
      /**
       * <code>optional .exec.DrillbitEndpoint endpoint = 3;</code>
       */
      public boolean hasEndpoint() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional .exec.DrillbitEndpoint endpoint = 3;</code>
       */
      public org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint getEndpoint() {
        if (endpointBuilder_ == null) {
          return endpoint_;
        } else {
          return endpointBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.DrillbitEndpoint endpoint = 3;</code>
       */
      public Builder setEndpoint(org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint value) {
        if (endpointBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          endpoint_ = value;
          onChanged();
        } else {
          endpointBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .exec.DrillbitEndpoint endpoint = 3;</code>
       */
      public Builder setEndpoint(
          org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.Builder builderForValue) {
        if (endpointBuilder_ == null) {
          endpoint_ = builderForValue.build();
          onChanged();
        } else {
          endpointBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .exec.DrillbitEndpoint endpoint = 3;</code>
       */
      public Builder mergeEndpoint(org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint value) {
        if (endpointBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004) &&
              endpoint_ != org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.getDefaultInstance()) {
            endpoint_ =
              org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.newBuilder(endpoint_).mergeFrom(value).buildPartial();
          } else {
            endpoint_ = value;
          }
          onChanged();
        } else {
          endpointBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>optional .exec.DrillbitEndpoint endpoint = 3;</code>
       */
      public Builder clearEndpoint() {
        if (endpointBuilder_ == null) {
          endpoint_ = org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.getDefaultInstance();
          onChanged();
        } else {
          endpointBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }
      /**
       * <code>optional .exec.DrillbitEndpoint endpoint = 3;</code>
       */
      public org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.Builder getEndpointBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getEndpointFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.DrillbitEndpoint endpoint = 3;</code>
       */
      public org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpointOrBuilder getEndpointOrBuilder() {
        if (endpointBuilder_ != null) {
          return endpointBuilder_.getMessageOrBuilder();
        } else {
          return endpoint_;
        }
      }
      /**
       * <code>optional .exec.DrillbitEndpoint endpoint = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint, org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.Builder, org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpointOrBuilder> 
          getEndpointFieldBuilder() {
        if (endpointBuilder_ == null) {
          endpointBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint, org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.Builder, org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpointOrBuilder>(
                  endpoint_,
                  getParentForChildren(),
                  isClean());
          endpoint_ = null;
        }
        return endpointBuilder_;
      }

      // repeated string authenticationMechanisms = 4;
      private com.google.protobuf.LazyStringList authenticationMechanisms_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensureAuthenticationMechanismsIsMutable() {
        if (!((bitField0_ & 0x00000008) == 0x00000008)) {
          authenticationMechanisms_ = new com.google.protobuf.LazyStringArrayList(authenticationMechanisms_);
          bitField0_ |= 0x00000008;
         }
      }
      /**
       * <code>repeated string authenticationMechanisms = 4;</code>
       */
      public java.util.List<java.lang.String>
          getAuthenticationMechanismsList() {
        return java.util.Collections.unmodifiableList(authenticationMechanisms_);
      }
      /**
       * <code>repeated string authenticationMechanisms = 4;</code>
       */
      public int getAuthenticationMechanismsCount() {
        return authenticationMechanisms_.size();
      }
      /**
       * <code>repeated string authenticationMechanisms = 4;</code>
       */
      public java.lang.String getAuthenticationMechanisms(int index) {
        return authenticationMechanisms_.get(index);
      }
      /**
       * <code>repeated string authenticationMechanisms = 4;</code>
       */
      public com.google.protobuf.ByteString
          getAuthenticationMechanismsBytes(int index) {
        return authenticationMechanisms_.getByteString(index);
      }
      /**
       * <code>repeated string authenticationMechanisms = 4;</code>
       */
      public Builder setAuthenticationMechanisms(
          int index, java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureAuthenticationMechanismsIsMutable();
        authenticationMechanisms_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string authenticationMechanisms = 4;</code>
       */
      public Builder addAuthenticationMechanisms(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureAuthenticationMechanismsIsMutable();
        authenticationMechanisms_.add(value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string authenticationMechanisms = 4;</code>
       */
      public Builder addAllAuthenticationMechanisms(
          java.lang.Iterable<java.lang.String> values) {
        ensureAuthenticationMechanismsIsMutable();
        super.addAll(values, authenticationMechanisms_);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string authenticationMechanisms = 4;</code>
       */
      public Builder clearAuthenticationMechanisms() {
        authenticationMechanisms_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string authenticationMechanisms = 4;</code>
       */
      public Builder addAuthenticationMechanismsBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureAuthenticationMechanismsIsMutable();
        authenticationMechanisms_.add(value);
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:exec.bit.control.BitControlHandshake)
    }

    static {
      defaultInstance = new BitControlHandshake(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.bit.control.BitControlHandshake)
  }

  public interface BitStatusOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // repeated .exec.bit.control.FragmentStatus fragment_status = 1;
    /**
     * <code>repeated .exec.bit.control.FragmentStatus fragment_status = 1;</code>
     */
    java.util.List<org.apache.drill.exec.proto.BitControl.FragmentStatus> 
        getFragmentStatusList();
    /**
     * <code>repeated .exec.bit.control.FragmentStatus fragment_status = 1;</code>
     */
    org.apache.drill.exec.proto.BitControl.FragmentStatus getFragmentStatus(int index);
    /**
     * <code>repeated .exec.bit.control.FragmentStatus fragment_status = 1;</code>
     */
    int getFragmentStatusCount();
    /**
     * <code>repeated .exec.bit.control.FragmentStatus fragment_status = 1;</code>
     */
    java.util.List<? extends org.apache.drill.exec.proto.BitControl.FragmentStatusOrBuilder> 
        getFragmentStatusOrBuilderList();
    /**
     * <code>repeated .exec.bit.control.FragmentStatus fragment_status = 1;</code>
     */
    org.apache.drill.exec.proto.BitControl.FragmentStatusOrBuilder getFragmentStatusOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code exec.bit.control.BitStatus}
   */
  public static final class BitStatus extends
      com.google.protobuf.GeneratedMessage
      implements BitStatusOrBuilder {
    // Use BitStatus.newBuilder() to construct.
    private BitStatus(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private BitStatus(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final BitStatus defaultInstance;
    public static BitStatus getDefaultInstance() {
      return defaultInstance;
    }

    public BitStatus getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private BitStatus(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                fragmentStatus_ = new java.util.ArrayList<org.apache.drill.exec.proto.BitControl.FragmentStatus>();
                mutable_bitField0_ |= 0x00000001;
              }
              fragmentStatus_.add(input.readMessage(org.apache.drill.exec.proto.BitControl.FragmentStatus.PARSER, extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
          fragmentStatus_ = java.util.Collections.unmodifiableList(fragmentStatus_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_BitStatus_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_BitStatus_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.BitControl.BitStatus.class, org.apache.drill.exec.proto.BitControl.BitStatus.Builder.class);
    }

    public static com.google.protobuf.Parser<BitStatus> PARSER =
        new com.google.protobuf.AbstractParser<BitStatus>() {
      public BitStatus parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new BitStatus(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<BitStatus> getParserForType() {
      return PARSER;
    }

    // repeated .exec.bit.control.FragmentStatus fragment_status = 1;
    public static final int FRAGMENT_STATUS_FIELD_NUMBER = 1;
    private java.util.List<org.apache.drill.exec.proto.BitControl.FragmentStatus> fragmentStatus_;
    /**
     * <code>repeated .exec.bit.control.FragmentStatus fragment_status = 1;</code>
     */
    public java.util.List<org.apache.drill.exec.proto.BitControl.FragmentStatus> getFragmentStatusList() {
      return fragmentStatus_;
    }
    /**
     * <code>repeated .exec.bit.control.FragmentStatus fragment_status = 1;</code>
     */
    public java.util.List<? extends org.apache.drill.exec.proto.BitControl.FragmentStatusOrBuilder> 
        getFragmentStatusOrBuilderList() {
      return fragmentStatus_;
    }
    /**
     * <code>repeated .exec.bit.control.FragmentStatus fragment_status = 1;</code>
     */
    public int getFragmentStatusCount() {
      return fragmentStatus_.size();
    }
    /**
     * <code>repeated .exec.bit.control.FragmentStatus fragment_status = 1;</code>
     */
    public org.apache.drill.exec.proto.BitControl.FragmentStatus getFragmentStatus(int index) {
      return fragmentStatus_.get(index);
    }
    /**
     * <code>repeated .exec.bit.control.FragmentStatus fragment_status = 1;</code>
     */
    public org.apache.drill.exec.proto.BitControl.FragmentStatusOrBuilder getFragmentStatusOrBuilder(
        int index) {
      return fragmentStatus_.get(index);
    }

    private void initFields() {
      fragmentStatus_ = java.util.Collections.emptyList();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      for (int i = 0; i < fragmentStatus_.size(); i++) {
        output.writeMessage(1, fragmentStatus_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < fragmentStatus_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, fragmentStatus_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.BitControl.BitStatus parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.BitControl.BitStatus parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitControl.BitStatus parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.BitControl.BitStatus parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitControl.BitStatus parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.BitControl.BitStatus parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitControl.BitStatus parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.BitControl.BitStatus parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitControl.BitStatus parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.BitControl.BitStatus parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.BitControl.BitStatus prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.bit.control.BitStatus}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.BitControl.BitStatusOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_BitStatus_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_BitStatus_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.BitControl.BitStatus.class, org.apache.drill.exec.proto.BitControl.BitStatus.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.BitControl.BitStatus.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getFragmentStatusFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        if (fragmentStatusBuilder_ == null) {
          fragmentStatus_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          fragmentStatusBuilder_.clear();
        }
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_BitStatus_descriptor;
      }

      public org.apache.drill.exec.proto.BitControl.BitStatus getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.BitControl.BitStatus.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.BitControl.BitStatus build() {
        org.apache.drill.exec.proto.BitControl.BitStatus result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.BitControl.BitStatus buildPartial() {
        org.apache.drill.exec.proto.BitControl.BitStatus result = new org.apache.drill.exec.proto.BitControl.BitStatus(this);
        int from_bitField0_ = bitField0_;
        if (fragmentStatusBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)) {
            fragmentStatus_ = java.util.Collections.unmodifiableList(fragmentStatus_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.fragmentStatus_ = fragmentStatus_;
        } else {
          result.fragmentStatus_ = fragmentStatusBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.BitControl.BitStatus) {
          return mergeFrom((org.apache.drill.exec.proto.BitControl.BitStatus)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.BitControl.BitStatus other) {
        if (other == org.apache.drill.exec.proto.BitControl.BitStatus.getDefaultInstance()) return this;
        if (fragmentStatusBuilder_ == null) {
          if (!other.fragmentStatus_.isEmpty()) {
            if (fragmentStatus_.isEmpty()) {
              fragmentStatus_ = other.fragmentStatus_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureFragmentStatusIsMutable();
              fragmentStatus_.addAll(other.fragmentStatus_);
            }
            onChanged();
          }
        } else {
          if (!other.fragmentStatus_.isEmpty()) {
            if (fragmentStatusBuilder_.isEmpty()) {
              fragmentStatusBuilder_.dispose();
              fragmentStatusBuilder_ = null;
              fragmentStatus_ = other.fragmentStatus_;
              bitField0_ = (bitField0_ & ~0x00000001);
              fragmentStatusBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getFragmentStatusFieldBuilder() : null;
            } else {
              fragmentStatusBuilder_.addAllMessages(other.fragmentStatus_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.BitControl.BitStatus parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.BitControl.BitStatus) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // repeated .exec.bit.control.FragmentStatus fragment_status = 1;
      private java.util.List<org.apache.drill.exec.proto.BitControl.FragmentStatus> fragmentStatus_ =
        java.util.Collections.emptyList();
      private void ensureFragmentStatusIsMutable() {
        if (!((bitField0_ & 0x00000001) == 0x00000001)) {
          fragmentStatus_ = new java.util.ArrayList<org.apache.drill.exec.proto.BitControl.FragmentStatus>(fragmentStatus_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          org.apache.drill.exec.proto.BitControl.FragmentStatus, org.apache.drill.exec.proto.BitControl.FragmentStatus.Builder, org.apache.drill.exec.proto.BitControl.FragmentStatusOrBuilder> fragmentStatusBuilder_;

      /**
       * <code>repeated .exec.bit.control.FragmentStatus fragment_status = 1;</code>
       */
      public java.util.List<org.apache.drill.exec.proto.BitControl.FragmentStatus> getFragmentStatusList() {
        if (fragmentStatusBuilder_ == null) {
          return java.util.Collections.unmodifiableList(fragmentStatus_);
        } else {
          return fragmentStatusBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .exec.bit.control.FragmentStatus fragment_status = 1;</code>
       */
      public int getFragmentStatusCount() {
        if (fragmentStatusBuilder_ == null) {
          return fragmentStatus_.size();
        } else {
          return fragmentStatusBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .exec.bit.control.FragmentStatus fragment_status = 1;</code>
       */
      public org.apache.drill.exec.proto.BitControl.FragmentStatus getFragmentStatus(int index) {
        if (fragmentStatusBuilder_ == null) {
          return fragmentStatus_.get(index);
        } else {
          return fragmentStatusBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .exec.bit.control.FragmentStatus fragment_status = 1;</code>
       */
      public Builder setFragmentStatus(
          int index, org.apache.drill.exec.proto.BitControl.FragmentStatus value) {
        if (fragmentStatusBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFragmentStatusIsMutable();
          fragmentStatus_.set(index, value);
          onChanged();
        } else {
          fragmentStatusBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.FragmentStatus fragment_status = 1;</code>
       */
      public Builder setFragmentStatus(
          int index, org.apache.drill.exec.proto.BitControl.FragmentStatus.Builder builderForValue) {
        if (fragmentStatusBuilder_ == null) {
          ensureFragmentStatusIsMutable();
          fragmentStatus_.set(index, builderForValue.build());
          onChanged();
        } else {
          fragmentStatusBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.FragmentStatus fragment_status = 1;</code>
       */
      public Builder addFragmentStatus(org.apache.drill.exec.proto.BitControl.FragmentStatus value) {
        if (fragmentStatusBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFragmentStatusIsMutable();
          fragmentStatus_.add(value);
          onChanged();
        } else {
          fragmentStatusBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.FragmentStatus fragment_status = 1;</code>
       */
      public Builder addFragmentStatus(
          int index, org.apache.drill.exec.proto.BitControl.FragmentStatus value) {
        if (fragmentStatusBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFragmentStatusIsMutable();
          fragmentStatus_.add(index, value);
          onChanged();
        } else {
          fragmentStatusBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.FragmentStatus fragment_status = 1;</code>
       */
      public Builder addFragmentStatus(
          org.apache.drill.exec.proto.BitControl.FragmentStatus.Builder builderForValue) {
        if (fragmentStatusBuilder_ == null) {
          ensureFragmentStatusIsMutable();
          fragmentStatus_.add(builderForValue.build());
          onChanged();
        } else {
          fragmentStatusBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.FragmentStatus fragment_status = 1;</code>
       */
      public Builder addFragmentStatus(
          int index, org.apache.drill.exec.proto.BitControl.FragmentStatus.Builder builderForValue) {
        if (fragmentStatusBuilder_ == null) {
          ensureFragmentStatusIsMutable();
          fragmentStatus_.add(index, builderForValue.build());
          onChanged();
        } else {
          fragmentStatusBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.FragmentStatus fragment_status = 1;</code>
       */
      public Builder addAllFragmentStatus(
          java.lang.Iterable<? extends org.apache.drill.exec.proto.BitControl.FragmentStatus> values) {
        if (fragmentStatusBuilder_ == null) {
          ensureFragmentStatusIsMutable();
          super.addAll(values, fragmentStatus_);
          onChanged();
        } else {
          fragmentStatusBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.FragmentStatus fragment_status = 1;</code>
       */
      public Builder clearFragmentStatus() {
        if (fragmentStatusBuilder_ == null) {
          fragmentStatus_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          fragmentStatusBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.FragmentStatus fragment_status = 1;</code>
       */
      public Builder removeFragmentStatus(int index) {
        if (fragmentStatusBuilder_ == null) {
          ensureFragmentStatusIsMutable();
          fragmentStatus_.remove(index);
          onChanged();
        } else {
          fragmentStatusBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.FragmentStatus fragment_status = 1;</code>
       */
      public org.apache.drill.exec.proto.BitControl.FragmentStatus.Builder getFragmentStatusBuilder(
          int index) {
        return getFragmentStatusFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .exec.bit.control.FragmentStatus fragment_status = 1;</code>
       */
      public org.apache.drill.exec.proto.BitControl.FragmentStatusOrBuilder getFragmentStatusOrBuilder(
          int index) {
        if (fragmentStatusBuilder_ == null) {
          return fragmentStatus_.get(index);  } else {
          return fragmentStatusBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .exec.bit.control.FragmentStatus fragment_status = 1;</code>
       */
      public java.util.List<? extends org.apache.drill.exec.proto.BitControl.FragmentStatusOrBuilder> 
           getFragmentStatusOrBuilderList() {
        if (fragmentStatusBuilder_ != null) {
          return fragmentStatusBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(fragmentStatus_);
        }
      }
      /**
       * <code>repeated .exec.bit.control.FragmentStatus fragment_status = 1;</code>
       */
      public org.apache.drill.exec.proto.BitControl.FragmentStatus.Builder addFragmentStatusBuilder() {
        return getFragmentStatusFieldBuilder().addBuilder(
            org.apache.drill.exec.proto.BitControl.FragmentStatus.getDefaultInstance());
      }
      /**
       * <code>repeated .exec.bit.control.FragmentStatus fragment_status = 1;</code>
       */
      public org.apache.drill.exec.proto.BitControl.FragmentStatus.Builder addFragmentStatusBuilder(
          int index) {
        return getFragmentStatusFieldBuilder().addBuilder(
            index, org.apache.drill.exec.proto.BitControl.FragmentStatus.getDefaultInstance());
      }
      /**
       * <code>repeated .exec.bit.control.FragmentStatus fragment_status = 1;</code>
       */
      public java.util.List<org.apache.drill.exec.proto.BitControl.FragmentStatus.Builder> 
           getFragmentStatusBuilderList() {
        return getFragmentStatusFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          org.apache.drill.exec.proto.BitControl.FragmentStatus, org.apache.drill.exec.proto.BitControl.FragmentStatus.Builder, org.apache.drill.exec.proto.BitControl.FragmentStatusOrBuilder> 
          getFragmentStatusFieldBuilder() {
        if (fragmentStatusBuilder_ == null) {
          fragmentStatusBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              org.apache.drill.exec.proto.BitControl.FragmentStatus, org.apache.drill.exec.proto.BitControl.FragmentStatus.Builder, org.apache.drill.exec.proto.BitControl.FragmentStatusOrBuilder>(
                  fragmentStatus_,
                  ((bitField0_ & 0x00000001) == 0x00000001),
                  getParentForChildren(),
                  isClean());
          fragmentStatus_ = null;
        }
        return fragmentStatusBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:exec.bit.control.BitStatus)
    }

    static {
      defaultInstance = new BitStatus(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.bit.control.BitStatus)
  }

  public interface FragmentStatusOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // optional .exec.shared.MinorFragmentProfile profile = 1;
    /**
     * <code>optional .exec.shared.MinorFragmentProfile profile = 1;</code>
     */
    boolean hasProfile();
    /**
     * <code>optional .exec.shared.MinorFragmentProfile profile = 1;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.MinorFragmentProfile getProfile();
    /**
     * <code>optional .exec.shared.MinorFragmentProfile profile = 1;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.MinorFragmentProfileOrBuilder getProfileOrBuilder();

    // optional .exec.bit.FragmentHandle handle = 2;
    /**
     * <code>optional .exec.bit.FragmentHandle handle = 2;</code>
     */
    boolean hasHandle();
    /**
     * <code>optional .exec.bit.FragmentHandle handle = 2;</code>
     */
    org.apache.drill.exec.proto.ExecProtos.FragmentHandle getHandle();
    /**
     * <code>optional .exec.bit.FragmentHandle handle = 2;</code>
     */
    org.apache.drill.exec.proto.ExecProtos.FragmentHandleOrBuilder getHandleOrBuilder();
  }
  /**
   * Protobuf type {@code exec.bit.control.FragmentStatus}
   */
  public static final class FragmentStatus extends
      com.google.protobuf.GeneratedMessage
      implements FragmentStatusOrBuilder {
    // Use FragmentStatus.newBuilder() to construct.
    private FragmentStatus(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private FragmentStatus(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final FragmentStatus defaultInstance;
    public static FragmentStatus getDefaultInstance() {
      return defaultInstance;
    }

    public FragmentStatus getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private FragmentStatus(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              org.apache.drill.exec.proto.UserBitShared.MinorFragmentProfile.Builder subBuilder = null;
              if (((bitField0_ & 0x00000001) == 0x00000001)) {
                subBuilder = profile_.toBuilder();
              }
              profile_ = input.readMessage(org.apache.drill.exec.proto.UserBitShared.MinorFragmentProfile.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(profile_);
                profile_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000001;
              break;
            }
            case 18: {
              org.apache.drill.exec.proto.ExecProtos.FragmentHandle.Builder subBuilder = null;
              if (((bitField0_ & 0x00000002) == 0x00000002)) {
                subBuilder = handle_.toBuilder();
              }
              handle_ = input.readMessage(org.apache.drill.exec.proto.ExecProtos.FragmentHandle.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(handle_);
                handle_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000002;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_FragmentStatus_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_FragmentStatus_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.BitControl.FragmentStatus.class, org.apache.drill.exec.proto.BitControl.FragmentStatus.Builder.class);
    }

    public static com.google.protobuf.Parser<FragmentStatus> PARSER =
        new com.google.protobuf.AbstractParser<FragmentStatus>() {
      public FragmentStatus parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new FragmentStatus(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<FragmentStatus> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // optional .exec.shared.MinorFragmentProfile profile = 1;
    public static final int PROFILE_FIELD_NUMBER = 1;
    private org.apache.drill.exec.proto.UserBitShared.MinorFragmentProfile profile_;
    /**
     * <code>optional .exec.shared.MinorFragmentProfile profile = 1;</code>
     */
    public boolean hasProfile() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional .exec.shared.MinorFragmentProfile profile = 1;</code>
     */
    public org.apache.drill.exec.proto.UserBitShared.MinorFragmentProfile getProfile() {
      return profile_;
    }
    /**
     * <code>optional .exec.shared.MinorFragmentProfile profile = 1;</code>
     */
    public org.apache.drill.exec.proto.UserBitShared.MinorFragmentProfileOrBuilder getProfileOrBuilder() {
      return profile_;
    }

    // optional .exec.bit.FragmentHandle handle = 2;
    public static final int HANDLE_FIELD_NUMBER = 2;
    private org.apache.drill.exec.proto.ExecProtos.FragmentHandle handle_;
    /**
     * <code>optional .exec.bit.FragmentHandle handle = 2;</code>
     */
    public boolean hasHandle() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional .exec.bit.FragmentHandle handle = 2;</code>
     */
    public org.apache.drill.exec.proto.ExecProtos.FragmentHandle getHandle() {
      return handle_;
    }
    /**
     * <code>optional .exec.bit.FragmentHandle handle = 2;</code>
     */
    public org.apache.drill.exec.proto.ExecProtos.FragmentHandleOrBuilder getHandleOrBuilder() {
      return handle_;
    }

    private void initFields() {
      profile_ = org.apache.drill.exec.proto.UserBitShared.MinorFragmentProfile.getDefaultInstance();
      handle_ = org.apache.drill.exec.proto.ExecProtos.FragmentHandle.getDefaultInstance();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, profile_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(2, handle_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, profile_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, handle_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.BitControl.FragmentStatus parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.BitControl.FragmentStatus parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitControl.FragmentStatus parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.BitControl.FragmentStatus parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitControl.FragmentStatus parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.BitControl.FragmentStatus parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitControl.FragmentStatus parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.BitControl.FragmentStatus parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitControl.FragmentStatus parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.BitControl.FragmentStatus parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.BitControl.FragmentStatus prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.bit.control.FragmentStatus}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.BitControl.FragmentStatusOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_FragmentStatus_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_FragmentStatus_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.BitControl.FragmentStatus.class, org.apache.drill.exec.proto.BitControl.FragmentStatus.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.BitControl.FragmentStatus.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getProfileFieldBuilder();
          getHandleFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        if (profileBuilder_ == null) {
          profile_ = org.apache.drill.exec.proto.UserBitShared.MinorFragmentProfile.getDefaultInstance();
        } else {
          profileBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (handleBuilder_ == null) {
          handle_ = org.apache.drill.exec.proto.ExecProtos.FragmentHandle.getDefaultInstance();
        } else {
          handleBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_FragmentStatus_descriptor;
      }

      public org.apache.drill.exec.proto.BitControl.FragmentStatus getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.BitControl.FragmentStatus.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.BitControl.FragmentStatus build() {
        org.apache.drill.exec.proto.BitControl.FragmentStatus result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.BitControl.FragmentStatus buildPartial() {
        org.apache.drill.exec.proto.BitControl.FragmentStatus result = new org.apache.drill.exec.proto.BitControl.FragmentStatus(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (profileBuilder_ == null) {
          result.profile_ = profile_;
        } else {
          result.profile_ = profileBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        if (handleBuilder_ == null) {
          result.handle_ = handle_;
        } else {
          result.handle_ = handleBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.BitControl.FragmentStatus) {
          return mergeFrom((org.apache.drill.exec.proto.BitControl.FragmentStatus)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.BitControl.FragmentStatus other) {
        if (other == org.apache.drill.exec.proto.BitControl.FragmentStatus.getDefaultInstance()) return this;
        if (other.hasProfile()) {
          mergeProfile(other.getProfile());
        }
        if (other.hasHandle()) {
          mergeHandle(other.getHandle());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.BitControl.FragmentStatus parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.BitControl.FragmentStatus) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // optional .exec.shared.MinorFragmentProfile profile = 1;
      private org.apache.drill.exec.proto.UserBitShared.MinorFragmentProfile profile_ = org.apache.drill.exec.proto.UserBitShared.MinorFragmentProfile.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserBitShared.MinorFragmentProfile, org.apache.drill.exec.proto.UserBitShared.MinorFragmentProfile.Builder, org.apache.drill.exec.proto.UserBitShared.MinorFragmentProfileOrBuilder> profileBuilder_;
      /**
       * <code>optional .exec.shared.MinorFragmentProfile profile = 1;</code>
       */
      public boolean hasProfile() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional .exec.shared.MinorFragmentProfile profile = 1;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.MinorFragmentProfile getProfile() {
        if (profileBuilder_ == null) {
          return profile_;
        } else {
          return profileBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.shared.MinorFragmentProfile profile = 1;</code>
       */
      public Builder setProfile(org.apache.drill.exec.proto.UserBitShared.MinorFragmentProfile value) {
        if (profileBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          profile_ = value;
          onChanged();
        } else {
          profileBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.shared.MinorFragmentProfile profile = 1;</code>
       */
      public Builder setProfile(
          org.apache.drill.exec.proto.UserBitShared.MinorFragmentProfile.Builder builderForValue) {
        if (profileBuilder_ == null) {
          profile_ = builderForValue.build();
          onChanged();
        } else {
          profileBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.shared.MinorFragmentProfile profile = 1;</code>
       */
      public Builder mergeProfile(org.apache.drill.exec.proto.UserBitShared.MinorFragmentProfile value) {
        if (profileBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001) &&
              profile_ != org.apache.drill.exec.proto.UserBitShared.MinorFragmentProfile.getDefaultInstance()) {
            profile_ =
              org.apache.drill.exec.proto.UserBitShared.MinorFragmentProfile.newBuilder(profile_).mergeFrom(value).buildPartial();
          } else {
            profile_ = value;
          }
          onChanged();
        } else {
          profileBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.shared.MinorFragmentProfile profile = 1;</code>
       */
      public Builder clearProfile() {
        if (profileBuilder_ == null) {
          profile_ = org.apache.drill.exec.proto.UserBitShared.MinorFragmentProfile.getDefaultInstance();
          onChanged();
        } else {
          profileBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       * <code>optional .exec.shared.MinorFragmentProfile profile = 1;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.MinorFragmentProfile.Builder getProfileBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getProfileFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.shared.MinorFragmentProfile profile = 1;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.MinorFragmentProfileOrBuilder getProfileOrBuilder() {
        if (profileBuilder_ != null) {
          return profileBuilder_.getMessageOrBuilder();
        } else {
          return profile_;
        }
      }
      /**
       * <code>optional .exec.shared.MinorFragmentProfile profile = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserBitShared.MinorFragmentProfile, org.apache.drill.exec.proto.UserBitShared.MinorFragmentProfile.Builder, org.apache.drill.exec.proto.UserBitShared.MinorFragmentProfileOrBuilder> 
          getProfileFieldBuilder() {
        if (profileBuilder_ == null) {
          profileBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.drill.exec.proto.UserBitShared.MinorFragmentProfile, org.apache.drill.exec.proto.UserBitShared.MinorFragmentProfile.Builder, org.apache.drill.exec.proto.UserBitShared.MinorFragmentProfileOrBuilder>(
                  profile_,
                  getParentForChildren(),
                  isClean());
          profile_ = null;
        }
        return profileBuilder_;
      }

      // optional .exec.bit.FragmentHandle handle = 2;
      private org.apache.drill.exec.proto.ExecProtos.FragmentHandle handle_ = org.apache.drill.exec.proto.ExecProtos.FragmentHandle.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.ExecProtos.FragmentHandle, org.apache.drill.exec.proto.ExecProtos.FragmentHandle.Builder, org.apache.drill.exec.proto.ExecProtos.FragmentHandleOrBuilder> handleBuilder_;
      /**
       * <code>optional .exec.bit.FragmentHandle handle = 2;</code>
       */
      public boolean hasHandle() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional .exec.bit.FragmentHandle handle = 2;</code>
       */
      public org.apache.drill.exec.proto.ExecProtos.FragmentHandle getHandle() {
        if (handleBuilder_ == null) {
          return handle_;
        } else {
          return handleBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.bit.FragmentHandle handle = 2;</code>
       */
      public Builder setHandle(org.apache.drill.exec.proto.ExecProtos.FragmentHandle value) {
        if (handleBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          handle_ = value;
          onChanged();
        } else {
          handleBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .exec.bit.FragmentHandle handle = 2;</code>
       */
      public Builder setHandle(
          org.apache.drill.exec.proto.ExecProtos.FragmentHandle.Builder builderForValue) {
        if (handleBuilder_ == null) {
          handle_ = builderForValue.build();
          onChanged();
        } else {
          handleBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .exec.bit.FragmentHandle handle = 2;</code>
       */
      public Builder mergeHandle(org.apache.drill.exec.proto.ExecProtos.FragmentHandle value) {
        if (handleBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002) &&
              handle_ != org.apache.drill.exec.proto.ExecProtos.FragmentHandle.getDefaultInstance()) {
            handle_ =
              org.apache.drill.exec.proto.ExecProtos.FragmentHandle.newBuilder(handle_).mergeFrom(value).buildPartial();
          } else {
            handle_ = value;
          }
          onChanged();
        } else {
          handleBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .exec.bit.FragmentHandle handle = 2;</code>
       */
      public Builder clearHandle() {
        if (handleBuilder_ == null) {
          handle_ = org.apache.drill.exec.proto.ExecProtos.FragmentHandle.getDefaultInstance();
          onChanged();
        } else {
          handleBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       * <code>optional .exec.bit.FragmentHandle handle = 2;</code>
       */
      public org.apache.drill.exec.proto.ExecProtos.FragmentHandle.Builder getHandleBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getHandleFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.bit.FragmentHandle handle = 2;</code>
       */
      public org.apache.drill.exec.proto.ExecProtos.FragmentHandleOrBuilder getHandleOrBuilder() {
        if (handleBuilder_ != null) {
          return handleBuilder_.getMessageOrBuilder();
        } else {
          return handle_;
        }
      }
      /**
       * <code>optional .exec.bit.FragmentHandle handle = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.ExecProtos.FragmentHandle, org.apache.drill.exec.proto.ExecProtos.FragmentHandle.Builder, org.apache.drill.exec.proto.ExecProtos.FragmentHandleOrBuilder> 
          getHandleFieldBuilder() {
        if (handleBuilder_ == null) {
          handleBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.drill.exec.proto.ExecProtos.FragmentHandle, org.apache.drill.exec.proto.ExecProtos.FragmentHandle.Builder, org.apache.drill.exec.proto.ExecProtos.FragmentHandleOrBuilder>(
                  handle_,
                  getParentForChildren(),
                  isClean());
          handle_ = null;
        }
        return handleBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:exec.bit.control.FragmentStatus)
    }

    static {
      defaultInstance = new FragmentStatus(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.bit.control.FragmentStatus)
  }

  public interface InitializeFragmentsOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // repeated .exec.bit.control.PlanFragment fragment = 1;
    /**
     * <code>repeated .exec.bit.control.PlanFragment fragment = 1;</code>
     */
    java.util.List<org.apache.drill.exec.proto.BitControl.PlanFragment> 
        getFragmentList();
    /**
     * <code>repeated .exec.bit.control.PlanFragment fragment = 1;</code>
     */
    org.apache.drill.exec.proto.BitControl.PlanFragment getFragment(int index);
    /**
     * <code>repeated .exec.bit.control.PlanFragment fragment = 1;</code>
     */
    int getFragmentCount();
    /**
     * <code>repeated .exec.bit.control.PlanFragment fragment = 1;</code>
     */
    java.util.List<? extends org.apache.drill.exec.proto.BitControl.PlanFragmentOrBuilder> 
        getFragmentOrBuilderList();
    /**
     * <code>repeated .exec.bit.control.PlanFragment fragment = 1;</code>
     */
    org.apache.drill.exec.proto.BitControl.PlanFragmentOrBuilder getFragmentOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code exec.bit.control.InitializeFragments}
   */
  public static final class InitializeFragments extends
      com.google.protobuf.GeneratedMessage
      implements InitializeFragmentsOrBuilder {
    // Use InitializeFragments.newBuilder() to construct.
    private InitializeFragments(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private InitializeFragments(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final InitializeFragments defaultInstance;
    public static InitializeFragments getDefaultInstance() {
      return defaultInstance;
    }

    public InitializeFragments getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private InitializeFragments(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                fragment_ = new java.util.ArrayList<org.apache.drill.exec.proto.BitControl.PlanFragment>();
                mutable_bitField0_ |= 0x00000001;
              }
              fragment_.add(input.readMessage(org.apache.drill.exec.proto.BitControl.PlanFragment.PARSER, extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
          fragment_ = java.util.Collections.unmodifiableList(fragment_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_InitializeFragments_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_InitializeFragments_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.BitControl.InitializeFragments.class, org.apache.drill.exec.proto.BitControl.InitializeFragments.Builder.class);
    }

    public static com.google.protobuf.Parser<InitializeFragments> PARSER =
        new com.google.protobuf.AbstractParser<InitializeFragments>() {
      public InitializeFragments parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new InitializeFragments(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<InitializeFragments> getParserForType() {
      return PARSER;
    }

    // repeated .exec.bit.control.PlanFragment fragment = 1;
    public static final int FRAGMENT_FIELD_NUMBER = 1;
    private java.util.List<org.apache.drill.exec.proto.BitControl.PlanFragment> fragment_;
    /**
     * <code>repeated .exec.bit.control.PlanFragment fragment = 1;</code>
     */
    public java.util.List<org.apache.drill.exec.proto.BitControl.PlanFragment> getFragmentList() {
      return fragment_;
    }
    /**
     * <code>repeated .exec.bit.control.PlanFragment fragment = 1;</code>
     */
    public java.util.List<? extends org.apache.drill.exec.proto.BitControl.PlanFragmentOrBuilder> 
        getFragmentOrBuilderList() {
      return fragment_;
    }
    /**
     * <code>repeated .exec.bit.control.PlanFragment fragment = 1;</code>
     */
    public int getFragmentCount() {
      return fragment_.size();
    }
    /**
     * <code>repeated .exec.bit.control.PlanFragment fragment = 1;</code>
     */
    public org.apache.drill.exec.proto.BitControl.PlanFragment getFragment(int index) {
      return fragment_.get(index);
    }
    /**
     * <code>repeated .exec.bit.control.PlanFragment fragment = 1;</code>
     */
    public org.apache.drill.exec.proto.BitControl.PlanFragmentOrBuilder getFragmentOrBuilder(
        int index) {
      return fragment_.get(index);
    }

    private void initFields() {
      fragment_ = java.util.Collections.emptyList();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      for (int i = 0; i < fragment_.size(); i++) {
        output.writeMessage(1, fragment_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < fragment_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, fragment_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.BitControl.InitializeFragments parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.BitControl.InitializeFragments parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitControl.InitializeFragments parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.BitControl.InitializeFragments parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitControl.InitializeFragments parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.BitControl.InitializeFragments parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitControl.InitializeFragments parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.BitControl.InitializeFragments parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitControl.InitializeFragments parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.BitControl.InitializeFragments parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.BitControl.InitializeFragments prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.bit.control.InitializeFragments}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.BitControl.InitializeFragmentsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_InitializeFragments_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_InitializeFragments_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.BitControl.InitializeFragments.class, org.apache.drill.exec.proto.BitControl.InitializeFragments.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.BitControl.InitializeFragments.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getFragmentFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        if (fragmentBuilder_ == null) {
          fragment_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          fragmentBuilder_.clear();
        }
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_InitializeFragments_descriptor;
      }

      public org.apache.drill.exec.proto.BitControl.InitializeFragments getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.BitControl.InitializeFragments.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.BitControl.InitializeFragments build() {
        org.apache.drill.exec.proto.BitControl.InitializeFragments result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.BitControl.InitializeFragments buildPartial() {
        org.apache.drill.exec.proto.BitControl.InitializeFragments result = new org.apache.drill.exec.proto.BitControl.InitializeFragments(this);
        int from_bitField0_ = bitField0_;
        if (fragmentBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)) {
            fragment_ = java.util.Collections.unmodifiableList(fragment_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.fragment_ = fragment_;
        } else {
          result.fragment_ = fragmentBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.BitControl.InitializeFragments) {
          return mergeFrom((org.apache.drill.exec.proto.BitControl.InitializeFragments)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.BitControl.InitializeFragments other) {
        if (other == org.apache.drill.exec.proto.BitControl.InitializeFragments.getDefaultInstance()) return this;
        if (fragmentBuilder_ == null) {
          if (!other.fragment_.isEmpty()) {
            if (fragment_.isEmpty()) {
              fragment_ = other.fragment_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureFragmentIsMutable();
              fragment_.addAll(other.fragment_);
            }
            onChanged();
          }
        } else {
          if (!other.fragment_.isEmpty()) {
            if (fragmentBuilder_.isEmpty()) {
              fragmentBuilder_.dispose();
              fragmentBuilder_ = null;
              fragment_ = other.fragment_;
              bitField0_ = (bitField0_ & ~0x00000001);
              fragmentBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getFragmentFieldBuilder() : null;
            } else {
              fragmentBuilder_.addAllMessages(other.fragment_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.BitControl.InitializeFragments parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.BitControl.InitializeFragments) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // repeated .exec.bit.control.PlanFragment fragment = 1;
      private java.util.List<org.apache.drill.exec.proto.BitControl.PlanFragment> fragment_ =
        java.util.Collections.emptyList();
      private void ensureFragmentIsMutable() {
        if (!((bitField0_ & 0x00000001) == 0x00000001)) {
          fragment_ = new java.util.ArrayList<org.apache.drill.exec.proto.BitControl.PlanFragment>(fragment_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          org.apache.drill.exec.proto.BitControl.PlanFragment, org.apache.drill.exec.proto.BitControl.PlanFragment.Builder, org.apache.drill.exec.proto.BitControl.PlanFragmentOrBuilder> fragmentBuilder_;

      /**
       * <code>repeated .exec.bit.control.PlanFragment fragment = 1;</code>
       */
      public java.util.List<org.apache.drill.exec.proto.BitControl.PlanFragment> getFragmentList() {
        if (fragmentBuilder_ == null) {
          return java.util.Collections.unmodifiableList(fragment_);
        } else {
          return fragmentBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragment = 1;</code>
       */
      public int getFragmentCount() {
        if (fragmentBuilder_ == null) {
          return fragment_.size();
        } else {
          return fragmentBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragment = 1;</code>
       */
      public org.apache.drill.exec.proto.BitControl.PlanFragment getFragment(int index) {
        if (fragmentBuilder_ == null) {
          return fragment_.get(index);
        } else {
          return fragmentBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragment = 1;</code>
       */
      public Builder setFragment(
          int index, org.apache.drill.exec.proto.BitControl.PlanFragment value) {
        if (fragmentBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFragmentIsMutable();
          fragment_.set(index, value);
          onChanged();
        } else {
          fragmentBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragment = 1;</code>
       */
      public Builder setFragment(
          int index, org.apache.drill.exec.proto.BitControl.PlanFragment.Builder builderForValue) {
        if (fragmentBuilder_ == null) {
          ensureFragmentIsMutable();
          fragment_.set(index, builderForValue.build());
          onChanged();
        } else {
          fragmentBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragment = 1;</code>
       */
      public Builder addFragment(org.apache.drill.exec.proto.BitControl.PlanFragment value) {
        if (fragmentBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFragmentIsMutable();
          fragment_.add(value);
          onChanged();
        } else {
          fragmentBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragment = 1;</code>
       */
      public Builder addFragment(
          int index, org.apache.drill.exec.proto.BitControl.PlanFragment value) {
        if (fragmentBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFragmentIsMutable();
          fragment_.add(index, value);
          onChanged();
        } else {
          fragmentBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragment = 1;</code>
       */
      public Builder addFragment(
          org.apache.drill.exec.proto.BitControl.PlanFragment.Builder builderForValue) {
        if (fragmentBuilder_ == null) {
          ensureFragmentIsMutable();
          fragment_.add(builderForValue.build());
          onChanged();
        } else {
          fragmentBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragment = 1;</code>
       */
      public Builder addFragment(
          int index, org.apache.drill.exec.proto.BitControl.PlanFragment.Builder builderForValue) {
        if (fragmentBuilder_ == null) {
          ensureFragmentIsMutable();
          fragment_.add(index, builderForValue.build());
          onChanged();
        } else {
          fragmentBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragment = 1;</code>
       */
      public Builder addAllFragment(
          java.lang.Iterable<? extends org.apache.drill.exec.proto.BitControl.PlanFragment> values) {
        if (fragmentBuilder_ == null) {
          ensureFragmentIsMutable();
          super.addAll(values, fragment_);
          onChanged();
        } else {
          fragmentBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragment = 1;</code>
       */
      public Builder clearFragment() {
        if (fragmentBuilder_ == null) {
          fragment_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          fragmentBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragment = 1;</code>
       */
      public Builder removeFragment(int index) {
        if (fragmentBuilder_ == null) {
          ensureFragmentIsMutable();
          fragment_.remove(index);
          onChanged();
        } else {
          fragmentBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragment = 1;</code>
       */
      public org.apache.drill.exec.proto.BitControl.PlanFragment.Builder getFragmentBuilder(
          int index) {
        return getFragmentFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragment = 1;</code>
       */
      public org.apache.drill.exec.proto.BitControl.PlanFragmentOrBuilder getFragmentOrBuilder(
          int index) {
        if (fragmentBuilder_ == null) {
          return fragment_.get(index);  } else {
          return fragmentBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragment = 1;</code>
       */
      public java.util.List<? extends org.apache.drill.exec.proto.BitControl.PlanFragmentOrBuilder> 
           getFragmentOrBuilderList() {
        if (fragmentBuilder_ != null) {
          return fragmentBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(fragment_);
        }
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragment = 1;</code>
       */
      public org.apache.drill.exec.proto.BitControl.PlanFragment.Builder addFragmentBuilder() {
        return getFragmentFieldBuilder().addBuilder(
            org.apache.drill.exec.proto.BitControl.PlanFragment.getDefaultInstance());
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragment = 1;</code>
       */
      public org.apache.drill.exec.proto.BitControl.PlanFragment.Builder addFragmentBuilder(
          int index) {
        return getFragmentFieldBuilder().addBuilder(
            index, org.apache.drill.exec.proto.BitControl.PlanFragment.getDefaultInstance());
      }
      /**
       * <code>repeated .exec.bit.control.PlanFragment fragment = 1;</code>
       */
      public java.util.List<org.apache.drill.exec.proto.BitControl.PlanFragment.Builder> 
           getFragmentBuilderList() {
        return getFragmentFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          org.apache.drill.exec.proto.BitControl.PlanFragment, org.apache.drill.exec.proto.BitControl.PlanFragment.Builder, org.apache.drill.exec.proto.BitControl.PlanFragmentOrBuilder> 
          getFragmentFieldBuilder() {
        if (fragmentBuilder_ == null) {
          fragmentBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              org.apache.drill.exec.proto.BitControl.PlanFragment, org.apache.drill.exec.proto.BitControl.PlanFragment.Builder, org.apache.drill.exec.proto.BitControl.PlanFragmentOrBuilder>(
                  fragment_,
                  ((bitField0_ & 0x00000001) == 0x00000001),
                  getParentForChildren(),
                  isClean());
          fragment_ = null;
        }
        return fragmentBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:exec.bit.control.InitializeFragments)
    }

    static {
      defaultInstance = new InitializeFragments(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.bit.control.InitializeFragments)
  }

  public interface CustomMessageOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // optional int32 type = 1;
    /**
     * <code>optional int32 type = 1;</code>
     */
    boolean hasType();
    /**
     * <code>optional int32 type = 1;</code>
     */
    int getType();

    // optional bytes message = 2;
    /**
     * <code>optional bytes message = 2;</code>
     */
    boolean hasMessage();
    /**
     * <code>optional bytes message = 2;</code>
     */
    com.google.protobuf.ByteString getMessage();
  }
  /**
   * Protobuf type {@code exec.bit.control.CustomMessage}
   */
  public static final class CustomMessage extends
      com.google.protobuf.GeneratedMessage
      implements CustomMessageOrBuilder {
    // Use CustomMessage.newBuilder() to construct.
    private CustomMessage(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private CustomMessage(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final CustomMessage defaultInstance;
    public static CustomMessage getDefaultInstance() {
      return defaultInstance;
    }

    public CustomMessage getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private CustomMessage(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              bitField0_ |= 0x00000001;
              type_ = input.readInt32();
              break;
            }
            case 18: {
              bitField0_ |= 0x00000002;
              message_ = input.readBytes();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_CustomMessage_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_CustomMessage_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.BitControl.CustomMessage.class, org.apache.drill.exec.proto.BitControl.CustomMessage.Builder.class);
    }

    public static com.google.protobuf.Parser<CustomMessage> PARSER =
        new com.google.protobuf.AbstractParser<CustomMessage>() {
      public CustomMessage parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new CustomMessage(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<CustomMessage> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // optional int32 type = 1;
    public static final int TYPE_FIELD_NUMBER = 1;
    private int type_;
    /**
     * <code>optional int32 type = 1;</code>
     */
    public boolean hasType() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional int32 type = 1;</code>
     */
    public int getType() {
      return type_;
    }

    // optional bytes message = 2;
    public static final int MESSAGE_FIELD_NUMBER = 2;
    private com.google.protobuf.ByteString message_;
    /**
     * <code>optional bytes message = 2;</code>
     */
    public boolean hasMessage() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional bytes message = 2;</code>
     */
    public com.google.protobuf.ByteString getMessage() {
      return message_;
    }

    private void initFields() {
      type_ = 0;
      message_ = com.google.protobuf.ByteString.EMPTY;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeInt32(1, type_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeBytes(2, message_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(1, type_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(2, message_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.BitControl.CustomMessage parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.BitControl.CustomMessage parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitControl.CustomMessage parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.BitControl.CustomMessage parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitControl.CustomMessage parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.BitControl.CustomMessage parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitControl.CustomMessage parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.BitControl.CustomMessage parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitControl.CustomMessage parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.BitControl.CustomMessage parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.BitControl.CustomMessage prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.bit.control.CustomMessage}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.BitControl.CustomMessageOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_CustomMessage_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_CustomMessage_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.BitControl.CustomMessage.class, org.apache.drill.exec.proto.BitControl.CustomMessage.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.BitControl.CustomMessage.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        type_ = 0;
        bitField0_ = (bitField0_ & ~0x00000001);
        message_ = com.google.protobuf.ByteString.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_CustomMessage_descriptor;
      }

      public org.apache.drill.exec.proto.BitControl.CustomMessage getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.BitControl.CustomMessage.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.BitControl.CustomMessage build() {
        org.apache.drill.exec.proto.BitControl.CustomMessage result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.BitControl.CustomMessage buildPartial() {
        org.apache.drill.exec.proto.BitControl.CustomMessage result = new org.apache.drill.exec.proto.BitControl.CustomMessage(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.type_ = type_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.message_ = message_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.BitControl.CustomMessage) {
          return mergeFrom((org.apache.drill.exec.proto.BitControl.CustomMessage)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.BitControl.CustomMessage other) {
        if (other == org.apache.drill.exec.proto.BitControl.CustomMessage.getDefaultInstance()) return this;
        if (other.hasType()) {
          setType(other.getType());
        }
        if (other.hasMessage()) {
          setMessage(other.getMessage());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.BitControl.CustomMessage parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.BitControl.CustomMessage) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // optional int32 type = 1;
      private int type_ ;
      /**
       * <code>optional int32 type = 1;</code>
       */
      public boolean hasType() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional int32 type = 1;</code>
       */
      public int getType() {
        return type_;
      }
      /**
       * <code>optional int32 type = 1;</code>
       */
      public Builder setType(int value) {
        bitField0_ |= 0x00000001;
        type_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 type = 1;</code>
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        type_ = 0;
        onChanged();
        return this;
      }

      // optional bytes message = 2;
      private com.google.protobuf.ByteString message_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <code>optional bytes message = 2;</code>
       */
      public boolean hasMessage() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional bytes message = 2;</code>
       */
      public com.google.protobuf.ByteString getMessage() {
        return message_;
      }
      /**
       * <code>optional bytes message = 2;</code>
       */
      public Builder setMessage(com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        message_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bytes message = 2;</code>
       */
      public Builder clearMessage() {
        bitField0_ = (bitField0_ & ~0x00000002);
        message_ = getDefaultInstance().getMessage();
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:exec.bit.control.CustomMessage)
    }

    static {
      defaultInstance = new CustomMessage(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.bit.control.CustomMessage)
  }

  public interface PlanFragmentOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // optional .exec.bit.FragmentHandle handle = 1;
    /**
     * <code>optional .exec.bit.FragmentHandle handle = 1;</code>
     */
    boolean hasHandle();
    /**
     * <code>optional .exec.bit.FragmentHandle handle = 1;</code>
     */
    org.apache.drill.exec.proto.ExecProtos.FragmentHandle getHandle();
    /**
     * <code>optional .exec.bit.FragmentHandle handle = 1;</code>
     */
    org.apache.drill.exec.proto.ExecProtos.FragmentHandleOrBuilder getHandleOrBuilder();

    // optional float network_cost = 4;
    /**
     * <code>optional float network_cost = 4;</code>
     */
    boolean hasNetworkCost();
    /**
     * <code>optional float network_cost = 4;</code>
     */
    float getNetworkCost();

    // optional float cpu_cost = 5;
    /**
     * <code>optional float cpu_cost = 5;</code>
     */
    boolean hasCpuCost();
    /**
     * <code>optional float cpu_cost = 5;</code>
     */
    float getCpuCost();

    // optional float disk_cost = 6;
    /**
     * <code>optional float disk_cost = 6;</code>
     */
    boolean hasDiskCost();
    /**
     * <code>optional float disk_cost = 6;</code>
     */
    float getDiskCost();

    // optional float memory_cost = 7;
    /**
     * <code>optional float memory_cost = 7;</code>
     */
    boolean hasMemoryCost();
    /**
     * <code>optional float memory_cost = 7;</code>
     */
    float getMemoryCost();

    // optional string fragment_json = 8;
    /**
     * <code>optional string fragment_json = 8;</code>
     */
    boolean hasFragmentJson();
    /**
     * <code>optional string fragment_json = 8;</code>
     */
    java.lang.String getFragmentJson();
    /**
     * <code>optional string fragment_json = 8;</code>
     */
    com.google.protobuf.ByteString
        getFragmentJsonBytes();

    // optional bool leaf_fragment = 9;
    /**
     * <code>optional bool leaf_fragment = 9;</code>
     */
    boolean hasLeafFragment();
    /**
     * <code>optional bool leaf_fragment = 9;</code>
     */
    boolean getLeafFragment();

    // optional .exec.DrillbitEndpoint assignment = 10;
    /**
     * <code>optional .exec.DrillbitEndpoint assignment = 10;</code>
     */
    boolean hasAssignment();
    /**
     * <code>optional .exec.DrillbitEndpoint assignment = 10;</code>
     */
    org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint getAssignment();
    /**
     * <code>optional .exec.DrillbitEndpoint assignment = 10;</code>
     */
    org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpointOrBuilder getAssignmentOrBuilder();

    // optional .exec.DrillbitEndpoint foreman = 11;
    /**
     * <code>optional .exec.DrillbitEndpoint foreman = 11;</code>
     */
    boolean hasForeman();
    /**
     * <code>optional .exec.DrillbitEndpoint foreman = 11;</code>
     */
    org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint getForeman();
    /**
     * <code>optional .exec.DrillbitEndpoint foreman = 11;</code>
     */
    org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpointOrBuilder getForemanOrBuilder();

    // optional int64 mem_initial = 12 [default = 20000000];
    /**
     * <code>optional int64 mem_initial = 12 [default = 20000000];</code>
     *
     * <pre>
     * 20 megs
     * </pre>
     */
    boolean hasMemInitial();
    /**
     * <code>optional int64 mem_initial = 12 [default = 20000000];</code>
     *
     * <pre>
     * 20 megs
     * </pre>
     */
    long getMemInitial();

    // optional int64 mem_max = 13 [default = 2000000000];
    /**
     * <code>optional int64 mem_max = 13 [default = 2000000000];</code>
     *
     * <pre>
     * 20 gigs
     * </pre>
     */
    boolean hasMemMax();
    /**
     * <code>optional int64 mem_max = 13 [default = 2000000000];</code>
     *
     * <pre>
     * 20 gigs
     * </pre>
     */
    long getMemMax();

    // optional .exec.shared.UserCredentials credentials = 14;
    /**
     * <code>optional .exec.shared.UserCredentials credentials = 14;</code>
     */
    boolean hasCredentials();
    /**
     * <code>optional .exec.shared.UserCredentials credentials = 14;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.UserCredentials getCredentials();
    /**
     * <code>optional .exec.shared.UserCredentials credentials = 14;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.UserCredentialsOrBuilder getCredentialsOrBuilder();

    // optional string options_json = 15;
    /**
     * <code>optional string options_json = 15;</code>
     */
    boolean hasOptionsJson();
    /**
     * <code>optional string options_json = 15;</code>
     */
    java.lang.String getOptionsJson();
    /**
     * <code>optional string options_json = 15;</code>
     */
    com.google.protobuf.ByteString
        getOptionsJsonBytes();

    // optional .exec.bit.control.QueryContextInformation context = 16;
    /**
     * <code>optional .exec.bit.control.QueryContextInformation context = 16;</code>
     */
    boolean hasContext();
    /**
     * <code>optional .exec.bit.control.QueryContextInformation context = 16;</code>
     */
    org.apache.drill.exec.proto.BitControl.QueryContextInformation getContext();
    /**
     * <code>optional .exec.bit.control.QueryContextInformation context = 16;</code>
     */
    org.apache.drill.exec.proto.BitControl.QueryContextInformationOrBuilder getContextOrBuilder();

    // repeated .exec.bit.control.Collector collector = 17;
    /**
     * <code>repeated .exec.bit.control.Collector collector = 17;</code>
     */
    java.util.List<org.apache.drill.exec.proto.BitControl.Collector> 
        getCollectorList();
    /**
     * <code>repeated .exec.bit.control.Collector collector = 17;</code>
     */
    org.apache.drill.exec.proto.BitControl.Collector getCollector(int index);
    /**
     * <code>repeated .exec.bit.control.Collector collector = 17;</code>
     */
    int getCollectorCount();
    /**
     * <code>repeated .exec.bit.control.Collector collector = 17;</code>
     */
    java.util.List<? extends org.apache.drill.exec.proto.BitControl.CollectorOrBuilder> 
        getCollectorOrBuilderList();
    /**
     * <code>repeated .exec.bit.control.Collector collector = 17;</code>
     */
    org.apache.drill.exec.proto.BitControl.CollectorOrBuilder getCollectorOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code exec.bit.control.PlanFragment}
   */
  public static final class PlanFragment extends
      com.google.protobuf.GeneratedMessage
      implements PlanFragmentOrBuilder {
    // Use PlanFragment.newBuilder() to construct.
    private PlanFragment(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private PlanFragment(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final PlanFragment defaultInstance;
    public static PlanFragment getDefaultInstance() {
      return defaultInstance;
    }

    public PlanFragment getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private PlanFragment(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              org.apache.drill.exec.proto.ExecProtos.FragmentHandle.Builder subBuilder = null;
              if (((bitField0_ & 0x00000001) == 0x00000001)) {
                subBuilder = handle_.toBuilder();
              }
              handle_ = input.readMessage(org.apache.drill.exec.proto.ExecProtos.FragmentHandle.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(handle_);
                handle_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000001;
              break;
            }
            case 37: {
              bitField0_ |= 0x00000002;
              networkCost_ = input.readFloat();
              break;
            }
            case 45: {
              bitField0_ |= 0x00000004;
              cpuCost_ = input.readFloat();
              break;
            }
            case 53: {
              bitField0_ |= 0x00000008;
              diskCost_ = input.readFloat();
              break;
            }
            case 61: {
              bitField0_ |= 0x00000010;
              memoryCost_ = input.readFloat();
              break;
            }
            case 66: {
              bitField0_ |= 0x00000020;
              fragmentJson_ = input.readBytes();
              break;
            }
            case 72: {
              bitField0_ |= 0x00000040;
              leafFragment_ = input.readBool();
              break;
            }
            case 82: {
              org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.Builder subBuilder = null;
              if (((bitField0_ & 0x00000080) == 0x00000080)) {
                subBuilder = assignment_.toBuilder();
              }
              assignment_ = input.readMessage(org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(assignment_);
                assignment_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000080;
              break;
            }
            case 90: {
              org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.Builder subBuilder = null;
              if (((bitField0_ & 0x00000100) == 0x00000100)) {
                subBuilder = foreman_.toBuilder();
              }
              foreman_ = input.readMessage(org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(foreman_);
                foreman_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000100;
              break;
            }
            case 96: {
              bitField0_ |= 0x00000200;
              memInitial_ = input.readInt64();
              break;
            }
            case 104: {
              bitField0_ |= 0x00000400;
              memMax_ = input.readInt64();
              break;
            }
            case 114: {
              org.apache.drill.exec.proto.UserBitShared.UserCredentials.Builder subBuilder = null;
              if (((bitField0_ & 0x00000800) == 0x00000800)) {
                subBuilder = credentials_.toBuilder();
              }
              credentials_ = input.readMessage(org.apache.drill.exec.proto.UserBitShared.UserCredentials.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(credentials_);
                credentials_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000800;
              break;
            }
            case 122: {
              bitField0_ |= 0x00001000;
              optionsJson_ = input.readBytes();
              break;
            }
            case 130: {
              org.apache.drill.exec.proto.BitControl.QueryContextInformation.Builder subBuilder = null;
              if (((bitField0_ & 0x00002000) == 0x00002000)) {
                subBuilder = context_.toBuilder();
              }
              context_ = input.readMessage(org.apache.drill.exec.proto.BitControl.QueryContextInformation.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(context_);
                context_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00002000;
              break;
            }
            case 138: {
              if (!((mutable_bitField0_ & 0x00004000) == 0x00004000)) {
                collector_ = new java.util.ArrayList<org.apache.drill.exec.proto.BitControl.Collector>();
                mutable_bitField0_ |= 0x00004000;
              }
              collector_.add(input.readMessage(org.apache.drill.exec.proto.BitControl.Collector.PARSER, extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00004000) == 0x00004000)) {
          collector_ = java.util.Collections.unmodifiableList(collector_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_PlanFragment_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_PlanFragment_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.BitControl.PlanFragment.class, org.apache.drill.exec.proto.BitControl.PlanFragment.Builder.class);
    }

    public static com.google.protobuf.Parser<PlanFragment> PARSER =
        new com.google.protobuf.AbstractParser<PlanFragment>() {
      public PlanFragment parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new PlanFragment(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<PlanFragment> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // optional .exec.bit.FragmentHandle handle = 1;
    public static final int HANDLE_FIELD_NUMBER = 1;
    private org.apache.drill.exec.proto.ExecProtos.FragmentHandle handle_;
    /**
     * <code>optional .exec.bit.FragmentHandle handle = 1;</code>
     */
    public boolean hasHandle() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional .exec.bit.FragmentHandle handle = 1;</code>
     */
    public org.apache.drill.exec.proto.ExecProtos.FragmentHandle getHandle() {
      return handle_;
    }
    /**
     * <code>optional .exec.bit.FragmentHandle handle = 1;</code>
     */
    public org.apache.drill.exec.proto.ExecProtos.FragmentHandleOrBuilder getHandleOrBuilder() {
      return handle_;
    }

    // optional float network_cost = 4;
    public static final int NETWORK_COST_FIELD_NUMBER = 4;
    private float networkCost_;
    /**
     * <code>optional float network_cost = 4;</code>
     */
    public boolean hasNetworkCost() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional float network_cost = 4;</code>
     */
    public float getNetworkCost() {
      return networkCost_;
    }

    // optional float cpu_cost = 5;
    public static final int CPU_COST_FIELD_NUMBER = 5;
    private float cpuCost_;
    /**
     * <code>optional float cpu_cost = 5;</code>
     */
    public boolean hasCpuCost() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional float cpu_cost = 5;</code>
     */
    public float getCpuCost() {
      return cpuCost_;
    }

    // optional float disk_cost = 6;
    public static final int DISK_COST_FIELD_NUMBER = 6;
    private float diskCost_;
    /**
     * <code>optional float disk_cost = 6;</code>
     */
    public boolean hasDiskCost() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional float disk_cost = 6;</code>
     */
    public float getDiskCost() {
      return diskCost_;
    }

    // optional float memory_cost = 7;
    public static final int MEMORY_COST_FIELD_NUMBER = 7;
    private float memoryCost_;
    /**
     * <code>optional float memory_cost = 7;</code>
     */
    public boolean hasMemoryCost() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     * <code>optional float memory_cost = 7;</code>
     */
    public float getMemoryCost() {
      return memoryCost_;
    }

    // optional string fragment_json = 8;
    public static final int FRAGMENT_JSON_FIELD_NUMBER = 8;
    private java.lang.Object fragmentJson_;
    /**
     * <code>optional string fragment_json = 8;</code>
     */
    public boolean hasFragmentJson() {
      return ((bitField0_ & 0x00000020) == 0x00000020);
    }
    /**
     * <code>optional string fragment_json = 8;</code>
     */
    public java.lang.String getFragmentJson() {
      java.lang.Object ref = fragmentJson_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          fragmentJson_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string fragment_json = 8;</code>
     */
    public com.google.protobuf.ByteString
        getFragmentJsonBytes() {
      java.lang.Object ref = fragmentJson_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        fragmentJson_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // optional bool leaf_fragment = 9;
    public static final int LEAF_FRAGMENT_FIELD_NUMBER = 9;
    private boolean leafFragment_;
    /**
     * <code>optional bool leaf_fragment = 9;</code>
     */
    public boolean hasLeafFragment() {
      return ((bitField0_ & 0x00000040) == 0x00000040);
    }
    /**
     * <code>optional bool leaf_fragment = 9;</code>
     */
    public boolean getLeafFragment() {
      return leafFragment_;
    }

    // optional .exec.DrillbitEndpoint assignment = 10;
    public static final int ASSIGNMENT_FIELD_NUMBER = 10;
    private org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint assignment_;
    /**
     * <code>optional .exec.DrillbitEndpoint assignment = 10;</code>
     */
    public boolean hasAssignment() {
      return ((bitField0_ & 0x00000080) == 0x00000080);
    }
    /**
     * <code>optional .exec.DrillbitEndpoint assignment = 10;</code>
     */
    public org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint getAssignment() {
      return assignment_;
    }
    /**
     * <code>optional .exec.DrillbitEndpoint assignment = 10;</code>
     */
    public org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpointOrBuilder getAssignmentOrBuilder() {
      return assignment_;
    }

    // optional .exec.DrillbitEndpoint foreman = 11;
    public static final int FOREMAN_FIELD_NUMBER = 11;
    private org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint foreman_;
    /**
     * <code>optional .exec.DrillbitEndpoint foreman = 11;</code>
     */
    public boolean hasForeman() {
      return ((bitField0_ & 0x00000100) == 0x00000100);
    }
    /**
     * <code>optional .exec.DrillbitEndpoint foreman = 11;</code>
     */
    public org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint getForeman() {
      return foreman_;
    }
    /**
     * <code>optional .exec.DrillbitEndpoint foreman = 11;</code>
     */
    public org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpointOrBuilder getForemanOrBuilder() {
      return foreman_;
    }

    // optional int64 mem_initial = 12 [default = 20000000];
    public static final int MEM_INITIAL_FIELD_NUMBER = 12;
    private long memInitial_;
    /**
     * <code>optional int64 mem_initial = 12 [default = 20000000];</code>
     *
     * <pre>
     * 20 megs
     * </pre>
     */
    public boolean hasMemInitial() {
      return ((bitField0_ & 0x00000200) == 0x00000200);
    }
    /**
     * <code>optional int64 mem_initial = 12 [default = 20000000];</code>
     *
     * <pre>
     * 20 megs
     * </pre>
     */
    public long getMemInitial() {
      return memInitial_;
    }

    // optional int64 mem_max = 13 [default = 2000000000];
    public static final int MEM_MAX_FIELD_NUMBER = 13;
    private long memMax_;
    /**
     * <code>optional int64 mem_max = 13 [default = 2000000000];</code>
     *
     * <pre>
     * 20 gigs
     * </pre>
     */
    public boolean hasMemMax() {
      return ((bitField0_ & 0x00000400) == 0x00000400);
    }
    /**
     * <code>optional int64 mem_max = 13 [default = 2000000000];</code>
     *
     * <pre>
     * 20 gigs
     * </pre>
     */
    public long getMemMax() {
      return memMax_;
    }

    // optional .exec.shared.UserCredentials credentials = 14;
    public static final int CREDENTIALS_FIELD_NUMBER = 14;
    private org.apache.drill.exec.proto.UserBitShared.UserCredentials credentials_;
    /**
     * <code>optional .exec.shared.UserCredentials credentials = 14;</code>
     */
    public boolean hasCredentials() {
      return ((bitField0_ & 0x00000800) == 0x00000800);
    }
    /**
     * <code>optional .exec.shared.UserCredentials credentials = 14;</code>
     */
    public org.apache.drill.exec.proto.UserBitShared.UserCredentials getCredentials() {
      return credentials_;
    }
    /**
     * <code>optional .exec.shared.UserCredentials credentials = 14;</code>
     */
    public org.apache.drill.exec.proto.UserBitShared.UserCredentialsOrBuilder getCredentialsOrBuilder() {
      return credentials_;
    }

    // optional string options_json = 15;
    public static final int OPTIONS_JSON_FIELD_NUMBER = 15;
    private java.lang.Object optionsJson_;
    /**
     * <code>optional string options_json = 15;</code>
     */
    public boolean hasOptionsJson() {
      return ((bitField0_ & 0x00001000) == 0x00001000);
    }
    /**
     * <code>optional string options_json = 15;</code>
     */
    public java.lang.String getOptionsJson() {
      java.lang.Object ref = optionsJson_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          optionsJson_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string options_json = 15;</code>
     */
    public com.google.protobuf.ByteString
        getOptionsJsonBytes() {
      java.lang.Object ref = optionsJson_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        optionsJson_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // optional .exec.bit.control.QueryContextInformation context = 16;
    public static final int CONTEXT_FIELD_NUMBER = 16;
    private org.apache.drill.exec.proto.BitControl.QueryContextInformation context_;
    /**
     * <code>optional .exec.bit.control.QueryContextInformation context = 16;</code>
     */
    public boolean hasContext() {
      return ((bitField0_ & 0x00002000) == 0x00002000);
    }
    /**
     * <code>optional .exec.bit.control.QueryContextInformation context = 16;</code>
     */
    public org.apache.drill.exec.proto.BitControl.QueryContextInformation getContext() {
      return context_;
    }
    /**
     * <code>optional .exec.bit.control.QueryContextInformation context = 16;</code>
     */
    public org.apache.drill.exec.proto.BitControl.QueryContextInformationOrBuilder getContextOrBuilder() {
      return context_;
    }

    // repeated .exec.bit.control.Collector collector = 17;
    public static final int COLLECTOR_FIELD_NUMBER = 17;
    private java.util.List<org.apache.drill.exec.proto.BitControl.Collector> collector_;
    /**
     * <code>repeated .exec.bit.control.Collector collector = 17;</code>
     */
    public java.util.List<org.apache.drill.exec.proto.BitControl.Collector> getCollectorList() {
      return collector_;
    }
    /**
     * <code>repeated .exec.bit.control.Collector collector = 17;</code>
     */
    public java.util.List<? extends org.apache.drill.exec.proto.BitControl.CollectorOrBuilder> 
        getCollectorOrBuilderList() {
      return collector_;
    }
    /**
     * <code>repeated .exec.bit.control.Collector collector = 17;</code>
     */
    public int getCollectorCount() {
      return collector_.size();
    }
    /**
     * <code>repeated .exec.bit.control.Collector collector = 17;</code>
     */
    public org.apache.drill.exec.proto.BitControl.Collector getCollector(int index) {
      return collector_.get(index);
    }
    /**
     * <code>repeated .exec.bit.control.Collector collector = 17;</code>
     */
    public org.apache.drill.exec.proto.BitControl.CollectorOrBuilder getCollectorOrBuilder(
        int index) {
      return collector_.get(index);
    }

    private void initFields() {
      handle_ = org.apache.drill.exec.proto.ExecProtos.FragmentHandle.getDefaultInstance();
      networkCost_ = 0F;
      cpuCost_ = 0F;
      diskCost_ = 0F;
      memoryCost_ = 0F;
      fragmentJson_ = "";
      leafFragment_ = false;
      assignment_ = org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.getDefaultInstance();
      foreman_ = org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.getDefaultInstance();
      memInitial_ = 20000000L;
      memMax_ = 2000000000L;
      credentials_ = org.apache.drill.exec.proto.UserBitShared.UserCredentials.getDefaultInstance();
      optionsJson_ = "";
      context_ = org.apache.drill.exec.proto.BitControl.QueryContextInformation.getDefaultInstance();
      collector_ = java.util.Collections.emptyList();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, handle_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeFloat(4, networkCost_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeFloat(5, cpuCost_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeFloat(6, diskCost_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        output.writeFloat(7, memoryCost_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        output.writeBytes(8, getFragmentJsonBytes());
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        output.writeBool(9, leafFragment_);
      }
      if (((bitField0_ & 0x00000080) == 0x00000080)) {
        output.writeMessage(10, assignment_);
      }
      if (((bitField0_ & 0x00000100) == 0x00000100)) {
        output.writeMessage(11, foreman_);
      }
      if (((bitField0_ & 0x00000200) == 0x00000200)) {
        output.writeInt64(12, memInitial_);
      }
      if (((bitField0_ & 0x00000400) == 0x00000400)) {
        output.writeInt64(13, memMax_);
      }
      if (((bitField0_ & 0x00000800) == 0x00000800)) {
        output.writeMessage(14, credentials_);
      }
      if (((bitField0_ & 0x00001000) == 0x00001000)) {
        output.writeBytes(15, getOptionsJsonBytes());
      }
      if (((bitField0_ & 0x00002000) == 0x00002000)) {
        output.writeMessage(16, context_);
      }
      for (int i = 0; i < collector_.size(); i++) {
        output.writeMessage(17, collector_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, handle_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeFloatSize(4, networkCost_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeFloatSize(5, cpuCost_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeFloatSize(6, diskCost_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.CodedOutputStream
          .computeFloatSize(7, memoryCost_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(8, getFragmentJsonBytes());
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(9, leafFragment_);
      }
      if (((bitField0_ & 0x00000080) == 0x00000080)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(10, assignment_);
      }
      if (((bitField0_ & 0x00000100) == 0x00000100)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(11, foreman_);
      }
      if (((bitField0_ & 0x00000200) == 0x00000200)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt64Size(12, memInitial_);
      }
      if (((bitField0_ & 0x00000400) == 0x00000400)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt64Size(13, memMax_);
      }
      if (((bitField0_ & 0x00000800) == 0x00000800)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(14, credentials_);
      }
      if (((bitField0_ & 0x00001000) == 0x00001000)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(15, getOptionsJsonBytes());
      }
      if (((bitField0_ & 0x00002000) == 0x00002000)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(16, context_);
      }
      for (int i = 0; i < collector_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(17, collector_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.BitControl.PlanFragment parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.BitControl.PlanFragment parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitControl.PlanFragment parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.BitControl.PlanFragment parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitControl.PlanFragment parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.BitControl.PlanFragment parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitControl.PlanFragment parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.BitControl.PlanFragment parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitControl.PlanFragment parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.BitControl.PlanFragment parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.BitControl.PlanFragment prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.bit.control.PlanFragment}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.BitControl.PlanFragmentOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_PlanFragment_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_PlanFragment_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.BitControl.PlanFragment.class, org.apache.drill.exec.proto.BitControl.PlanFragment.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.BitControl.PlanFragment.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getHandleFieldBuilder();
          getAssignmentFieldBuilder();
          getForemanFieldBuilder();
          getCredentialsFieldBuilder();
          getContextFieldBuilder();
          getCollectorFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        if (handleBuilder_ == null) {
          handle_ = org.apache.drill.exec.proto.ExecProtos.FragmentHandle.getDefaultInstance();
        } else {
          handleBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        networkCost_ = 0F;
        bitField0_ = (bitField0_ & ~0x00000002);
        cpuCost_ = 0F;
        bitField0_ = (bitField0_ & ~0x00000004);
        diskCost_ = 0F;
        bitField0_ = (bitField0_ & ~0x00000008);
        memoryCost_ = 0F;
        bitField0_ = (bitField0_ & ~0x00000010);
        fragmentJson_ = "";
        bitField0_ = (bitField0_ & ~0x00000020);
        leafFragment_ = false;
        bitField0_ = (bitField0_ & ~0x00000040);
        if (assignmentBuilder_ == null) {
          assignment_ = org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.getDefaultInstance();
        } else {
          assignmentBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000080);
        if (foremanBuilder_ == null) {
          foreman_ = org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.getDefaultInstance();
        } else {
          foremanBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000100);
        memInitial_ = 20000000L;
        bitField0_ = (bitField0_ & ~0x00000200);
        memMax_ = 2000000000L;
        bitField0_ = (bitField0_ & ~0x00000400);
        if (credentialsBuilder_ == null) {
          credentials_ = org.apache.drill.exec.proto.UserBitShared.UserCredentials.getDefaultInstance();
        } else {
          credentialsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000800);
        optionsJson_ = "";
        bitField0_ = (bitField0_ & ~0x00001000);
        if (contextBuilder_ == null) {
          context_ = org.apache.drill.exec.proto.BitControl.QueryContextInformation.getDefaultInstance();
        } else {
          contextBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00002000);
        if (collectorBuilder_ == null) {
          collector_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00004000);
        } else {
          collectorBuilder_.clear();
        }
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_PlanFragment_descriptor;
      }

      public org.apache.drill.exec.proto.BitControl.PlanFragment getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.BitControl.PlanFragment.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.BitControl.PlanFragment build() {
        org.apache.drill.exec.proto.BitControl.PlanFragment result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.BitControl.PlanFragment buildPartial() {
        org.apache.drill.exec.proto.BitControl.PlanFragment result = new org.apache.drill.exec.proto.BitControl.PlanFragment(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (handleBuilder_ == null) {
          result.handle_ = handle_;
        } else {
          result.handle_ = handleBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.networkCost_ = networkCost_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.cpuCost_ = cpuCost_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.diskCost_ = diskCost_;
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000010;
        }
        result.memoryCost_ = memoryCost_;
        if (((from_bitField0_ & 0x00000020) == 0x00000020)) {
          to_bitField0_ |= 0x00000020;
        }
        result.fragmentJson_ = fragmentJson_;
        if (((from_bitField0_ & 0x00000040) == 0x00000040)) {
          to_bitField0_ |= 0x00000040;
        }
        result.leafFragment_ = leafFragment_;
        if (((from_bitField0_ & 0x00000080) == 0x00000080)) {
          to_bitField0_ |= 0x00000080;
        }
        if (assignmentBuilder_ == null) {
          result.assignment_ = assignment_;
        } else {
          result.assignment_ = assignmentBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000100) == 0x00000100)) {
          to_bitField0_ |= 0x00000100;
        }
        if (foremanBuilder_ == null) {
          result.foreman_ = foreman_;
        } else {
          result.foreman_ = foremanBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000200) == 0x00000200)) {
          to_bitField0_ |= 0x00000200;
        }
        result.memInitial_ = memInitial_;
        if (((from_bitField0_ & 0x00000400) == 0x00000400)) {
          to_bitField0_ |= 0x00000400;
        }
        result.memMax_ = memMax_;
        if (((from_bitField0_ & 0x00000800) == 0x00000800)) {
          to_bitField0_ |= 0x00000800;
        }
        if (credentialsBuilder_ == null) {
          result.credentials_ = credentials_;
        } else {
          result.credentials_ = credentialsBuilder_.build();
        }
        if (((from_bitField0_ & 0x00001000) == 0x00001000)) {
          to_bitField0_ |= 0x00001000;
        }
        result.optionsJson_ = optionsJson_;
        if (((from_bitField0_ & 0x00002000) == 0x00002000)) {
          to_bitField0_ |= 0x00002000;
        }
        if (contextBuilder_ == null) {
          result.context_ = context_;
        } else {
          result.context_ = contextBuilder_.build();
        }
        if (collectorBuilder_ == null) {
          if (((bitField0_ & 0x00004000) == 0x00004000)) {
            collector_ = java.util.Collections.unmodifiableList(collector_);
            bitField0_ = (bitField0_ & ~0x00004000);
          }
          result.collector_ = collector_;
        } else {
          result.collector_ = collectorBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.BitControl.PlanFragment) {
          return mergeFrom((org.apache.drill.exec.proto.BitControl.PlanFragment)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.BitControl.PlanFragment other) {
        if (other == org.apache.drill.exec.proto.BitControl.PlanFragment.getDefaultInstance()) return this;
        if (other.hasHandle()) {
          mergeHandle(other.getHandle());
        }
        if (other.hasNetworkCost()) {
          setNetworkCost(other.getNetworkCost());
        }
        if (other.hasCpuCost()) {
          setCpuCost(other.getCpuCost());
        }
        if (other.hasDiskCost()) {
          setDiskCost(other.getDiskCost());
        }
        if (other.hasMemoryCost()) {
          setMemoryCost(other.getMemoryCost());
        }
        if (other.hasFragmentJson()) {
          bitField0_ |= 0x00000020;
          fragmentJson_ = other.fragmentJson_;
          onChanged();
        }
        if (other.hasLeafFragment()) {
          setLeafFragment(other.getLeafFragment());
        }
        if (other.hasAssignment()) {
          mergeAssignment(other.getAssignment());
        }
        if (other.hasForeman()) {
          mergeForeman(other.getForeman());
        }
        if (other.hasMemInitial()) {
          setMemInitial(other.getMemInitial());
        }
        if (other.hasMemMax()) {
          setMemMax(other.getMemMax());
        }
        if (other.hasCredentials()) {
          mergeCredentials(other.getCredentials());
        }
        if (other.hasOptionsJson()) {
          bitField0_ |= 0x00001000;
          optionsJson_ = other.optionsJson_;
          onChanged();
        }
        if (other.hasContext()) {
          mergeContext(other.getContext());
        }
        if (collectorBuilder_ == null) {
          if (!other.collector_.isEmpty()) {
            if (collector_.isEmpty()) {
              collector_ = other.collector_;
              bitField0_ = (bitField0_ & ~0x00004000);
            } else {
              ensureCollectorIsMutable();
              collector_.addAll(other.collector_);
            }
            onChanged();
          }
        } else {
          if (!other.collector_.isEmpty()) {
            if (collectorBuilder_.isEmpty()) {
              collectorBuilder_.dispose();
              collectorBuilder_ = null;
              collector_ = other.collector_;
              bitField0_ = (bitField0_ & ~0x00004000);
              collectorBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getCollectorFieldBuilder() : null;
            } else {
              collectorBuilder_.addAllMessages(other.collector_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.BitControl.PlanFragment parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.BitControl.PlanFragment) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // optional .exec.bit.FragmentHandle handle = 1;
      private org.apache.drill.exec.proto.ExecProtos.FragmentHandle handle_ = org.apache.drill.exec.proto.ExecProtos.FragmentHandle.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.ExecProtos.FragmentHandle, org.apache.drill.exec.proto.ExecProtos.FragmentHandle.Builder, org.apache.drill.exec.proto.ExecProtos.FragmentHandleOrBuilder> handleBuilder_;
      /**
       * <code>optional .exec.bit.FragmentHandle handle = 1;</code>
       */
      public boolean hasHandle() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional .exec.bit.FragmentHandle handle = 1;</code>
       */
      public org.apache.drill.exec.proto.ExecProtos.FragmentHandle getHandle() {
        if (handleBuilder_ == null) {
          return handle_;
        } else {
          return handleBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.bit.FragmentHandle handle = 1;</code>
       */
      public Builder setHandle(org.apache.drill.exec.proto.ExecProtos.FragmentHandle value) {
        if (handleBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          handle_ = value;
          onChanged();
        } else {
          handleBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.bit.FragmentHandle handle = 1;</code>
       */
      public Builder setHandle(
          org.apache.drill.exec.proto.ExecProtos.FragmentHandle.Builder builderForValue) {
        if (handleBuilder_ == null) {
          handle_ = builderForValue.build();
          onChanged();
        } else {
          handleBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.bit.FragmentHandle handle = 1;</code>
       */
      public Builder mergeHandle(org.apache.drill.exec.proto.ExecProtos.FragmentHandle value) {
        if (handleBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001) &&
              handle_ != org.apache.drill.exec.proto.ExecProtos.FragmentHandle.getDefaultInstance()) {
            handle_ =
              org.apache.drill.exec.proto.ExecProtos.FragmentHandle.newBuilder(handle_).mergeFrom(value).buildPartial();
          } else {
            handle_ = value;
          }
          onChanged();
        } else {
          handleBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.bit.FragmentHandle handle = 1;</code>
       */
      public Builder clearHandle() {
        if (handleBuilder_ == null) {
          handle_ = org.apache.drill.exec.proto.ExecProtos.FragmentHandle.getDefaultInstance();
          onChanged();
        } else {
          handleBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       * <code>optional .exec.bit.FragmentHandle handle = 1;</code>
       */
      public org.apache.drill.exec.proto.ExecProtos.FragmentHandle.Builder getHandleBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getHandleFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.bit.FragmentHandle handle = 1;</code>
       */
      public org.apache.drill.exec.proto.ExecProtos.FragmentHandleOrBuilder getHandleOrBuilder() {
        if (handleBuilder_ != null) {
          return handleBuilder_.getMessageOrBuilder();
        } else {
          return handle_;
        }
      }
      /**
       * <code>optional .exec.bit.FragmentHandle handle = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.ExecProtos.FragmentHandle, org.apache.drill.exec.proto.ExecProtos.FragmentHandle.Builder, org.apache.drill.exec.proto.ExecProtos.FragmentHandleOrBuilder> 
          getHandleFieldBuilder() {
        if (handleBuilder_ == null) {
          handleBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.drill.exec.proto.ExecProtos.FragmentHandle, org.apache.drill.exec.proto.ExecProtos.FragmentHandle.Builder, org.apache.drill.exec.proto.ExecProtos.FragmentHandleOrBuilder>(
                  handle_,
                  getParentForChildren(),
                  isClean());
          handle_ = null;
        }
        return handleBuilder_;
      }

      // optional float network_cost = 4;
      private float networkCost_ ;
      /**
       * <code>optional float network_cost = 4;</code>
       */
      public boolean hasNetworkCost() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional float network_cost = 4;</code>
       */
      public float getNetworkCost() {
        return networkCost_;
      }
      /**
       * <code>optional float network_cost = 4;</code>
       */
      public Builder setNetworkCost(float value) {
        bitField0_ |= 0x00000002;
        networkCost_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional float network_cost = 4;</code>
       */
      public Builder clearNetworkCost() {
        bitField0_ = (bitField0_ & ~0x00000002);
        networkCost_ = 0F;
        onChanged();
        return this;
      }

      // optional float cpu_cost = 5;
      private float cpuCost_ ;
      /**
       * <code>optional float cpu_cost = 5;</code>
       */
      public boolean hasCpuCost() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional float cpu_cost = 5;</code>
       */
      public float getCpuCost() {
        return cpuCost_;
      }
      /**
       * <code>optional float cpu_cost = 5;</code>
       */
      public Builder setCpuCost(float value) {
        bitField0_ |= 0x00000004;
        cpuCost_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional float cpu_cost = 5;</code>
       */
      public Builder clearCpuCost() {
        bitField0_ = (bitField0_ & ~0x00000004);
        cpuCost_ = 0F;
        onChanged();
        return this;
      }

      // optional float disk_cost = 6;
      private float diskCost_ ;
      /**
       * <code>optional float disk_cost = 6;</code>
       */
      public boolean hasDiskCost() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional float disk_cost = 6;</code>
       */
      public float getDiskCost() {
        return diskCost_;
      }
      /**
       * <code>optional float disk_cost = 6;</code>
       */
      public Builder setDiskCost(float value) {
        bitField0_ |= 0x00000008;
        diskCost_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional float disk_cost = 6;</code>
       */
      public Builder clearDiskCost() {
        bitField0_ = (bitField0_ & ~0x00000008);
        diskCost_ = 0F;
        onChanged();
        return this;
      }

      // optional float memory_cost = 7;
      private float memoryCost_ ;
      /**
       * <code>optional float memory_cost = 7;</code>
       */
      public boolean hasMemoryCost() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       * <code>optional float memory_cost = 7;</code>
       */
      public float getMemoryCost() {
        return memoryCost_;
      }
      /**
       * <code>optional float memory_cost = 7;</code>
       */
      public Builder setMemoryCost(float value) {
        bitField0_ |= 0x00000010;
        memoryCost_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional float memory_cost = 7;</code>
       */
      public Builder clearMemoryCost() {
        bitField0_ = (bitField0_ & ~0x00000010);
        memoryCost_ = 0F;
        onChanged();
        return this;
      }

      // optional string fragment_json = 8;
      private java.lang.Object fragmentJson_ = "";
      /**
       * <code>optional string fragment_json = 8;</code>
       */
      public boolean hasFragmentJson() {
        return ((bitField0_ & 0x00000020) == 0x00000020);
      }
      /**
       * <code>optional string fragment_json = 8;</code>
       */
      public java.lang.String getFragmentJson() {
        java.lang.Object ref = fragmentJson_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          fragmentJson_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string fragment_json = 8;</code>
       */
      public com.google.protobuf.ByteString
          getFragmentJsonBytes() {
        java.lang.Object ref = fragmentJson_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          fragmentJson_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string fragment_json = 8;</code>
       */
      public Builder setFragmentJson(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000020;
        fragmentJson_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string fragment_json = 8;</code>
       */
      public Builder clearFragmentJson() {
        bitField0_ = (bitField0_ & ~0x00000020);
        fragmentJson_ = getDefaultInstance().getFragmentJson();
        onChanged();
        return this;
      }
      /**
       * <code>optional string fragment_json = 8;</code>
       */
      public Builder setFragmentJsonBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000020;
        fragmentJson_ = value;
        onChanged();
        return this;
      }

      // optional bool leaf_fragment = 9;
      private boolean leafFragment_ ;
      /**
       * <code>optional bool leaf_fragment = 9;</code>
       */
      public boolean hasLeafFragment() {
        return ((bitField0_ & 0x00000040) == 0x00000040);
      }
      /**
       * <code>optional bool leaf_fragment = 9;</code>
       */
      public boolean getLeafFragment() {
        return leafFragment_;
      }
      /**
       * <code>optional bool leaf_fragment = 9;</code>
       */
      public Builder setLeafFragment(boolean value) {
        bitField0_ |= 0x00000040;
        leafFragment_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool leaf_fragment = 9;</code>
       */
      public Builder clearLeafFragment() {
        bitField0_ = (bitField0_ & ~0x00000040);
        leafFragment_ = false;
        onChanged();
        return this;
      }

      // optional .exec.DrillbitEndpoint assignment = 10;
      private org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint assignment_ = org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint, org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.Builder, org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpointOrBuilder> assignmentBuilder_;
      /**
       * <code>optional .exec.DrillbitEndpoint assignment = 10;</code>
       */
      public boolean hasAssignment() {
        return ((bitField0_ & 0x00000080) == 0x00000080);
      }
      /**
       * <code>optional .exec.DrillbitEndpoint assignment = 10;</code>
       */
      public org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint getAssignment() {
        if (assignmentBuilder_ == null) {
          return assignment_;
        } else {
          return assignmentBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.DrillbitEndpoint assignment = 10;</code>
       */
      public Builder setAssignment(org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint value) {
        if (assignmentBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          assignment_ = value;
          onChanged();
        } else {
          assignmentBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000080;
        return this;
      }
      /**
       * <code>optional .exec.DrillbitEndpoint assignment = 10;</code>
       */
      public Builder setAssignment(
          org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.Builder builderForValue) {
        if (assignmentBuilder_ == null) {
          assignment_ = builderForValue.build();
          onChanged();
        } else {
          assignmentBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000080;
        return this;
      }
      /**
       * <code>optional .exec.DrillbitEndpoint assignment = 10;</code>
       */
      public Builder mergeAssignment(org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint value) {
        if (assignmentBuilder_ == null) {
          if (((bitField0_ & 0x00000080) == 0x00000080) &&
              assignment_ != org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.getDefaultInstance()) {
            assignment_ =
              org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.newBuilder(assignment_).mergeFrom(value).buildPartial();
          } else {
            assignment_ = value;
          }
          onChanged();
        } else {
          assignmentBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000080;
        return this;
      }
      /**
       * <code>optional .exec.DrillbitEndpoint assignment = 10;</code>
       */
      public Builder clearAssignment() {
        if (assignmentBuilder_ == null) {
          assignment_ = org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.getDefaultInstance();
          onChanged();
        } else {
          assignmentBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000080);
        return this;
      }
      /**
       * <code>optional .exec.DrillbitEndpoint assignment = 10;</code>
       */
      public org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.Builder getAssignmentBuilder() {
        bitField0_ |= 0x00000080;
        onChanged();
        return getAssignmentFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.DrillbitEndpoint assignment = 10;</code>
       */
      public org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpointOrBuilder getAssignmentOrBuilder() {
        if (assignmentBuilder_ != null) {
          return assignmentBuilder_.getMessageOrBuilder();
        } else {
          return assignment_;
        }
      }
      /**
       * <code>optional .exec.DrillbitEndpoint assignment = 10;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint, org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.Builder, org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpointOrBuilder> 
          getAssignmentFieldBuilder() {
        if (assignmentBuilder_ == null) {
          assignmentBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint, org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.Builder, org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpointOrBuilder>(
                  assignment_,
                  getParentForChildren(),
                  isClean());
          assignment_ = null;
        }
        return assignmentBuilder_;
      }

      // optional .exec.DrillbitEndpoint foreman = 11;
      private org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint foreman_ = org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint, org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.Builder, org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpointOrBuilder> foremanBuilder_;
      /**
       * <code>optional .exec.DrillbitEndpoint foreman = 11;</code>
       */
      public boolean hasForeman() {
        return ((bitField0_ & 0x00000100) == 0x00000100);
      }
      /**
       * <code>optional .exec.DrillbitEndpoint foreman = 11;</code>
       */
      public org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint getForeman() {
        if (foremanBuilder_ == null) {
          return foreman_;
        } else {
          return foremanBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.DrillbitEndpoint foreman = 11;</code>
       */
      public Builder setForeman(org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint value) {
        if (foremanBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          foreman_ = value;
          onChanged();
        } else {
          foremanBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000100;
        return this;
      }
      /**
       * <code>optional .exec.DrillbitEndpoint foreman = 11;</code>
       */
      public Builder setForeman(
          org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.Builder builderForValue) {
        if (foremanBuilder_ == null) {
          foreman_ = builderForValue.build();
          onChanged();
        } else {
          foremanBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000100;
        return this;
      }
      /**
       * <code>optional .exec.DrillbitEndpoint foreman = 11;</code>
       */
      public Builder mergeForeman(org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint value) {
        if (foremanBuilder_ == null) {
          if (((bitField0_ & 0x00000100) == 0x00000100) &&
              foreman_ != org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.getDefaultInstance()) {
            foreman_ =
              org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.newBuilder(foreman_).mergeFrom(value).buildPartial();
          } else {
            foreman_ = value;
          }
          onChanged();
        } else {
          foremanBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000100;
        return this;
      }
      /**
       * <code>optional .exec.DrillbitEndpoint foreman = 11;</code>
       */
      public Builder clearForeman() {
        if (foremanBuilder_ == null) {
          foreman_ = org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.getDefaultInstance();
          onChanged();
        } else {
          foremanBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000100);
        return this;
      }
      /**
       * <code>optional .exec.DrillbitEndpoint foreman = 11;</code>
       */
      public org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.Builder getForemanBuilder() {
        bitField0_ |= 0x00000100;
        onChanged();
        return getForemanFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.DrillbitEndpoint foreman = 11;</code>
       */
      public org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpointOrBuilder getForemanOrBuilder() {
        if (foremanBuilder_ != null) {
          return foremanBuilder_.getMessageOrBuilder();
        } else {
          return foreman_;
        }
      }
      /**
       * <code>optional .exec.DrillbitEndpoint foreman = 11;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint, org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.Builder, org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpointOrBuilder> 
          getForemanFieldBuilder() {
        if (foremanBuilder_ == null) {
          foremanBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint, org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.Builder, org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpointOrBuilder>(
                  foreman_,
                  getParentForChildren(),
                  isClean());
          foreman_ = null;
        }
        return foremanBuilder_;
      }

      // optional int64 mem_initial = 12 [default = 20000000];
      private long memInitial_ = 20000000L;
      /**
       * <code>optional int64 mem_initial = 12 [default = 20000000];</code>
       *
       * <pre>
       * 20 megs
       * </pre>
       */
      public boolean hasMemInitial() {
        return ((bitField0_ & 0x00000200) == 0x00000200);
      }
      /**
       * <code>optional int64 mem_initial = 12 [default = 20000000];</code>
       *
       * <pre>
       * 20 megs
       * </pre>
       */
      public long getMemInitial() {
        return memInitial_;
      }
      /**
       * <code>optional int64 mem_initial = 12 [default = 20000000];</code>
       *
       * <pre>
       * 20 megs
       * </pre>
       */
      public Builder setMemInitial(long value) {
        bitField0_ |= 0x00000200;
        memInitial_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int64 mem_initial = 12 [default = 20000000];</code>
       *
       * <pre>
       * 20 megs
       * </pre>
       */
      public Builder clearMemInitial() {
        bitField0_ = (bitField0_ & ~0x00000200);
        memInitial_ = 20000000L;
        onChanged();
        return this;
      }

      // optional int64 mem_max = 13 [default = 2000000000];
      private long memMax_ = 2000000000L;
      /**
       * <code>optional int64 mem_max = 13 [default = 2000000000];</code>
       *
       * <pre>
       * 20 gigs
       * </pre>
       */
      public boolean hasMemMax() {
        return ((bitField0_ & 0x00000400) == 0x00000400);
      }
      /**
       * <code>optional int64 mem_max = 13 [default = 2000000000];</code>
       *
       * <pre>
       * 20 gigs
       * </pre>
       */
      public long getMemMax() {
        return memMax_;
      }
      /**
       * <code>optional int64 mem_max = 13 [default = 2000000000];</code>
       *
       * <pre>
       * 20 gigs
       * </pre>
       */
      public Builder setMemMax(long value) {
        bitField0_ |= 0x00000400;
        memMax_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int64 mem_max = 13 [default = 2000000000];</code>
       *
       * <pre>
       * 20 gigs
       * </pre>
       */
      public Builder clearMemMax() {
        bitField0_ = (bitField0_ & ~0x00000400);
        memMax_ = 2000000000L;
        onChanged();
        return this;
      }

      // optional .exec.shared.UserCredentials credentials = 14;
      private org.apache.drill.exec.proto.UserBitShared.UserCredentials credentials_ = org.apache.drill.exec.proto.UserBitShared.UserCredentials.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserBitShared.UserCredentials, org.apache.drill.exec.proto.UserBitShared.UserCredentials.Builder, org.apache.drill.exec.proto.UserBitShared.UserCredentialsOrBuilder> credentialsBuilder_;
      /**
       * <code>optional .exec.shared.UserCredentials credentials = 14;</code>
       */
      public boolean hasCredentials() {
        return ((bitField0_ & 0x00000800) == 0x00000800);
      }
      /**
       * <code>optional .exec.shared.UserCredentials credentials = 14;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.UserCredentials getCredentials() {
        if (credentialsBuilder_ == null) {
          return credentials_;
        } else {
          return credentialsBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.shared.UserCredentials credentials = 14;</code>
       */
      public Builder setCredentials(org.apache.drill.exec.proto.UserBitShared.UserCredentials value) {
        if (credentialsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          credentials_ = value;
          onChanged();
        } else {
          credentialsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000800;
        return this;
      }
      /**
       * <code>optional .exec.shared.UserCredentials credentials = 14;</code>
       */
      public Builder setCredentials(
          org.apache.drill.exec.proto.UserBitShared.UserCredentials.Builder builderForValue) {
        if (credentialsBuilder_ == null) {
          credentials_ = builderForValue.build();
          onChanged();
        } else {
          credentialsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000800;
        return this;
      }
      /**
       * <code>optional .exec.shared.UserCredentials credentials = 14;</code>
       */
      public Builder mergeCredentials(org.apache.drill.exec.proto.UserBitShared.UserCredentials value) {
        if (credentialsBuilder_ == null) {
          if (((bitField0_ & 0x00000800) == 0x00000800) &&
              credentials_ != org.apache.drill.exec.proto.UserBitShared.UserCredentials.getDefaultInstance()) {
            credentials_ =
              org.apache.drill.exec.proto.UserBitShared.UserCredentials.newBuilder(credentials_).mergeFrom(value).buildPartial();
          } else {
            credentials_ = value;
          }
          onChanged();
        } else {
          credentialsBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000800;
        return this;
      }
      /**
       * <code>optional .exec.shared.UserCredentials credentials = 14;</code>
       */
      public Builder clearCredentials() {
        if (credentialsBuilder_ == null) {
          credentials_ = org.apache.drill.exec.proto.UserBitShared.UserCredentials.getDefaultInstance();
          onChanged();
        } else {
          credentialsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000800);
        return this;
      }
      /**
       * <code>optional .exec.shared.UserCredentials credentials = 14;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.UserCredentials.Builder getCredentialsBuilder() {
        bitField0_ |= 0x00000800;
        onChanged();
        return getCredentialsFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.shared.UserCredentials credentials = 14;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.UserCredentialsOrBuilder getCredentialsOrBuilder() {
        if (credentialsBuilder_ != null) {
          return credentialsBuilder_.getMessageOrBuilder();
        } else {
          return credentials_;
        }
      }
      /**
       * <code>optional .exec.shared.UserCredentials credentials = 14;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserBitShared.UserCredentials, org.apache.drill.exec.proto.UserBitShared.UserCredentials.Builder, org.apache.drill.exec.proto.UserBitShared.UserCredentialsOrBuilder> 
          getCredentialsFieldBuilder() {
        if (credentialsBuilder_ == null) {
          credentialsBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.drill.exec.proto.UserBitShared.UserCredentials, org.apache.drill.exec.proto.UserBitShared.UserCredentials.Builder, org.apache.drill.exec.proto.UserBitShared.UserCredentialsOrBuilder>(
                  credentials_,
                  getParentForChildren(),
                  isClean());
          credentials_ = null;
        }
        return credentialsBuilder_;
      }

      // optional string options_json = 15;
      private java.lang.Object optionsJson_ = "";
      /**
       * <code>optional string options_json = 15;</code>
       */
      public boolean hasOptionsJson() {
        return ((bitField0_ & 0x00001000) == 0x00001000);
      }
      /**
       * <code>optional string options_json = 15;</code>
       */
      public java.lang.String getOptionsJson() {
        java.lang.Object ref = optionsJson_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          optionsJson_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string options_json = 15;</code>
       */
      public com.google.protobuf.ByteString
          getOptionsJsonBytes() {
        java.lang.Object ref = optionsJson_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          optionsJson_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string options_json = 15;</code>
       */
      public Builder setOptionsJson(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00001000;
        optionsJson_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string options_json = 15;</code>
       */
      public Builder clearOptionsJson() {
        bitField0_ = (bitField0_ & ~0x00001000);
        optionsJson_ = getDefaultInstance().getOptionsJson();
        onChanged();
        return this;
      }
      /**
       * <code>optional string options_json = 15;</code>
       */
      public Builder setOptionsJsonBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00001000;
        optionsJson_ = value;
        onChanged();
        return this;
      }

      // optional .exec.bit.control.QueryContextInformation context = 16;
      private org.apache.drill.exec.proto.BitControl.QueryContextInformation context_ = org.apache.drill.exec.proto.BitControl.QueryContextInformation.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.BitControl.QueryContextInformation, org.apache.drill.exec.proto.BitControl.QueryContextInformation.Builder, org.apache.drill.exec.proto.BitControl.QueryContextInformationOrBuilder> contextBuilder_;
      /**
       * <code>optional .exec.bit.control.QueryContextInformation context = 16;</code>
       */
      public boolean hasContext() {
        return ((bitField0_ & 0x00002000) == 0x00002000);
      }
      /**
       * <code>optional .exec.bit.control.QueryContextInformation context = 16;</code>
       */
      public org.apache.drill.exec.proto.BitControl.QueryContextInformation getContext() {
        if (contextBuilder_ == null) {
          return context_;
        } else {
          return contextBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.bit.control.QueryContextInformation context = 16;</code>
       */
      public Builder setContext(org.apache.drill.exec.proto.BitControl.QueryContextInformation value) {
        if (contextBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          context_ = value;
          onChanged();
        } else {
          contextBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00002000;
        return this;
      }
      /**
       * <code>optional .exec.bit.control.QueryContextInformation context = 16;</code>
       */
      public Builder setContext(
          org.apache.drill.exec.proto.BitControl.QueryContextInformation.Builder builderForValue) {
        if (contextBuilder_ == null) {
          context_ = builderForValue.build();
          onChanged();
        } else {
          contextBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00002000;
        return this;
      }
      /**
       * <code>optional .exec.bit.control.QueryContextInformation context = 16;</code>
       */
      public Builder mergeContext(org.apache.drill.exec.proto.BitControl.QueryContextInformation value) {
        if (contextBuilder_ == null) {
          if (((bitField0_ & 0x00002000) == 0x00002000) &&
              context_ != org.apache.drill.exec.proto.BitControl.QueryContextInformation.getDefaultInstance()) {
            context_ =
              org.apache.drill.exec.proto.BitControl.QueryContextInformation.newBuilder(context_).mergeFrom(value).buildPartial();
          } else {
            context_ = value;
          }
          onChanged();
        } else {
          contextBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00002000;
        return this;
      }
      /**
       * <code>optional .exec.bit.control.QueryContextInformation context = 16;</code>
       */
      public Builder clearContext() {
        if (contextBuilder_ == null) {
          context_ = org.apache.drill.exec.proto.BitControl.QueryContextInformation.getDefaultInstance();
          onChanged();
        } else {
          contextBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00002000);
        return this;
      }
      /**
       * <code>optional .exec.bit.control.QueryContextInformation context = 16;</code>
       */
      public org.apache.drill.exec.proto.BitControl.QueryContextInformation.Builder getContextBuilder() {
        bitField0_ |= 0x00002000;
        onChanged();
        return getContextFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.bit.control.QueryContextInformation context = 16;</code>
       */
      public org.apache.drill.exec.proto.BitControl.QueryContextInformationOrBuilder getContextOrBuilder() {
        if (contextBuilder_ != null) {
          return contextBuilder_.getMessageOrBuilder();
        } else {
          return context_;
        }
      }
      /**
       * <code>optional .exec.bit.control.QueryContextInformation context = 16;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.BitControl.QueryContextInformation, org.apache.drill.exec.proto.BitControl.QueryContextInformation.Builder, org.apache.drill.exec.proto.BitControl.QueryContextInformationOrBuilder> 
          getContextFieldBuilder() {
        if (contextBuilder_ == null) {
          contextBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.drill.exec.proto.BitControl.QueryContextInformation, org.apache.drill.exec.proto.BitControl.QueryContextInformation.Builder, org.apache.drill.exec.proto.BitControl.QueryContextInformationOrBuilder>(
                  context_,
                  getParentForChildren(),
                  isClean());
          context_ = null;
        }
        return contextBuilder_;
      }

      // repeated .exec.bit.control.Collector collector = 17;
      private java.util.List<org.apache.drill.exec.proto.BitControl.Collector> collector_ =
        java.util.Collections.emptyList();
      private void ensureCollectorIsMutable() {
        if (!((bitField0_ & 0x00004000) == 0x00004000)) {
          collector_ = new java.util.ArrayList<org.apache.drill.exec.proto.BitControl.Collector>(collector_);
          bitField0_ |= 0x00004000;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          org.apache.drill.exec.proto.BitControl.Collector, org.apache.drill.exec.proto.BitControl.Collector.Builder, org.apache.drill.exec.proto.BitControl.CollectorOrBuilder> collectorBuilder_;

      /**
       * <code>repeated .exec.bit.control.Collector collector = 17;</code>
       */
      public java.util.List<org.apache.drill.exec.proto.BitControl.Collector> getCollectorList() {
        if (collectorBuilder_ == null) {
          return java.util.Collections.unmodifiableList(collector_);
        } else {
          return collectorBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .exec.bit.control.Collector collector = 17;</code>
       */
      public int getCollectorCount() {
        if (collectorBuilder_ == null) {
          return collector_.size();
        } else {
          return collectorBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .exec.bit.control.Collector collector = 17;</code>
       */
      public org.apache.drill.exec.proto.BitControl.Collector getCollector(int index) {
        if (collectorBuilder_ == null) {
          return collector_.get(index);
        } else {
          return collectorBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .exec.bit.control.Collector collector = 17;</code>
       */
      public Builder setCollector(
          int index, org.apache.drill.exec.proto.BitControl.Collector value) {
        if (collectorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCollectorIsMutable();
          collector_.set(index, value);
          onChanged();
        } else {
          collectorBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.Collector collector = 17;</code>
       */
      public Builder setCollector(
          int index, org.apache.drill.exec.proto.BitControl.Collector.Builder builderForValue) {
        if (collectorBuilder_ == null) {
          ensureCollectorIsMutable();
          collector_.set(index, builderForValue.build());
          onChanged();
        } else {
          collectorBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.Collector collector = 17;</code>
       */
      public Builder addCollector(org.apache.drill.exec.proto.BitControl.Collector value) {
        if (collectorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCollectorIsMutable();
          collector_.add(value);
          onChanged();
        } else {
          collectorBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.Collector collector = 17;</code>
       */
      public Builder addCollector(
          int index, org.apache.drill.exec.proto.BitControl.Collector value) {
        if (collectorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCollectorIsMutable();
          collector_.add(index, value);
          onChanged();
        } else {
          collectorBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.Collector collector = 17;</code>
       */
      public Builder addCollector(
          org.apache.drill.exec.proto.BitControl.Collector.Builder builderForValue) {
        if (collectorBuilder_ == null) {
          ensureCollectorIsMutable();
          collector_.add(builderForValue.build());
          onChanged();
        } else {
          collectorBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.Collector collector = 17;</code>
       */
      public Builder addCollector(
          int index, org.apache.drill.exec.proto.BitControl.Collector.Builder builderForValue) {
        if (collectorBuilder_ == null) {
          ensureCollectorIsMutable();
          collector_.add(index, builderForValue.build());
          onChanged();
        } else {
          collectorBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.Collector collector = 17;</code>
       */
      public Builder addAllCollector(
          java.lang.Iterable<? extends org.apache.drill.exec.proto.BitControl.Collector> values) {
        if (collectorBuilder_ == null) {
          ensureCollectorIsMutable();
          super.addAll(values, collector_);
          onChanged();
        } else {
          collectorBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.Collector collector = 17;</code>
       */
      public Builder clearCollector() {
        if (collectorBuilder_ == null) {
          collector_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00004000);
          onChanged();
        } else {
          collectorBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.Collector collector = 17;</code>
       */
      public Builder removeCollector(int index) {
        if (collectorBuilder_ == null) {
          ensureCollectorIsMutable();
          collector_.remove(index);
          onChanged();
        } else {
          collectorBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .exec.bit.control.Collector collector = 17;</code>
       */
      public org.apache.drill.exec.proto.BitControl.Collector.Builder getCollectorBuilder(
          int index) {
        return getCollectorFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .exec.bit.control.Collector collector = 17;</code>
       */
      public org.apache.drill.exec.proto.BitControl.CollectorOrBuilder getCollectorOrBuilder(
          int index) {
        if (collectorBuilder_ == null) {
          return collector_.get(index);  } else {
          return collectorBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .exec.bit.control.Collector collector = 17;</code>
       */
      public java.util.List<? extends org.apache.drill.exec.proto.BitControl.CollectorOrBuilder> 
           getCollectorOrBuilderList() {
        if (collectorBuilder_ != null) {
          return collectorBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(collector_);
        }
      }
      /**
       * <code>repeated .exec.bit.control.Collector collector = 17;</code>
       */
      public org.apache.drill.exec.proto.BitControl.Collector.Builder addCollectorBuilder() {
        return getCollectorFieldBuilder().addBuilder(
            org.apache.drill.exec.proto.BitControl.Collector.getDefaultInstance());
      }
      /**
       * <code>repeated .exec.bit.control.Collector collector = 17;</code>
       */
      public org.apache.drill.exec.proto.BitControl.Collector.Builder addCollectorBuilder(
          int index) {
        return getCollectorFieldBuilder().addBuilder(
            index, org.apache.drill.exec.proto.BitControl.Collector.getDefaultInstance());
      }
      /**
       * <code>repeated .exec.bit.control.Collector collector = 17;</code>
       */
      public java.util.List<org.apache.drill.exec.proto.BitControl.Collector.Builder> 
           getCollectorBuilderList() {
        return getCollectorFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          org.apache.drill.exec.proto.BitControl.Collector, org.apache.drill.exec.proto.BitControl.Collector.Builder, org.apache.drill.exec.proto.BitControl.CollectorOrBuilder> 
          getCollectorFieldBuilder() {
        if (collectorBuilder_ == null) {
          collectorBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              org.apache.drill.exec.proto.BitControl.Collector, org.apache.drill.exec.proto.BitControl.Collector.Builder, org.apache.drill.exec.proto.BitControl.CollectorOrBuilder>(
                  collector_,
                  ((bitField0_ & 0x00004000) == 0x00004000),
                  getParentForChildren(),
                  isClean());
          collector_ = null;
        }
        return collectorBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:exec.bit.control.PlanFragment)
    }

    static {
      defaultInstance = new PlanFragment(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.bit.control.PlanFragment)
  }

  public interface CollectorOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // optional int32 opposite_major_fragment_id = 1;
    /**
     * <code>optional int32 opposite_major_fragment_id = 1;</code>
     */
    boolean hasOppositeMajorFragmentId();
    /**
     * <code>optional int32 opposite_major_fragment_id = 1;</code>
     */
    int getOppositeMajorFragmentId();

    // repeated int32 incoming_minor_fragment = 2 [packed = true];
    /**
     * <code>repeated int32 incoming_minor_fragment = 2 [packed = true];</code>
     */
    java.util.List<java.lang.Integer> getIncomingMinorFragmentList();
    /**
     * <code>repeated int32 incoming_minor_fragment = 2 [packed = true];</code>
     */
    int getIncomingMinorFragmentCount();
    /**
     * <code>repeated int32 incoming_minor_fragment = 2 [packed = true];</code>
     */
    int getIncomingMinorFragment(int index);

    // optional bool supports_out_of_order = 3;
    /**
     * <code>optional bool supports_out_of_order = 3;</code>
     */
    boolean hasSupportsOutOfOrder();
    /**
     * <code>optional bool supports_out_of_order = 3;</code>
     */
    boolean getSupportsOutOfOrder();

    // optional bool is_spooling = 4;
    /**
     * <code>optional bool is_spooling = 4;</code>
     */
    boolean hasIsSpooling();
    /**
     * <code>optional bool is_spooling = 4;</code>
     */
    boolean getIsSpooling();
  }
  /**
   * Protobuf type {@code exec.bit.control.Collector}
   */
  public static final class Collector extends
      com.google.protobuf.GeneratedMessage
      implements CollectorOrBuilder {
    // Use Collector.newBuilder() to construct.
    private Collector(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private Collector(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final Collector defaultInstance;
    public static Collector getDefaultInstance() {
      return defaultInstance;
    }

    public Collector getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private Collector(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              bitField0_ |= 0x00000001;
              oppositeMajorFragmentId_ = input.readInt32();
              break;
            }
            case 16: {
              if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
                incomingMinorFragment_ = new java.util.ArrayList<java.lang.Integer>();
                mutable_bitField0_ |= 0x00000002;
              }
              incomingMinorFragment_.add(input.readInt32());
              break;
            }
            case 18: {
              int length = input.readRawVarint32();
              int limit = input.pushLimit(length);
              if (!((mutable_bitField0_ & 0x00000002) == 0x00000002) && input.getBytesUntilLimit() > 0) {
                incomingMinorFragment_ = new java.util.ArrayList<java.lang.Integer>();
                mutable_bitField0_ |= 0x00000002;
              }
              while (input.getBytesUntilLimit() > 0) {
                incomingMinorFragment_.add(input.readInt32());
              }
              input.popLimit(limit);
              break;
            }
            case 24: {
              bitField0_ |= 0x00000002;
              supportsOutOfOrder_ = input.readBool();
              break;
            }
            case 32: {
              bitField0_ |= 0x00000004;
              isSpooling_ = input.readBool();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
          incomingMinorFragment_ = java.util.Collections.unmodifiableList(incomingMinorFragment_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_Collector_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_Collector_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.BitControl.Collector.class, org.apache.drill.exec.proto.BitControl.Collector.Builder.class);
    }

    public static com.google.protobuf.Parser<Collector> PARSER =
        new com.google.protobuf.AbstractParser<Collector>() {
      public Collector parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Collector(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<Collector> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // optional int32 opposite_major_fragment_id = 1;
    public static final int OPPOSITE_MAJOR_FRAGMENT_ID_FIELD_NUMBER = 1;
    private int oppositeMajorFragmentId_;
    /**
     * <code>optional int32 opposite_major_fragment_id = 1;</code>
     */
    public boolean hasOppositeMajorFragmentId() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional int32 opposite_major_fragment_id = 1;</code>
     */
    public int getOppositeMajorFragmentId() {
      return oppositeMajorFragmentId_;
    }

    // repeated int32 incoming_minor_fragment = 2 [packed = true];
    public static final int INCOMING_MINOR_FRAGMENT_FIELD_NUMBER = 2;
    private java.util.List<java.lang.Integer> incomingMinorFragment_;
    /**
     * <code>repeated int32 incoming_minor_fragment = 2 [packed = true];</code>
     */
    public java.util.List<java.lang.Integer>
        getIncomingMinorFragmentList() {
      return incomingMinorFragment_;
    }
    /**
     * <code>repeated int32 incoming_minor_fragment = 2 [packed = true];</code>
     */
    public int getIncomingMinorFragmentCount() {
      return incomingMinorFragment_.size();
    }
    /**
     * <code>repeated int32 incoming_minor_fragment = 2 [packed = true];</code>
     */
    public int getIncomingMinorFragment(int index) {
      return incomingMinorFragment_.get(index);
    }
    private int incomingMinorFragmentMemoizedSerializedSize = -1;

    // optional bool supports_out_of_order = 3;
    public static final int SUPPORTS_OUT_OF_ORDER_FIELD_NUMBER = 3;
    private boolean supportsOutOfOrder_;
    /**
     * <code>optional bool supports_out_of_order = 3;</code>
     */
    public boolean hasSupportsOutOfOrder() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional bool supports_out_of_order = 3;</code>
     */
    public boolean getSupportsOutOfOrder() {
      return supportsOutOfOrder_;
    }

    // optional bool is_spooling = 4;
    public static final int IS_SPOOLING_FIELD_NUMBER = 4;
    private boolean isSpooling_;
    /**
     * <code>optional bool is_spooling = 4;</code>
     */
    public boolean hasIsSpooling() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional bool is_spooling = 4;</code>
     */
    public boolean getIsSpooling() {
      return isSpooling_;
    }

    private void initFields() {
      oppositeMajorFragmentId_ = 0;
      incomingMinorFragment_ = java.util.Collections.emptyList();
      supportsOutOfOrder_ = false;
      isSpooling_ = false;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeInt32(1, oppositeMajorFragmentId_);
      }
      if (getIncomingMinorFragmentList().size() > 0) {
        output.writeRawVarint32(18);
        output.writeRawVarint32(incomingMinorFragmentMemoizedSerializedSize);
      }
      for (int i = 0; i < incomingMinorFragment_.size(); i++) {
        output.writeInt32NoTag(incomingMinorFragment_.get(i));
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeBool(3, supportsOutOfOrder_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeBool(4, isSpooling_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(1, oppositeMajorFragmentId_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < incomingMinorFragment_.size(); i++) {
          dataSize += com.google.protobuf.CodedOutputStream
            .computeInt32SizeNoTag(incomingMinorFragment_.get(i));
        }
        size += dataSize;
        if (!getIncomingMinorFragmentList().isEmpty()) {
          size += 1;
          size += com.google.protobuf.CodedOutputStream
              .computeInt32SizeNoTag(dataSize);
        }
        incomingMinorFragmentMemoizedSerializedSize = dataSize;
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(3, supportsOutOfOrder_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(4, isSpooling_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.BitControl.Collector parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.BitControl.Collector parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitControl.Collector parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.BitControl.Collector parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitControl.Collector parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.BitControl.Collector parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitControl.Collector parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.BitControl.Collector parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitControl.Collector parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.BitControl.Collector parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.BitControl.Collector prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.bit.control.Collector}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.BitControl.CollectorOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_Collector_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_Collector_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.BitControl.Collector.class, org.apache.drill.exec.proto.BitControl.Collector.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.BitControl.Collector.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        oppositeMajorFragmentId_ = 0;
        bitField0_ = (bitField0_ & ~0x00000001);
        incomingMinorFragment_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        supportsOutOfOrder_ = false;
        bitField0_ = (bitField0_ & ~0x00000004);
        isSpooling_ = false;
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_Collector_descriptor;
      }

      public org.apache.drill.exec.proto.BitControl.Collector getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.BitControl.Collector.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.BitControl.Collector build() {
        org.apache.drill.exec.proto.BitControl.Collector result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.BitControl.Collector buildPartial() {
        org.apache.drill.exec.proto.BitControl.Collector result = new org.apache.drill.exec.proto.BitControl.Collector(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.oppositeMajorFragmentId_ = oppositeMajorFragmentId_;
        if (((bitField0_ & 0x00000002) == 0x00000002)) {
          incomingMinorFragment_ = java.util.Collections.unmodifiableList(incomingMinorFragment_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.incomingMinorFragment_ = incomingMinorFragment_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000002;
        }
        result.supportsOutOfOrder_ = supportsOutOfOrder_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000004;
        }
        result.isSpooling_ = isSpooling_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.BitControl.Collector) {
          return mergeFrom((org.apache.drill.exec.proto.BitControl.Collector)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.BitControl.Collector other) {
        if (other == org.apache.drill.exec.proto.BitControl.Collector.getDefaultInstance()) return this;
        if (other.hasOppositeMajorFragmentId()) {
          setOppositeMajorFragmentId(other.getOppositeMajorFragmentId());
        }
        if (!other.incomingMinorFragment_.isEmpty()) {
          if (incomingMinorFragment_.isEmpty()) {
            incomingMinorFragment_ = other.incomingMinorFragment_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureIncomingMinorFragmentIsMutable();
            incomingMinorFragment_.addAll(other.incomingMinorFragment_);
          }
          onChanged();
        }
        if (other.hasSupportsOutOfOrder()) {
          setSupportsOutOfOrder(other.getSupportsOutOfOrder());
        }
        if (other.hasIsSpooling()) {
          setIsSpooling(other.getIsSpooling());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.BitControl.Collector parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.BitControl.Collector) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // optional int32 opposite_major_fragment_id = 1;
      private int oppositeMajorFragmentId_ ;
      /**
       * <code>optional int32 opposite_major_fragment_id = 1;</code>
       */
      public boolean hasOppositeMajorFragmentId() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional int32 opposite_major_fragment_id = 1;</code>
       */
      public int getOppositeMajorFragmentId() {
        return oppositeMajorFragmentId_;
      }
      /**
       * <code>optional int32 opposite_major_fragment_id = 1;</code>
       */
      public Builder setOppositeMajorFragmentId(int value) {
        bitField0_ |= 0x00000001;
        oppositeMajorFragmentId_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 opposite_major_fragment_id = 1;</code>
       */
      public Builder clearOppositeMajorFragmentId() {
        bitField0_ = (bitField0_ & ~0x00000001);
        oppositeMajorFragmentId_ = 0;
        onChanged();
        return this;
      }

      // repeated int32 incoming_minor_fragment = 2 [packed = true];
      private java.util.List<java.lang.Integer> incomingMinorFragment_ = java.util.Collections.emptyList();
      private void ensureIncomingMinorFragmentIsMutable() {
        if (!((bitField0_ & 0x00000002) == 0x00000002)) {
          incomingMinorFragment_ = new java.util.ArrayList<java.lang.Integer>(incomingMinorFragment_);
          bitField0_ |= 0x00000002;
         }
      }
      /**
       * <code>repeated int32 incoming_minor_fragment = 2 [packed = true];</code>
       */
      public java.util.List<java.lang.Integer>
          getIncomingMinorFragmentList() {
        return java.util.Collections.unmodifiableList(incomingMinorFragment_);
      }
      /**
       * <code>repeated int32 incoming_minor_fragment = 2 [packed = true];</code>
       */
      public int getIncomingMinorFragmentCount() {
        return incomingMinorFragment_.size();
      }
      /**
       * <code>repeated int32 incoming_minor_fragment = 2 [packed = true];</code>
       */
      public int getIncomingMinorFragment(int index) {
        return incomingMinorFragment_.get(index);
      }
      /**
       * <code>repeated int32 incoming_minor_fragment = 2 [packed = true];</code>
       */
      public Builder setIncomingMinorFragment(
          int index, int value) {
        ensureIncomingMinorFragmentIsMutable();
        incomingMinorFragment_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated int32 incoming_minor_fragment = 2 [packed = true];</code>
       */
      public Builder addIncomingMinorFragment(int value) {
        ensureIncomingMinorFragmentIsMutable();
        incomingMinorFragment_.add(value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated int32 incoming_minor_fragment = 2 [packed = true];</code>
       */
      public Builder addAllIncomingMinorFragment(
          java.lang.Iterable<? extends java.lang.Integer> values) {
        ensureIncomingMinorFragmentIsMutable();
        super.addAll(values, incomingMinorFragment_);
        onChanged();
        return this;
      }
      /**
       * <code>repeated int32 incoming_minor_fragment = 2 [packed = true];</code>
       */
      public Builder clearIncomingMinorFragment() {
        incomingMinorFragment_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      // optional bool supports_out_of_order = 3;
      private boolean supportsOutOfOrder_ ;
      /**
       * <code>optional bool supports_out_of_order = 3;</code>
       */
      public boolean hasSupportsOutOfOrder() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional bool supports_out_of_order = 3;</code>
       */
      public boolean getSupportsOutOfOrder() {
        return supportsOutOfOrder_;
      }
      /**
       * <code>optional bool supports_out_of_order = 3;</code>
       */
      public Builder setSupportsOutOfOrder(boolean value) {
        bitField0_ |= 0x00000004;
        supportsOutOfOrder_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool supports_out_of_order = 3;</code>
       */
      public Builder clearSupportsOutOfOrder() {
        bitField0_ = (bitField0_ & ~0x00000004);
        supportsOutOfOrder_ = false;
        onChanged();
        return this;
      }

      // optional bool is_spooling = 4;
      private boolean isSpooling_ ;
      /**
       * <code>optional bool is_spooling = 4;</code>
       */
      public boolean hasIsSpooling() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional bool is_spooling = 4;</code>
       */
      public boolean getIsSpooling() {
        return isSpooling_;
      }
      /**
       * <code>optional bool is_spooling = 4;</code>
       */
      public Builder setIsSpooling(boolean value) {
        bitField0_ |= 0x00000008;
        isSpooling_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool is_spooling = 4;</code>
       */
      public Builder clearIsSpooling() {
        bitField0_ = (bitField0_ & ~0x00000008);
        isSpooling_ = false;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:exec.bit.control.Collector)
    }

    static {
      defaultInstance = new Collector(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.bit.control.Collector)
  }

  public interface QueryContextInformationOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // optional int64 query_start_time = 1;
    /**
     * <code>optional int64 query_start_time = 1;</code>
     *
     * <pre>
     * start time of query in milliseconds
     * </pre>
     */
    boolean hasQueryStartTime();
    /**
     * <code>optional int64 query_start_time = 1;</code>
     *
     * <pre>
     * start time of query in milliseconds
     * </pre>
     */
    long getQueryStartTime();

    // optional int32 time_zone = 2;
    /**
     * <code>optional int32 time_zone = 2;</code>
     *
     * <pre>
     * timezone of the Drillbit where user is connected
     * </pre>
     */
    boolean hasTimeZone();
    /**
     * <code>optional int32 time_zone = 2;</code>
     *
     * <pre>
     * timezone of the Drillbit where user is connected
     * </pre>
     */
    int getTimeZone();

    // optional string default_schema_name = 3;
    /**
     * <code>optional string default_schema_name = 3;</code>
     *
     * <pre>
     * default schema in current session when the query is submitted
     * </pre>
     */
    boolean hasDefaultSchemaName();
    /**
     * <code>optional string default_schema_name = 3;</code>
     *
     * <pre>
     * default schema in current session when the query is submitted
     * </pre>
     */
    java.lang.String getDefaultSchemaName();
    /**
     * <code>optional string default_schema_name = 3;</code>
     *
     * <pre>
     * default schema in current session when the query is submitted
     * </pre>
     */
    com.google.protobuf.ByteString
        getDefaultSchemaNameBytes();

    // optional string session_id = 4;
    /**
     * <code>optional string session_id = 4;</code>
     *
     * <pre>
     * current session id
     * </pre>
     */
    boolean hasSessionId();
    /**
     * <code>optional string session_id = 4;</code>
     *
     * <pre>
     * current session id
     * </pre>
     */
    java.lang.String getSessionId();
    /**
     * <code>optional string session_id = 4;</code>
     *
     * <pre>
     * current session id
     * </pre>
     */
    com.google.protobuf.ByteString
        getSessionIdBytes();
  }
  /**
   * Protobuf type {@code exec.bit.control.QueryContextInformation}
   */
  public static final class QueryContextInformation extends
      com.google.protobuf.GeneratedMessage
      implements QueryContextInformationOrBuilder {
    // Use QueryContextInformation.newBuilder() to construct.
    private QueryContextInformation(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private QueryContextInformation(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final QueryContextInformation defaultInstance;
    public static QueryContextInformation getDefaultInstance() {
      return defaultInstance;
    }

    public QueryContextInformation getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private QueryContextInformation(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              bitField0_ |= 0x00000001;
              queryStartTime_ = input.readInt64();
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              timeZone_ = input.readInt32();
              break;
            }
            case 26: {
              bitField0_ |= 0x00000004;
              defaultSchemaName_ = input.readBytes();
              break;
            }
            case 34: {
              bitField0_ |= 0x00000008;
              sessionId_ = input.readBytes();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_QueryContextInformation_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_QueryContextInformation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.BitControl.QueryContextInformation.class, org.apache.drill.exec.proto.BitControl.QueryContextInformation.Builder.class);
    }

    public static com.google.protobuf.Parser<QueryContextInformation> PARSER =
        new com.google.protobuf.AbstractParser<QueryContextInformation>() {
      public QueryContextInformation parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new QueryContextInformation(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<QueryContextInformation> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // optional int64 query_start_time = 1;
    public static final int QUERY_START_TIME_FIELD_NUMBER = 1;
    private long queryStartTime_;
    /**
     * <code>optional int64 query_start_time = 1;</code>
     *
     * <pre>
     * start time of query in milliseconds
     * </pre>
     */
    public boolean hasQueryStartTime() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional int64 query_start_time = 1;</code>
     *
     * <pre>
     * start time of query in milliseconds
     * </pre>
     */
    public long getQueryStartTime() {
      return queryStartTime_;
    }

    // optional int32 time_zone = 2;
    public static final int TIME_ZONE_FIELD_NUMBER = 2;
    private int timeZone_;
    /**
     * <code>optional int32 time_zone = 2;</code>
     *
     * <pre>
     * timezone of the Drillbit where user is connected
     * </pre>
     */
    public boolean hasTimeZone() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional int32 time_zone = 2;</code>
     *
     * <pre>
     * timezone of the Drillbit where user is connected
     * </pre>
     */
    public int getTimeZone() {
      return timeZone_;
    }

    // optional string default_schema_name = 3;
    public static final int DEFAULT_SCHEMA_NAME_FIELD_NUMBER = 3;
    private java.lang.Object defaultSchemaName_;
    /**
     * <code>optional string default_schema_name = 3;</code>
     *
     * <pre>
     * default schema in current session when the query is submitted
     * </pre>
     */
    public boolean hasDefaultSchemaName() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional string default_schema_name = 3;</code>
     *
     * <pre>
     * default schema in current session when the query is submitted
     * </pre>
     */
    public java.lang.String getDefaultSchemaName() {
      java.lang.Object ref = defaultSchemaName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          defaultSchemaName_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string default_schema_name = 3;</code>
     *
     * <pre>
     * default schema in current session when the query is submitted
     * </pre>
     */
    public com.google.protobuf.ByteString
        getDefaultSchemaNameBytes() {
      java.lang.Object ref = defaultSchemaName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        defaultSchemaName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // optional string session_id = 4;
    public static final int SESSION_ID_FIELD_NUMBER = 4;
    private java.lang.Object sessionId_;
    /**
     * <code>optional string session_id = 4;</code>
     *
     * <pre>
     * current session id
     * </pre>
     */
    public boolean hasSessionId() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional string session_id = 4;</code>
     *
     * <pre>
     * current session id
     * </pre>
     */
    public java.lang.String getSessionId() {
      java.lang.Object ref = sessionId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          sessionId_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string session_id = 4;</code>
     *
     * <pre>
     * current session id
     * </pre>
     */
    public com.google.protobuf.ByteString
        getSessionIdBytes() {
      java.lang.Object ref = sessionId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        sessionId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private void initFields() {
      queryStartTime_ = 0L;
      timeZone_ = 0;
      defaultSchemaName_ = "";
      sessionId_ = "";
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeInt64(1, queryStartTime_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeInt32(2, timeZone_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeBytes(3, getDefaultSchemaNameBytes());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeBytes(4, getSessionIdBytes());
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt64Size(1, queryStartTime_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(2, timeZone_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(3, getDefaultSchemaNameBytes());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(4, getSessionIdBytes());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.BitControl.QueryContextInformation parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.BitControl.QueryContextInformation parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitControl.QueryContextInformation parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.BitControl.QueryContextInformation parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitControl.QueryContextInformation parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.BitControl.QueryContextInformation parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitControl.QueryContextInformation parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.BitControl.QueryContextInformation parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitControl.QueryContextInformation parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.BitControl.QueryContextInformation parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.BitControl.QueryContextInformation prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.bit.control.QueryContextInformation}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.BitControl.QueryContextInformationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_QueryContextInformation_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_QueryContextInformation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.BitControl.QueryContextInformation.class, org.apache.drill.exec.proto.BitControl.QueryContextInformation.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.BitControl.QueryContextInformation.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        queryStartTime_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000001);
        timeZone_ = 0;
        bitField0_ = (bitField0_ & ~0x00000002);
        defaultSchemaName_ = "";
        bitField0_ = (bitField0_ & ~0x00000004);
        sessionId_ = "";
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_QueryContextInformation_descriptor;
      }

      public org.apache.drill.exec.proto.BitControl.QueryContextInformation getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.BitControl.QueryContextInformation.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.BitControl.QueryContextInformation build() {
        org.apache.drill.exec.proto.BitControl.QueryContextInformation result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.BitControl.QueryContextInformation buildPartial() {
        org.apache.drill.exec.proto.BitControl.QueryContextInformation result = new org.apache.drill.exec.proto.BitControl.QueryContextInformation(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.queryStartTime_ = queryStartTime_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.timeZone_ = timeZone_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.defaultSchemaName_ = defaultSchemaName_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.sessionId_ = sessionId_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.BitControl.QueryContextInformation) {
          return mergeFrom((org.apache.drill.exec.proto.BitControl.QueryContextInformation)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.BitControl.QueryContextInformation other) {
        if (other == org.apache.drill.exec.proto.BitControl.QueryContextInformation.getDefaultInstance()) return this;
        if (other.hasQueryStartTime()) {
          setQueryStartTime(other.getQueryStartTime());
        }
        if (other.hasTimeZone()) {
          setTimeZone(other.getTimeZone());
        }
        if (other.hasDefaultSchemaName()) {
          bitField0_ |= 0x00000004;
          defaultSchemaName_ = other.defaultSchemaName_;
          onChanged();
        }
        if (other.hasSessionId()) {
          bitField0_ |= 0x00000008;
          sessionId_ = other.sessionId_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.BitControl.QueryContextInformation parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.BitControl.QueryContextInformation) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // optional int64 query_start_time = 1;
      private long queryStartTime_ ;
      /**
       * <code>optional int64 query_start_time = 1;</code>
       *
       * <pre>
       * start time of query in milliseconds
       * </pre>
       */
      public boolean hasQueryStartTime() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional int64 query_start_time = 1;</code>
       *
       * <pre>
       * start time of query in milliseconds
       * </pre>
       */
      public long getQueryStartTime() {
        return queryStartTime_;
      }
      /**
       * <code>optional int64 query_start_time = 1;</code>
       *
       * <pre>
       * start time of query in milliseconds
       * </pre>
       */
      public Builder setQueryStartTime(long value) {
        bitField0_ |= 0x00000001;
        queryStartTime_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int64 query_start_time = 1;</code>
       *
       * <pre>
       * start time of query in milliseconds
       * </pre>
       */
      public Builder clearQueryStartTime() {
        bitField0_ = (bitField0_ & ~0x00000001);
        queryStartTime_ = 0L;
        onChanged();
        return this;
      }

      // optional int32 time_zone = 2;
      private int timeZone_ ;
      /**
       * <code>optional int32 time_zone = 2;</code>
       *
       * <pre>
       * timezone of the Drillbit where user is connected
       * </pre>
       */
      public boolean hasTimeZone() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional int32 time_zone = 2;</code>
       *
       * <pre>
       * timezone of the Drillbit where user is connected
       * </pre>
       */
      public int getTimeZone() {
        return timeZone_;
      }
      /**
       * <code>optional int32 time_zone = 2;</code>
       *
       * <pre>
       * timezone of the Drillbit where user is connected
       * </pre>
       */
      public Builder setTimeZone(int value) {
        bitField0_ |= 0x00000002;
        timeZone_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 time_zone = 2;</code>
       *
       * <pre>
       * timezone of the Drillbit where user is connected
       * </pre>
       */
      public Builder clearTimeZone() {
        bitField0_ = (bitField0_ & ~0x00000002);
        timeZone_ = 0;
        onChanged();
        return this;
      }

      // optional string default_schema_name = 3;
      private java.lang.Object defaultSchemaName_ = "";
      /**
       * <code>optional string default_schema_name = 3;</code>
       *
       * <pre>
       * default schema in current session when the query is submitted
       * </pre>
       */
      public boolean hasDefaultSchemaName() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional string default_schema_name = 3;</code>
       *
       * <pre>
       * default schema in current session when the query is submitted
       * </pre>
       */
      public java.lang.String getDefaultSchemaName() {
        java.lang.Object ref = defaultSchemaName_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          defaultSchemaName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string default_schema_name = 3;</code>
       *
       * <pre>
       * default schema in current session when the query is submitted
       * </pre>
       */
      public com.google.protobuf.ByteString
          getDefaultSchemaNameBytes() {
        java.lang.Object ref = defaultSchemaName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          defaultSchemaName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string default_schema_name = 3;</code>
       *
       * <pre>
       * default schema in current session when the query is submitted
       * </pre>
       */
      public Builder setDefaultSchemaName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        defaultSchemaName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string default_schema_name = 3;</code>
       *
       * <pre>
       * default schema in current session when the query is submitted
       * </pre>
       */
      public Builder clearDefaultSchemaName() {
        bitField0_ = (bitField0_ & ~0x00000004);
        defaultSchemaName_ = getDefaultInstance().getDefaultSchemaName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string default_schema_name = 3;</code>
       *
       * <pre>
       * default schema in current session when the query is submitted
       * </pre>
       */
      public Builder setDefaultSchemaNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        defaultSchemaName_ = value;
        onChanged();
        return this;
      }

      // optional string session_id = 4;
      private java.lang.Object sessionId_ = "";
      /**
       * <code>optional string session_id = 4;</code>
       *
       * <pre>
       * current session id
       * </pre>
       */
      public boolean hasSessionId() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional string session_id = 4;</code>
       *
       * <pre>
       * current session id
       * </pre>
       */
      public java.lang.String getSessionId() {
        java.lang.Object ref = sessionId_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          sessionId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string session_id = 4;</code>
       *
       * <pre>
       * current session id
       * </pre>
       */
      public com.google.protobuf.ByteString
          getSessionIdBytes() {
        java.lang.Object ref = sessionId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          sessionId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string session_id = 4;</code>
       *
       * <pre>
       * current session id
       * </pre>
       */
      public Builder setSessionId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
        sessionId_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string session_id = 4;</code>
       *
       * <pre>
       * current session id
       * </pre>
       */
      public Builder clearSessionId() {
        bitField0_ = (bitField0_ & ~0x00000008);
        sessionId_ = getDefaultInstance().getSessionId();
        onChanged();
        return this;
      }
      /**
       * <code>optional string session_id = 4;</code>
       *
       * <pre>
       * current session id
       * </pre>
       */
      public Builder setSessionIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
        sessionId_ = value;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:exec.bit.control.QueryContextInformation)
    }

    static {
      defaultInstance = new QueryContextInformation(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.bit.control.QueryContextInformation)
  }

  public interface WorkQueueStatusOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // optional .exec.DrillbitEndpoint endpoint = 1;
    /**
     * <code>optional .exec.DrillbitEndpoint endpoint = 1;</code>
     */
    boolean hasEndpoint();
    /**
     * <code>optional .exec.DrillbitEndpoint endpoint = 1;</code>
     */
    org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint getEndpoint();
    /**
     * <code>optional .exec.DrillbitEndpoint endpoint = 1;</code>
     */
    org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpointOrBuilder getEndpointOrBuilder();

    // optional int32 queue_length = 2;
    /**
     * <code>optional int32 queue_length = 2;</code>
     */
    boolean hasQueueLength();
    /**
     * <code>optional int32 queue_length = 2;</code>
     */
    int getQueueLength();

    // optional int64 report_time = 3;
    /**
     * <code>optional int64 report_time = 3;</code>
     */
    boolean hasReportTime();
    /**
     * <code>optional int64 report_time = 3;</code>
     */
    long getReportTime();
  }
  /**
   * Protobuf type {@code exec.bit.control.WorkQueueStatus}
   */
  public static final class WorkQueueStatus extends
      com.google.protobuf.GeneratedMessage
      implements WorkQueueStatusOrBuilder {
    // Use WorkQueueStatus.newBuilder() to construct.
    private WorkQueueStatus(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private WorkQueueStatus(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final WorkQueueStatus defaultInstance;
    public static WorkQueueStatus getDefaultInstance() {
      return defaultInstance;
    }

    public WorkQueueStatus getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private WorkQueueStatus(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.Builder subBuilder = null;
              if (((bitField0_ & 0x00000001) == 0x00000001)) {
                subBuilder = endpoint_.toBuilder();
              }
              endpoint_ = input.readMessage(org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(endpoint_);
                endpoint_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000001;
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              queueLength_ = input.readInt32();
              break;
            }
            case 24: {
              bitField0_ |= 0x00000004;
              reportTime_ = input.readInt64();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_WorkQueueStatus_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_WorkQueueStatus_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.BitControl.WorkQueueStatus.class, org.apache.drill.exec.proto.BitControl.WorkQueueStatus.Builder.class);
    }

    public static com.google.protobuf.Parser<WorkQueueStatus> PARSER =
        new com.google.protobuf.AbstractParser<WorkQueueStatus>() {
      public WorkQueueStatus parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new WorkQueueStatus(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<WorkQueueStatus> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // optional .exec.DrillbitEndpoint endpoint = 1;
    public static final int ENDPOINT_FIELD_NUMBER = 1;
    private org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint endpoint_;
    /**
     * <code>optional .exec.DrillbitEndpoint endpoint = 1;</code>
     */
    public boolean hasEndpoint() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional .exec.DrillbitEndpoint endpoint = 1;</code>
     */
    public org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint getEndpoint() {
      return endpoint_;
    }
    /**
     * <code>optional .exec.DrillbitEndpoint endpoint = 1;</code>
     */
    public org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpointOrBuilder getEndpointOrBuilder() {
      return endpoint_;
    }

    // optional int32 queue_length = 2;
    public static final int QUEUE_LENGTH_FIELD_NUMBER = 2;
    private int queueLength_;
    /**
     * <code>optional int32 queue_length = 2;</code>
     */
    public boolean hasQueueLength() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional int32 queue_length = 2;</code>
     */
    public int getQueueLength() {
      return queueLength_;
    }

    // optional int64 report_time = 3;
    public static final int REPORT_TIME_FIELD_NUMBER = 3;
    private long reportTime_;
    /**
     * <code>optional int64 report_time = 3;</code>
     */
    public boolean hasReportTime() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional int64 report_time = 3;</code>
     */
    public long getReportTime() {
      return reportTime_;
    }

    private void initFields() {
      endpoint_ = org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.getDefaultInstance();
      queueLength_ = 0;
      reportTime_ = 0L;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, endpoint_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeInt32(2, queueLength_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeInt64(3, reportTime_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, endpoint_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(2, queueLength_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt64Size(3, reportTime_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.BitControl.WorkQueueStatus parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.BitControl.WorkQueueStatus parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitControl.WorkQueueStatus parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.BitControl.WorkQueueStatus parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitControl.WorkQueueStatus parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.BitControl.WorkQueueStatus parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitControl.WorkQueueStatus parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.BitControl.WorkQueueStatus parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitControl.WorkQueueStatus parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.BitControl.WorkQueueStatus parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.BitControl.WorkQueueStatus prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.bit.control.WorkQueueStatus}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.BitControl.WorkQueueStatusOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_WorkQueueStatus_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_WorkQueueStatus_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.BitControl.WorkQueueStatus.class, org.apache.drill.exec.proto.BitControl.WorkQueueStatus.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.BitControl.WorkQueueStatus.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getEndpointFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        if (endpointBuilder_ == null) {
          endpoint_ = org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.getDefaultInstance();
        } else {
          endpointBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        queueLength_ = 0;
        bitField0_ = (bitField0_ & ~0x00000002);
        reportTime_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_WorkQueueStatus_descriptor;
      }

      public org.apache.drill.exec.proto.BitControl.WorkQueueStatus getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.BitControl.WorkQueueStatus.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.BitControl.WorkQueueStatus build() {
        org.apache.drill.exec.proto.BitControl.WorkQueueStatus result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.BitControl.WorkQueueStatus buildPartial() {
        org.apache.drill.exec.proto.BitControl.WorkQueueStatus result = new org.apache.drill.exec.proto.BitControl.WorkQueueStatus(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (endpointBuilder_ == null) {
          result.endpoint_ = endpoint_;
        } else {
          result.endpoint_ = endpointBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.queueLength_ = queueLength_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.reportTime_ = reportTime_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.BitControl.WorkQueueStatus) {
          return mergeFrom((org.apache.drill.exec.proto.BitControl.WorkQueueStatus)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.BitControl.WorkQueueStatus other) {
        if (other == org.apache.drill.exec.proto.BitControl.WorkQueueStatus.getDefaultInstance()) return this;
        if (other.hasEndpoint()) {
          mergeEndpoint(other.getEndpoint());
        }
        if (other.hasQueueLength()) {
          setQueueLength(other.getQueueLength());
        }
        if (other.hasReportTime()) {
          setReportTime(other.getReportTime());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.BitControl.WorkQueueStatus parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.BitControl.WorkQueueStatus) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // optional .exec.DrillbitEndpoint endpoint = 1;
      private org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint endpoint_ = org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint, org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.Builder, org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpointOrBuilder> endpointBuilder_;
      /**
       * <code>optional .exec.DrillbitEndpoint endpoint = 1;</code>
       */
      public boolean hasEndpoint() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional .exec.DrillbitEndpoint endpoint = 1;</code>
       */
      public org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint getEndpoint() {
        if (endpointBuilder_ == null) {
          return endpoint_;
        } else {
          return endpointBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.DrillbitEndpoint endpoint = 1;</code>
       */
      public Builder setEndpoint(org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint value) {
        if (endpointBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          endpoint_ = value;
          onChanged();
        } else {
          endpointBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.DrillbitEndpoint endpoint = 1;</code>
       */
      public Builder setEndpoint(
          org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.Builder builderForValue) {
        if (endpointBuilder_ == null) {
          endpoint_ = builderForValue.build();
          onChanged();
        } else {
          endpointBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.DrillbitEndpoint endpoint = 1;</code>
       */
      public Builder mergeEndpoint(org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint value) {
        if (endpointBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001) &&
              endpoint_ != org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.getDefaultInstance()) {
            endpoint_ =
              org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.newBuilder(endpoint_).mergeFrom(value).buildPartial();
          } else {
            endpoint_ = value;
          }
          onChanged();
        } else {
          endpointBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.DrillbitEndpoint endpoint = 1;</code>
       */
      public Builder clearEndpoint() {
        if (endpointBuilder_ == null) {
          endpoint_ = org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.getDefaultInstance();
          onChanged();
        } else {
          endpointBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       * <code>optional .exec.DrillbitEndpoint endpoint = 1;</code>
       */
      public org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.Builder getEndpointBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getEndpointFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.DrillbitEndpoint endpoint = 1;</code>
       */
      public org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpointOrBuilder getEndpointOrBuilder() {
        if (endpointBuilder_ != null) {
          return endpointBuilder_.getMessageOrBuilder();
        } else {
          return endpoint_;
        }
      }
      /**
       * <code>optional .exec.DrillbitEndpoint endpoint = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint, org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.Builder, org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpointOrBuilder> 
          getEndpointFieldBuilder() {
        if (endpointBuilder_ == null) {
          endpointBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint, org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpoint.Builder, org.apache.drill.exec.proto.CoordinationProtos.DrillbitEndpointOrBuilder>(
                  endpoint_,
                  getParentForChildren(),
                  isClean());
          endpoint_ = null;
        }
        return endpointBuilder_;
      }

      // optional int32 queue_length = 2;
      private int queueLength_ ;
      /**
       * <code>optional int32 queue_length = 2;</code>
       */
      public boolean hasQueueLength() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional int32 queue_length = 2;</code>
       */
      public int getQueueLength() {
        return queueLength_;
      }
      /**
       * <code>optional int32 queue_length = 2;</code>
       */
      public Builder setQueueLength(int value) {
        bitField0_ |= 0x00000002;
        queueLength_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 queue_length = 2;</code>
       */
      public Builder clearQueueLength() {
        bitField0_ = (bitField0_ & ~0x00000002);
        queueLength_ = 0;
        onChanged();
        return this;
      }

      // optional int64 report_time = 3;
      private long reportTime_ ;
      /**
       * <code>optional int64 report_time = 3;</code>
       */
      public boolean hasReportTime() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional int64 report_time = 3;</code>
       */
      public long getReportTime() {
        return reportTime_;
      }
      /**
       * <code>optional int64 report_time = 3;</code>
       */
      public Builder setReportTime(long value) {
        bitField0_ |= 0x00000004;
        reportTime_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int64 report_time = 3;</code>
       */
      public Builder clearReportTime() {
        bitField0_ = (bitField0_ & ~0x00000004);
        reportTime_ = 0L;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:exec.bit.control.WorkQueueStatus)
    }

    static {
      defaultInstance = new WorkQueueStatus(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.bit.control.WorkQueueStatus)
  }

  public interface FinishedReceiverOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // optional .exec.bit.FragmentHandle receiver = 1;
    /**
     * <code>optional .exec.bit.FragmentHandle receiver = 1;</code>
     */
    boolean hasReceiver();
    /**
     * <code>optional .exec.bit.FragmentHandle receiver = 1;</code>
     */
    org.apache.drill.exec.proto.ExecProtos.FragmentHandle getReceiver();
    /**
     * <code>optional .exec.bit.FragmentHandle receiver = 1;</code>
     */
    org.apache.drill.exec.proto.ExecProtos.FragmentHandleOrBuilder getReceiverOrBuilder();

    // optional .exec.bit.FragmentHandle sender = 2;
    /**
     * <code>optional .exec.bit.FragmentHandle sender = 2;</code>
     */
    boolean hasSender();
    /**
     * <code>optional .exec.bit.FragmentHandle sender = 2;</code>
     */
    org.apache.drill.exec.proto.ExecProtos.FragmentHandle getSender();
    /**
     * <code>optional .exec.bit.FragmentHandle sender = 2;</code>
     */
    org.apache.drill.exec.proto.ExecProtos.FragmentHandleOrBuilder getSenderOrBuilder();
  }
  /**
   * Protobuf type {@code exec.bit.control.FinishedReceiver}
   */
  public static final class FinishedReceiver extends
      com.google.protobuf.GeneratedMessage
      implements FinishedReceiverOrBuilder {
    // Use FinishedReceiver.newBuilder() to construct.
    private FinishedReceiver(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private FinishedReceiver(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final FinishedReceiver defaultInstance;
    public static FinishedReceiver getDefaultInstance() {
      return defaultInstance;
    }

    public FinishedReceiver getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private FinishedReceiver(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              org.apache.drill.exec.proto.ExecProtos.FragmentHandle.Builder subBuilder = null;
              if (((bitField0_ & 0x00000001) == 0x00000001)) {
                subBuilder = receiver_.toBuilder();
              }
              receiver_ = input.readMessage(org.apache.drill.exec.proto.ExecProtos.FragmentHandle.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(receiver_);
                receiver_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000001;
              break;
            }
            case 18: {
              org.apache.drill.exec.proto.ExecProtos.FragmentHandle.Builder subBuilder = null;
              if (((bitField0_ & 0x00000002) == 0x00000002)) {
                subBuilder = sender_.toBuilder();
              }
              sender_ = input.readMessage(org.apache.drill.exec.proto.ExecProtos.FragmentHandle.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(sender_);
                sender_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000002;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_FinishedReceiver_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_FinishedReceiver_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.BitControl.FinishedReceiver.class, org.apache.drill.exec.proto.BitControl.FinishedReceiver.Builder.class);
    }

    public static com.google.protobuf.Parser<FinishedReceiver> PARSER =
        new com.google.protobuf.AbstractParser<FinishedReceiver>() {
      public FinishedReceiver parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new FinishedReceiver(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<FinishedReceiver> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // optional .exec.bit.FragmentHandle receiver = 1;
    public static final int RECEIVER_FIELD_NUMBER = 1;
    private org.apache.drill.exec.proto.ExecProtos.FragmentHandle receiver_;
    /**
     * <code>optional .exec.bit.FragmentHandle receiver = 1;</code>
     */
    public boolean hasReceiver() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional .exec.bit.FragmentHandle receiver = 1;</code>
     */
    public org.apache.drill.exec.proto.ExecProtos.FragmentHandle getReceiver() {
      return receiver_;
    }
    /**
     * <code>optional .exec.bit.FragmentHandle receiver = 1;</code>
     */
    public org.apache.drill.exec.proto.ExecProtos.FragmentHandleOrBuilder getReceiverOrBuilder() {
      return receiver_;
    }

    // optional .exec.bit.FragmentHandle sender = 2;
    public static final int SENDER_FIELD_NUMBER = 2;
    private org.apache.drill.exec.proto.ExecProtos.FragmentHandle sender_;
    /**
     * <code>optional .exec.bit.FragmentHandle sender = 2;</code>
     */
    public boolean hasSender() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional .exec.bit.FragmentHandle sender = 2;</code>
     */
    public org.apache.drill.exec.proto.ExecProtos.FragmentHandle getSender() {
      return sender_;
    }
    /**
     * <code>optional .exec.bit.FragmentHandle sender = 2;</code>
     */
    public org.apache.drill.exec.proto.ExecProtos.FragmentHandleOrBuilder getSenderOrBuilder() {
      return sender_;
    }

    private void initFields() {
      receiver_ = org.apache.drill.exec.proto.ExecProtos.FragmentHandle.getDefaultInstance();
      sender_ = org.apache.drill.exec.proto.ExecProtos.FragmentHandle.getDefaultInstance();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, receiver_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(2, sender_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, receiver_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, sender_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.BitControl.FinishedReceiver parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.BitControl.FinishedReceiver parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitControl.FinishedReceiver parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.BitControl.FinishedReceiver parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitControl.FinishedReceiver parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.BitControl.FinishedReceiver parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitControl.FinishedReceiver parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.BitControl.FinishedReceiver parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.BitControl.FinishedReceiver parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.BitControl.FinishedReceiver parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.BitControl.FinishedReceiver prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.bit.control.FinishedReceiver}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.BitControl.FinishedReceiverOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_FinishedReceiver_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_FinishedReceiver_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.BitControl.FinishedReceiver.class, org.apache.drill.exec.proto.BitControl.FinishedReceiver.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.BitControl.FinishedReceiver.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getReceiverFieldBuilder();
          getSenderFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        if (receiverBuilder_ == null) {
          receiver_ = org.apache.drill.exec.proto.ExecProtos.FragmentHandle.getDefaultInstance();
        } else {
          receiverBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (senderBuilder_ == null) {
          sender_ = org.apache.drill.exec.proto.ExecProtos.FragmentHandle.getDefaultInstance();
        } else {
          senderBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.BitControl.internal_static_exec_bit_control_FinishedReceiver_descriptor;
      }

      public org.apache.drill.exec.proto.BitControl.FinishedReceiver getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.BitControl.FinishedReceiver.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.BitControl.FinishedReceiver build() {
        org.apache.drill.exec.proto.BitControl.FinishedReceiver result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.BitControl.FinishedReceiver buildPartial() {
        org.apache.drill.exec.proto.BitControl.FinishedReceiver result = new org.apache.drill.exec.proto.BitControl.FinishedReceiver(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (receiverBuilder_ == null) {
          result.receiver_ = receiver_;
        } else {
          result.receiver_ = receiverBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        if (senderBuilder_ == null) {
          result.sender_ = sender_;
        } else {
          result.sender_ = senderBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.BitControl.FinishedReceiver) {
          return mergeFrom((org.apache.drill.exec.proto.BitControl.FinishedReceiver)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.BitControl.FinishedReceiver other) {
        if (other == org.apache.drill.exec.proto.BitControl.FinishedReceiver.getDefaultInstance()) return this;
        if (other.hasReceiver()) {
          mergeReceiver(other.getReceiver());
        }
        if (other.hasSender()) {
          mergeSender(other.getSender());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.BitControl.FinishedReceiver parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.BitControl.FinishedReceiver) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // optional .exec.bit.FragmentHandle receiver = 1;
      private org.apache.drill.exec.proto.ExecProtos.FragmentHandle receiver_ = org.apache.drill.exec.proto.ExecProtos.FragmentHandle.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.ExecProtos.FragmentHandle, org.apache.drill.exec.proto.ExecProtos.FragmentHandle.Builder, org.apache.drill.exec.proto.ExecProtos.FragmentHandleOrBuilder> receiverBuilder_;
      /**
       * <code>optional .exec.bit.FragmentHandle receiver = 1;</code>
       */
      public boolean hasReceiver() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional .exec.bit.FragmentHandle receiver = 1;</code>
       */
      public org.apache.drill.exec.proto.ExecProtos.FragmentHandle getReceiver() {
        if (receiverBuilder_ == null) {
          return receiver_;
        } else {
          return receiverBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.bit.FragmentHandle receiver = 1;</code>
       */
      public Builder setReceiver(org.apache.drill.exec.proto.ExecProtos.FragmentHandle value) {
        if (receiverBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          receiver_ = value;
          onChanged();
        } else {
          receiverBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.bit.FragmentHandle receiver = 1;</code>
       */
      public Builder setReceiver(
          org.apache.drill.exec.proto.ExecProtos.FragmentHandle.Builder builderForValue) {
        if (receiverBuilder_ == null) {
          receiver_ = builderForValue.build();
          onChanged();
        } else {
          receiverBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.bit.FragmentHandle receiver = 1;</code>
       */
      public Builder mergeReceiver(org.apache.drill.exec.proto.ExecProtos.FragmentHandle value) {
        if (receiverBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001) &&
              receiver_ != org.apache.drill.exec.proto.ExecProtos.FragmentHandle.getDefaultInstance()) {
            receiver_ =
              org.apache.drill.exec.proto.ExecProtos.FragmentHandle.newBuilder(receiver_).mergeFrom(value).buildPartial();
          } else {
            receiver_ = value;
          }
          onChanged();
        } else {
          receiverBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.bit.FragmentHandle receiver = 1;</code>
       */
      public Builder clearReceiver() {
        if (receiverBuilder_ == null) {
          receiver_ = org.apache.drill.exec.proto.ExecProtos.FragmentHandle.getDefaultInstance();
          onChanged();
        } else {
          receiverBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       * <code>optional .exec.bit.FragmentHandle receiver = 1;</code>
       */
      public org.apache.drill.exec.proto.ExecProtos.FragmentHandle.Builder getReceiverBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getReceiverFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.bit.FragmentHandle receiver = 1;</code>
       */
      public org.apache.drill.exec.proto.ExecProtos.FragmentHandleOrBuilder getReceiverOrBuilder() {
        if (receiverBuilder_ != null) {
          return receiverBuilder_.getMessageOrBuilder();
        } else {
          return receiver_;
        }
      }
      /**
       * <code>optional .exec.bit.FragmentHandle receiver = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.ExecProtos.FragmentHandle, org.apache.drill.exec.proto.ExecProtos.FragmentHandle.Builder, org.apache.drill.exec.proto.ExecProtos.FragmentHandleOrBuilder> 
          getReceiverFieldBuilder() {
        if (receiverBuilder_ == null) {
          receiverBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.drill.exec.proto.ExecProtos.FragmentHandle, org.apache.drill.exec.proto.ExecProtos.FragmentHandle.Builder, org.apache.drill.exec.proto.ExecProtos.FragmentHandleOrBuilder>(
                  receiver_,
                  getParentForChildren(),
                  isClean());
          receiver_ = null;
        }
        return receiverBuilder_;
      }

      // optional .exec.bit.FragmentHandle sender = 2;
      private org.apache.drill.exec.proto.ExecProtos.FragmentHandle sender_ = org.apache.drill.exec.proto.ExecProtos.FragmentHandle.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.ExecProtos.FragmentHandle, org.apache.drill.exec.proto.ExecProtos.FragmentHandle.Builder, org.apache.drill.exec.proto.ExecProtos.FragmentHandleOrBuilder> senderBuilder_;
      /**
       * <code>optional .exec.bit.FragmentHandle sender = 2;</code>
       */
      public boolean hasSender() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional .exec.bit.FragmentHandle sender = 2;</code>
       */
      public org.apache.drill.exec.proto.ExecProtos.FragmentHandle getSender() {
        if (senderBuilder_ == null) {
          return sender_;
        } else {
          return senderBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.bit.FragmentHandle sender = 2;</code>
       */
      public Builder setSender(org.apache.drill.exec.proto.ExecProtos.FragmentHandle value) {
        if (senderBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          sender_ = value;
          onChanged();
        } else {
          senderBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .exec.bit.FragmentHandle sender = 2;</code>
       */
      public Builder setSender(
          org.apache.drill.exec.proto.ExecProtos.FragmentHandle.Builder builderForValue) {
        if (senderBuilder_ == null) {
          sender_ = builderForValue.build();
          onChanged();
        } else {
          senderBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .exec.bit.FragmentHandle sender = 2;</code>
       */
      public Builder mergeSender(org.apache.drill.exec.proto.ExecProtos.FragmentHandle value) {
        if (senderBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002) &&
              sender_ != org.apache.drill.exec.proto.ExecProtos.FragmentHandle.getDefaultInstance()) {
            sender_ =
              org.apache.drill.exec.proto.ExecProtos.FragmentHandle.newBuilder(sender_).mergeFrom(value).buildPartial();
          } else {
            sender_ = value;
          }
          onChanged();
        } else {
          senderBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .exec.bit.FragmentHandle sender = 2;</code>
       */
      public Builder clearSender() {
        if (senderBuilder_ == null) {
          sender_ = org.apache.drill.exec.proto.ExecProtos.FragmentHandle.getDefaultInstance();
          onChanged();
        } else {
          senderBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       * <code>optional .exec.bit.FragmentHandle sender = 2;</code>
       */
      public org.apache.drill.exec.proto.ExecProtos.FragmentHandle.Builder getSenderBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getSenderFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.bit.FragmentHandle sender = 2;</code>
       */
      public org.apache.drill.exec.proto.ExecProtos.FragmentHandleOrBuilder getSenderOrBuilder() {
        if (senderBuilder_ != null) {
          return senderBuilder_.getMessageOrBuilder();
        } else {
          return sender_;
        }
      }
      /**
       * <code>optional .exec.bit.FragmentHandle sender = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.ExecProtos.FragmentHandle, org.apache.drill.exec.proto.ExecProtos.FragmentHandle.Builder, org.apache.drill.exec.proto.ExecProtos.FragmentHandleOrBuilder> 
          getSenderFieldBuilder() {
        if (senderBuilder_ == null) {
          senderBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.drill.exec.proto.ExecProtos.FragmentHandle, org.apache.drill.exec.proto.ExecProtos.FragmentHandle.Builder, org.apache.drill.exec.proto.ExecProtos.FragmentHandleOrBuilder>(
                  sender_,
                  getParentForChildren(),
                  isClean());
          sender_ = null;
        }
        return senderBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:exec.bit.control.FinishedReceiver)
    }

    static {
      defaultInstance = new FinishedReceiver(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.bit.control.FinishedReceiver)
  }

  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_exec_bit_control_BitControlHandshake_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_exec_bit_control_BitControlHandshake_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_exec_bit_control_BitStatus_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_exec_bit_control_BitStatus_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_exec_bit_control_FragmentStatus_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_exec_bit_control_FragmentStatus_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_exec_bit_control_InitializeFragments_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_exec_bit_control_InitializeFragments_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_exec_bit_control_CustomMessage_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_exec_bit_control_CustomMessage_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_exec_bit_control_PlanFragment_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_exec_bit_control_PlanFragment_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_exec_bit_control_Collector_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_exec_bit_control_Collector_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_exec_bit_control_QueryContextInformation_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_exec_bit_control_QueryContextInformation_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_exec_bit_control_WorkQueueStatus_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_exec_bit_control_WorkQueueStatus_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_exec_bit_control_FinishedReceiver_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_exec_bit_control_FinishedReceiver_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\020BitControl.proto\022\020exec.bit.control\032\025Ex" +
      "ecutionProtos.proto\032\022Coordination.proto\032" +
      "\023UserBitShared.proto\"\255\001\n\023BitControlHands" +
      "hake\022\023\n\013rpc_version\030\001 \001(\005\0225\n\007channel\030\002 \001" +
      "(\0162\027.exec.shared.RpcChannel:\013BIT_CONTROL" +
      "\022(\n\010endpoint\030\003 \001(\0132\026.exec.DrillbitEndpoi" +
      "nt\022 \n\030authenticationMechanisms\030\004 \003(\t\"F\n\t" +
      "BitStatus\0229\n\017fragment_status\030\001 \003(\0132 .exe" +
      "c.bit.control.FragmentStatus\"n\n\016Fragment" +
      "Status\0222\n\007profile\030\001 \001(\0132!.exec.shared.Mi",
      "norFragmentProfile\022(\n\006handle\030\002 \001(\0132\030.exe" +
      "c.bit.FragmentHandle\"G\n\023InitializeFragme" +
      "nts\0220\n\010fragment\030\001 \003(\0132\036.exec.bit.control" +
      ".PlanFragment\".\n\rCustomMessage\022\014\n\004type\030\001" +
      " \001(\005\022\017\n\007message\030\002 \001(\014\"\374\003\n\014PlanFragment\022(" +
      "\n\006handle\030\001 \001(\0132\030.exec.bit.FragmentHandle" +
      "\022\024\n\014network_cost\030\004 \001(\002\022\020\n\010cpu_cost\030\005 \001(\002" +
      "\022\021\n\tdisk_cost\030\006 \001(\002\022\023\n\013memory_cost\030\007 \001(\002" +
      "\022\025\n\rfragment_json\030\010 \001(\t\022\025\n\rleaf_fragment" +
      "\030\t \001(\010\022*\n\nassignment\030\n \001(\0132\026.exec.Drillb",
      "itEndpoint\022\'\n\007foreman\030\013 \001(\0132\026.exec.Drill" +
      "bitEndpoint\022\035\n\013mem_initial\030\014 \001(\003:\010200000" +
      "00\022\033\n\007mem_max\030\r \001(\003:\n2000000000\0221\n\013crede" +
      "ntials\030\016 \001(\0132\034.exec.shared.UserCredentia" +
      "ls\022\024\n\014options_json\030\017 \001(\t\022:\n\007context\030\020 \001(" +
      "\0132).exec.bit.control.QueryContextInforma" +
      "tion\022.\n\tcollector\030\021 \003(\0132\033.exec.bit.contr" +
      "ol.Collector\"\210\001\n\tCollector\022\"\n\032opposite_m" +
      "ajor_fragment_id\030\001 \001(\005\022#\n\027incoming_minor" +
      "_fragment\030\002 \003(\005B\002\020\001\022\035\n\025supports_out_of_o",
      "rder\030\003 \001(\010\022\023\n\013is_spooling\030\004 \001(\010\"w\n\027Query" +
      "ContextInformation\022\030\n\020query_start_time\030\001" +
      " \001(\003\022\021\n\ttime_zone\030\002 \001(\005\022\033\n\023default_schem" +
      "a_name\030\003 \001(\t\022\022\n\nsession_id\030\004 \001(\t\"f\n\017Work" +
      "QueueStatus\022(\n\010endpoint\030\001 \001(\0132\026.exec.Dri" +
      "llbitEndpoint\022\024\n\014queue_length\030\002 \001(\005\022\023\n\013r" +
      "eport_time\030\003 \001(\003\"h\n\020FinishedReceiver\022*\n\010" +
      "receiver\030\001 \001(\0132\030.exec.bit.FragmentHandle" +
      "\022(\n\006sender\030\002 \001(\0132\030.exec.bit.FragmentHand" +
      "le*\206\003\n\007RpcType\022\r\n\tHANDSHAKE\020\000\022\007\n\003ACK\020\001\022\013",
      "\n\007GOODBYE\020\002\022\034\n\030REQ_INITIALIZE_FRAGMENTS\020" +
      "\003\022\027\n\023REQ_CANCEL_FRAGMENT\020\006\022\031\n\025REQ_RECEIV" +
      "ER_FINISHED\020\007\022\027\n\023REQ_FRAGMENT_STATUS\020\010\022\022" +
      "\n\016REQ_BIT_STATUS\020\t\022\024\n\020REQ_QUERY_STATUS\020\n" +
      "\022\024\n\020REQ_QUERY_CANCEL\020\017\022\030\n\024REQ_UNPAUSE_FR" +
      "AGMENT\020\020\022\016\n\nREQ_CUSTOM\020\021\022\030\n\024RESP_FRAGMEN" +
      "T_HANDLE\020\013\022\030\n\024RESP_FRAGMENT_STATUS\020\014\022\023\n\017" +
      "RESP_BIT_STATUS\020\r\022\025\n\021RESP_QUERY_STATUS\020\016" +
      "\022\017\n\013RESP_CUSTOM\020\022\022\020\n\014SASL_MESSAGE\020\023B+\n\033o" +
      "rg.apache.drill.exec.protoB\nBitControlH\001"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
      new com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner() {
        public com.google.protobuf.ExtensionRegistry assignDescriptors(
            com.google.protobuf.Descriptors.FileDescriptor root) {
          descriptor = root;
          internal_static_exec_bit_control_BitControlHandshake_descriptor =
            getDescriptor().getMessageTypes().get(0);
          internal_static_exec_bit_control_BitControlHandshake_fieldAccessorTable = new
            com.google.protobuf.GeneratedMessage.FieldAccessorTable(
              internal_static_exec_bit_control_BitControlHandshake_descriptor,
              new java.lang.String[] { "RpcVersion", "Channel", "Endpoint", "AuthenticationMechanisms", });
          internal_static_exec_bit_control_BitStatus_descriptor =
            getDescriptor().getMessageTypes().get(1);
          internal_static_exec_bit_control_BitStatus_fieldAccessorTable = new
            com.google.protobuf.GeneratedMessage.FieldAccessorTable(
              internal_static_exec_bit_control_BitStatus_descriptor,
              new java.lang.String[] { "FragmentStatus", });
          internal_static_exec_bit_control_FragmentStatus_descriptor =
            getDescriptor().getMessageTypes().get(2);
          internal_static_exec_bit_control_FragmentStatus_fieldAccessorTable = new
            com.google.protobuf.GeneratedMessage.FieldAccessorTable(
              internal_static_exec_bit_control_FragmentStatus_descriptor,
              new java.lang.String[] { "Profile", "Handle", });
          internal_static_exec_bit_control_InitializeFragments_descriptor =
            getDescriptor().getMessageTypes().get(3);
          internal_static_exec_bit_control_InitializeFragments_fieldAccessorTable = new
            com.google.protobuf.GeneratedMessage.FieldAccessorTable(
              internal_static_exec_bit_control_InitializeFragments_descriptor,
              new java.lang.String[] { "Fragment", });
          internal_static_exec_bit_control_CustomMessage_descriptor =
            getDescriptor().getMessageTypes().get(4);
          internal_static_exec_bit_control_CustomMessage_fieldAccessorTable = new
            com.google.protobuf.GeneratedMessage.FieldAccessorTable(
              internal_static_exec_bit_control_CustomMessage_descriptor,
              new java.lang.String[] { "Type", "Message", });
          internal_static_exec_bit_control_PlanFragment_descriptor =
            getDescriptor().getMessageTypes().get(5);
          internal_static_exec_bit_control_PlanFragment_fieldAccessorTable = new
            com.google.protobuf.GeneratedMessage.FieldAccessorTable(
              internal_static_exec_bit_control_PlanFragment_descriptor,
              new java.lang.String[] { "Handle", "NetworkCost", "CpuCost", "DiskCost", "MemoryCost", "FragmentJson", "LeafFragment", "Assignment", "Foreman", "MemInitial", "MemMax", "Credentials", "OptionsJson", "Context", "Collector", });
          internal_static_exec_bit_control_Collector_descriptor =
            getDescriptor().getMessageTypes().get(6);
          internal_static_exec_bit_control_Collector_fieldAccessorTable = new
            com.google.protobuf.GeneratedMessage.FieldAccessorTable(
              internal_static_exec_bit_control_Collector_descriptor,
              new java.lang.String[] { "OppositeMajorFragmentId", "IncomingMinorFragment", "SupportsOutOfOrder", "IsSpooling", });
          internal_static_exec_bit_control_QueryContextInformation_descriptor =
            getDescriptor().getMessageTypes().get(7);
          internal_static_exec_bit_control_QueryContextInformation_fieldAccessorTable = new
            com.google.protobuf.GeneratedMessage.FieldAccessorTable(
              internal_static_exec_bit_control_QueryContextInformation_descriptor,
              new java.lang.String[] { "QueryStartTime", "TimeZone", "DefaultSchemaName", "SessionId", });
          internal_static_exec_bit_control_WorkQueueStatus_descriptor =
            getDescriptor().getMessageTypes().get(8);
          internal_static_exec_bit_control_WorkQueueStatus_fieldAccessorTable = new
            com.google.protobuf.GeneratedMessage.FieldAccessorTable(
              internal_static_exec_bit_control_WorkQueueStatus_descriptor,
              new java.lang.String[] { "Endpoint", "QueueLength", "ReportTime", });
          internal_static_exec_bit_control_FinishedReceiver_descriptor =
            getDescriptor().getMessageTypes().get(9);
          internal_static_exec_bit_control_FinishedReceiver_fieldAccessorTable = new
            com.google.protobuf.GeneratedMessage.FieldAccessorTable(
              internal_static_exec_bit_control_FinishedReceiver_descriptor,
              new java.lang.String[] { "Receiver", "Sender", });
          return null;
        }
      };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          org.apache.drill.exec.proto.ExecProtos.getDescriptor(),
          org.apache.drill.exec.proto.CoordinationProtos.getDescriptor(),
          org.apache.drill.exec.proto.UserBitShared.getDescriptor(),
        }, assigner);
  }

  // @@protoc_insertion_point(outer_class_scope)
}
